/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.common;

import com.iplanet.ias.admin.common.ObjectNames;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public class ObjectNameHelper {
    public static String getType(ObjectName objectName) {
        String type = objectName.getKeyProperty("type");
        return type;
    }

    public static String getName(ObjectName objectName) {
        String name = objectName.getKeyProperty("name");
        return name;
    }

    public static String getClassId(ObjectName objectName) {
        String classId = objectName.getKeyProperty("class");
        return classId;
    }

    public static String getServerId(ObjectName objectName) {
        String serverId = objectName.getKeyProperty("server");
        return serverId;
    }

    public static String getServerInstanceName(ObjectName objectName) {
        String instanceName = null;
        instanceName = ObjectNameHelper.getType(objectName).equals("server-instance") ? ObjectNameHelper.getName(objectName) : objectName.getKeyProperty("instance-name");
        return instanceName;
    }

    public static String getModuleType(ObjectName objectName) {
        String moduleType = null;
        moduleType = objectName.getKeyProperty("module-type");
        return moduleType;
    }

    public static String getApplicationName(ObjectName objectName) {
        String app = null;
        app = objectName.getKeyProperty("app-name");
        return app;
    }

    public static String getGroupId(ObjectName objectName) {
        String moduleType = null;
        moduleType = objectName.getKeyProperty("group");
        return moduleType;
    }

    public static String getVirtualServerClassId(ObjectName objectName) {
        String classId = objectName.getKeyProperty("virtual-server-class-id");
        return classId;
    }

    public static String getVirtualServerId(ObjectName objectName) {
        String virtualServerId = objectName.getKeyProperty("virtual-server-id");
        return virtualServerId;
    }

    public static String getHttpListenerId(ObjectName objectName) {
        String listenerId = null;
        listenerId = objectName.getKeyProperty("http-listener-id");
        return listenerId;
    }

    public static boolean isMonitorMBean(ObjectName objectName) {
        boolean isMonitor = false;
        String monitorKeyValue = null;
        monitorKeyValue = objectName.getKeyProperty("type");
        if (monitorKeyValue != null) {
            isMonitor = monitorKeyValue.equals("monitor");
        }
        return isMonitor;
    }

    public static ObjectName[] getInstanceRelatedMBeans(MBeanServer mbs, String instanceName) {
        ObjectName pattern = ObjectNames.getAllObjectNamesPattern();
        Set<ObjectInstance> names = mbs.queryMBeans(pattern, null);
        Iterator<ObjectInstance> iter = names.iterator();
        ArrayList<ObjectName> arr = new ArrayList<ObjectName>();
        while (iter.hasNext()) {
            ObjectName objectName = (ObjectName)((Object)iter.next());
            String name = ObjectNameHelper.getServerInstanceName(objectName);
            if (!instanceName.equals(name)) continue;
            arr.add(objectName);
        }
        return arr.toArray(new ObjectName[arr.size()]);
    }
}

