/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.common;

import com.iplanet.ias.admin.common.ObjectNameHelper;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFOtherException;
import com.iplanet.ias.admin.common.exception.AFRuntimeException;
import com.iplanet.ias.admin.common.exception.AFTargetNotFoundException;
import com.iplanet.ias.admin.common.exception.AttributeNotFoundException;
import com.iplanet.ias.admin.common.exception.InvalidAttributeValueException;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.SOMLocalStringsManager;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class JMXExceptionTranslator {
    private static final String NULL_ARGUMENT = "null-arg";
    private static SOMLocalStringsManager localizedStrMgr = SOMLocalStringsManager.getManager(class$com$iplanet$ias$admin$common$JMXExceptionTranslator == null ? (class$com$iplanet$ias$admin$common$JMXExceptionTranslator = JMXExceptionTranslator.class$("com.iplanet.ias.admin.common.JMXExceptionTranslator")) : class$com$iplanet$ias$admin$common$JMXExceptionTranslator);
    static /* synthetic */ Class class$com$iplanet$ias$admin$common$JMXExceptionTranslator;

    public static AFException translate(Exception e) {
        ArgChecker.check(e != null, (Object)NULL_ARGUMENT);
        AFException afe = new AFException(e.getMessage());
        if (e instanceof MBeanException) {
            Exception targetException = ((MBeanException)e).getTargetException();
            if (targetException instanceof AFException) {
                afe = (AFException)targetException;
            } else {
                if (targetException instanceof AFRuntimeException) {
                    throw (AFRuntimeException)targetException;
                }
                if (targetException instanceof MBeanException) {
                    Exception excpn = ((MBeanException)targetException).getTargetException();
                    if (excpn != null && excpn instanceof javax.management.InvalidAttributeValueException) {
                        afe = new InvalidAttributeValueException(excpn.getLocalizedMessage());
                    }
                } else {
                    afe = new AFOtherException(targetException);
                }
            }
        } else if (e instanceof InstanceNotFoundException) {
            String msg = JMXExceptionTranslator.convertInstanceNotFoundExceptionMessage(e);
            afe = new AFTargetNotFoundException(msg);
        } else if (e instanceof ReflectionException) {
            afe = new AFOtherException(e);
        } else if (e instanceof javax.management.AttributeNotFoundException) {
            afe = new AttributeNotFoundException(e.getLocalizedMessage());
        } else if (e instanceof javax.management.InvalidAttributeValueException) {
            afe = new InvalidAttributeValueException(e.getLocalizedMessage());
        } else if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        return afe;
    }

    private static String convertInstanceNotFoundExceptionMessage(Exception e) {
        String msg;
        String type = null;
        String name = null;
        try {
            ObjectName objectName = new ObjectName(e.getMessage());
            type = ObjectNameHelper.getType(objectName);
            name = ObjectNameHelper.getName(objectName);
        }
        catch (MalformedObjectNameException mfone) {
            // empty catch block
        }
        if (type != null) {
            String notFound = localizedStrMgr.getString("admin.common.is_not_found");
            msg = name != null ? type + " '" + name + "' " + notFound : type + " " + notFound;
        } else {
            msg = e.getLocalizedMessage();
        }
        return msg;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

