/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.comm;

import com.iplanet.ias.admin.comm.HttpConnectorAddress;
import com.iplanet.ias.admin.comm.IConnection;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.SOMLocalStringsManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.net.UnknownHostException;

class ServletConnection
implements IConnection {
    private URLConnection mConnection = null;
    private ObjectOutputStream mObjectOutStream = null;
    private ObjectInputStream mObjectInStream = null;
    private static SOMLocalStringsManager localizedStrMgr = SOMLocalStringsManager.getManager(class$com$iplanet$ias$admin$comm$ServletConnection == null ? (class$com$iplanet$ias$admin$comm$ServletConnection = ServletConnection.class$("com.iplanet.ias.admin.comm.ServletConnection")) : class$com$iplanet$ias$admin$comm$ServletConnection);
    static /* synthetic */ Class class$com$iplanet$ias$admin$comm$ServletConnection;

    ServletConnection(HttpConnectorAddress a) throws IOException {
        try {
            this.mConnection = a.openConnection("/web1/entry");
        }
        catch (IOException ioe) {
            this.handleException(ioe);
        }
    }

    public Object receive() throws IOException, ClassNotFoundException {
        Object value = null;
        try {
            this.mObjectInStream = new ObjectInputStream(new BufferedInputStream(this.mConnection.getInputStream()));
            value = this.mObjectInStream.readObject();
        }
        catch (IOException ioe) {
            this.handleException(ioe);
        }
        return value;
    }

    public void send(Serializable object) throws IOException {
        try {
            this.mObjectOutStream = new ObjectOutputStream(new BufferedOutputStream(this.mConnection.getOutputStream()));
            this.mObjectOutStream.writeObject(object);
            this.mObjectOutStream.flush();
            this.mObjectOutStream.close();
        }
        catch (IOException ioe) {
            this.handleException(ioe);
        }
    }

    public void close() {
        try {
            this.mObjectInStream.close();
            this.mObjectOutStream.close();
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    private void handleException(IOException e) throws IOException {
        IOException exception = null;
        if (e instanceof UnknownHostException) {
            String msg = localizedStrMgr.getString("admin.comm.unknown_host");
            exception = new UnknownHostException(msg + e.getMessage());
        } else if (e instanceof ConnectException) {
            String msg = localizedStrMgr.getString("admin.comm.invalid_host_port");
            exception = new ConnectException(msg);
        } else {
            int responseCode = ((HttpURLConnection)this.mConnection).getResponseCode();
            if (responseCode == 401) {
                String msg = localizedStrMgr.getString("admin.comm.unauthorized_access");
                exception = new IOException(msg);
            } else {
                exception = e;
            }
        }
        throw exception;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

