/*
 * Decompiled with CFR 0.152.
 */
package archiver.serializer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class XMLGraphSerializer {
    private BufferedWriter outStream;
    private int indentLevel;
    private boolean indent = true;
    private HashMap ObjectMap = new HashMap();
    private static String indentChar = "  ";
    private static String startTag = "<";
    private static String endTagNL = ">\n";
    private static String endTag = ">";
    private static String endEmptyTagNL = "/>\n";
    private static String endEmptyTag = "/>";
    private static String objectTag = "OBJECT";
    private static String arrayTag = "ARRAY";
    private static String rowTag = "ROW";
    private static String classAttrib = "CLASS";
    private static String IDAttrib = "ID";
    private static String refAttrib = "REFERENCE";
    private static String rowAttrib = "ROW";
    private static String rowClassAttrib = "ROWCLASS";
    private static String sizeAttrib = "SIZE";
    private static String primitiveArray = "PRIMITIVE";
    private static String startCDATA = "<![CDATA[";
    private static String endCDATA = "]]>";
    private static final String encoding = "UTF-8";

    private XMLGraphSerializer() {
    }

    public XMLGraphSerializer(OutputStream outputStream) {
        this();
        try {
            this.outStream = new BufferedWriter(new OutputStreamWriter(outputStream, encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Problems creating OutputStreamWriter: " + unsupportedEncodingException);
        }
    }

    private String getObjectName(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(object.getClass().getName());
        stringBuffer.append(object.hashCode());
        return stringBuffer.toString();
    }

    private void writeLevel(String string) throws IOException {
        if (this.indent) {
            int n = 0;
            while (n < this.indentLevel) {
                this.outStream.write(indentChar);
                ++n;
            }
        }
        this.outStream.write(string);
    }

    private void writeLevel(char[] cArray) throws IOException {
        if (this.indent) {
            int n = 0;
            while (n < this.indentLevel) {
                this.outStream.write(indentChar);
                ++n;
            }
        }
        this.outStream.write(cArray);
    }

    private void writeCDATA(String string) throws IOException {
        this.outStream.write(startCDATA);
        this.outStream.write(string);
        this.outStream.write(endCDATA);
    }

    private boolean recordObject(Object object) {
        boolean bl = false;
        String string = this.getObjectName(object);
        if (!this.ObjectMap.containsKey(string)) {
            this.ObjectMap.put(string, object);
        } else {
            bl = true;
        }
        return bl;
    }

    private void addAttribute(String string, String string2, StringBuffer stringBuffer) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(string);
        stringBuffer.append('=');
        stringBuffer.append('\"');
        stringBuffer.append(string2);
        stringBuffer.append('\"');
    }

    private boolean needsCDATA(String string) {
        boolean bl = false;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '<' || c == '>' || c == '&') {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public void DumpStatus() {
        System.out.println("Dumping state information for XMLGraphSerializer");
        System.out.println("Object Map contains ");
        Iterator iterator = this.ObjectMap.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            System.out.println("Object Map contains object or class " + v.getClass().getName());
            System.out.println("Object state is " + v.toString());
        }
        System.out.println("Dumping state information for XMLGraphSerializer - END");
    }

    private void putStartTag(String string, String string2, boolean bl, boolean bl2) throws IOException {
        this.writeLevel(startTag);
        this.outStream.write(string);
        if (string2 != null) {
            this.outStream.write(32);
            this.outStream.write(string2);
        }
        if (bl) {
            if (bl2) {
                this.outStream.write(endEmptyTagNL);
            } else {
                this.outStream.write(endEmptyTag);
            }
        } else {
            if (bl2) {
                this.outStream.write(endTagNL);
            } else {
                this.outStream.write(endTag);
            }
            if (this.indent) {
                ++this.indentLevel;
            }
        }
    }

    private void putEndTag(String string, boolean bl) throws IOException {
        if (this.indent) {
            --this.indentLevel;
        }
        if (this.indent && bl) {
            this.writeLevel("</");
        } else {
            this.outStream.write("</");
        }
        this.outStream.write(string);
        this.outStream.write(">\n");
    }

    private void xlateObject(Object object) throws IOException, IllegalAccessException {
        try {
            if (object == null) {
                this.putStartTag(objectTag, null, true, true);
            } else if (object instanceof String || object instanceof StringBuffer) {
                this.xlateString(null, object);
            } else if (this.recordObject(object)) {
                this.xlateObjectReference(object);
            } else {
                int n;
                Class<?> clazz = object.getClass();
                StringBuffer stringBuffer = new StringBuffer();
                this.addAttribute(classAttrib, clazz.getName(), stringBuffer);
                this.addAttribute(IDAttrib, this.getObjectName(object), stringBuffer);
                this.putStartTag(objectTag, stringBuffer.toString(), false, true);
                HashMap<String, Field> hashMap = new HashMap<String, Field>();
                Class<?> clazz2 = clazz;
                Field[] fieldArray = null;
                while (clazz2 != null) {
                    fieldArray = clazz2.getDeclaredFields();
                    n = 0;
                    while (n < fieldArray.length) {
                        if (!hashMap.containsKey(fieldArray[n].getName())) {
                            hashMap.put(fieldArray[n].getName(), fieldArray[n]);
                        }
                        ++n;
                    }
                    clazz2 = clazz2.getSuperclass();
                }
                ArrayList arrayList = new ArrayList(hashMap.values());
                n = 0;
                while (n < arrayList.size()) {
                    Field field = (Field)arrayList.get(n);
                    if (!Modifier.isTransient(field.getModifiers()) && !Modifier.isStatic(field.getModifiers())) {
                        Class<?> clazz3 = field.getType();
                        ((AccessibleObject)field).setAccessible(true);
                        Object object2 = field.get(object);
                        String string = field.getName();
                        if (object2 != null) {
                            if (clazz3.isPrimitive()) {
                                this.xlatePrimitive(string, object2);
                            } else if (object2 instanceof String || object2 instanceof StringBuffer) {
                                this.xlateString(string, object2);
                            } else if (clazz3.isArray()) {
                                this.xlateArray(string, object2);
                            } else if (object2 instanceof Collection) {
                                this.xlateCollection(string, object2);
                            } else {
                                this.putStartTag(string, null, false, true);
                                this.xlateObject(object2);
                                this.putEndTag(string, true);
                            }
                        } else {
                            this.putStartTag(string, null, false, true);
                            this.putStartTag(objectTag, null, true, true);
                            this.putEndTag(string, true);
                        }
                    }
                    ++n;
                }
                this.putEndTag(objectTag, true);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.DumpStatus();
            System.out.println("IO Exception in XLateObject current object class " + object.getClass().getName());
            System.out.println("IO Exception in XLateObject current object is " + object);
            this.outStream.close();
            throw iOException;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            this.DumpStatus();
            System.out.println("IO Exception in XLateObject current object class " + object.getClass().getName());
            System.out.println("IO Exception in XLateObject current object is " + object);
            this.outStream.close();
            throw illegalAccessException;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            this.DumpStatus();
            System.out.println("IO Exception in XLateObject current object class " + object.getClass().getName());
            System.out.println("IO Exception in XLateObject current object is " + object);
            this.outStream.close();
            throw runtimeException;
        }
    }

    private void xlateObjectReference(Object object) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.addAttribute(refAttrib, this.getObjectName(object), stringBuffer);
        this.putStartTag(objectTag, stringBuffer.toString(), true, true);
    }

    private void xlatePrimitive(String string, Object object) throws IOException {
        Class<?> clazz = object.getClass();
        String string2 = object.toString();
        this.putStartTag(string, null, false, false);
        if (clazz == Character.TYPE) {
            if (this.needsCDATA(string2)) {
                this.writeCDATA(string2);
            } else {
                this.outStream.write(string2);
            }
        } else {
            this.outStream.write(string2);
        }
        this.putEndTag(string, false);
    }

    private void xlateString(String string, Object object) throws IOException {
        String string2;
        if (string != null) {
            this.putStartTag(string, null, false, false);
        }
        if (this.needsCDATA(string2 = object.toString())) {
            this.writeCDATA(string2);
        } else {
            this.outStream.write(string2);
        }
        if (string != null) {
            this.putEndTag(string, false);
        }
    }

    private void xlateArray(String string, Object object) throws IOException, IllegalAccessException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = Array.getLength(object);
        this.addAttribute(sizeAttrib, Integer.toString(n), stringBuffer);
        this.addAttribute(classAttrib, primitiveArray, stringBuffer);
        this.addAttribute(rowClassAttrib, object.getClass().getComponentType().getName(), stringBuffer);
        this.putStartTag(string, null, false, true);
        this.putStartTag(arrayTag, stringBuffer.toString(), false, true);
        int n2 = 0;
        while (n2 < n) {
            Object object2 = Array.get(object, n2);
            if (object2 instanceof String || object2 instanceof Number || object2 instanceof Character || object2 instanceof Boolean) {
                this.xlateSimpleRow(n2, object2);
            } else {
                StringBuffer stringBuffer2 = new StringBuffer();
                this.addAttribute(rowAttrib, Integer.toString(n2), stringBuffer2);
                this.putStartTag(rowTag, stringBuffer2.toString(), false, true);
                this.xlateObject(object2);
                this.putEndTag(rowTag, true);
            }
            ++n2;
        }
        this.putEndTag(arrayTag, true);
        this.putEndTag(string, true);
    }

    private void xlateCollection(String string, Object object) throws IOException, IllegalAccessException {
        StringBuffer stringBuffer = new StringBuffer();
        Collection collection = (Collection)object;
        int n = collection.size();
        this.addAttribute(sizeAttrib, Integer.toString(n), stringBuffer);
        this.addAttribute(classAttrib, collection.getClass().getName(), stringBuffer);
        this.addAttribute(rowClassAttrib, "", stringBuffer);
        this.putStartTag(string, null, false, true);
        this.putStartTag(arrayTag, stringBuffer.toString(), false, true);
        Iterator iterator = collection.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof String || e instanceof Number || e instanceof Character || e instanceof Boolean) {
                this.xlateSimpleRow(n2, e);
            } else {
                StringBuffer stringBuffer2 = new StringBuffer();
                this.addAttribute(rowAttrib, Integer.toString(n2), stringBuffer2);
                this.putStartTag(rowTag, stringBuffer2.toString(), false, true);
                this.xlateObject(e);
                this.putEndTag(rowTag, true);
            }
            ++n2;
        }
        this.putEndTag(arrayTag, true);
        this.putEndTag(string, true);
    }

    private void xlateSimpleRow(int n, Object object) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.addAttribute(rowAttrib, Integer.toString(n), stringBuffer);
        Class<?> clazz = object.getClass();
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                this.addAttribute("ROWCLASS", "int", stringBuffer);
            } else if (clazz == Short.TYPE) {
                this.addAttribute("ROWCLASS", "short", stringBuffer);
            } else if (clazz == Long.TYPE) {
                this.addAttribute("ROWCLASS", "long", stringBuffer);
            } else if (clazz == Float.TYPE) {
                this.addAttribute("ROWCLASS", "float", stringBuffer);
            } else if (clazz == Double.TYPE) {
                this.addAttribute("ROWCLASS", "double", stringBuffer);
            } else if (clazz == Boolean.TYPE) {
                this.addAttribute("ROWCLASS", "boolean", stringBuffer);
            } else if (clazz == Character.TYPE) {
                this.addAttribute("ROWCLASS", "char", stringBuffer);
            } else {
                this.addAttribute("ROWCLASS", "unknown", stringBuffer);
            }
        } else {
            this.addAttribute("ROWCLASS", clazz.getName(), stringBuffer);
        }
        this.addAttribute("VALUE", object.toString(), stringBuffer);
        this.putStartTag(rowTag, stringBuffer.toString(), true, true);
    }

    public void writeObject(Object object) throws IOException {
        try {
            this.outStream.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n\n");
            this.xlateObject(object);
            this.outStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.DumpStatus();
            try {
                this.outStream.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            this.DumpStatus();
            try {
                this.outStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

