/*
 * Decompiled with CFR 0.152.
 */
package antlr.debug;

import antlr.debug.InputBufferEvent;
import antlr.debug.InputBufferListener;
import antlr.debug.ListenerBase;
import java.util.Vector;

public class InputBufferEventSupport {
    protected static final int CONSUME = 0;
    protected static final int LA = 1;
    protected static final int MARK = 2;
    protected static final int REWIND = 3;
    private Object source;
    private Vector inputBufferListeners;
    private InputBufferEvent inputBufferEvent;

    public void addInputBufferListener(InputBufferListener inputBufferListener) {
        if (this.inputBufferListeners == null) {
            this.inputBufferListeners = new Vector();
        }
        this.inputBufferListeners.addElement(inputBufferListener);
    }

    public void fireConsume(char c) {
        this.inputBufferEvent.setValues(0, c, 0);
        this.fireEvents(0, this.inputBufferListeners);
    }

    public void fireEvent(int n, ListenerBase listenerBase) {
        switch (n) {
            case 0: {
                ((InputBufferListener)listenerBase).inputBufferConsume(this.inputBufferEvent);
                break;
            }
            case 1: {
                ((InputBufferListener)listenerBase).inputBufferLA(this.inputBufferEvent);
                break;
            }
            case 2: {
                ((InputBufferListener)listenerBase).inputBufferMark(this.inputBufferEvent);
                break;
            }
            case 3: {
                ((InputBufferListener)listenerBase).inputBufferRewind(this.inputBufferEvent);
                break;
            }
            default: {
                throw new IllegalArgumentException("bad type " + n + " for fireEvent()");
            }
        }
    }

    public void fireEvents(int n, Vector vector) {
        Vector vector2 = null;
        ListenerBase listenerBase = null;
        InputBufferEventSupport inputBufferEventSupport = this;
        synchronized (inputBufferEventSupport) {
            if (vector == null) {
                Object var6_7 = null;
                return;
            }
            vector2 = (Vector)vector.clone();
        }
        if (vector2 != null) {
            int n2 = 0;
            while (n2 < vector2.size()) {
                listenerBase = (ListenerBase)vector2.elementAt(n2);
                this.fireEvent(n, listenerBase);
                ++n2;
            }
        }
    }

    public void fireLA(char c, int n) {
        this.inputBufferEvent.setValues(1, c, n);
        this.fireEvents(1, this.inputBufferListeners);
    }

    public void fireMark(int n) {
        this.inputBufferEvent.setValues(2, ' ', n);
        this.fireEvents(2, this.inputBufferListeners);
    }

    public void fireRewind(int n) {
        this.inputBufferEvent.setValues(3, ' ', n);
        this.fireEvents(3, this.inputBufferListeners);
    }

    public Vector getInputBufferListeners() {
        return this.inputBufferListeners;
    }

    protected void refresh(Vector vector) {
        Vector vector2;
        Vector vector3 = vector;
        synchronized (vector3) {
            vector2 = (Vector)vector.clone();
        }
        if (vector2 != null) {
            int n = 0;
            while (n < vector2.size()) {
                ((ListenerBase)vector2.elementAt(n)).refresh();
                ++n;
            }
        }
    }

    public void refreshListeners() {
        this.refresh(this.inputBufferListeners);
    }

    public void removeInputBufferListener(InputBufferListener inputBufferListener) {
        if (this.inputBufferListeners != null) {
            this.inputBufferListeners.removeElement(inputBufferListener);
        }
    }

    public InputBufferEventSupport(Object object) {
        this.inputBufferEvent = new InputBufferEvent(object);
        this.source = object;
    }
}

