/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.CodeGenerator;
import antlr.GrammarSymbol;
import antlr.LLkGrammarAnalyzer;
import antlr.RuleSymbol;
import antlr.Token;
import antlr.TokenManager;
import antlr.Tool;
import antlr.collections.impl.Vector;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class Grammar {
    protected Tool tool;
    protected CodeGenerator generator;
    protected LLkGrammarAnalyzer theLLkAnalyzer;
    protected Hashtable symbols;
    protected boolean buildAST = false;
    protected boolean analyzerDebug = false;
    protected boolean interactive = false;
    protected String superClass = null;
    protected TokenManager tokenManager;
    protected String exportVocab = null;
    protected String importVocab = null;
    protected Hashtable options;
    protected Vector rules;
    protected String preambleAction = null;
    protected String className = null;
    protected String fileName = null;
    protected String classMemberAction = null;
    protected boolean hasSyntacticPredicate = false;
    protected boolean hasUserErrorHandling = false;
    protected int maxk = 1;
    protected boolean traceRules = false;
    protected boolean debuggingOutput = false;
    protected boolean defaultErrorHandler = true;
    protected String comment = null;

    public void define(RuleSymbol ruleSymbol) {
        this.rules.appendElement(ruleSymbol);
        this.symbols.put(ruleSymbol.getId(), ruleSymbol);
    }

    public abstract void generate() throws IOException;

    protected String getClassName() {
        return this.className;
    }

    public boolean getDefaultErrorHandler() {
        return this.defaultErrorHandler;
    }

    public String getFilename() {
        return this.fileName;
    }

    public int getIntegerOption(String string) throws NumberFormatException {
        Token token = (Token)this.options.get(string);
        if (token == null || token.getType() != 20) {
            throw new NumberFormatException();
        }
        return Integer.parseInt(token.getText());
    }

    public Token getOption(String string) {
        return (Token)this.options.get(string);
    }

    protected abstract String getSuperClass();

    public GrammarSymbol getSymbol(String string) {
        return (GrammarSymbol)this.symbols.get(string);
    }

    public Enumeration getSymbols() {
        return this.symbols.elements();
    }

    public boolean hasOption(String string) {
        return this.options.containsKey(string);
    }

    public boolean isDefined(String string) {
        return this.symbols.containsKey(string);
    }

    public abstract void processArguments(String[] var1);

    public void setCodeGenerator(CodeGenerator codeGenerator) {
        this.generator = codeGenerator;
    }

    public void setFilename(String string) {
        this.fileName = string;
    }

    public void setGrammarAnalyzer(LLkGrammarAnalyzer lLkGrammarAnalyzer) {
        this.theLLkAnalyzer = lLkGrammarAnalyzer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setOption(String string, Token token) {
        this.options.put(string, token);
        String string2 = token.getText();
        if (string.equals("k")) {
            try {
                this.maxk = this.getIntegerOption("k");
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                this.tool.error("option 'k' must be an integer (was " + token.getText() + ")", this.getFilename(), token.getLine());
            }
            return true;
        }
        if (string.equals("codeGenMakeSwitchThreshold")) {
            try {
                int n = this.getIntegerOption("codeGenMakeSwitchThreshold");
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                this.tool.error("option 'codeGenMakeSwitchThreshold' must be an integer", this.getFilename(), token.getLine());
            }
            return true;
        }
        if (string.equals("codeGenBitsetTestThreshold")) {
            try {
                int n = this.getIntegerOption("codeGenBitsetTestThreshold");
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                this.tool.error("option 'codeGenBitsetTestThreshold' must be an integer", this.getFilename(), token.getLine());
            }
            return true;
        }
        if (string.equals("defaultErrorHandler")) {
            if (string2.equals("true")) {
                this.defaultErrorHandler = true;
                return true;
            }
            if (string2.equals("false")) {
                this.defaultErrorHandler = false;
                return true;
            }
            this.tool.error("Value for defaultErrorHandler must be true or false", this.getFilename(), token.getLine());
            return true;
        }
        if (string.equals("analyzerDebug")) {
            if (string2.equals("true")) {
                this.analyzerDebug = true;
                return true;
            }
            if (string2.equals("false")) {
                this.analyzerDebug = false;
                return true;
            }
            this.tool.error("option 'analyzerDebug' must be true or false", this.getFilename(), token.getLine());
            return true;
        }
        if (!string.equals("codeGenDebug")) {
            if (!string.equals("classHeaderSuffix")) return false;
            return true;
        }
        if (string2.equals("true")) {
            this.analyzerDebug = true;
            return true;
        }
        if (string2.equals("false")) {
            this.analyzerDebug = false;
            return true;
        }
        this.tool.error("option 'codeGenDebug' must be true or false", this.getFilename(), token.getLine());
        return true;
    }

    public void setTokenManager(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public Grammar(String string, Tool tool, String string2) {
        this.className = string;
        this.tool = tool;
        this.symbols = new Hashtable();
        this.options = new Hashtable();
        this.rules = new Vector(100);
        this.superClass = string2;
    }
}

