/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.util.Hashtable;
import java.util.Vector;
import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.ClassType;
import sun.rmi.rmic.iiop.CompoundType;
import sun.rmi.rmic.iiop.Constants;
import sun.rmi.rmic.iiop.ContextElement;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.Type;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Environment;
import sun.tools.java.MemberDefinition;

public class ValueType
extends ClassType {
    private boolean isCustom = false;

    public static ValueType forValue(ClassDefinition classDefinition, ContextStack contextStack, boolean bl) {
        Constants constants;
        if (contextStack.anyErrors()) {
            return null;
        }
        sun.tools.java.Type type = classDefinition.getType();
        String string = type.toString();
        Type type2 = ValueType.getType(string, contextStack);
        if (type2 != null) {
            if (!(type2 instanceof ValueType)) {
                return null;
            }
            return (ValueType)type2;
        }
        boolean bl2 = false;
        if (classDefinition.getClassDeclaration().getName() == idJavaLangClass) {
            bl2 = true;
            constants = contextStack.getEnv();
            ClassDeclaration classDeclaration = constants.getClassDeclaration(idClassDesc);
            ClassDefinition classDefinition2 = null;
            try {
                classDefinition2 = classDeclaration.getClassDefinition((Environment)constants);
            }
            catch (ClassNotFound classNotFound) {
                ValueType.classNotFound(contextStack, classNotFound);
                return null;
            }
            classDefinition = classDefinition2;
        }
        if (ValueType.couldBeValue(contextStack, classDefinition)) {
            constants = new ValueType(classDefinition, contextStack, bl2);
            ValueType.putType(string, (Type)constants, contextStack);
            contextStack.push((ContextElement)((Object)constants));
            if (super.initialize(contextStack, bl)) {
                contextStack.pop(true);
                return constants;
            }
            ValueType.removeType(string, contextStack);
            contextStack.pop(false);
            return null;
        }
        return null;
    }

    public String getTypeDescription() {
        String string = this.addExceptionDescription("Value");
        if (this.isCustom) {
            string = "Custom " + string;
        }
        if (this.isIDLEntity) {
            string = string + " [IDLEntity]";
        }
        return string;
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    private ValueType(ClassDefinition classDefinition, ContextStack contextStack, boolean bl) {
        super(contextStack, classDefinition, 0x6008000);
        if (bl) {
            this.setNames(idJavaLangClass, IDL_CLASS_MODULE, "ClassDesc");
        }
    }

    private static boolean couldBeValue(ContextStack contextStack, ClassDefinition classDefinition) {
        boolean bl = false;
        ClassDeclaration classDeclaration = classDefinition.getClassDeclaration();
        BatchEnvironment batchEnvironment = contextStack.getEnv();
        try {
            if (batchEnvironment.defRemote.implementedBy((Environment)batchEnvironment, classDeclaration)) {
                ValueType.failedConstraint(10, false, contextStack, classDefinition.getName());
            } else if (!batchEnvironment.defSerializable.implementedBy((Environment)batchEnvironment, classDeclaration)) {
                ValueType.failedConstraint(11, false, contextStack, classDefinition.getName());
            } else {
                bl = true;
            }
        }
        catch (ClassNotFound classNotFound) {
            ValueType.classNotFound(contextStack, classNotFound);
        }
        return bl;
    }

    private boolean initialize(ContextStack contextStack, boolean bl) {
        ClassDefinition classDefinition = this.getClassDefinition();
        ClassDeclaration classDeclaration = this.getClassDeclaration();
        try {
            if (!this.initParents(contextStack)) {
                ValueType.failedConstraint(12, bl, contextStack, this.getQualifiedName());
                return false;
            }
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            Vector vector3 = new Vector();
            if (this.addNonRemoteInterfaces(vector, contextStack) != null && this.addAllMethods(classDefinition, vector2, false, false, contextStack) != null && this.updateParentClassMethods(classDefinition, vector2, false, contextStack) != null) {
                if (this.addAllMembers(vector3, false, false, contextStack)) {
                    if (!this.initialize(vector, vector2, vector3, contextStack, bl)) {
                        return false;
                    }
                    boolean bl2 = false;
                    if (!this.env.defExternalizable.implementedBy((Environment)this.env, classDeclaration)) {
                        if (!this.checkPersistentFields(this.getClassInstance(), bl)) {
                            return false;
                        }
                    } else {
                        bl2 = true;
                    }
                    if (bl2) {
                        this.isCustom = true;
                    } else {
                        for (MemberDefinition memberDefinition = classDefinition.getFirstMember(); memberDefinition != null; memberDefinition = memberDefinition.getNextMember()) {
                            sun.tools.java.Type[] typeArray;
                            sun.tools.java.Type type;
                            sun.tools.java.Type type2;
                            if (!memberDefinition.isMethod() || memberDefinition.isInitializer() || !memberDefinition.isPrivate() || !memberDefinition.getName().toString().equals("writeObject") || (type2 = (type = memberDefinition.getType()).getReturnType()) != sun.tools.java.Type.tVoid || (typeArray = type.getArgumentTypes()).length != 1 || !typeArray[0].getTypeSignature().equals("Ljava/io/ObjectOutputStream;")) continue;
                            this.isCustom = true;
                        }
                    }
                }
                return true;
            }
        }
        catch (ClassNotFound classNotFound) {
            ValueType.classNotFound(contextStack, classNotFound);
        }
        return false;
    }

    private boolean checkPersistentFields(Class clazz, boolean bl) {
        Object object;
        Object object2;
        Cloneable cloneable;
        for (int i = 0; i < this.methods.length; ++i) {
            if (!this.methods[i].getName().equals("writeObject") || this.methods[i].getArguments().length != 1) continue;
            Type type = this.methods[i].getReturnType();
            cloneable = this.methods[i].getArguments()[0];
            object2 = ((Type)cloneable).getQualifiedName();
            if (!type.isType(1) || !((String)object2).equals("java.io.ObjectOutputStream")) continue;
            return true;
        }
        MemberDefinition memberDefinition = null;
        for (int i = 0; i < this.members.length; ++i) {
            if (!this.members[i].getName().equals("serialPersistentFields") || (object = ((Type)(object2 = ((CompoundType.Member)(cloneable = this.members[i])).getType())).getElementType()) == null || !((Type)object).getQualifiedName().equals("java.io.ObjectStreamField")) continue;
            if (((CompoundType.Member)cloneable).isStatic() && ((CompoundType.Member)cloneable).isFinal() && ((CompoundType.Member)cloneable).isPrivate()) {
                memberDefinition = ((CompoundType.Member)cloneable).getMemberDefinition();
                continue;
            }
            ValueType.failedConstraint(4, bl, this.stack, this.getQualifiedName());
            return false;
        }
        if (memberDefinition == null) {
            return true;
        }
        Hashtable hashtable = this.getPersistentFields(clazz);
        boolean bl2 = true;
        for (int i = 0; i < this.members.length; ++i) {
            object = this.members[i].getName();
            String string = this.members[i].getType().getSignature();
            String string2 = (String)hashtable.get(object);
            if (string2 == null) {
                this.members[i].setTransient();
                continue;
            }
            if (string2.equals(string)) {
                hashtable.remove(object);
                continue;
            }
            bl2 = false;
            ValueType.failedConstraint(2, bl, this.stack, object, this.getQualifiedName());
        }
        if (bl2 && hashtable.size() > 0) {
            bl2 = false;
            ValueType.failedConstraint(9, bl, this.stack, this.getQualifiedName());
        }
        return bl2;
    }

    private Hashtable getPersistentFields(Class clazz) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass != null) {
            ObjectStreamField[] objectStreamFieldArray = objectStreamClass.getFields();
            for (int i = 0; i < objectStreamFieldArray.length; ++i) {
                String string;
                String string2 = String.valueOf(objectStreamFieldArray[i].getTypeCode());
                if (objectStreamFieldArray[i].isPrimitive()) {
                    string = string2;
                } else {
                    if (objectStreamFieldArray[i].getTypeCode() == '[') {
                        string2 = "";
                    }
                    if ((string = string2 + objectStreamFieldArray[i].getType().getName().replace('.', '/')).endsWith(";")) {
                        string = string.substring(0, string.length() - 1);
                    }
                }
                hashtable.put(objectStreamFieldArray[i].getName(), string);
            }
        }
        return hashtable;
    }
}

