/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import java.io.IOException;
import sun.rmi.rmic.IndentingWriter;
import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.CompoundType;
import sun.rmi.rmic.iiop.ContextStack;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.Environment;

public abstract class ClassType
extends CompoundType {
    private ClassType parent;

    public ClassType getSuperclass() {
        return this.parent;
    }

    public void print(IndentingWriter indentingWriter, boolean bl, boolean bl2, boolean bl3) throws IOException {
        if (this.isInner()) {
            indentingWriter.p("// " + this.getTypeDescription() + " (INNER)");
        } else {
            indentingWriter.p("// " + this.getTypeDescription());
        }
        indentingWriter.pln(" (" + this.getRepositoryID() + ")\n");
        this.printPackageOpen(indentingWriter, bl2);
        if (!bl2) {
            indentingWriter.p("public ");
        }
        String string = "";
        indentingWriter.p("class " + this.getTypeName(false, bl2, false));
        if (this.printExtends(indentingWriter, bl, bl2, bl3)) {
            string = ",";
        }
        this.printImplements(indentingWriter, string, bl, bl2, bl3);
        indentingWriter.plnI(" {");
        this.printMembers(indentingWriter, bl, bl2, bl3);
        indentingWriter.pln();
        this.printMethods(indentingWriter, bl, bl2, bl3);
        if (bl2) {
            indentingWriter.pOln("};");
        } else {
            indentingWriter.pOln("}");
        }
        this.printPackageClose(indentingWriter, bl2);
    }

    protected void destroy() {
        if (!this.destroyed) {
            super.destroy();
            if (this.parent != null) {
                this.parent.destroy();
                this.parent = null;
            }
        }
    }

    protected ClassType(ContextStack contextStack, int n, ClassDefinition classDefinition) {
        super(contextStack, n, classDefinition);
        if ((n & 0x4000000) == 0 && classDefinition.isInterface()) {
            throw new CompilerError("Not a class");
        }
        this.parent = null;
    }

    protected ClassType(int n, ClassDefinition classDefinition, ContextStack contextStack) {
        super(contextStack, classDefinition, n);
        if ((n & 0x4000000) == 0 && classDefinition.isInterface()) {
            throw new CompilerError("Not a class");
        }
        this.parent = null;
    }

    protected ClassType(ContextStack contextStack, ClassDefinition classDefinition, int n) {
        super(contextStack, classDefinition, n);
        if ((n & 0x4000000) == 0 && classDefinition.isInterface()) {
            throw new CompilerError("Not a class");
        }
        this.parent = null;
    }

    protected void swapInvalidTypes() {
        super.swapInvalidTypes();
        if (this.parent != null && this.parent.getStatus() != 1) {
            this.parent = (ClassType)this.getValidType(this.parent);
        }
    }

    public String addExceptionDescription(String string) {
        if (this.isException) {
            string = this.isCheckedException ? string + " - Checked Exception" : string + " - Unchecked Exception";
        }
        return string;
    }

    protected boolean initParents(ContextStack contextStack) {
        contextStack.setNewContextCode(11);
        BatchEnvironment batchEnvironment = contextStack.getEnv();
        boolean bl = true;
        try {
            ClassDeclaration classDeclaration = this.getClassDefinition().getSuperClass((Environment)batchEnvironment);
            if (classDeclaration != null) {
                ClassDefinition classDefinition = classDeclaration.getClassDefinition((Environment)batchEnvironment);
                this.parent = (ClassType)ClassType.makeType(classDefinition.getType(), classDefinition, contextStack);
                if (this.parent == null) {
                    bl = false;
                }
            }
        }
        catch (ClassNotFound classNotFound) {
            ClassType.classNotFound(contextStack, classNotFound);
            throw new CompilerError("ClassType constructor");
        }
        return bl;
    }
}

