/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.rmi.rmic.BatchEnvironment;
import sun.rmi.rmic.Constants;
import sun.rmi.rmic.Generator;
import sun.rmi.rmic.Names;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassNotFound;
import sun.tools.java.ClassPath;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.javac.SourceClass;
import sun.tools.util.CommandLine;

public class Main
implements Constants {
    String sourcePathArg;
    String sysClassPathArg;
    String extDirsArg;
    String classPathString;
    File destDir;
    int flags;
    long tm;
    Vector classes;
    boolean nowrite;
    boolean nocompile;
    boolean keepGenerated;
    boolean status;
    String[] generatorArgs;
    Vector generators;
    Class environmentClass = BatchEnvironment.class;
    boolean iiopGeneration = false;
    String program;
    OutputStream out;
    private static boolean resourcesInitialized = false;
    private static ResourceBundle resources;
    private static ResourceBundle resourcesExt;

    public Main(OutputStream outputStream, String string) {
        this.out = outputStream;
        this.program = string;
    }

    public void output(String string) {
        PrintStream printStream = this.out instanceof PrintStream ? (PrintStream)this.out : new PrintStream(this.out, true);
        printStream.println(string);
    }

    public void error(String string) {
        this.output(Main.getText(string));
    }

    public void error(String string, String string2) {
        this.output(Main.getText(string, string2));
    }

    public void error(String string, String string2, String string3) {
        this.output(Main.getText(string, string2, string3));
    }

    public void usage() {
        this.error("rmic.usage", this.program);
    }

    public synchronized boolean compile(String[] stringArray) {
        if (!this.parseArgs(stringArray)) {
            return false;
        }
        if (this.classes.size() == 0) {
            this.usage();
            return false;
        }
        return this.doCompile();
    }

    public File getDestinationDir() {
        return this.destDir;
    }

    public boolean parseArgs(String[] stringArray) {
        int n;
        this.sourcePathArg = null;
        this.sysClassPathArg = null;
        this.extDirsArg = null;
        this.classPathString = null;
        this.destDir = null;
        this.flags = 4;
        this.tm = System.currentTimeMillis();
        this.classes = new Vector();
        this.nowrite = false;
        this.nocompile = false;
        this.keepGenerated = false;
        this.generatorArgs = this.getArray("generator.args", true);
        if (this.generatorArgs == null) {
            return false;
        }
        this.generators = new Vector();
        try {
            stringArray = CommandLine.parse((String[])stringArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.error("rmic.cant.read", fileNotFoundException.getMessage());
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null) continue;
            if (stringArray[n].equals("-g")) {
                this.flags &= 0xFFFFBFFF;
                this.flags |= 0x3000;
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-O")) {
                this.flags &= 0xFFFFEFFF;
                this.flags &= 0xFFFFDFFF;
                this.flags |= 0x4020;
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-nowarn")) {
                this.flags &= 0xFFFFFFFB;
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-debug")) {
                this.flags |= 2;
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-depend")) {
                this.flags |= 0x20;
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-verbose")) {
                this.flags |= 1;
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-nowrite")) {
                this.nowrite = true;
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-Xnocompile")) {
                this.nocompile = true;
                this.keepGenerated = true;
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-keep") || stringArray[n].equals("-keepgenerated")) {
                this.keepGenerated = true;
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-show")) {
                this.error("rmic.option.unsupported", "-show");
                this.usage();
                return false;
            }
            if (stringArray[n].equals("-classpath")) {
                if (n + 1 < stringArray.length) {
                    if (this.classPathString != null) {
                        this.error("rmic.option.already.seen", "-classpath");
                        this.usage();
                        return false;
                    }
                    stringArray[n] = null;
                    this.classPathString = stringArray[++n];
                    stringArray[n] = null;
                    continue;
                }
                this.error("rmic.option.requires.argument", "-classpath");
                this.usage();
                return false;
            }
            if (stringArray[n].equals("-sourcepath")) {
                if (n + 1 < stringArray.length) {
                    if (this.sourcePathArg != null) {
                        this.error("rmic.option.already.seen", "-sourcepath");
                        this.usage();
                        return false;
                    }
                    stringArray[n] = null;
                    this.sourcePathArg = stringArray[++n];
                    stringArray[n] = null;
                    continue;
                }
                this.error("rmic.option.requires.argument", "-sourcepath");
                this.usage();
                return false;
            }
            if (stringArray[n].equals("-bootclasspath")) {
                if (n + 1 < stringArray.length) {
                    if (this.sysClassPathArg != null) {
                        this.error("rmic.option.already.seen", "-bootclasspath");
                        this.usage();
                        return false;
                    }
                    stringArray[n] = null;
                    this.sysClassPathArg = stringArray[++n];
                    stringArray[n] = null;
                    continue;
                }
                this.error("rmic.option.requires.argument", "-bootclasspath");
                this.usage();
                return false;
            }
            if (stringArray[n].equals("-extdirs")) {
                if (n + 1 < stringArray.length) {
                    if (this.extDirsArg != null) {
                        this.error("rmic.option.already.seen", "-extdirs");
                        this.usage();
                        return false;
                    }
                    stringArray[n] = null;
                    this.extDirsArg = stringArray[++n];
                    stringArray[n] = null;
                    continue;
                }
                this.error("rmic.option.requires.argument", "-extdirs");
                this.usage();
                return false;
            }
            if (stringArray[n].equals("-d")) {
                if (n + 1 < stringArray.length) {
                    if (this.destDir != null) {
                        this.error("rmic.option.already.seen", "-d");
                        this.usage();
                        return false;
                    }
                    stringArray[n] = null;
                    this.destDir = new File(stringArray[++n]);
                    stringArray[n] = null;
                    if (this.destDir.exists()) continue;
                    this.error("rmic.no.such.directory", this.destDir.getPath());
                    this.usage();
                    return false;
                }
                this.error("rmic.option.requires.argument", "-d");
                this.usage();
                return false;
            }
            if (this.checkGeneratorArg(stringArray, n)) continue;
            this.usage();
            return false;
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null) continue;
            if (stringArray[n].startsWith("-")) {
                this.error("rmic.no.such.option", stringArray[n]);
                this.usage();
                return false;
            }
            this.classes.addElement(stringArray[n]);
        }
        if (this.generators.size() == 0) {
            this.addGenerator("default");
        }
        return true;
    }

    protected boolean checkGeneratorArg(String[] stringArray, int n) {
        boolean bl = true;
        if (stringArray[n].startsWith("-")) {
            String string = stringArray[n].substring(1).toLowerCase();
            for (int i = 0; i < this.generatorArgs.length; ++i) {
                if (!string.equalsIgnoreCase(this.generatorArgs[i])) continue;
                Generator generator = this.addGenerator(string);
                if (generator == null) {
                    return false;
                }
                bl = generator.parseArgs(stringArray, this);
                break;
            }
        }
        return bl;
    }

    protected Generator addGenerator(String string) {
        Generator generator;
        String string2 = Main.getString("generator.class." + string);
        if (string2 == null) {
            this.error("rmic.missing.property", string);
            return null;
        }
        try {
            generator = (Generator)Class.forName(string2).newInstance();
        }
        catch (Exception exception) {
            this.error("rmic.cannot.instantiate", string2);
            return null;
        }
        this.generators.addElement(generator);
        Class clazz = BatchEnvironment.class;
        String string3 = Main.getString("generator.env." + string);
        if (string3 != null) {
            try {
                clazz = Class.forName(string3);
                if (this.environmentClass.isAssignableFrom(clazz)) {
                    this.environmentClass = clazz;
                } else if (!clazz.isAssignableFrom(this.environmentClass)) {
                    this.error("rmic.cannot.use.both", this.environmentClass.getName(), clazz.getName());
                    return null;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.error("rmic.class.not.found", string3);
                return null;
            }
        }
        if (string.equals("iiop")) {
            this.iiopGeneration = true;
        }
        return generator;
    }

    protected String[] getArray(String string, boolean bl) {
        String[] stringArray = null;
        String string2 = Main.getString(string);
        if (string2 == null) {
            if (bl) {
                this.error("rmic.resource.not.found", string);
                return null;
            }
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ", \t\n\r", false);
        int n = stringTokenizer.countTokens();
        stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public BatchEnvironment getEnv() {
        ClassPath classPath = BatchEnvironment.createClassPath(this.classPathString, this.sysClassPathArg, this.extDirsArg);
        BatchEnvironment batchEnvironment = null;
        try {
            Class[] classArray = new Class[]{OutputStream.class, ClassPath.class, Main.class};
            Object[] objectArray = new Object[]{this.out, classPath, this};
            Constructor constructor = this.environmentClass.getConstructor(classArray);
            batchEnvironment = (BatchEnvironment)((Object)constructor.newInstance(objectArray));
            batchEnvironment.reset();
        }
        catch (Exception exception) {
            this.error("rmic.cannot.instantiate", this.environmentClass.getName());
        }
        return batchEnvironment;
    }

    /*
     * WARNING - void declaration
     */
    public boolean doCompile() {
        boolean bl;
        Object object;
        BatchEnvironment batchEnvironment;
        block19: {
            batchEnvironment = this.getEnv();
            batchEnvironment.flags |= this.flags;
            batchEnvironment.majorVersion = (short)45;
            batchEnvironment.minorVersion = (short)3;
            String string = Main.getText("rmic.no.memory");
            String string2 = Main.getText("rmic.stack.overflow");
            try {
                void outOfMemoryError;
                int bl2 = this.classes.size() - 1;
                while (outOfMemoryError >= 0) {
                    object = Identifier.lookup((String)((String)this.classes.elementAt((int)outOfMemoryError)));
                    object = batchEnvironment.resolvePackageQualifiedName((Identifier)object);
                    object = Names.mangleClass(object);
                    ClassDeclaration classDeclaration = batchEnvironment.getClassDeclaration((Identifier)object);
                    try {
                        ClassDefinition classDefinition = classDeclaration.getClassDefinition((Environment)batchEnvironment);
                        for (int i = 0; i < this.generators.size(); ++i) {
                            Generator generator = (Generator)this.generators.elementAt(i);
                            generator.generate(batchEnvironment, classDefinition, this.destDir);
                        }
                    }
                    catch (ClassNotFound classNotFound) {
                        batchEnvironment.error(0L, "rmic.class.not.found", object);
                    }
                    --outOfMemoryError;
                }
                if (!this.nocompile) {
                    this.compileAllClasses(batchEnvironment);
                }
            }
            catch (OutOfMemoryError stackOverflowError) {
                batchEnvironment.output(string);
                return false;
            }
            catch (StackOverflowError error) {
                batchEnvironment.output(string2);
                return false;
            }
            catch (Error exception) {
                if (batchEnvironment.nerrors == 0 || batchEnvironment.dump()) {
                    exception.printStackTrace();
                    batchEnvironment.error(0L, "fatal.error");
                }
            }
            catch (Exception exception) {
                if (batchEnvironment.nerrors != 0 && !batchEnvironment.dump()) break block19;
                exception.printStackTrace();
                batchEnvironment.error(0L, "fatal.exception");
            }
        }
        batchEnvironment.flushErrors();
        boolean bl3 = true;
        if (batchEnvironment.nerrors > 0) {
            object = "";
            object = batchEnvironment.nerrors > 1 ? Main.getText("rmic.errors", batchEnvironment.nerrors) : Main.getText("rmic.1error");
            if (batchEnvironment.nwarnings > 0) {
                object = batchEnvironment.nwarnings > 1 ? (String)object + ", " + Main.getText("rmic.warnings", batchEnvironment.nwarnings) : (String)object + ", " + Main.getText("rmic.1warning");
            }
            this.output((String)object);
            bl = false;
        } else if (batchEnvironment.nwarnings > 0) {
            if (batchEnvironment.nwarnings > 1) {
                this.output(Main.getText("rmic.warnings", batchEnvironment.nwarnings));
            } else {
                this.output(Main.getText("rmic.1warning"));
            }
        }
        if (!this.keepGenerated) {
            batchEnvironment.deleteGeneratedFiles();
        }
        if (batchEnvironment.verbose()) {
            this.tm = System.currentTimeMillis() - this.tm;
            this.output(Main.getText("rmic.done_in", Long.toString(this.tm)));
        }
        batchEnvironment.shutdown();
        this.sourcePathArg = null;
        this.sysClassPathArg = null;
        this.extDirsArg = null;
        this.classPathString = null;
        this.destDir = null;
        this.classes = null;
        this.generatorArgs = null;
        this.generators = null;
        this.environmentClass = null;
        this.program = null;
        this.out = null;
        return bl;
    }

    public void compileAllClasses(BatchEnvironment batchEnvironment) throws ClassNotFound, IOException, InterruptedException {
        boolean bl;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        do {
            bl = true;
            Enumeration enumeration = batchEnvironment.getClasses();
            while (enumeration.hasMoreElements()) {
                ClassDeclaration classDeclaration = (ClassDeclaration)enumeration.nextElement();
                bl = this.compileClass(classDeclaration, byteArrayOutputStream, batchEnvironment);
            }
        } while (!bl);
    }

    public boolean compileClass(ClassDeclaration classDeclaration, ByteArrayOutputStream byteArrayOutputStream, BatchEnvironment batchEnvironment) throws ClassNotFound, IOException, InterruptedException {
        boolean bl = true;
        batchEnvironment.flushErrors();
        switch (classDeclaration.getStatus()) {
            case 0: {
                if (!batchEnvironment.dependencies()) break;
            }
            case 3: {
                bl = false;
                batchEnvironment.loadDefinition(classDeclaration);
                if (classDeclaration.getStatus() != 4) break;
            }
            case 4: {
                if (classDeclaration.getClassDefinition().isInsideLocal()) break;
                if (this.nocompile) {
                    throw new IOException("Compilation required, but -Xnocompile option in effect");
                }
                bl = false;
                SourceClass sourceClass = (SourceClass)classDeclaration.getClassDefinition((Environment)batchEnvironment);
                sourceClass.check((Environment)batchEnvironment);
                classDeclaration.setDefinition((ClassDefinition)sourceClass, 5);
            }
            case 5: {
                Object object;
                File file;
                SourceClass sourceClass = (SourceClass)classDeclaration.getClassDefinition((Environment)batchEnvironment);
                if (sourceClass.getError()) {
                    classDeclaration.setDefinition((ClassDefinition)sourceClass, 6);
                    break;
                }
                bl = false;
                byteArrayOutputStream.reset();
                sourceClass.compile((OutputStream)byteArrayOutputStream);
                classDeclaration.setDefinition((ClassDefinition)sourceClass, 6);
                sourceClass.cleanup((Environment)batchEnvironment);
                if (sourceClass.getError() || this.nowrite) break;
                String string = classDeclaration.getName().getQualifier().toString().replace('.', File.separatorChar);
                String string2 = classDeclaration.getName().getFlatName().toString().replace('.', '$') + ".class";
                if (this.destDir != null) {
                    if (string.length() > 0) {
                        file = new File(this.destDir, string);
                        if (!file.exists()) {
                            file.mkdirs();
                        }
                        file = new File(file, string2);
                    } else {
                        file = new File(this.destDir, string2);
                    }
                } else {
                    object = (ClassFile)sourceClass.getSource();
                    if (object.isZipped()) {
                        batchEnvironment.error(0L, "cant.write", object.getPath());
                        break;
                    }
                    file = new File(object.getPath());
                    file = new File(file.getParent(), string2);
                }
                try {
                    object = new FileOutputStream(file.getPath());
                    byteArrayOutputStream.writeTo((OutputStream)object);
                    ((FileOutputStream)object).close();
                    if (!batchEnvironment.verbose()) break;
                    this.output(Main.getText("rmic.wrote", file.getPath()));
                    break;
                }
                catch (IOException iOException) {
                    batchEnvironment.error(0L, "cant.write", file.getPath());
                }
            }
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        Main main = new Main(System.out, "rmic");
        System.exit(main.compile(stringArray) ? 0 : 1);
    }

    public static String getString(String string) {
        if (!resourcesInitialized) {
            Main.initResources();
        }
        if (resourcesExt != null) {
            try {
                return resourcesExt.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        try {
            return resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private static void initResources() {
        try {
            resources = ResourceBundle.getBundle("sun.rmi.rmic.resources.rmic");
            resourcesInitialized = true;
            try {
                resourcesExt = ResourceBundle.getBundle("sun.rmi.rmic.resources.rmicext");
            }
            catch (MissingResourceException missingResourceException) {}
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("fatal: missing resource bundle: " + missingResourceException.getClassName());
        }
    }

    public static String getText(String string) {
        String string2 = Main.getString(string);
        if (string2 == null) {
            string2 = "no text found: \"" + string + "\"";
        }
        return string2;
    }

    public static String getText(String string, int n) {
        return Main.getText(string, Integer.toString(n), null, null);
    }

    public static String getText(String string, String string2) {
        return Main.getText(string, string2, null, null);
    }

    public static String getText(String string, String string2, String string3) {
        return Main.getText(string, string2, string3, null);
    }

    public static String getText(String string, String string2, String string3, String string4) {
        String string5 = Main.getString(string);
        if (string5 == null) {
            string5 = "no text found: key = \"" + string + "\", " + "arguments = \"{0}\", \"{1}\", \"{2}\"";
        }
        Object[] objectArray = new String[]{string2 != null ? string2.toString() : "null", string3 != null ? string3.toString() : "null", string4 != null ? string4.toString() : "null"};
        return MessageFormat.format(string5, objectArray);
    }

    static {
        resourcesExt = null;
    }
}

