/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmmf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class IssuerAndSubject
implements ASN1Value {
    private ANY issuer;
    private ANY subject;
    private INTEGER certReqId;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    private IssuerAndSubject() {
    }

    public IssuerAndSubject(ANY aNY, ANY aNY2, INTEGER iNTEGER) {
        if (aNY == null || aNY2 == null) {
            throw new IllegalArgumentException("parameter to IssuerAndSubject constructor is null");
        }
        this.sequence = new SEQUENCE();
        this.issuer = aNY;
        this.sequence.addElement(aNY);
        this.subject = aNY2;
        this.sequence.addElement(aNY2);
        this.certReqId = iNTEGER;
        this.sequence.addElement(iNTEGER);
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.sequence.encode(outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public INTEGER getCertReqId() {
        return this.certReqId;
    }

    public ANY getIssuer() {
        return this.issuer;
    }

    public ANY getSubject() {
        return this.subject;
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(ANY.getTemplate());
            this.seqt.addElement(ANY.getTemplate());
            this.seqt.addOptionalElement(INTEGER.getTemplate());
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            return new IssuerAndSubject((ANY)sEQUENCE.elementAt(0), (ANY)sEQUENCE.elementAt(1), (INTEGER)sEQUENCE.elementAt(2));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }
    }
}

