/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class TaggedAttribute
implements ASN1Value {
    public static final INTEGER BODYIDMAX = new INTEGER("4294967295");
    private SEQUENCE sequence;
    private INTEGER bodyPartID;
    private OBJECT_IDENTIFIER type;
    private SET values;
    public static final Tag TAG = SEQUENCE.TAG;
    private static Template templateInstance = new Template();

    private TaggedAttribute() {
    }

    public TaggedAttribute(INTEGER iNTEGER, OBJECT_IDENTIFIER oBJECT_IDENTIFIER, ASN1Value aSN1Value) {
        this.sequence = new SEQUENCE();
        Assert.assert(iNTEGER.compareTo(BODYIDMAX) <= 0);
        this.bodyPartID = iNTEGER;
        this.sequence.addElement(iNTEGER);
        this.type = oBJECT_IDENTIFIER;
        this.sequence.addElement(oBJECT_IDENTIFIER);
        this.values = new SET();
        this.values.addElement(aSN1Value);
        this.sequence.addElement(this.values);
    }

    public TaggedAttribute(INTEGER iNTEGER, OBJECT_IDENTIFIER oBJECT_IDENTIFIER, SET sET) {
        this.sequence = new SEQUENCE();
        Assert.assert(iNTEGER.compareTo(BODYIDMAX) <= 0);
        this.bodyPartID = iNTEGER;
        this.sequence.addElement(iNTEGER);
        this.type = oBJECT_IDENTIFIER;
        this.sequence.addElement(oBJECT_IDENTIFIER);
        this.values = sET;
        this.sequence.addElement(sET);
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public INTEGER getBodyPartID() {
        return this.bodyPartID;
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public OBJECT_IDENTIFIER getType() {
        return this.type;
    }

    public SET getValues() {
        return this.values;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(new OBJECT_IDENTIFIER.Template());
            this.seqt.addElement(new SET.OF_Template(new ANY.Template()));
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            Assert.assert(sEQUENCE.size() == 3);
            return new TaggedAttribute((INTEGER)sEQUENCE.elementAt(0), (OBJECT_IDENTIFIER)sEQUENCE.elementAt(1), (SET)sEQUENCE.elementAt(2));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }
    }
}

