/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs12;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BMPString;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.JSSSecureRandom;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs12.CertBag;
import org.mozilla.jss.pkcs12.PasswordConverter;
import org.mozilla.jss.pkix.primitive.Attribute;
import org.mozilla.jss.pkix.primitive.EncryptedPrivateKeyInfo;
import org.mozilla.jss.pkix.primitive.PrivateKeyInfo;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.AssertionException;
import org.mozilla.jss.util.Password;

public final class SafeBag
implements ASN1Value {
    private OBJECT_IDENTIFIER bagType;
    private ANY bagContent;
    private SET bagAttributes;
    public static final OBJECT_IDENTIFIER PKCS12_VERSION_1 = OBJECT_IDENTIFIER.PKCS12.subBranch(10L);
    public static final OBJECT_IDENTIFIER PKCS12_BAG_IDS = PKCS12_VERSION_1.subBranch(1L);
    public static final OBJECT_IDENTIFIER KEY_BAG = PKCS12_BAG_IDS.subBranch(1L);
    public static final OBJECT_IDENTIFIER PKCS8_SHROUDED_KEY_BAG = PKCS12_BAG_IDS.subBranch(2L);
    public static final OBJECT_IDENTIFIER CERT_BAG = PKCS12_BAG_IDS.subBranch(3L);
    public static final OBJECT_IDENTIFIER CRL_BAG = PKCS12_BAG_IDS.subBranch(4L);
    public static final OBJECT_IDENTIFIER SECRET_BAG = PKCS12_BAG_IDS.subBranch(5L);
    public static final OBJECT_IDENTIFIER SAFE_CONTENTS_BAG = PKCS12_BAG_IDS.subBranch(6L);
    public static final OBJECT_IDENTIFIER FRIENDLY_NAME = OBJECT_IDENTIFIER.PKCS9.subBranch(20L);
    public static final OBJECT_IDENTIFIER LOCAL_KEY_ID = OBJECT_IDENTIFIER.PKCS9.subBranch(21L);
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    private SafeBag() {
    }

    public SafeBag(OBJECT_IDENTIFIER oBJECT_IDENTIFIER, ASN1Value aSN1Value, SET sET) {
        if (oBJECT_IDENTIFIER == null || aSN1Value == null) {
            throw new IllegalArgumentException("bagType or bagContent is null");
        }
        this.bagType = oBJECT_IDENTIFIER;
        try {
            if (aSN1Value instanceof ANY) {
                this.bagContent = (ANY)aSN1Value;
            } else {
                byte[] byArray = ASN1Util.encode(aSN1Value);
                this.bagContent = (ANY)ASN1Util.decode(ANY.getTemplate(), byArray);
            }
        }
        catch (InvalidBERException invalidBERException) {
            Assert.notReached("failed to convert ASN1Value to ANY");
        }
        this.bagAttributes = sET;
    }

    public static SafeBag createCertBag(byte[] byArray, String string) throws DigestException, NoSuchAlgorithmException, InvalidBERException {
        return SafeBag.createCertBag(byArray, string, SafeBag.getLocalKeyIDFromCert(byArray));
    }

    public static SafeBag createCertBag(byte[] byArray, String string, byte[] byArray2) throws InvalidBERException {
        try {
            CertBag certBag = new CertBag(CertBag.X509_CERT_TYPE, new ANY(byArray));
            SET sET = new SET();
            sET.addElement(new Attribute(FRIENDLY_NAME, new BMPString(string)));
            sET.addElement(new Attribute(LOCAL_KEY_ID, new OCTET_STRING(byArray2)));
            return new SafeBag(CERT_BAG, certBag, sET);
        }
        catch (CharConversionException charConversionException) {
            throw new AssertionException("CharConversionException converting Unicode to BMPString");
        }
    }

    public static SafeBag createEncryptedPrivateKeyBag(PrivateKeyInfo privateKeyInfo, String string, byte[] byArray, Password password) throws CryptoManager.NotInitializedException, TokenException {
        try {
            PBEAlgorithm pBEAlgorithm = PBEAlgorithm.PBE_SHA1_DES3_CBC;
            boolean bl = true;
            byte[] byArray2 = new byte[pBEAlgorithm.getSaltLength()];
            JSSSecureRandom jSSSecureRandom = CryptoManager.getInstance().getSecureRNG();
            jSSSecureRandom.nextBytes(byArray2);
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = EncryptedPrivateKeyInfo.createPBE(PBEAlgorithm.PBE_SHA1_DES3_CBC, password, byArray2, 1, new PasswordConverter(), privateKeyInfo);
            SET sET = new SET();
            sET.addElement(new Attribute(FRIENDLY_NAME, new BMPString(string)));
            sET.addElement(new Attribute(LOCAL_KEY_ID, new OCTET_STRING(byArray)));
            return new SafeBag(PKCS8_SHROUDED_KEY_BAG, encryptedPrivateKeyInfo, sET);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionException("Unable to find PBE algorithm: " + noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AssertionException("InvalidKeyException while creating EncryptedContentInfo: " + invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new AssertionException("InvalidAlgorithmParameterException while creating EncryptedContentInfo: " + invalidAlgorithmParameterException);
        }
        catch (CharConversionException charConversionException) {
            throw new AssertionException("CharConversionException while creating EncryptedContentInfo: " + charConversionException);
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addElement(this.bagType);
        sEQUENCE.addElement(new EXPLICIT(new Tag(0L), this.bagContent));
        if (this.bagAttributes != null) {
            sEQUENCE.addElement(this.bagAttributes);
        }
        sEQUENCE.encode(tag, outputStream);
    }

    public SET getBagAttributes() {
        return this.bagAttributes;
    }

    public ANY getBagContent() {
        return this.bagContent;
    }

    public OBJECT_IDENTIFIER getBagType() {
        return this.bagType;
    }

    public ASN1Value getInterpretedBagContent() throws InvalidBERException {
        if (this.bagType.equals(KEY_BAG)) {
            return this.bagContent.decodeWith(PrivateKeyInfo.getTemplate());
        }
        if (this.bagType.equals(PKCS8_SHROUDED_KEY_BAG)) {
            return this.bagContent.decodeWith(EncryptedPrivateKeyInfo.getTemplate());
        }
        if (this.bagType.equals(CERT_BAG)) {
            return this.bagContent.decodeWith(CertBag.getTemplate());
        }
        return this.bagContent;
    }

    public static final byte[] getLocalKeyIDFromCert(byte[] byArray) throws DigestException, NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        return messageDigest.digest(byArray);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(OBJECT_IDENTIFIER.getTemplate());
            this.seqt.addElement(new EXPLICIT.Template(new Tag(0L), ANY.getTemplate()));
            this.seqt.addOptionalElement(new SET.OF_Template(Attribute.getTemplate()));
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            try {
                SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
                return new SafeBag((OBJECT_IDENTIFIER)sEQUENCE.elementAt(0), ((EXPLICIT)sEQUENCE.elementAt(1)).getContent(), (SET)sEQUENCE.elementAt(2));
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidBERException(invalidBERException, "SafeBag");
            }
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }
    }
}

