/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.NoSuchItemOnTokenException;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs11.KeyType;
import org.mozilla.jss.pkcs11.PK11Key;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.pkcs11.PrivateKeyProxy;
import org.mozilla.jss.util.Assert;

final class PK11PrivKey
extends PK11Key
implements PrivateKey {
    protected PK11PrivKey(byte[] byArray) {
        Assert.assert(byArray != null);
        this.keyProxy = new PrivateKeyProxy(byArray);
    }

    public native KeyType getKeyType();

    public native CryptoToken getOwningToken();

    public native int getStrength();

    public PrivateKey.Type getType() {
        KeyType keyType = this.getKeyType();
        if (keyType == KeyType.RSA) {
            return PrivateKey.Type.RSA;
        }
        Assert.assert(keyType == KeyType.DSA);
        return PrivateKey.Type.DSA;
    }

    public native byte[] getUniqueID() throws TokenException;

    public native void verifyKeyIsOnToken(PK11Token var1) throws NoSuchItemOnTokenException;
}

