/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.PrintableString;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public abstract class TimeBase
implements ASN1Value {
    public static final Form FORM = Form.PRIMITIVE;
    private Date date;

    private TimeBase() {
    }

    public TimeBase(Date date) {
        this.date = date;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(this.getTag(), outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        int n;
        if (this.isUTC()) {
            new ASN1Header(tag, FORM, 13L).encode(outputStream);
        } else {
            new ASN1Header(tag, FORM, 15L).encode(outputStream);
        }
        boolean bl = false;
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTime(this.date);
        if (this.isUTC()) {
            n = calendar.get(1);
            outputStream.write(n % 100 / 10 + 48);
            outputStream.write(n % 10 + 48);
        } else {
            n = calendar.get(1);
            outputStream.write(n % 10000 / 1000 + 48);
            outputStream.write(n % 1000 / 100 + 48);
            outputStream.write(n % 100 / 10 + 48);
            outputStream.write(n % 10 + 48);
        }
        n = calendar.get(2) + 1;
        Assert.assert(n >= 1 && n <= 12);
        outputStream.write(n / 10 + 48);
        outputStream.write(n % 10 + 48);
        n = calendar.get(5);
        Assert.assert(n >= 1 && n <= 31);
        outputStream.write(n / 10 + 48);
        outputStream.write(n % 10 + 48);
        n = calendar.get(11);
        Assert.assert(n >= 0 && n <= 23);
        outputStream.write(n / 10 + 48);
        outputStream.write(n % 10 + 48);
        n = calendar.get(12);
        Assert.assert(n >= 0 && n <= 59);
        outputStream.write(n / 10 + 48);
        outputStream.write(n % 10 + 48);
        n = calendar.get(13);
        Assert.assert(n >= 0 && n <= 59);
        outputStream.write(n / 10 + 48);
        outputStream.write(n % 10 + 48);
        outputStream.write(90);
    }

    public abstract Tag getTag();

    protected abstract boolean isUTC();

    public Date toDate() {
        return this.date;
    }

    public static abstract class Template {
        private static void checkBounds(int n, int n2, int n3) throws InvalidBERException {
            if (n + n2 > n3) {
                throw new InvalidBERException("Too few characters in TimeBase");
            }
        }

        private static void checkRange(int n, int n2, int n3, String string) throws InvalidBERException {
            if (n < n2 || n > n3) {
                throw new InvalidBERException("Invalid " + string);
            }
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), inputStream);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            TimeZone timeZone;
            int n;
            int n2;
            PrintableString.Template template = new PrintableString.Template();
            PrintableString printableString = (PrintableString)template.decode(tag, inputStream);
            char[] cArray = printableString.toCharArray();
            int n3 = 0;
            if (this.isUTC()) {
                Template.checkBounds(n3, 2, cArray.length);
                n2 = (cArray[n3] - 48) * 10;
                n2 = (n2 += cArray[n3 + 1] - 48) < 70 ? (n2 += 2000) : (n2 += 1900);
                n3 += 2;
            } else {
                Template.checkBounds(n3, 4, cArray.length);
                n2 = (cArray[n3] - 48) * 1000;
                n2 += (cArray[n3 + 1] - 48) * 100;
                n2 += (cArray[n3 + 2] - 48) * 10;
                Template.checkRange(n2 += cArray[n3 + 3] - 48, 0, 9999, "year");
                n3 += 4;
            }
            int n4 = 0;
            Template.checkBounds(n3, 2, cArray.length);
            n4 = (cArray[n3] - 48) * 10;
            Template.checkRange(n4 += cArray[n3 + 1] - 48, 1, 12, "month");
            --n4;
            Template.checkBounds(n3 += 2, 2, cArray.length);
            int n5 = (cArray[n3] - 48) * 10;
            Template.checkRange(n5 += cArray[n3 + 1] - 48, 1, 31, "day");
            Template.checkBounds(n3 += 2, 2, cArray.length);
            int n6 = (cArray[n3] - 48) * 10;
            Template.checkRange(n6 += cArray[n3 + 1] - 48, 0, 23, "hour");
            Template.checkBounds(n3 += 2, 2, cArray.length);
            int n7 = (cArray[n3] - 48) * 10;
            Template.checkRange(n7 += cArray[n3 + 1] - 48, 0, 59, "minute");
            if ((n3 += 2) < cArray.length && cArray[n3] >= '0' && cArray[n3] <= '9') {
                Template.checkBounds(n3, 2, cArray.length);
                n = (cArray[n3] - 48) * 10;
                Template.checkRange(n += cArray[n3 + 1] - 48, 0, 59, "second");
                n3 += 2;
            } else {
                n = 0;
            }
            if (!this.isUTC()) {
                while (n3 < cArray.length && cArray[n3] != '+' && cArray[n3] != '-' && cArray[n3] != 'Z') {
                    ++n3;
                }
            }
            if (n3 < cArray.length) {
                Template.checkBounds(n3, 1, cArray.length);
                if (cArray[n3] == '+' || cArray[n3] == '-') {
                    Template.checkBounds(n3 + 1, 4, cArray.length);
                    int n8 = (cArray[n3 + 1] - 48) * 10;
                    n8 += cArray[n3 + 2] - 48;
                    int n9 = (cArray[n3 + 3] - 48) * 10;
                    n9 += cArray[n3 + 4] - 48;
                    Template.checkRange(n8, 0, 23, "hour offset");
                    Template.checkRange(n9, 0, 59, "minute offset");
                    if (cArray[n3 += 5] == '-') {
                        n8 = -n8;
                        n9 = -n9;
                    }
                    timeZone = (TimeZone)TimeZone.getTimeZone("GMT").clone();
                    timeZone.setRawOffset((n8 * 60 + n9) * 60 * 1000);
                } else {
                    if (cArray[n3] != 'Z') throw new InvalidBERException("Invalid character " + cArray[n3]);
                    ++n3;
                    boolean bl = false;
                    boolean bl2 = false;
                    timeZone = (TimeZone)TimeZone.getTimeZone("GMT").clone();
                }
            } else {
                if (this.isUTC()) {
                    throw new InvalidBERException("no timezone specified for UTCTime");
                }
                timeZone = TimeZone.getDefault();
            }
            if (n3 != cArray.length) {
                throw new InvalidBERException("Extra characters at end");
            }
            Calendar calendar = Calendar.getInstance(timeZone);
            calendar.set(n2, n4, n5, n6, n7, n);
            return this.generateInstance(calendar.getTime());
        }

        protected abstract TimeBase generateInstance(Date var1);

        protected abstract Tag getTag();

        protected abstract boolean isUTC();

        public boolean tagMatch(Tag tag) {
            return this.getTag().equals(tag);
        }
    }
}

