/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Random;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;

public class INTEGER
extends BigInteger
implements ASN1Value {
    private byte[] encodedContents = null;
    public static final Tag TAG = new Tag(Tag.Class.UNIVERSAL, 2L);
    public static final Form FORM = Form.PRIMITIVE;
    private static final Template templateInstance = new Template();

    public INTEGER(int n, int n2, Random random) {
        super(n, n2, random);
    }

    public INTEGER(int n, Random random) throws NumberFormatException {
        super(n, random);
    }

    public INTEGER(int n, byte[] byArray) throws NumberFormatException {
        super(n, byArray);
    }

    public INTEGER(long l) {
        super(BigInteger.valueOf(l).toByteArray());
    }

    public INTEGER(String string) throws NumberFormatException {
        super(string);
    }

    public INTEGER(String string, int n) throws NumberFormatException {
        super(string, n);
    }

    public INTEGER(byte[] byArray) throws NumberFormatException {
        super(byArray);
    }

    private static boolean arraysEqual(byte[] byArray, int[] nArray) {
        if (byArray == null || nArray == null) {
            return false;
        }
        if (byArray.length != nArray.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != (byte)nArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public byte[] encode() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(this.getTag(), outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.getHeader(tag).encode(outputStream);
        outputStream.write(this.getEncodedContents());
    }

    public long getContentLength() {
        return this.getEncodedContents().length;
    }

    private byte[] getEncodedContents() {
        if (this.encodedContents == null) {
            this.encodedContents = this.toByteArray();
        }
        return this.encodedContents;
    }

    private ASN1Header getHeader(Tag tag) {
        return new ASN1Header(tag, FORM, this.getContentLength());
    }

    public Tag getTag() {
        return TAG;
    }

    public static ASN1Template getTemplate() {
        return templateInstance;
    }

    public static void main(String[] stringArray) {
        try {
            int[] nArray = new int[11];
            int[][] nArray2 = new int[11][];
            int n = 0;
            nArray[n] = 0;
            int n2 = n++;
            int[] nArray3 = new int[3];
            nArray3[0] = 2;
            nArray3[1] = 1;
            nArray2[n2] = nArray3;
            nArray[n] = 1;
            nArray2[n++] = new int[]{2, 1, 1};
            nArray[n] = -1;
            nArray2[n++] = new int[]{2, 1, 255};
            nArray[n] = 127;
            nArray2[n++] = new int[]{2, 1, 127};
            nArray[n] = 128;
            int n3 = n++;
            int[] nArray4 = new int[4];
            nArray4[0] = 2;
            nArray4[1] = 2;
            nArray4[3] = 128;
            nArray2[n3] = nArray4;
            nArray[n] = 255;
            int n4 = n++;
            int[] nArray5 = new int[4];
            nArray5[0] = 2;
            nArray5[1] = 2;
            nArray5[3] = 255;
            nArray2[n4] = nArray5;
            nArray[n] = 256;
            int n5 = n++;
            int[] nArray6 = new int[4];
            nArray6[0] = 2;
            nArray6[1] = 2;
            nArray6[2] = 1;
            nArray2[n5] = nArray6;
            nArray[n] = -128;
            nArray2[n++] = new int[]{2, 1, 128};
            nArray[n] = -129;
            nArray2[n++] = new int[]{2, 2, 255, 127};
            nArray[n] = 43568;
            int n6 = n++;
            int[] nArray7 = new int[5];
            nArray7[0] = 2;
            nArray7[1] = 3;
            nArray7[3] = 170;
            nArray7[4] = 48;
            nArray2[n6] = nArray7;
            nArray[n] = -43568;
            nArray2[n++] = new int[]{2, 3, 255, 85, 208};
            n = 0;
            while (n < nArray.length) {
                ByteArrayInputStream byteArrayInputStream;
                Template template;
                INTEGER iNTEGER;
                INTEGER iNTEGER2 = new INTEGER(nArray[n]);
                byte[] byArray = iNTEGER2.encode();
                if (!INTEGER.arraysEqual(byArray, nArray2[n])) {
                    System.err.println("Encoding FAILED: " + nArray[n]);
                    System.exit(-1);
                }
                if ((iNTEGER = (INTEGER)(template = new Template()).decode(byteArrayInputStream = new ByteArrayInputStream(byArray))).intValue() != nArray[n]) {
                    System.err.println("Decoding FAILED: " + nArray[n]);
                    System.exit(-1);
                }
                ++n;
            }
            System.out.println("PASS");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class Template
    implements ASN1Template {
        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(this.getTag(), inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            try {
                ASN1Header aSN1Header = new ASN1Header(inputStream);
                aSN1Header.validate(tag, FORM);
                if (aSN1Header.getContentLength() < 1L) {
                    throw new InvalidBERException("Invalid 0 length for INTEGER");
                }
                byte[] byArray = new byte[(int)aSN1Header.getContentLength()];
                ASN1Util.readFully(byArray, inputStream);
                return new INTEGER(byArray);
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidBERException(invalidBERException, "INTEGER");
            }
        }

        Tag getTag() {
            return TAG;
        }

        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }
    }
}

