/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Session;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class MailSessionFactory
implements ObjectFactory {
    protected static final String factoryType = "javax.mail.Session";

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        final Reference reference = (Reference)object;
        if (!reference.getClassName().equals(factoryType)) {
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                RefAddr refAddr;
                Properties properties = new Properties();
                properties.put("mail.transport.protocol", "smtp");
                properties.put("mail.smtp.host", "localhost");
                Enumeration<RefAddr> enumeration = reference.getAll();
                while (enumeration.hasMoreElements()) {
                    refAddr = enumeration.nextElement();
                    if ("factory".equals(refAddr.getType())) continue;
                    properties.put(refAddr.getType(), (String)refAddr.getContent());
                }
                refAddr = Session.getInstance((Properties)properties, null);
                return refAddr;
            }
        });
    }
}

