/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.logging;

import java.io.Writer;
import javax.servlet.ServletContext;
import org.apache.jasper.logging.LogDaemon;
import org.apache.jasper.logging.Logger;
import org.apache.jasper.util.Queue;

public class JasperLogger
extends Logger {
    static LogDaemon logDaemon = null;
    static Queue logQueue = null;
    ServletContext servletContext = null;

    public JasperLogger(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.init();
    }

    public JasperLogger() {
        this.init();
    }

    private void init() {
        if (logDaemon == null || logQueue == null) {
            logQueue = new Queue();
            LogDaemon logDaemon = new LogDaemon(logQueue, this.servletContext);
            logDaemon.start();
        }
    }

    protected void realLog(String string) {
        logQueue.put(new LogEntry(string, null));
    }

    protected void realLog(String string, Throwable throwable) {
        logQueue.put(new LogEntry(string, throwable));
    }

    public void flush() {
        logDaemon.flush();
    }

    public String toString() {
        return "JasperLogger(" + this.getName() + ", " + this.getPath() + ")";
    }

    class LogEntry {
        String logName;
        long date;
        String message;
        Throwable t;

        LogEntry(String string, Throwable throwable) {
            if (JasperLogger.this.timestamp) {
                this.date = System.currentTimeMillis();
            }
            this.message = string;
            this.t = throwable;
        }

        Writer getWriter() {
            return JasperLogger.this.sink;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (!JasperLogger.this.custom) {
                stringBuffer.append("<");
                stringBuffer.append(JasperLogger.this.getName());
                stringBuffer.append("> ");
            }
            if (JasperLogger.this.timestamp) {
                JasperLogger.this.formatTimestamp(this.date, stringBuffer);
                stringBuffer.append(" - ");
            }
            if (this.message != null) {
                stringBuffer.append(this.message);
            }
            if (this.t != null) {
                stringBuffer.append(" - ");
                stringBuffer.append(Logger.throwableToString(this.t));
            }
            if (!JasperLogger.this.custom) {
                stringBuffer.append("</");
                stringBuffer.append(JasperLogger.this.getName());
                stringBuffer.append("> ");
            }
            return stringBuffer.toString();
        }
    }
}

