/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util.ssi;

import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.util.DateTool;
import org.apache.catalina.util.ssi.SsiCommand;
import org.apache.catalina.util.ssi.SsiConfig;
import org.apache.catalina.util.ssi.SsiEcho;
import org.apache.catalina.util.ssi.SsiExec;
import org.apache.catalina.util.ssi.SsiFlastmod;
import org.apache.catalina.util.ssi.SsiFsize;
import org.apache.catalina.util.ssi.SsiInclude;

public class SsiMediator {
    protected static Hashtable serverVariables = new Hashtable(17);
    protected static Hashtable ssiCommands = null;
    protected static HttpServletRequest req = null;
    protected static HttpServletResponse res = null;
    protected static OutputStream out = null;
    protected static ServletContext servletContext = null;
    protected static ServletContext origServletContext = null;
    protected static String contextPath = null;
    protected static String relpath = "/";
    protected static String path = new String();
    protected static int debug = 0;
    protected static boolean isVirtualWebappRelative = false;

    public SsiMediator() {
    }

    public SsiMediator(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, OutputStream outputStream, ServletContext servletContext, int n, String string, boolean bl) {
        debug = n;
        this.flush(httpServletRequest, httpServletResponse, outputStream, servletContext, string, bl);
    }

    public final SsiCommand getCommand(String string) {
        return (SsiCommand)ssiCommands.get(string);
    }

    public void flush(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, OutputStream outputStream, ServletContext servletContext, String string, boolean bl) {
        req = httpServletRequest;
        res = httpServletResponse;
        out = outputStream;
        SsiMediator.servletContext = servletContext;
        origServletContext = servletContext;
        contextPath = httpServletRequest.getContextPath();
        path = string;
        relpath = string.substring(0, string.lastIndexOf(47) + 1);
        isVirtualWebappRelative = bl;
        int n = 0;
        serverVariables.put("AUTH_TYPE", this.nullToString(httpServletRequest.getAuthType()));
        n = httpServletRequest.getContentLength();
        serverVariables.put("CONTENT_LENGTH", this.nullToString(n <= 0 ? null : new Integer(n).toString()));
        serverVariables.put("CONTENT_TYPE", this.nullToString(httpServletRequest.getContentType()));
        serverVariables.put("GATEWAY_INTERFACE", "CGI/1.1");
        serverVariables.put("PATH_INFO", this.nullToString(httpServletRequest.getPathInfo()));
        serverVariables.put("PATH_TRANSLATED ", this.nullToString(httpServletRequest.getPathTranslated()));
        serverVariables.put("QUERY_STRING", this.nullToString(httpServletRequest.getQueryString()));
        serverVariables.put("REMOTE_ADDR", this.nullToString(httpServletRequest.getRemoteAddr()));
        serverVariables.put("REMOTE_HOST", this.nullToString(httpServletRequest.getRemoteHost()));
        serverVariables.put("REMOTE_IDENT", "");
        serverVariables.put("REMOTE_USER", this.nullToString(httpServletRequest.getRemoteUser()));
        serverVariables.put("REQUEST_METHOD", this.nullToString(httpServletRequest.getMethod()));
        serverVariables.put("SCRIPT_NAME", this.nullToString(httpServletRequest.getServletPath()));
        serverVariables.put("SERVER_NAME", this.nullToString(httpServletRequest.getServerName()));
        serverVariables.put("SERVER_PORT", new Integer(httpServletRequest.getServerPort()).toString());
        serverVariables.put("SERVER_PROTOCOL", this.nullToString(httpServletRequest.getProtocol()));
        serverVariables.put("SERVER_SOFTWARE", this.nullToString(servletContext.getServerInfo()));
        serverVariables.put("DOCUMENT_NAME", this.nullToString(string.substring(string.lastIndexOf(47) + 1, string.length())));
        serverVariables.put("DOCUMENT_URI", this.nullToString(string));
        serverVariables.put("QUERY_STRING_UNESCAPED", this.nullToString(""));
        this.flushDate();
        ((SsiConfig)ssiCommands.get("config")).flush();
    }

    public byte[] getError() {
        return ((SsiConfig)ssiCommands.get("config")).getError();
    }

    protected void flushDate() {
        serverVariables.put("DATE_LOCAL", this.timefmt(new Date()));
        serverVariables.put("DATE_GMT", this.timefmt(this.getGMTDate()));
        serverVariables.put("LAST_MODIFIED", ((SsiFlastmod)ssiCommands.get("flastmod")).getDate(path));
    }

    protected String timefmt(Date date) {
        String string = ((SsiConfig)ssiCommands.get("config")).getTimefmt();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, DateTool.LOCALE_US);
        return simpleDateFormat.format(date);
    }

    protected String timefmt(String string) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        Date date = null;
        try {
            date = dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return new String(this.getError());
        }
        return this.timefmt(date);
    }

    protected String getServerVariable(String string) {
        this.flushDate();
        if (serverVariables.get(string) == null) {
            return new String(this.getError());
        }
        return (String)serverVariables.get(string);
    }

    protected String getVirtualPath(String string) {
        int n;
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (string2 == null) {
            return null;
        }
        if (string2.indexOf(92) >= 0) {
            string2 = string2.replace('\\', '/');
        }
        if (!string2.startsWith("/")) {
            string2 = relpath.concat(string2);
        }
        while ((n = string2.indexOf("//")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 1);
        }
        while ((n = string2.indexOf("/./")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 2);
        }
        while ((n = string2.indexOf("/../")) >= 0) {
            if (n == 0) {
                return null;
            }
            int n2 = string2.lastIndexOf(47, n - 1);
            string2 = string2.substring(0, n2) + string2.substring(n + 3);
        }
        if (!isVirtualWebappRelative) {
            String string3;
            ServletContext servletContext;
            if (!string.startsWith("/") || string.startsWith("./")) {
                SsiMediator.servletContext = origServletContext;
            } else if (string.indexOf(47, 1) == -1) {
                SsiMediator.servletContext = SsiMediator.servletContext.getContext("/");
            } else if (!contextPath.equals("") && string2 != null && string2.startsWith(contextPath)) {
                SsiMediator.servletContext = SsiMediator.servletContext.getContext(contextPath);
                string2 = string2.substring(contextPath.length());
            } else if (string2 != null && (servletContext = SsiMediator.servletContext.getContext(string3 = string2.substring(0, string.indexOf(47, 1)))) != null) {
                SsiMediator.servletContext = servletContext;
                string2 = string2.substring(string3.length());
            }
        }
        return string2;
    }

    protected String getFilePath(String string) {
        int n;
        if (string == null) {
            return null;
        }
        String string2 = string;
        servletContext = origServletContext;
        if (string2 == null) {
            return null;
        }
        if (string2.indexOf(92) >= 0) {
            string2 = string2.replace('\\', '/');
        }
        while ((n = string2.indexOf("//")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 1);
        }
        if (string2.startsWith("/") || string2.indexOf("../") >= 0) {
            return null;
        }
        return relpath.concat(string2);
    }

    protected String getCGIPath(String string) {
        String string2 = "/cgi-bin/";
        if (string == null) {
            return null;
        }
        if (!string.startsWith(string2)) {
            return null;
        }
        string = "http://localhost:8080" + contextPath + string;
        return string;
    }

    protected String getCommandPath(String string) {
        String string2 = "/bin/sh";
        if (string == null) {
            return null;
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        string = string2 + string;
        return string;
    }

    private String nullToString(String string) {
        return string == null ? "" : string;
    }

    private String getGMTDate() {
        Date date = new Date();
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        dateFormat.setTimeZone(DateTool.GMT_ZONE);
        return dateFormat.format(date);
    }

    static {
        ssiCommands = new Hashtable(6);
        ssiCommands.put("config", new SsiConfig());
        ssiCommands.put("include", new SsiInclude());
        ssiCommands.put("echo", new SsiEcho());
        ssiCommands.put("fsize", new SsiFsize());
        ssiCommands.put("flastmod", new SsiFlastmod());
        ssiCommands.put("exec", new SsiExec());
    }
}

