/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.Cookie;

public final class RequestUtil {
    private static SimpleDateFormat format = new SimpleDateFormat(" EEEE, dd-MMM-yy kk:mm:ss zz");

    public static String encodeCookie(Cookie cookie) {
        StringBuffer stringBuffer = new StringBuffer(cookie.getName());
        stringBuffer.append("=");
        stringBuffer.append(cookie.getValue());
        if (cookie.getComment() != null) {
            stringBuffer.append("; Comment=\"");
            stringBuffer.append(cookie.getComment());
            stringBuffer.append("\"");
        }
        if (cookie.getDomain() != null) {
            stringBuffer.append("; Domain=\"");
            stringBuffer.append(cookie.getDomain());
            stringBuffer.append("\"");
        }
        long l = cookie.getMaxAge();
        if (cookie.getMaxAge() >= 0) {
            stringBuffer.append("; Max-Age=\"");
            stringBuffer.append(cookie.getMaxAge());
            stringBuffer.append("\"");
        }
        if (cookie.getPath() != null) {
            stringBuffer.append("; Path=\"");
            stringBuffer.append(cookie.getPath());
            stringBuffer.append("\"");
        }
        if (cookie.getSecure()) {
            stringBuffer.append("; Secure");
        }
        if (cookie.getVersion() > 0) {
            stringBuffer.append("; Version=\"");
            stringBuffer.append(cookie.getVersion());
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    public static String filter(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        StringBuffer stringBuffer = new StringBuffer(cArray.length + 50);
        block6: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String normalize(String string) {
        int n;
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (string2.equals("/.")) {
            return "/";
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        while ((n = string2.indexOf("//")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 1);
        }
        while ((n = string2.indexOf("/./")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 2);
        }
        while ((n = string2.indexOf("/../")) >= 0) {
            if (n == 0) {
                return null;
            }
            int n2 = string2.lastIndexOf(47, n - 1);
            string2 = string2.substring(0, n2) + string2.substring(n + 3);
        }
        return string2;
    }

    public static String parseCharacterEncoding(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("charset=");
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(n + 8);
        int n2 = string2.indexOf(59);
        if (n2 >= 0) {
            string2 = string2.substring(0, n2);
        }
        if ((string2 = string2.trim()).length() > 2 && string2.startsWith("\"") && string2.endsWith("\"")) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        return string2.trim();
    }

    public static Cookie[] parseCookieHeader(String string) {
        if (string == null || string.length() < 1) {
            return new Cookie[0];
        }
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>();
        while (string.length() > 0) {
            int n = string.indexOf(59);
            if (n < 0) {
                n = string.length();
            }
            if (n == 0) {
                if (string.length() == 1) break;
                string = string.substring(1);
                continue;
            }
            String string2 = string.substring(0, n);
            string = n < string.length() ? string.substring(n + 1) : "";
            try {
                int n2 = string2.indexOf(61);
                if (n2 <= 0) continue;
                String string3 = RequestUtil.URLDecode(string2.substring(0, n2).trim());
                String string4 = string2.substring(n2 + 1).trim();
                arrayList.add(new Cookie(string3, string4));
            }
            catch (Throwable throwable) {}
        }
        return arrayList.toArray(new Cookie[arrayList.size()]);
    }

    public static void parseParameters(Map map, String string, String string2) throws UnsupportedEncodingException {
        if (string != null && string.length() > 0) {
            byte[] byArray = null;
            byArray = string2 == null ? string.getBytes() : string.getBytes(string2);
            RequestUtil.parseParameters(map, byArray, string2);
        }
    }

    public static String URLDecode(String string) {
        return RequestUtil.URLDecode(string, null);
    }

    public static String URLDecode(String string, String string2) {
        if (string == null) {
            return null;
        }
        byte[] byArray = null;
        try {
            byArray = string2 == null ? string.getBytes() : string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return RequestUtil.URLDecode(byArray, string2);
    }

    public static String URLDecode(byte[] byArray) {
        return RequestUtil.URLDecode(byArray, null);
    }

    public static String URLDecode(byte[] byArray, String string) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4;
            if ((n4 = byArray[n2++]) == 43) {
                n4 = 32;
            } else if (n4 == 37) {
                n4 = (byte)((RequestUtil.convertHexDigit(byArray[n2++]) << 4) + RequestUtil.convertHexDigit(byArray[n2++]));
            }
            byArray[n3++] = n4;
        }
        if (string != null) {
            try {
                return new String(byArray, 0, n3, string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return new String(byArray, 0, n3);
    }

    private static byte convertHexDigit(byte by) {
        if (by >= 48 && by <= 57) {
            return (byte)(by - 48);
        }
        if (by >= 97 && by <= 102) {
            return (byte)(by - 97 + 10);
        }
        if (by >= 65 && by <= 70) {
            return (byte)(by - 65 + 10);
        }
        return 0;
    }

    private static void putMapEntry(Map map, String string, String string2) {
        String[] stringArray = null;
        String[] stringArray2 = (String[])map.get(string);
        if (stringArray2 == null) {
            stringArray = new String[]{string2};
        } else {
            stringArray = new String[stringArray2.length + 1];
            System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
            stringArray[stringArray2.length] = string2;
        }
        map.put(string, stringArray);
    }

    public static void parseParameters(Map map, byte[] byArray, String string) throws UnsupportedEncodingException {
        if (byArray != null && byArray.length > 0) {
            boolean bl = false;
            int n = 0;
            int n2 = 0;
            String string2 = null;
            String string3 = null;
            block6: while (n < byArray.length) {
                byte by = byArray[n++];
                switch ((char)by) {
                    case '&': {
                        string3 = new String(byArray, 0, n2, string);
                        if (string2 != null) {
                            RequestUtil.putMapEntry(map, string2, string3);
                            string2 = null;
                        }
                        n2 = 0;
                        continue block6;
                    }
                    case '=': {
                        if (string2 == null) {
                            string2 = new String(byArray, 0, n2, string);
                            n2 = 0;
                            continue block6;
                        }
                        byArray[n2++] = by;
                        continue block6;
                    }
                    case '+': {
                        byArray[n2++] = 32;
                        continue block6;
                    }
                    case '%': {
                        if (n <= byArray.length - 2 && (char)byArray[n] != '&' && (char)byArray[n + 1] != '&') {
                            byArray[n2++] = (byte)((RequestUtil.convertHexDigit(byArray[n++]) << 4) + RequestUtil.convertHexDigit(byArray[n++]));
                            continue block6;
                        }
                        byArray[n2++] = by;
                        continue block6;
                    }
                }
                byArray[n2++] = by;
            }
            if (string2 != null) {
                string3 = new String(byArray, 0, n2, string);
                RequestUtil.putMapEntry(map, string2, string3);
            }
        }
    }

    static {
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

