/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.catalina.util.MIME2Java;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMWriter {
    private static String PRINTWRITER_ENCODING = "UTF8";
    private static String[] MIME2JAVA_ENCODINGS = new String[]{"Default", "UTF-8", "US-ASCII", "ISO-8859-1", "ISO-8859-2", "ISO-8859-3", "ISO-8859-4", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8", "ISO-8859-9", "ISO-2022-JP", "SHIFT_JIS", "EUC-JP", "GB2312", "BIG5", "EUC-KR", "ISO-2022-KR", "KOI8-R", "EBCDIC-CP-US", "EBCDIC-CP-CA", "EBCDIC-CP-NL", "EBCDIC-CP-DK", "EBCDIC-CP-NO", "EBCDIC-CP-FI", "EBCDIC-CP-SE", "EBCDIC-CP-IT", "EBCDIC-CP-ES", "EBCDIC-CP-GB", "EBCDIC-CP-FR", "EBCDIC-CP-AR1", "EBCDIC-CP-HE", "EBCDIC-CP-CH", "EBCDIC-CP-ROECE", "EBCDIC-CP-YU", "EBCDIC-CP-IS", "EBCDIC-CP-AR2", "UTF-16"};
    protected PrintWriter out;
    protected boolean canonical;

    public DOMWriter(String string, boolean bl) throws UnsupportedEncodingException {
        this.out = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, string));
        this.canonical = bl;
    }

    public DOMWriter(boolean bl) throws UnsupportedEncodingException {
        this(DOMWriter.getWriterEncoding(), bl);
    }

    public DOMWriter(Writer writer, boolean bl) {
        this.out = new PrintWriter(writer);
        this.canonical = bl;
    }

    public static String getWriterEncoding() {
        return PRINTWRITER_ENCODING;
    }

    public static void setWriterEncoding(String string) {
        PRINTWRITER_ENCODING = string.equalsIgnoreCase("DEFAULT") ? "UTF8" : (string.equalsIgnoreCase("UTF-16") ? "Unicode" : MIME2Java.convert(string));
    }

    public static boolean isValidJavaEncoding(String string) {
        for (int i = 0; i < MIME2JAVA_ENCODINGS.length; ++i) {
            if (!string.equals(MIME2JAVA_ENCODINGS[i])) continue;
            return true;
        }
        return false;
    }

    public void print(Node node) {
        if (node == null) {
            return;
        }
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                if (!this.canonical) {
                    String string = this.getWriterEncoding();
                    string = string.equalsIgnoreCase("DEFAULT") ? "UTF-8" : (string.equalsIgnoreCase("Unicode") ? "UTF-16" : MIME2Java.reverse(string));
                    this.out.println("<?xml version=\"1.0\" encoding=\"" + string + "\"?>");
                }
                this.print(((Document)node).getDocumentElement());
                this.out.flush();
                break;
            }
            case 1: {
                this.out.print('<');
                this.out.print(node.getNodeName());
                Attr[] attrArray = this.sortAttributes(node.getAttributes());
                for (int i = 0; i < attrArray.length; ++i) {
                    Attr attr = attrArray[i];
                    this.out.print(' ');
                    this.out.print(attr.getNodeName());
                    this.out.print("=\"");
                    this.out.print(this.normalize(attr.getNodeValue()));
                    this.out.print('\"');
                }
                this.out.print('>');
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    this.print(nodeList.item(i));
                }
                break;
            }
            case 5: {
                if (this.canonical) {
                    NodeList nodeList = node.getChildNodes();
                    if (nodeList == null) break;
                    int n = nodeList.getLength();
                    for (int i = 0; i < n; ++i) {
                        this.print(nodeList.item(i));
                    }
                    break;
                }
                this.out.print('&');
                this.out.print(node.getNodeName());
                this.out.print(';');
                break;
            }
            case 4: {
                if (this.canonical) {
                    this.out.print(this.normalize(node.getNodeValue()));
                    break;
                }
                this.out.print("<![CDATA[");
                this.out.print(node.getNodeValue());
                this.out.print("]]>");
                break;
            }
            case 3: {
                this.out.print(this.normalize(node.getNodeValue()));
                break;
            }
            case 7: {
                this.out.print("<?");
                this.out.print(node.getNodeName());
                String string = node.getNodeValue();
                if (string != null && string.length() > 0) {
                    this.out.print(' ');
                    this.out.print(string);
                }
                this.out.print("?>");
            }
        }
        if (s == 1) {
            this.out.print("</");
            this.out.print(node.getNodeName());
            this.out.print('>');
        }
        this.out.flush();
    }

    protected Attr[] sortAttributes(NamedNodeMap namedNodeMap) {
        int n;
        int n2 = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        Attr[] attrArray = new Attr[n2];
        for (n = 0; n < n2; ++n) {
            attrArray[n] = (Attr)namedNodeMap.item(n);
        }
        for (n = 0; n < n2 - 1; ++n) {
            String string = attrArray[n].getNodeName();
            int n3 = n;
            for (int i = n + 1; i < n2; ++i) {
                String string2 = attrArray[i].getNodeName();
                if (string2.compareTo(string) >= 0) continue;
                string = string2;
                n3 = i;
            }
            if (n3 == n) continue;
            Attr attr = attrArray[n];
            attrArray[n] = attrArray[n3];
            attrArray[n3] = attr;
        }
        return attrArray;
    }

    protected String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    if (this.canonical) {
                        stringBuffer.append("&#");
                        stringBuffer.append(Integer.toString(c));
                        stringBuffer.append(';');
                        continue block7;
                    }
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static void printValidJavaEncoding() {
        System.err.println("    ENCODINGS:");
        System.err.print("   ");
        for (int i = 0; i < MIME2JAVA_ENCODINGS.length; ++i) {
            System.err.print(MIME2JAVA_ENCODINGS[i] + " ");
            if (i % 7 != 0) continue;
            System.err.println();
            System.err.print("   ");
        }
    }
}

