/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.File;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.util.ProcessEnvironment;

public class CGIProcessEnvironment
extends ProcessEnvironment {
    private Hashtable queryParameters = null;
    private String cgiPathPrefix = null;

    public CGIProcessEnvironment(HttpServletRequest httpServletRequest, ServletContext servletContext) {
        this(httpServletRequest, servletContext, "");
    }

    public CGIProcessEnvironment(HttpServletRequest httpServletRequest, ServletContext servletContext, String string) {
        this(httpServletRequest, servletContext, string, 0);
    }

    public CGIProcessEnvironment(HttpServletRequest httpServletRequest, ServletContext servletContext, int n) {
        this(httpServletRequest, servletContext, "", 0);
    }

    public CGIProcessEnvironment(HttpServletRequest httpServletRequest, ServletContext servletContext, String string, int n) {
        super(httpServletRequest, servletContext, n);
        this.cgiPathPrefix = string;
        this.queryParameters = new Hashtable();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration != null && enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().toString();
            if (string2 == null) continue;
            this.queryParameters.put(string2, URLEncoder.encode(httpServletRequest.getParameter(string2)));
        }
        this.valid = this.deriveProcessEnvironment(httpServletRequest);
    }

    protected boolean deriveProcessEnvironment(HttpServletRequest httpServletRequest) {
        super.deriveProcessEnvironment(httpServletRequest);
        Hashtable hashtable = this.getEnvironment();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        string = this.pathInfo;
        string = string == null ? "" : string;
        string2 = httpServletRequest.getPathTranslated();
        string2 = string2 == null ? "" : string2;
        String[] stringArray = this.findCGI(string, this.getWebAppRootDir(), this.getContextPath(), this.getServletPath(), this.cgiPathPrefix);
        string5 = stringArray[0];
        string6 = stringArray[1];
        string7 = stringArray[2];
        string8 = stringArray[3];
        if (string5 == null || string6 == null || string7 == null || string8 == null) {
            return false;
        }
        hashtable.put("SERVER_SOFTWARE", "TOMCAT");
        hashtable.put("SERVER_NAME", this.nullsToBlanks(httpServletRequest.getServerName()));
        hashtable.put("GATEWAY_INTERFACE", "CGI/1.1");
        hashtable.put("SERVER_PROTOCOL", this.nullsToBlanks(httpServletRequest.getProtocol()));
        int n = httpServletRequest.getServerPort();
        Integer n2 = n == 0 ? new Integer(-1) : new Integer(n);
        hashtable.put("SERVER_PORT", n2.toString());
        hashtable.put("REQUEST_METHOD", this.nullsToBlanks(httpServletRequest.getMethod()));
        string3 = this.pathInfo == null || this.pathInfo.substring(string7.length()).length() <= 0 ? "" : this.pathInfo.substring(string7.length());
        hashtable.put("PATH_INFO", string3);
        string4 = string3 != null && !"".equals(string3) ? this.getContext().getRealPath(string3) : null;
        if (string4 != null && !"".equals(string4)) {
            hashtable.put("PATH_TRANSLATED", this.nullsToBlanks(string4));
        }
        hashtable.put("SCRIPT_NAME", this.nullsToBlanks(string6));
        hashtable.put("QUERY_STRING", this.nullsToBlanks(httpServletRequest.getQueryString()));
        hashtable.put("REMOTE_HOST", this.nullsToBlanks(httpServletRequest.getRemoteHost()));
        hashtable.put("REMOTE_ADDR", this.nullsToBlanks(httpServletRequest.getRemoteAddr()));
        hashtable.put("AUTH_TYPE", this.nullsToBlanks(httpServletRequest.getAuthType()));
        hashtable.put("REMOTE_USER", this.nullsToBlanks(httpServletRequest.getRemoteUser()));
        hashtable.put("REMOTE_IDENT", "");
        hashtable.put("CONTENT_TYPE", this.nullsToBlanks(httpServletRequest.getContentType()));
        int n3 = httpServletRequest.getContentLength();
        String string9 = n3 <= 0 ? "" : new Integer(n3).toString();
        hashtable.put("CONTENT_LENGTH", string9);
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        String string10 = null;
        while (enumeration.hasMoreElements()) {
            string10 = null;
            string10 = ((String)enumeration.nextElement()).toUpperCase();
            if ("AUTHORIZATION".equalsIgnoreCase(string10) || "PROXY_AUTHORIZATION".equalsIgnoreCase(string10)) continue;
            if ("HOST".equalsIgnoreCase(string10)) {
                String string11 = httpServletRequest.getHeader(string10);
                hashtable.put("HTTP_" + string10.replace('-', '_'), string11.substring(0, string11.indexOf(":")));
                continue;
            }
            hashtable.put("HTTP_" + string10.replace('-', '_'), httpServletRequest.getHeader(string10));
        }
        this.command = string5;
        this.workingDirectory = new File(this.command.substring(0, this.command.lastIndexOf(File.separator)));
        hashtable.put("X_TOMCAT_COMMAND_PATH", this.command);
        this.setEnvironment(hashtable);
        return true;
    }

    protected String[] findCGI(String string, String string2, String string3, String string4, String string5) {
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        if (string2 != null && string2.lastIndexOf("/") == string2.length() - 1) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string5 != null) {
            string2 = string2 + File.separator + string5;
        }
        if (this.debug >= 2) {
            this.log("findCGI: start = [" + string2 + "], pathInfo = [" + string + "] ");
        }
        File file = new File(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (!file.isFile() && stringTokenizer.hasMoreElements()) {
            file = new File(file, (String)stringTokenizer.nextElement());
            if (this.debug < 3) continue;
            this.log("findCGI: traversing to [" + file + "]");
        }
        if (!file.isFile()) {
            return new String[]{null, null, null, null};
        }
        if (this.debug >= 2) {
            this.log("findCGI: FOUND cgi at [" + file + "]");
        }
        string6 = file.getAbsolutePath();
        string7 = file.getName();
        string9 = file.getParent().substring(string2.length()) + File.separator + string7;
        string8 = ".".equals(string3) ? string4 + string9 : string3 + string4 + string9;
        if (this.debug >= 1) {
            this.log("findCGI calc: name=" + string7 + ", path=" + string6 + ", scriptname=" + string8 + ", cginame=" + string9);
        }
        return new String[]{string6, string8, string9, string7};
    }

    public String toString() {
        String string;
        Enumeration enumeration;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<TABLE border=2>");
        stringBuffer.append("<tr><th colspan=2 bgcolor=grey>");
        stringBuffer.append("ProcessEnvironment Info</th></tr>");
        stringBuffer.append("<tr><td>Debug Level</td><td>");
        stringBuffer.append(this.debug);
        stringBuffer.append("</td></tr>");
        stringBuffer.append("<tr><td>Validity:</td><td>");
        stringBuffer.append(this.isValid());
        stringBuffer.append("</td></tr>");
        if (this.isValid()) {
            enumeration = this.env.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                stringBuffer.append("<tr><td>");
                stringBuffer.append(string);
                stringBuffer.append("</td><td>");
                stringBuffer.append(this.blanksToString((String)this.env.get(string), "[will be set to blank]"));
                stringBuffer.append("</td></tr>");
            }
        }
        stringBuffer.append("<tr><td colspan=2><HR></td></tr>");
        stringBuffer.append("<tr><td>Derived Command</td><td>");
        stringBuffer.append(this.nullsToBlanks(this.command));
        stringBuffer.append("</td></tr>");
        stringBuffer.append("<tr><td>Working Directory</td><td>");
        if (this.workingDirectory != null) {
            stringBuffer.append(this.workingDirectory.toString());
        }
        stringBuffer.append("</td></tr>");
        stringBuffer.append("<tr><td colspan=2>Query Params</td></tr>");
        enumeration = this.queryParameters.keys();
        while (enumeration.hasMoreElements()) {
            string = enumeration.nextElement().toString();
            stringBuffer.append("<tr><td>");
            stringBuffer.append(string);
            stringBuffer.append("</td><td>");
            stringBuffer.append(this.queryParameters.get(string).toString());
            stringBuffer.append("</td></tr>");
        }
        stringBuffer.append("</TABLE><p>end.");
        return stringBuffer.toString();
    }

    public Hashtable getParameters() {
        return this.queryParameters;
    }
}

