/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.net.URL;
import org.apache.catalina.Deployer;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.util.StringManager;

public final class HostConfig
implements LifecycleListener {
    private String configClass = "org.apache.catalina.startup.ContextConfig";
    private String contextClass = "org.apache.catalina.core.StandardContext";
    private int debug = 0;
    private Host host = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");

    public String getConfigClass() {
        return this.configClass;
    }

    public void setConfigClass(String string) {
        this.configClass = string;
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(String string) {
        this.contextClass = string;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int n) {
        this.debug = n;
    }

    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        try {
            int n;
            this.host = (Host)((Object)lifecycleEvent.getLifecycle());
            if (this.host instanceof StandardHost && (n = ((StandardHost)this.host).getDebug()) > this.debug) {
                this.debug = n;
            }
        }
        catch (ClassCastException classCastException) {
            this.log(sm.getString("hostConfig.cce", lifecycleEvent.getLifecycle()), classCastException);
            return;
        }
        if (lifecycleEvent.getType().equals("start")) {
            this.start();
        } else if (lifecycleEvent.getType().equals("stop")) {
            this.stop();
        }
    }

    private File appBase() {
        File file = new File(this.host.getAppBase());
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.host.getAppBase());
        }
        return file;
    }

    private void deployApps() {
        File file;
        if (!(this.host instanceof Deployer)) {
            return;
        }
        if (this.debug >= 1) {
            this.log(sm.getString("hostConfig.deploying"));
        }
        if (!(file = this.appBase()).exists() || !file.isDirectory()) {
            return;
        }
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            URL uRL;
            Object object;
            if (stringArray[i].equalsIgnoreCase("META-INF") || stringArray[i].equalsIgnoreCase("WEB-INF")) continue;
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                object = new File(file2, "/WEB-INF");
                if (!((File)object).exists() || !((File)object).isDirectory() || !((File)object).canRead()) continue;
                String string = "/" + stringArray[i];
                if (stringArray[i].equals("ROOT")) {
                    string = "";
                }
                if (this.host.findChild(string) != null) continue;
                if (this.debug >= 1) {
                    this.log(sm.getString("hostConfig.deployDir", stringArray[i]));
                }
                try {
                    uRL = new URL("file", null, file2.getCanonicalPath());
                    ((Deployer)((Object)this.host)).install(string, uRL);
                }
                catch (Throwable throwable) {
                    this.log(sm.getString("hostConfig.deployDir.error", stringArray[i]), throwable);
                }
                continue;
            }
            if (!stringArray[i].toLowerCase().endsWith(".war")) continue;
            object = "/" + stringArray[i];
            int n = ((String)object).lastIndexOf(".");
            if (n >= 0) {
                object = ((String)object).substring(0, n);
            }
            if (((String)object).equals("/ROOT")) {
                object = "";
            }
            if (this.host.findChild((String)object) != null) continue;
            if (this.debug >= 1) {
                this.log(sm.getString("hostConfig.deployJar", stringArray[i]));
            }
            try {
                uRL = new URL("file", null, file2.getCanonicalPath());
                uRL = new URL("jar:" + uRL.toString() + "!/");
                ((Deployer)((Object)this.host)).install((String)object, uRL);
                continue;
            }
            catch (Throwable throwable) {
                this.log(sm.getString("hostConfig.deployJar.error", stringArray[i]), throwable);
            }
        }
    }

    private void log(String string) {
        Logger logger = null;
        if (this.host != null) {
            logger = this.host.getLogger();
        }
        if (logger != null) {
            logger.log("HostConfig[" + this.host.getName() + "]: " + string);
        } else {
            System.out.println("HostConfig[" + this.host.getName() + "]: " + string);
        }
    }

    private void log(String string, Throwable throwable) {
        Logger logger = null;
        if (this.host != null) {
            logger = this.host.getLogger();
        }
        if (logger != null) {
            logger.log("HostConfig[" + this.host.getName() + "] " + string, throwable);
        } else {
            System.out.println("HostConfig[" + this.host.getName() + "]: " + string);
            System.out.println("" + throwable);
            throwable.printStackTrace(System.out);
        }
    }

    private void start() {
        if (this.debug >= 1) {
            this.log(sm.getString("hostConfig.start"));
        }
        this.deployApps();
    }

    private void stop() {
        if (this.debug >= 1) {
            this.log(sm.getString("hostConfig.stop"));
        }
        this.undeployApps();
    }

    private void undeployApps() {
        if (!(this.host instanceof Deployer)) {
            return;
        }
        if (this.debug >= 1) {
            this.log(sm.getString("hostConfig.undeploying"));
        }
        String[] stringArray = ((Deployer)((Object)this.host)).findDeployedApps();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.debug >= 1) {
                this.log(sm.getString("hostConfig.undeploy", stringArray[i]));
            }
            try {
                ((Deployer)((Object)this.host)).remove(stringArray[i]);
                continue;
            }
            catch (Throwable throwable) {
                this.log(sm.getString("hostConfig.undeploy.error", stringArray[i]), throwable);
            }
        }
    }
}

