/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.InetAddress;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Logger;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.http.HttpConnector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.logger.FileLogger;
import org.apache.catalina.logger.SystemOutLogger;
import org.apache.catalina.net.SSLServerSocketFactory;
import org.apache.catalina.realm.MemoryRealm;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public class Embedded
implements Lifecycle {
    protected Connector[] connectors = new Connector[0];
    protected int debug = 0;
    protected boolean useNaming = true;
    protected Engine[] engines = new Engine[0];
    protected static final String info = "org.apache.catalina.startup.Embedded/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected Logger logger = null;
    protected Realm realm = null;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    protected String socketFactory = "org.apache.catalina.net.SSLSocketFactory";
    protected boolean started = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);

    public Embedded() {
        this(null, null);
    }

    public Embedded(Logger logger, Realm realm) {
        this.setLogger(logger);
        this.setRealm(realm);
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int n) {
        int n2 = this.debug;
        this.debug = n;
        this.support.firePropertyChange("debug", new Integer(n2), new Integer(this.debug));
    }

    public boolean isUseNaming() {
        return this.useNaming;
    }

    public void setUseNaming(boolean bl) {
        boolean bl2 = this.useNaming;
        this.useNaming = bl;
        this.support.firePropertyChange("useNaming", new Boolean(bl2), new Boolean(this.useNaming));
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        Logger logger2 = this.logger;
        this.logger = logger;
        this.support.firePropertyChange("logger", logger2, this.logger);
    }

    public Realm getRealm() {
        return this.realm;
    }

    public void setRealm(Realm realm) {
        Realm realm2 = this.realm;
        this.realm = realm;
        this.support.firePropertyChange("realm", realm2, this.realm);
    }

    public String getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(String string) {
        this.socketFactory = string;
    }

    public synchronized void addConnector(Connector connector) {
        Connector[] connectorArray;
        if (this.debug >= 1) {
            if (connector instanceof HttpConnector) {
                connectorArray = (Connector[])connector;
                this.logger.log("Adding connector for address '" + (connectorArray.getAddress() == null ? "ALL" : connectorArray.getAddress()) + "' port='" + connectorArray.getPort() + "'");
            } else {
                this.logger.log("Adding connector (" + connector.getInfo() + ")");
            }
        }
        if (this.engines.length < 1) {
            throw new IllegalStateException(sm.getString("embedded.noEngines"));
        }
        connector.setContainer(this.engines[this.engines.length - 1]);
        connectorArray = new Connector[this.connectors.length + 1];
        for (int i = 0; i < this.connectors.length; ++i) {
            connectorArray[i] = this.connectors[i];
        }
        connectorArray[this.connectors.length] = connector;
        this.connectors = connectorArray;
        if (this.started) {
            try {
                connector.initialize();
                if (connector instanceof Lifecycle) {
                    ((Lifecycle)((Object)connector)).start();
                }
            }
            catch (LifecycleException lifecycleException) {
                this.logger.log("Connector.start", lifecycleException);
            }
        }
    }

    public synchronized void addEngine(Engine engine) {
        if (this.debug >= 1) {
            this.logger.log("Adding engine (" + engine.getInfo() + ")");
        }
        Engine[] engineArray = new Engine[this.engines.length + 1];
        for (int i = 0; i < this.engines.length; ++i) {
            engineArray[i] = this.engines[i];
        }
        engineArray[this.engines.length] = engine;
        this.engines = engineArray;
        if (this.started && engine instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)engine)).start();
            }
            catch (LifecycleException lifecycleException) {
                this.logger.log("Engine.start", lifecycleException);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public Connector createConnector(InetAddress inetAddress, int n, boolean bl) {
        if (this.debug >= 1) {
            this.logger.log("Creating connector for address='" + (inetAddress == null ? "ALL" : inetAddress.getHostAddress()) + "' port='" + n + "' secure='" + bl + "'");
        }
        HttpConnector httpConnector = new HttpConnector();
        if (inetAddress != null) {
            httpConnector.setAddress(inetAddress.getHostAddress());
        }
        httpConnector.setDebug(this.debug);
        httpConnector.setPort(n);
        if (bl) {
            httpConnector.setScheme("https");
            httpConnector.setSecure(true);
            httpConnector.setFactory(new SSLServerSocketFactory());
        }
        return httpConnector;
    }

    public Context createContext(String string, String string2) {
        if (this.debug >= 1) {
            this.logger.log("Creating context '" + string + "' with docBase '" + string2 + "'");
        }
        StandardContext standardContext = new StandardContext();
        standardContext.setDebug(this.debug);
        standardContext.setDocBase(string2);
        standardContext.setPath(string);
        ContextConfig contextConfig = new ContextConfig();
        contextConfig.setDebug(this.debug);
        standardContext.addLifecycleListener(contextConfig);
        return standardContext;
    }

    public Engine createEngine() {
        if (this.debug >= 1) {
            this.logger.log("Creating engine");
        }
        StandardEngine standardEngine = new StandardEngine();
        standardEngine.setDebug(this.debug);
        standardEngine.setLogger(this.logger);
        standardEngine.setRealm(this.realm);
        return standardEngine;
    }

    public Host createHost(String string, String string2) {
        if (this.debug >= 1) {
            this.logger.log("Creating host '" + string + "' with appBase '" + string2 + "'");
        }
        StandardHost standardHost = new StandardHost();
        standardHost.setAppBase(string2);
        standardHost.setDebug(this.debug);
        standardHost.setName(string);
        return standardHost;
    }

    public Loader createLoader(ClassLoader classLoader) {
        if (this.debug >= 1) {
            this.logger.log("Creating Loader with parent class loader '" + classLoader + "'");
        }
        WebappLoader webappLoader = new WebappLoader(classLoader);
        return webappLoader;
    }

    public String getInfo() {
        return info;
    }

    public synchronized void removeConnector(Connector connector) {
        int n;
        if (this.debug >= 1) {
            if (connector instanceof HttpConnector) {
                HttpConnector httpConnector = (HttpConnector)connector;
                this.logger.log("Removing connector for address '" + (httpConnector.getAddress() == null ? "ALL" : httpConnector.getAddress()) + "' port='" + httpConnector.getPort() + "'");
            } else {
                this.logger.log("Removing connector (" + connector.getInfo() + ")");
            }
        }
        int n2 = -1;
        for (n = 0; n < this.connectors.length; ++n) {
            if (connector != this.connectors[n]) continue;
            n2 = n;
            break;
        }
        if (n2 < 0) {
            return;
        }
        if (connector instanceof Lifecycle) {
            if (this.debug >= 1) {
                this.logger.log(" Stopping this Connector");
            }
            try {
                ((Lifecycle)((Object)connector)).stop();
            }
            catch (LifecycleException lifecycleException) {
                this.logger.log("Connector.stop", lifecycleException);
            }
        }
        if (this.debug >= 1) {
            this.logger.log(" Removing this Connector");
        }
        n = 0;
        Connector[] connectorArray = new Connector[this.connectors.length - 1];
        for (int i = 0; i < this.connectors.length; ++i) {
            if (i == n2) continue;
            connectorArray[n++] = this.connectors[i];
        }
        this.connectors = connectorArray;
    }

    public synchronized void removeContext(Context context) {
        if (this.debug >= 1) {
            this.logger.log("Removing context[" + context.getPath() + "]");
        }
        boolean bl = false;
        for (int i = 0; i < this.engines.length; ++i) {
            Container[] containerArray = this.engines[i].findChildren();
            for (int j = 0; j < containerArray.length; ++j) {
                Container[] containerArray2 = containerArray[j].findChildren();
                for (int k = 0; k < containerArray2.length; ++k) {
                    if (context != (Context)containerArray2[k]) continue;
                    bl = true;
                    break;
                }
                if (bl) break;
            }
            if (bl) break;
        }
        if (!bl) {
            return;
        }
        if (this.debug >= 1) {
            this.logger.log(" Removing this Context");
        }
        context.getParent().removeChild(context);
    }

    public synchronized void removeEngine(Engine engine) {
        int n;
        if (this.debug >= 1) {
            this.logger.log("Removing engine (" + engine.getInfo() + ")");
        }
        int n2 = -1;
        for (n = 0; n < this.engines.length; ++n) {
            if (engine != this.engines[n]) continue;
            n2 = n;
            break;
        }
        if (n2 < 0) {
            return;
        }
        if (this.debug >= 1) {
            this.logger.log(" Removing related Containers");
        }
        while (true) {
            n = -1;
            for (int i = 0; i < this.connectors.length; ++i) {
                if (this.connectors[i].getContainer() != engine) continue;
                n = i;
                break;
            }
            if (n < 0) break;
            this.removeConnector(this.connectors[n]);
        }
        if (engine instanceof Lifecycle) {
            if (this.debug >= 1) {
                this.logger.log(" Stopping this Engine");
            }
            try {
                ((Lifecycle)((Object)engine)).stop();
            }
            catch (LifecycleException lifecycleException) {
                this.logger.log("Engine.stop", lifecycleException);
            }
        }
        if (this.debug >= 1) {
            this.logger.log(" Removing this Engine");
        }
        int n3 = 0;
        Engine[] engineArray = new Engine[this.engines.length - 1];
        for (int i = 0; i < this.engines.length; ++i) {
            if (i == n2) continue;
            engineArray[n3++] = this.engines[i];
        }
        this.engines = engineArray;
    }

    public synchronized void removeHost(Host host) {
        if (this.debug >= 1) {
            this.logger.log("Removing host[" + host.getName() + "]");
        }
        boolean bl = false;
        for (int i = 0; i < this.engines.length; ++i) {
            Container[] containerArray = this.engines[i].findChildren();
            for (int j = 0; j < containerArray.length; ++j) {
                if (host != (Host)containerArray[j]) continue;
                bl = true;
                break;
            }
            if (bl) break;
        }
        if (!bl) {
            return;
        }
        if (this.debug >= 1) {
            this.logger.log(" Removing this Host");
        }
        host.getParent().removeChild(host);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.removeLifecycleListener(lifecycleListener);
    }

    public void start() throws LifecycleException {
        int n;
        String string;
        if (this.debug >= 1) {
            this.logger.log("Starting embedded server");
        }
        if (System.getProperty("catalina.home") == null) {
            string = System.getProperty("com.sun.enterprise.home");
            if (string != null) {
                System.setProperty("catalina.home", System.getProperty("com.sun.enterprise.home"));
            } else {
                throw new LifecycleException("Must set 'catalina.home' system property");
            }
        }
        if (System.getProperty("catalina.base") == null) {
            System.setProperty("catalina.base", System.getProperty("catalina.home"));
        }
        if (this.started) {
            throw new LifecycleException(sm.getString("embedded.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (!this.useNaming) {
            System.setProperty("catalina.useNaming", "false");
        } else {
            System.setProperty("catalina.useNaming", "true");
            string = "org.apache.naming";
            String string2 = System.getProperty("java.naming.factory.url.pkgs");
            if (string2 != null) {
                string = string2 + ":" + string;
            }
            System.setProperty("java.naming.factory.url.pkgs", string);
            System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
        }
        for (n = 0; n < this.engines.length; ++n) {
            if (!(this.engines[n] instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)this.engines[n])).start();
        }
        for (n = 0; n < this.connectors.length; ++n) {
            this.connectors[n].initialize();
            if (!(this.connectors[n] instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)this.connectors[n])).start();
        }
    }

    public void stop() throws LifecycleException {
        int n;
        if (this.debug >= 1) {
            this.logger.log("Stopping embedded server");
        }
        if (!this.started) {
            throw new LifecycleException(sm.getString("embedded.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        for (n = 0; n < this.connectors.length; ++n) {
            if (!(this.connectors[n] instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)this.connectors[n])).stop();
        }
        for (n = 0; n < this.engines.length; ++n) {
            if (!(this.engines[n] instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)this.engines[n])).stop();
        }
    }

    public static void main(String[] stringArray) {
        String string;
        Embedded embedded = new Embedded(new SystemOutLogger(), new MemoryRealm());
        embedded.setDebug(5);
        embedded.setLogger(new SystemOutLogger());
        String string2 = System.getProperty("catalina.home");
        if (string2 == null) {
            System.err.println("You must set the 'catalina.home' system property");
            System.exit(1);
        }
        if ((string = System.getProperty("catalina.base")) == null) {
            string = string2;
            System.setProperty("catalina.base", string);
        }
        try {
            embedded.start();
        }
        catch (LifecycleException lifecycleException) {
            System.err.println("start: " + lifecycleException.toString());
            lifecycleException.printStackTrace();
        }
        Engine engine = embedded.createEngine();
        engine.setDefaultHost("localhost");
        Host host = embedded.createHost("localhost", string2 + "/webapps");
        engine.addChild(host);
        Context context = embedded.createContext("", string2 + "/webapps/ROOT");
        host.addChild(context);
        Context context2 = embedded.createContext("/examples", string2 + "/webapps/examples");
        Embedded.customize(context2);
        host.addChild(context2);
        embedded.addEngine(engine);
        Connector connector = embedded.createConnector(null, 8080, false);
        embedded.addConnector(connector);
        try {
            Thread.sleep(120000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        embedded.removeContext(context2);
        embedded.removeEngine(engine);
        try {
            embedded.stop();
        }
        catch (LifecycleException lifecycleException) {
            System.err.println("stop: " + lifecycleException.toString());
            lifecycleException.printStackTrace();
        }
    }

    private static void customize(Context context) {
        String string = context.getPath();
        string = string.length() < 1 ? "ROOT" : string.substring(1);
        FileLogger fileLogger = new FileLogger();
        fileLogger.setPrefix(string + "_log.");
        fileLogger.setSuffix(".txt");
        fileLogger.setTimestamp(true);
        context.setLogger(fileLogger);
    }
}

