/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.lang.reflect.Constructor;
import java.util.Stack;
import org.apache.catalina.Container;
import org.apache.catalina.Loader;
import org.apache.catalina.util.xml.SaxContext;
import org.apache.catalina.util.xml.XmlAction;

final class CreateLoaderAction
extends XmlAction {
    protected String loaderClass;
    protected String attributeName;

    public CreateLoaderAction(String string) {
        this(string, null);
    }

    public CreateLoaderAction(String string, String string2) {
        this.loaderClass = string;
        this.attributeName = string2;
    }

    public void start(SaxContext saxContext) throws Exception {
        int n;
        Class[] classArray;
        Stack stack = saxContext.getObjectStack();
        Container container = (Container)stack.peek();
        ClassLoader classLoader = container.getParentClassLoader();
        String string = this.loaderClass;
        if (this.attributeName != null && (classArray = saxContext.getAttributeList(n = saxContext.getTagCount() - 1)).getValue(this.attributeName) != null) {
            string = classArray.getValue(this.attributeName);
        }
        Class<?> clazz = Class.forName(string);
        classArray = new Class[]{ClassLoader.class};
        Object[] objectArray = new Object[]{classLoader};
        Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
        Loader loader = (Loader)constructor.newInstance(objectArray);
        stack.push(loader);
        if (saxContext.getDebug() >= 1) {
            saxContext.log("new " + loader.getClass().getName());
        }
    }

    public void cleanup(SaxContext saxContext) {
        Stack stack = saxContext.getObjectStack();
        Object e = stack.pop();
        if (saxContext.getDebug() >= 1) {
            saxContext.log("pop " + e.getClass().getName());
        }
    }
}

