/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.security.Security;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.startup.Catalina;
import org.apache.catalina.util.xml.XmlMapper;

public class CatalinaService
extends Catalina {
    protected boolean arguments(String[] stringArray) {
        boolean bl = false;
        if (stringArray.length < 1) {
            this.usage();
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (bl) {
                this.configFile = stringArray[i];
                bl = false;
                continue;
            }
            if (stringArray[i].equals("-config")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-debug")) {
                this.debug = true;
                continue;
            }
            if (stringArray[i].equals("-nonaming")) {
                this.useNaming = false;
                continue;
            }
            if (stringArray[i].equals("-help")) {
                this.usage();
                return false;
            }
            if (stringArray[i].equals("start")) {
                this.starting = true;
                this.stopping = false;
                continue;
            }
            if (stringArray[i].equals("stop")) {
                this.starting = false;
                this.stopping = true;
                continue;
            }
            this.usage();
            return false;
        }
        return true;
    }

    protected void execute() throws Exception {
        if (this.starting) {
            this.load();
            this.start();
        } else if (this.stopping) {
            this.stop();
        }
    }

    public void load() {
        block10: {
            String string;
            String string2;
            XmlMapper xmlMapper = this.createStartMapper();
            File file = this.configFile();
            try {
                xmlMapper.readXml(file, (Object)this);
            }
            catch (InvocationTargetException invocationTargetException) {
                System.out.println("Catalina.start: InvocationTargetException");
                invocationTargetException.getTargetException().printStackTrace(System.out);
            }
            catch (Exception exception) {
                System.out.println("Catalina.start: " + exception);
                exception.printStackTrace(System.out);
                System.exit(1);
            }
            if (!this.useNaming) {
                System.setProperty("catalina.useNaming", "false");
            } else {
                System.setProperty("catalina.useNaming", "true");
                string2 = "org.apache.naming";
                string = System.getProperty("java.naming.factory.url.pkgs");
                if (string != null) {
                    string2 = string2 + ":" + string;
                }
                System.setProperty("java.naming.factory.url.pkgs", string2);
                System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
            }
            if (System.getSecurityManager() != null) {
                string2 = Security.getProperty("package.access");
                string2 = string2 != null && string2.length() > 0 ? string2 + "," : "sun.,";
                Security.setProperty("package.access", string2 + "org.apache.catalina.,org.apache.jasper.");
                string = Security.getProperty("package.definition");
                string = string != null && string.length() > 0 ? string + "," : "sun.,";
                Security.setProperty("package.definition", string + "java.,org.apache.catalina.,org.apache.jasper.");
            }
            if (this.server instanceof Lifecycle) {
                try {
                    this.server.initialize();
                }
                catch (LifecycleException lifecycleException) {
                    System.out.println("Catalina.start: " + lifecycleException);
                    lifecycleException.printStackTrace(System.out);
                    if (lifecycleException.getThrowable() == null) break block10;
                    System.out.println("----- Root Cause -----");
                    lifecycleException.getThrowable().printStackTrace(System.out);
                }
            }
        }
    }

    public void start() {
        block3: {
            if (this.server instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)this.server)).start();
                }
                catch (LifecycleException lifecycleException) {
                    System.out.println("Catalina.start: " + lifecycleException);
                    lifecycleException.printStackTrace(System.out);
                    if (lifecycleException.getThrowable() == null) break block3;
                    System.out.println("----- Root Cause -----");
                    lifecycleException.getThrowable().printStackTrace(System.out);
                }
            }
        }
    }

    public void stop() {
        block3: {
            if (this.server instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)this.server)).stop();
                }
                catch (LifecycleException lifecycleException) {
                    System.out.println("Catalina.stop: " + lifecycleException);
                    lifecycleException.printStackTrace(System.out);
                    if (lifecycleException.getThrowable() == null) break block3;
                    System.out.println("----- Root Cause -----");
                    lifecycleException.getThrowable().printStackTrace(System.out);
                }
            }
        }
        System.out.println("Stop server complete");
    }
}

