/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.security.Security;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Server;
import org.apache.catalina.startup.CopyParentClassLoaderAction;
import org.apache.catalina.startup.CreateLoaderAction;
import org.apache.catalina.startup.LifecycleListenerAction;
import org.apache.catalina.startup.SetParentClassLoaderAction;
import org.apache.catalina.util.xml.XmlMapper;

public class Catalina {
    protected String configFile = "conf/server.xml";
    protected boolean debug = false;
    protected ClassLoader parentClassLoader = ClassLoader.getSystemClassLoader();
    protected Server server = null;
    protected boolean starting = false;
    protected boolean stopping = false;
    protected boolean useNaming = true;

    public static void main(String[] stringArray) {
        new Catalina().process(stringArray);
    }

    public void process(String[] stringArray) {
        this.setCatalinaHome();
        this.setCatalinaBase();
        try {
            if (this.arguments(stringArray)) {
                this.execute();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void setParentClassLoader(ClassLoader classLoader) {
        this.parentClassLoader = classLoader;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    protected boolean arguments(String[] stringArray) {
        boolean bl = false;
        if (stringArray.length < 1) {
            this.usage();
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (bl) {
                this.configFile = stringArray[i];
                bl = false;
                continue;
            }
            if (stringArray[i].equals("-config")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-debug")) {
                this.debug = true;
                continue;
            }
            if (stringArray[i].equals("-nonaming")) {
                this.useNaming = false;
                continue;
            }
            if (stringArray[i].equals("-help")) {
                this.usage();
                return false;
            }
            if (stringArray[i].equals("start")) {
                this.starting = true;
                continue;
            }
            if (stringArray[i].equals("stop")) {
                this.stopping = true;
                continue;
            }
            this.usage();
            return false;
        }
        return true;
    }

    protected File configFile() {
        File file = new File(this.configFile);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.configFile);
        }
        return file;
    }

    protected XmlMapper createStartMapper() {
        XmlMapper xmlMapper = new XmlMapper();
        if (this.debug) {
            xmlMapper.setDebug(999);
        }
        xmlMapper.setValidating(false);
        xmlMapper.addRule("Server", xmlMapper.objectCreate("org.apache.catalina.core.StandardServer", "className"));
        xmlMapper.addRule("Server", xmlMapper.setProperties());
        xmlMapper.addRule("Server", xmlMapper.addChild("setServer", "org.apache.catalina.Server"));
        xmlMapper.addRule("Server/Listener", xmlMapper.objectCreate(null, "className"));
        xmlMapper.addRule("Server/Listener", xmlMapper.setProperties());
        xmlMapper.addRule("Server/Listener", xmlMapper.addChild("addLifecycleListener", "org.apache.catalina.LifecycleListener"));
        xmlMapper.addRule("Server/Service", xmlMapper.objectCreate("org.apache.catalina.core.StandardService", "className"));
        xmlMapper.addRule("Server/Service", xmlMapper.setProperties());
        xmlMapper.addRule("Server/Service", xmlMapper.addChild("addService", "org.apache.catalina.Service"));
        xmlMapper.addRule("Server/Service/Listener", xmlMapper.objectCreate(null, "className"));
        xmlMapper.addRule("Server/Service/Listener", xmlMapper.setProperties());
        xmlMapper.addRule("Server/Service/Listener", xmlMapper.addChild("addLifecycleListener", "org.apache.catalina.LifecycleListener"));
        xmlMapper.addRule("Server/Service/Connector", xmlMapper.objectCreate("org.apache.catalina.connector.http.HttpConnector", "className"));
        xmlMapper.addRule("Server/Service/Connector", xmlMapper.setProperties());
        xmlMapper.addRule("Server/Service/Connector", xmlMapper.addChild("addConnector", "org.apache.catalina.Connector"));
        xmlMapper.addRule("Server/Service/Connector/Factory", xmlMapper.objectCreate("org.apache.catalina.net.DefaultServerSocketFactory", "className"));
        xmlMapper.addRule("Server/Service/Connector/Factory", xmlMapper.setProperties());
        xmlMapper.addRule("Server/Service/Connector/Factory", xmlMapper.addChild("setFactory", "org.apache.catalina.net.ServerSocketFactory"));
        xmlMapper.addRule("Server/Service/Connector/Listener", xmlMapper.objectCreate(null, "className"));
        xmlMapper.addRule("Server/Service/Connector/Listener", xmlMapper.setProperties());
        xmlMapper.addRule("Server/Service/Connector/Listener", xmlMapper.addChild("addLifecycleListener", "org.apache.catalina.LifecycleListener"));
        xmlMapper.addRule("Server/Service/Engine", xmlMapper.objectCreate("org.apache.catalina.core.StandardEngine", "className"));
        xmlMapper.addRule("Server/Service/Engine", xmlMapper.setProperties());
        xmlMapper.addRule("Server/Service/Engine", new LifecycleListenerAction("org.apache.catalina.startup.EngineConfig", "configClass"));
        xmlMapper.addRule("Server/Service/Engine", new SetParentClassLoaderAction(this.parentClassLoader));
        xmlMapper.addRule("Server/Service/Engine", xmlMapper.addChild("setContainer", "org.apache.catalina.Container"));
        xmlMapper.addRule("Server/Service/Engine/Listener", xmlMapper.objectCreate(null, "className"));
        xmlMapper.addRule("Server/Service/Engine/Listener", xmlMapper.setProperties());
        xmlMapper.addRule("Server/Service/Engine/Listener", xmlMapper.addChild("addLifecycleListener", "org.apache.catalina.LifecycleListener"));
        this.createStartMapperContext("Server/Service/Engine/Context", xmlMapper);
        this.createStartMapperDefaultContext("Server/Service/Engine/DefaultContext", xmlMapper);
        xmlMapper.addRule("Server/Service/Engine/Host", xmlMapper.objectCreate("org.apache.catalina.core.StandardHost", "className"));
        xmlMapper.addRule("Server/Service/Engine/Host", xmlMapper.setProperties());
        xmlMapper.addRule("Server/Service/Engine/Host", new CopyParentClassLoaderAction());
        xmlMapper.addRule("Server/Service/Engine/Host", new LifecycleListenerAction("org.apache.catalina.startup.HostConfig", "configClass"));
        xmlMapper.addRule("Server/Service/Engine/Host", xmlMapper.addChild("addChild", "org.apache.catalina.Container"));
        xmlMapper.addRule("Server/Service/Engine/Host/Alias", xmlMapper.methodSetter("addAlias", 0));
        xmlMapper.addRule("Server/Service/Engine/Host/Cluster", xmlMapper.objectCreate(null, "className"));
        xmlMapper.addRule("Server/Service/Engine/Host/Cluster", xmlMapper.setProperties());
        xmlMapper.addRule("Server/Service/Engine/Host/Cluster", xmlMapper.addChild("setCluster", "org.apache.catalina.Cluster"));
        this.createStartMapperContext("Server/Service/Engine/Host/Context", xmlMapper);
        this.createStartMapperDefaultContext("Server/Service/Engine/Host/DefaultContext", xmlMapper);
        xmlMapper.addRule("Server/Service/Engine/Host/Context/Manager/Store", xmlMapper.objectCreate(null, "className"));
        xmlMapper.addRule("Server/Service/Engine/Host/Context/Manager/Store", xmlMapper.setProperties());
        xmlMapper.addRule("Server/Service/Engine/Host/Context/Manager/Store", xmlMapper.addChild("setStore", "org.apache.catalina.Store"));
        xmlMapper.addRule("Server/Service/Engine/Host/Listener", xmlMapper.objectCreate(null, "className"));
        xmlMapper.addRule("Server/Service/Engine/Host/Listener", xmlMapper.setProperties());
        xmlMapper.addRule("Server/Service/Engine/Host/Listener", xmlMapper.addChild("addLifecycleListener", "org.apache.catalina.LifecycleListener"));
        xmlMapper.addRule("Server/Service/Engine/Host/Logger", xmlMapper.objectCreate(null, "className"));
        xmlMapper.addRule("Server/Service/Engine/Host/Logger", xmlMapper.setProperties());
        xmlMapper.addRule("Server/Service/Engine/Host/Logger", xmlMapper.addChild("setLogger", "org.apache.catalina.Logger"));
        xmlMapper.addRule("Server/Service/Engine/Host/Realm", xmlMapper.objectCreate(null, "className"));
        xmlMapper.addRule("Server/Service/Engine/Host/Realm", xmlMapper.setProperties());
        xmlMapper.addRule("Server/Service/Engine/Host/Realm", xmlMapper.addChild("setRealm", "org.apache.catalina.Realm"));
        xmlMapper.addRule("Server/Service/Engine/Host/Resources", xmlMapper.objectCreate("org.apache.naming.resources.FileDirContext", "className"));
        xmlMapper.addRule("Server/Service/Engine/Host/Resources", xmlMapper.setProperties());
        xmlMapper.addRule("Server/Service/Engine/Host/Resources", xmlMapper.addChild("setResources", "javax.naming.directory.DirContext"));
        xmlMapper.addRule("Server/Service/Engine/Host/Valve", xmlMapper.objectCreate(null, "className"));
        xmlMapper.addRule("Server/Service/Engine/Host/Valve", xmlMapper.setProperties());
        xmlMapper.addRule("Server/Service/Engine/Host/Valve", xmlMapper.addChild("addValve", "org.apache.catalina.Valve"));
        xmlMapper.addRule("Server/Service/Engine/Listener", xmlMapper.objectCreate(null, "className"));
        xmlMapper.addRule("Server/Service/Engine/Listener", xmlMapper.setProperties());
        xmlMapper.addRule("Server/Service/Engine/Listener", xmlMapper.addChild("addLifecycleListener", "org.apache.catalina.LifecycleListener"));
        xmlMapper.addRule("Server/Service/Engine/Logger", xmlMapper.objectCreate(null, "className"));
        xmlMapper.addRule("Server/Service/Engine/Logger", xmlMapper.setProperties());
        xmlMapper.addRule("Server/Service/Engine/Logger", xmlMapper.addChild("setLogger", "org.apache.catalina.Logger"));
        xmlMapper.addRule("Server/Service/Engine/Realm", xmlMapper.objectCreate(null, "className"));
        xmlMapper.addRule("Server/Service/Engine/Realm", xmlMapper.setProperties());
        xmlMapper.addRule("Server/Service/Engine/Realm", xmlMapper.addChild("setRealm", "org.apache.catalina.Realm"));
        xmlMapper.addRule("Server/Service/Engine/Resources", xmlMapper.objectCreate("org.apache.naming.resources.FileDirContext", "className"));
        xmlMapper.addRule("Server/Service/Engine/Resources", xmlMapper.setProperties());
        xmlMapper.addRule("Server/Service/Engine/Resources", xmlMapper.addChild("setResources", "javax.naming.directory.DirContext"));
        xmlMapper.addRule("Server/Service/Engine/Valve", xmlMapper.objectCreate(null, "className"));
        xmlMapper.addRule("Server/Service/Engine/Valve", xmlMapper.setProperties());
        xmlMapper.addRule("Server/Service/Engine/Valve", xmlMapper.addChild("addValve", "org.apache.catalina.Valve"));
        return xmlMapper;
    }

    protected void createStartMapperContext(String string, XmlMapper xmlMapper) {
        xmlMapper.addRule(string + "", xmlMapper.objectCreate("org.apache.catalina.core.StandardContext", "className"));
        xmlMapper.addRule(string + "", xmlMapper.setProperties());
        xmlMapper.addRule(string + "", new CopyParentClassLoaderAction());
        xmlMapper.addRule(string + "", new LifecycleListenerAction("org.apache.catalina.startup.ContextConfig", "configClass"));
        xmlMapper.addRule(string + "", xmlMapper.addChild("addChild", "org.apache.catalina.Container"));
        this.createContextCommon(string, xmlMapper);
    }

    protected void createStartMapperDefaultContext(String string, XmlMapper xmlMapper) {
        xmlMapper.addRule(string + "", xmlMapper.objectCreate("org.apache.catalina.core.DefaultContext", "className"));
        xmlMapper.addRule(string + "", xmlMapper.setProperties());
        xmlMapper.addRule(string + "", xmlMapper.addChild("addDefaultContext", "org.apache.catalina.core.DefaultContext"));
        this.createContextCommon(string, xmlMapper);
    }

    protected void createContextCommon(String string, XmlMapper xmlMapper) {
        xmlMapper.addRule(string + "/Ejb", xmlMapper.objectCreate("org.apache.catalina.deploy.ContextEjb"));
        xmlMapper.addRule(string + "/Ejb", xmlMapper.setProperties());
        xmlMapper.addRule(string + "/Ejb", xmlMapper.addChild("addEjb", "org.apache.catalina.deploy.ContextEjb"));
        xmlMapper.addRule(string + "/Environment", xmlMapper.objectCreate("org.apache.catalina.deploy.ContextEnvironment"));
        xmlMapper.addRule(string + "/Environment", xmlMapper.setProperties());
        xmlMapper.addRule(string + "/Environment", xmlMapper.addChild("addEnvironment", "org.apache.catalina.deploy.ContextEnvironment"));
        xmlMapper.addRule(string + "/InstanceListener", xmlMapper.methodSetter("addInstanceListener", 0));
        xmlMapper.addRule(string + "/Listener", xmlMapper.objectCreate(null, "className"));
        xmlMapper.addRule(string + "/Listener", xmlMapper.setProperties());
        xmlMapper.addRule(string + "/Listener", xmlMapper.addChild("addLifecycleListener", "org.apache.catalina.LifecycleListener"));
        xmlMapper.addRule(string + "/Loader", new CreateLoaderAction("org.apache.catalina.loader.WebappLoader", "className"));
        xmlMapper.addRule(string + "/Loader", xmlMapper.setProperties());
        xmlMapper.addRule(string + "/Loader", xmlMapper.addChild("setLoader", "org.apache.catalina.Loader"));
        xmlMapper.addRule(string + "/Logger", xmlMapper.objectCreate(null, "className"));
        xmlMapper.addRule(string + "/Logger", xmlMapper.setProperties());
        xmlMapper.addRule(string + "/Logger", xmlMapper.addChild("setLogger", "org.apache.catalina.Logger"));
        xmlMapper.addRule(string + "/Manager", xmlMapper.objectCreate("org.apache.catalina.session.StandardManager", "className"));
        xmlMapper.addRule(string + "/Manager", xmlMapper.setProperties());
        xmlMapper.addRule(string + "/Manager", xmlMapper.addChild("setManager", "org.apache.catalina.Manager"));
        xmlMapper.addRule(string + "/Parameter", xmlMapper.objectCreate("org.apache.catalina.deploy.ApplicationParameter"));
        xmlMapper.addRule(string + "/Parameter", xmlMapper.setProperties());
        xmlMapper.addRule(string + "/Parameter", xmlMapper.addChild("addApplicationParameter", "org.apache.catalina.deploy.ApplicationParameter"));
        xmlMapper.addRule(string + "/Realm", xmlMapper.objectCreate(null, "className"));
        xmlMapper.addRule(string + "/Realm", xmlMapper.setProperties());
        xmlMapper.addRule(string + "/Realm", xmlMapper.addChild("setRealm", "org.apache.catalina.Realm"));
        xmlMapper.addRule(string + "/Resource", xmlMapper.objectCreate("org.apache.catalina.deploy.ContextResource"));
        xmlMapper.addRule(string + "/Resource", xmlMapper.setProperties());
        xmlMapper.addRule(string + "/Resource", xmlMapper.addChild("addResource", "org.apache.catalina.deploy.ContextResource"));
        xmlMapper.addRule(string + "/ResourceParams", xmlMapper.objectCreate("org.apache.catalina.deploy.ResourceParams"));
        xmlMapper.addRule(string + "/ResourceParams", xmlMapper.setProperties());
        xmlMapper.addRule(string + "/ResourceParams", xmlMapper.addChild("addResourceParams", "org.apache.catalina.deploy.ResourceParams"));
        xmlMapper.addRule(string + "/ResourceParams/parameter", xmlMapper.methodSetter("addParameter", 2));
        xmlMapper.addRule(string + "/ResourceParams/parameter/name", xmlMapper.methodParam(0));
        xmlMapper.addRule(string + "/ResourceParams/parameter/value", xmlMapper.methodParam(1));
        xmlMapper.addRule(string + "/Resources", xmlMapper.objectCreate("org.apache.naming.resources.FileDirContext", "className"));
        xmlMapper.addRule(string + "/Resources", xmlMapper.setProperties());
        xmlMapper.addRule(string + "/Resources", xmlMapper.addChild("setResources", "javax.naming.directory.DirContext"));
        xmlMapper.addRule(string + "/Valve", xmlMapper.objectCreate(null, "className"));
        xmlMapper.addRule(string + "/Valve", xmlMapper.setProperties());
        xmlMapper.addRule(string + "/Valve", xmlMapper.addChild("addValve", "org.apache.catalina.Valve"));
        xmlMapper.addRule(string + "/WrapperLifecycle", xmlMapper.methodSetter("addWrapperLifecycle", 0));
        xmlMapper.addRule(string + "/WrapperListener", xmlMapper.methodSetter("addWrapperListener", 0));
    }

    protected XmlMapper createStopMapper() {
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.addRule("Server", xmlMapper.objectCreate("org.apache.catalina.core.StandardServer", "className"));
        xmlMapper.addRule("Server", xmlMapper.setProperties());
        xmlMapper.addRule("Server", xmlMapper.addChild("setServer", "org.apache.catalina.Server"));
        return xmlMapper;
    }

    protected void execute() throws Exception {
        if (this.starting) {
            this.start();
        } else if (this.stopping) {
            this.stop();
        }
    }

    protected void setCatalinaBase() {
        if (System.getProperty("catalina.base") != null) {
            return;
        }
        System.setProperty("catalina.base", System.getProperty("catalina.home"));
    }

    protected void setCatalinaHome() {
        if (System.getProperty("catalina.home") != null) {
            return;
        }
        System.setProperty("catalina.home", System.getProperty("user.dir"));
    }

    protected void start() {
        block15: {
            block14: {
                String string;
                String string2;
                XmlMapper xmlMapper = this.createStartMapper();
                File file = this.configFile();
                try {
                    xmlMapper.readXml(file, (Object)this);
                }
                catch (InvocationTargetException invocationTargetException) {
                    System.out.println("Catalina.start: InvocationTargetException");
                    invocationTargetException.getTargetException().printStackTrace(System.out);
                }
                catch (Exception exception) {
                    System.out.println("Catalina.start: " + exception);
                    exception.printStackTrace(System.out);
                    System.exit(1);
                }
                if (!this.useNaming) {
                    System.setProperty("catalina.useNaming", "false");
                } else {
                    System.setProperty("catalina.useNaming", "true");
                    string2 = "org.apache.naming";
                    string = System.getProperty("java.naming.factory.url.pkgs");
                    if (string != null) {
                        string2 = string2 + ":" + string;
                    }
                    System.setProperty("java.naming.factory.url.pkgs", string2);
                    string2 = System.getProperty("java.naming.factory.initial");
                    if (string2 == null) {
                        System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
                    }
                }
                if (System.getSecurityManager() != null) {
                    string2 = Security.getProperty("package.access");
                    string2 = string2 != null && string2.length() > 0 ? string2 + "," : "sun.,";
                    Security.setProperty("package.access", string2 + "org.apache.catalina.,org.apache.jasper.");
                    string = Security.getProperty("package.definition");
                    string = string != null && string.length() > 0 ? string + "," : "sun.,";
                    Security.setProperty("package.definition", string + "java.,org.apache.catalina.,org.apache.jasper.");
                }
                if (this.server instanceof Lifecycle) {
                    try {
                        this.server.initialize();
                        ((Lifecycle)((Object)this.server)).start();
                    }
                    catch (LifecycleException lifecycleException) {
                        System.out.println("Catalina.start: " + lifecycleException);
                        lifecycleException.printStackTrace(System.out);
                        if (lifecycleException.getThrowable() == null) break block14;
                        System.out.println("----- Root Cause -----");
                        lifecycleException.getThrowable().printStackTrace(System.out);
                    }
                }
            }
            this.server.await();
            if (this.server instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)this.server)).stop();
                }
                catch (LifecycleException lifecycleException) {
                    System.out.println("Catalina.stop: " + lifecycleException);
                    lifecycleException.printStackTrace(System.out);
                    if (lifecycleException.getThrowable() == null) break block15;
                    System.out.println("----- Root Cause -----");
                    lifecycleException.getThrowable().printStackTrace(System.out);
                }
            }
        }
    }

    protected void stop() {
        XmlMapper xmlMapper = this.createStopMapper();
        File file = this.configFile();
        try {
            xmlMapper.readXml(file, (Object)this);
        }
        catch (Exception exception) {
            System.out.println("Catalina.stop: " + exception);
            exception.printStackTrace(System.out);
            System.exit(1);
        }
        try {
            Socket socket = new Socket("127.0.0.1", this.server.getPort());
            OutputStream outputStream = socket.getOutputStream();
            String string = this.server.getShutdown();
            for (int i = 0; i < string.length(); ++i) {
                outputStream.write(string.charAt(i));
            }
            outputStream.flush();
            outputStream.close();
            socket.close();
        }
        catch (IOException iOException) {
            System.out.println("Catalina.stop: " + iOException);
            iOException.printStackTrace(System.out);
            System.exit(1);
        }
    }

    protected void usage() {
        System.out.println("usage: java org.apache.catalina.startup.Catalina [ -config {pathname} ] [ -debug ] [ -nonaming ] { start | stop }");
    }
}

