/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import com.sun.appserv.util.UuidGenerator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Session;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.CustomObjectInputStream;
import org.apache.catalina.util.LifecycleSupport;

public class StandardManager
extends ManagerBase
implements Lifecycle,
PropertyChangeListener,
Runnable {
    private int checkInterval = 60;
    private static final String info = "StandardManager/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    private int maxActiveSessions = -1;
    protected static String name = "StandardManager";
    private String pathname = "SESSIONS.ser";
    private boolean started = false;
    private Thread thread = null;
    private boolean threadDone = false;
    private String threadName = "StandardManager";

    public int getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(int n) {
        int n2 = this.checkInterval;
        this.checkInterval = n;
        this.support.firePropertyChange("checkInterval", new Integer(n2), new Integer(this.checkInterval));
    }

    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener(this);
        }
        super.setContainer(container);
        if (this.container != null && this.container instanceof Context) {
            this.setMaxInactiveInterval(((Context)this.container).getSessionTimeout() * 60);
            ((Context)this.container).addPropertyChangeListener(this);
        }
    }

    public String getInfo() {
        return info;
    }

    public int getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    public void setMaxActiveSessions(int n) {
        int n2 = this.maxActiveSessions;
        this.maxActiveSessions = n;
        this.support.firePropertyChange("maxActiveSessions", new Integer(n2), new Integer(this.maxActiveSessions));
    }

    public String getName() {
        return name;
    }

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String string) {
        String string2 = this.pathname;
        this.pathname = string;
        this.support.firePropertyChange("pathname", string2, this.pathname);
    }

    public Session createSession() {
        if (this.maxActiveSessions >= 0 && this.sessions.size() >= this.maxActiveSessions) {
            throw new IllegalStateException(sm.getString("standardManager.createSession.ise"));
        }
        return super.createSession();
    }

    public Session createSession(UuidGenerator uuidGenerator) {
        if (this.maxActiveSessions >= 0 && this.sessions.size() >= this.maxActiveSessions) {
            throw new IllegalStateException(sm.getString("standardManager.createSession.ise"));
        }
        return super.createSession(uuidGenerator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void load() throws ClassNotFoundException, IOException {
        block41: {
            Object object;
            if (this.debug >= 1) {
                this.log("Start: Loading persisted sessions");
            }
            this.recycled.clear();
            this.sessions.clear();
            File file = this.file();
            if (file == null) {
                return;
            }
            if (this.debug >= 1) {
                this.log(sm.getString("standardManager.loading", this.pathname));
            }
            FileInputStream fileInputStream = null;
            ObjectInputStream objectInputStream = null;
            Loader loader = null;
            ClassLoader classLoader = null;
            try {
                fileInputStream = new FileInputStream(file.getAbsolutePath());
                object = new BufferedInputStream(fileInputStream);
                if (this.container != null) {
                    loader = this.container.getLoader();
                }
                if (loader != null) {
                    classLoader = loader.getClassLoader();
                }
                if (classLoader != null) {
                    if (this.debug >= 1) {
                        this.log("Creating custom object input stream for class loader " + classLoader);
                    }
                    objectInputStream = new CustomObjectInputStream((InputStream)object, classLoader);
                } else {
                    if (this.debug >= 1) {
                        this.log("Creating standard object input stream");
                    }
                    objectInputStream = new ObjectInputStream((InputStream)object);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.debug >= 1) {
                    this.log("No persisted data file found");
                }
                return;
            }
            catch (IOException iOException) {
                this.log(sm.getString("standardManager.loading.ioe", iOException), iOException);
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    objectInputStream = null;
                }
                throw iOException;
            }
            object = this.sessions;
            synchronized (object) {
                Integer n = (Integer)objectInputStream.readObject();
                int n2 = n;
                if (this.debug >= 1) {
                    this.log("Loading " + n2 + " persisted sessions");
                }
                for (int i = 0; i < n2; ++i) {
                    StandardSession standardSession = new StandardSession(this);
                    standardSession.readObjectData(objectInputStream);
                    standardSession.setManager(this);
                    this.sessions.put(standardSession.getId(), standardSession);
                    standardSession.activate();
                }
                Object var12_18 = null;
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (file != null && file.exists()) {
                    file.delete();
                }
                break block41;
                {
                    catch (ClassNotFoundException classNotFoundException) {
                        this.log(sm.getString("standardManager.loading.cnfe", classNotFoundException), classNotFoundException);
                        if (objectInputStream != null) {
                            try {
                                objectInputStream.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            objectInputStream = null;
                        }
                        throw classNotFoundException;
                    }
                    catch (IOException iOException) {
                        this.log(sm.getString("standardManager.loading.ioe", iOException), iOException);
                        if (objectInputStream != null) {
                            try {
                                objectInputStream.close();
                            }
                            catch (IOException iOException3) {
                                // empty catch block
                            }
                            objectInputStream = null;
                        }
                        throw iOException;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_19 = null;
                    try {
                        if (objectInputStream != null) {
                            objectInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (file != null && file.exists()) {
                        file.delete();
                    }
                    throw throwable;
                }
            }
        }
        if (this.debug >= 1) {
            this.log("Finish: Loading persisted sessions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadPrevious() throws IOException {
        Object object;
        File file;
        if (this.debug >= 1) {
            this.log("Unloading persisted sessions");
        }
        if ((file = this.file()) == null) {
            return;
        }
        if (this.debug >= 1) {
            this.log(sm.getString("standardManager.unloading", this.pathname));
        }
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file.getAbsolutePath());
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(fileOutputStream));
        }
        catch (IOException iOException) {
            this.log(sm.getString("standardManager.unloading.ioe", iOException), iOException);
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                objectOutputStream = null;
            }
            throw iOException;
        }
        ArrayList<StandardSession> arrayList = new ArrayList<StandardSession>();
        Object object2 = this.sessions;
        synchronized (object2) {
            if (this.debug >= 1) {
                this.log("Unloading " + this.sessions.size() + " sessions");
            }
            try {
                objectOutputStream.writeObject(new Integer(this.sessions.size()));
                object = this.sessions.values().iterator();
                while (object.hasNext()) {
                    StandardSession standardSession = (StandardSession)object.next();
                    arrayList.add(standardSession);
                    standardSession.passivate();
                    standardSession.writeObjectData(objectOutputStream);
                }
            }
            catch (IOException iOException) {
                this.log(sm.getString("standardManager.unloading.ioe", iOException), iOException);
                if (objectOutputStream != null) {
                    try {
                        objectOutputStream.close();
                    }
                    catch (IOException iOException3) {
                        // empty catch block
                    }
                    objectOutputStream = null;
                }
                throw iOException;
            }
        }
        try {
            objectOutputStream.flush();
            objectOutputStream.close();
            objectOutputStream = null;
        }
        catch (IOException iOException) {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException4) {
                    // empty catch block
                }
                objectOutputStream = null;
            }
            throw iOException;
        }
        if (this.debug >= 1) {
            this.log("Expiring " + arrayList.size() + " persisted sessions");
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (StandardSession)object2.next();
            try {
                ((StandardSession)object).expire();
            }
            catch (Throwable throwable) {}
        }
        if (this.debug >= 1) {
            this.log("Unloading complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload() throws IOException {
        Object object;
        File file;
        if (this.debug >= 1) {
            this.log("Unloading persisted sessions");
        }
        if ((file = this.file()) == null) {
            return;
        }
        boolean bl = this.isDirectoryValidFor(file.getAbsolutePath());
        if (!bl) {
            return;
        }
        if (this.debug >= 1) {
            this.log(sm.getString("standardManager.unloading", this.pathname));
        }
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file.getAbsolutePath());
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(fileOutputStream));
        }
        catch (IOException iOException) {
            this.log(sm.getString("standardManager.unloading.ioe", iOException), iOException);
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                objectOutputStream = null;
            }
            throw iOException;
        }
        ArrayList<StandardSession> arrayList = new ArrayList<StandardSession>();
        Object object2 = this.sessions;
        synchronized (object2) {
            if (this.debug >= 1) {
                this.log("Unloading " + this.sessions.size() + " sessions");
            }
            try {
                objectOutputStream.writeObject(new Integer(this.sessions.size()));
                object = this.sessions.values().iterator();
                while (object.hasNext()) {
                    StandardSession standardSession = (StandardSession)object.next();
                    arrayList.add(standardSession);
                    standardSession.passivate();
                    standardSession.writeObjectData(objectOutputStream);
                }
            }
            catch (IOException iOException) {
                this.log(sm.getString("standardManager.unloading.ioe", iOException), iOException);
                if (objectOutputStream != null) {
                    try {
                        objectOutputStream.close();
                    }
                    catch (IOException iOException3) {
                        // empty catch block
                    }
                    objectOutputStream = null;
                }
                throw iOException;
            }
        }
        try {
            objectOutputStream.flush();
            objectOutputStream.close();
            objectOutputStream = null;
        }
        catch (IOException iOException) {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException4) {
                    // empty catch block
                }
                objectOutputStream = null;
            }
            throw iOException;
        }
        if (this.debug >= 1) {
            this.log("Expiring " + arrayList.size() + " persisted sessions");
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (StandardSession)object2.next();
            try {
                ((StandardSession)object).expire();
            }
            catch (Throwable throwable) {}
        }
        if (this.debug >= 1) {
            this.log("Unloading complete");
        }
    }

    private boolean isDirectoryValidFor(String string) {
        int n = string.lastIndexOf("/");
        String string2 = string.substring(0, n);
        File file = new File(string2);
        boolean bl = file.isDirectory();
        return bl;
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.removeLifecycleListener(lifecycleListener);
    }

    public void start() throws LifecycleException {
        if (this.debug >= 1) {
            this.log("Starting");
        }
        if (this.started) {
            throw new LifecycleException(sm.getString("standardManager.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.debug >= 1) {
            this.log("Force random number initialization starting");
        }
        String string = this.generateSessionId();
        if (this.debug >= 1) {
            this.log("Force random number initialization completed");
        }
        try {
            this.load();
        }
        catch (Throwable throwable) {
            this.log(sm.getString("standardManager.managerLoad"), throwable);
        }
        this.threadStart();
    }

    public void stop() throws LifecycleException {
        if (this.debug >= 1) {
            this.log("Stopping");
        }
        if (!this.started) {
            throw new LifecycleException(sm.getString("standardManager.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.threadStop();
        try {
            this.unload();
        }
        catch (IOException iOException) {
            this.log(sm.getString("standardManager.managerUnload"), iOException);
        }
        Session[] sessionArray = this.findSessions();
        for (int i = 0; i < sessionArray.length; ++i) {
            StandardSession standardSession = (StandardSession)sessionArray[i];
            if (!standardSession.isValid()) continue;
            try {
                standardSession.expire();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.random = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!(propertyChangeEvent.getSource() instanceof Context)) {
            return;
        }
        Context context = (Context)propertyChangeEvent.getSource();
        if (propertyChangeEvent.getPropertyName().equals("sessionTimeout")) {
            try {
                this.setMaxInactiveInterval((Integer)propertyChangeEvent.getNewValue() * 60);
            }
            catch (NumberFormatException numberFormatException) {
                this.log(sm.getString("standardManager.sessionTimeout", propertyChangeEvent.getNewValue().toString()));
            }
        }
    }

    private File file() {
        ServletContext servletContext;
        File file;
        if (this.pathname == null) {
            return null;
        }
        File file2 = new File(this.pathname);
        if (!file2.isAbsolute() && this.container instanceof Context && (file = (File)(servletContext = ((Context)this.container).getServletContext()).getAttribute("javax.servlet.context.tempdir")) != null) {
            file2 = new File(file, this.pathname);
        }
        return file2;
    }

    private void processExpires() {
        long l = System.currentTimeMillis();
        Session[] sessionArray = this.findSessions();
        for (int i = 0; i < sessionArray.length; ++i) {
            StandardSession standardSession = (StandardSession)sessionArray[i];
            if (standardSession.isValid()) continue;
            try {
                standardSession.expire();
                continue;
            }
            catch (Throwable throwable) {
                this.log(sm.getString("standardManager.expireException"), throwable);
            }
        }
    }

    private void threadSleep() {
        try {
            Thread.sleep((long)this.checkInterval * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        this.threadName = "StandardManager[" + this.container.getName() + "]";
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.setContextClassLoader(this.container.getLoader().getClassLoader());
        this.thread.start();
    }

    private void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            this.processExpires();
        }
    }
}

