/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import com.sun.appserv.util.UuidGenerator;
import com.sun.appserv.util.UuidGeneratorImpl;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.StringManager;

public abstract class ManagerBase
implements Manager {
    protected static final String DEFAULT_ALGORITHM = "MD5";
    protected static final int SESSION_ID_BYTES = 16;
    protected String algorithm = "MD5";
    protected Container container;
    protected int debug = 0;
    protected MessageDigest digest = null;
    protected boolean distributable;
    protected String entropy = null;
    private static final String info = "ManagerBase/1.0";
    protected int maxInactiveInterval = 60;
    protected static String name = "ManagerBase";
    protected Random random = null;
    protected String randomClass = "java.security.SecureRandom";
    protected UuidGenerator uuidGenerator = new UuidGeneratorImpl();
    protected ArrayList recycled = new ArrayList();
    protected HashMap sessions = new HashMap();
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.session");
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);

    public UuidGenerator getUuidGenerator() {
        return this.uuidGenerator;
    }

    public void setUuidGenerator(UuidGenerator uuidGenerator) {
        this.uuidGenerator = uuidGenerator;
    }

    public void clearSessions() {
        this.sessions.clear();
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String string) {
        String string2 = this.algorithm;
        this.algorithm = string;
        this.support.firePropertyChange("algorithm", string2, this.algorithm);
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        Container container2 = this.container;
        this.container = container;
        this.support.firePropertyChange("container", container2, this.container);
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int n) {
        this.debug = n;
    }

    public synchronized MessageDigest getDigest() {
        if (this.digest == null) {
            if (this.debug >= 1) {
                this.log(sm.getString("managerBase.getting", this.algorithm));
            }
            try {
                this.digest = MessageDigest.getInstance(this.algorithm);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.log(sm.getString("managerBase.digest", this.algorithm), noSuchAlgorithmException);
                try {
                    this.digest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                    this.log(sm.getString("managerBase.digest", DEFAULT_ALGORITHM), noSuchAlgorithmException);
                    this.digest = null;
                }
            }
            if (this.debug >= 1) {
                this.log(sm.getString("managerBase.gotten"));
            }
        }
        return this.digest;
    }

    public boolean getDistributable() {
        return this.distributable;
    }

    public void setDistributable(boolean bl) {
        boolean bl2 = this.distributable;
        this.distributable = bl;
        this.support.firePropertyChange("distributable", new Boolean(bl2), new Boolean(this.distributable));
    }

    public String getEntropy() {
        if (this.entropy == null) {
            this.setEntropy(this.toString());
        }
        return this.entropy;
    }

    public void setEntropy(String string) {
        String string2 = string;
        this.entropy = string;
        this.support.firePropertyChange("entropy", string2, this.entropy);
    }

    public String getInfo() {
        return info;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int n) {
        int n2 = this.maxInactiveInterval;
        this.maxInactiveInterval = n > 0 ? n : -1;
        this.support.firePropertyChange("maxInactiveInterval", new Integer(n2), new Integer(this.maxInactiveInterval));
    }

    public String getName() {
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Random getRandom() {
        if (this.random == null) {
            ManagerBase managerBase = this;
            synchronized (managerBase) {
                if (this.random == null) {
                    this.log(sm.getString("managerBase.seeding", this.randomClass));
                    long l = System.currentTimeMillis();
                    char[] cArray = this.getEntropy().toCharArray();
                    for (int i = 0; i < cArray.length; ++i) {
                        long l2 = (byte)cArray[i] << i % 8 * 8;
                        l ^= l2;
                    }
                    try {
                        Class<?> clazz = Class.forName(this.randomClass);
                        this.random = (Random)clazz.newInstance();
                        this.random.setSeed(l);
                    }
                    catch (Exception exception) {
                        this.log(sm.getString("managerBase.random", this.randomClass), exception);
                        this.random = new Random();
                        this.random.setSeed(l);
                    }
                    this.log(sm.getString("managerBase.complete", this.randomClass));
                }
            }
        }
        return this.random;
    }

    public String getRandomClass() {
        return this.randomClass;
    }

    public void setRandomClass(String string) {
        String string2 = this.randomClass;
        this.randomClass = string;
        this.support.firePropertyChange("randomClass", string2, this.randomClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Session session) {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.put(session.getId(), session);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session beginCreateSession() {
        Session session = null;
        Serializable serializable = this.recycled;
        synchronized (serializable) {
            int n = this.recycled.size();
            if (n > 0) {
                session = (Session)this.recycled.get(n - 1);
                this.recycled.remove(n - 1);
            }
        }
        if (session != null) {
            session.setManager(this);
        } else {
            session = this.createNewSession();
            serializable = (StandardSession)session;
            ((StandardSession)serializable).lockForeground();
        }
        if (this.debug >= 1) {
            this.log(sm.getString("GOT NEW SESSION: CLASS = " + session.getClass().getName()));
        }
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.maxInactiveInterval);
        return session;
    }

    public Session createSession() {
        Session session = this.beginCreateSession();
        String string = this.generateSessionId(session);
        session.setId(string);
        return session;
    }

    public Session createSession(UuidGenerator uuidGenerator) {
        this.log("Creating session with id appended with jroute");
        Session session = this.beginCreateSession();
        String string = this.generateSessionId(session, uuidGenerator);
        session.setId(string);
        return session;
    }

    protected Session createNewSession() {
        return new StandardSession(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createSessionPrevious() {
        Session session = null;
        Object object = this.recycled;
        synchronized (object) {
            int n = this.recycled.size();
            if (n > 0) {
                session = (Session)this.recycled.get(n - 1);
                this.recycled.remove(n - 1);
            }
        }
        if (session != null) {
            session.setManager(this);
        } else {
            session = new StandardSession(this);
        }
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.maxInactiveInterval);
        object = this.generateSessionId(session);
        session.setId((String)object);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session findSession(String string) throws IOException {
        if (string == null) {
            return null;
        }
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            Session session = (Session)this.sessions.get(string);
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session[] findSessions() {
        Session[] sessionArray = null;
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            sessionArray = new Session[this.sessions.size()];
            sessionArray = this.sessions.values().toArray(sessionArray);
        }
        return sessionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Session session) {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.remove(session.getId());
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    protected synchronized String generateSessionIdPrevious() {
        Random random = this.getRandom();
        byte[] byArray = new byte[16];
        this.getRandom().nextBytes(byArray);
        byArray = this.getDigest().digest(byArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            byte by = (byte)((byArray[i] & 0xF0) >> 4);
            byte by2 = (byte)(byArray[i] & 0xF);
            if (by < 10) {
                stringBuffer.append((char)(48 + by));
            } else {
                stringBuffer.append((char)(65 + (by - 10)));
            }
            if (by2 < 10) {
                stringBuffer.append((char)(48 + by2));
                continue;
            }
            stringBuffer.append((char)(65 + (by2 - 10)));
        }
        return stringBuffer.toString();
    }

    protected synchronized String generateSessionId(Object object) {
        String string = this.uuidGenerator.generateUuid(object);
        return string;
    }

    protected synchronized String generateSessionId(Object object, UuidGenerator uuidGenerator) {
        String string = uuidGenerator.generateUuid(object);
        return string;
    }

    protected synchronized String generateSessionId() {
        return this.generateSessionId(new Object());
    }

    protected Engine getEngine() {
        Engine engine = null;
        for (Container container = this.getContainer(); engine == null && container != null; container = container.getParent()) {
            if (container == null || !(container instanceof Engine)) continue;
            engine = (Engine)container;
        }
        return engine;
    }

    protected String getJvmRoute() {
        Engine engine = this.getEngine();
        return engine == null ? null : engine.getJvmRoute();
    }

    void log(String string) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log(this.getName() + "[" + this.container.getName() + "]: " + string);
        } else {
            String string2 = null;
            if (this.container != null) {
                string2 = this.container.getName();
            }
            System.out.println(this.getName() + "[" + string2 + "]: " + string);
        }
    }

    void log(String string, Throwable throwable) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log(this.getName() + "[" + this.container.getName() + "] " + string, throwable);
        } else {
            String string2 = null;
            if (this.container != null) {
                string2 = this.container.getName();
            }
            System.out.println(this.getName() + "[" + string2 + "]: " + string);
            throwable.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recycle(Session session) {
        ArrayList arrayList = this.recycled;
        synchronized (arrayList) {
            this.recycled.add(session);
        }
    }
}

