/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.Store;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StoreBase;
import org.apache.catalina.util.CustomObjectInputStream;

public class JDBCStore
extends StoreBase
implements Store {
    protected static String info = "JDBCStore/1.0";
    protected static String storeName = "JDBCStore";
    protected String threadName = "JDBCStore";
    protected String connString = null;
    private Connection conn = null;
    protected String driverName = null;
    protected String sessionTable = "tomcat$sessions";
    protected String sessionIdCol = "id";
    protected String sessionDataCol = "data";
    protected String sessionValidCol = "valid";
    protected String sessionMaxInactiveCol = "maxinactive";
    protected String sessionLastAccessedCol = "lastaccess";
    protected PreparedStatement preparedSizeSql = null;
    protected PreparedStatement preparedKeysSql = null;
    protected PreparedStatement preparedSaveSql = null;
    protected PreparedStatement preparedClearSql = null;
    protected PreparedStatement preparedRemoveSql = null;
    protected PreparedStatement preparedLoadSql = null;

    public String getInfo() {
        return info;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setDriverName(String string) {
        String string2 = this.driverName;
        this.driverName = string;
        this.support.firePropertyChange("driverName", string2, this.driverName);
        this.driverName = string;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setConnectionURL(String string) {
        String string2 = this.connString;
        this.connString = string;
        this.support.firePropertyChange("connString", string2, this.connString);
    }

    public String getConnectionURL() {
        return this.connString;
    }

    public void setSessionTable(String string) {
        String string2 = this.sessionTable;
        this.sessionTable = string;
        this.support.firePropertyChange("sessionTable", string2, this.sessionTable);
    }

    public String getSessionTable() {
        return this.sessionTable;
    }

    public void setSessionIdCol(String string) {
        String string2 = this.sessionIdCol;
        this.sessionIdCol = string;
        this.support.firePropertyChange("sessionIdCol", string2, this.sessionIdCol);
    }

    public String getSessionIdCol() {
        return this.sessionIdCol;
    }

    public void setSessionDataCol(String string) {
        String string2 = this.sessionDataCol;
        this.sessionDataCol = string;
        this.support.firePropertyChange("sessionDataCol", string2, this.sessionDataCol);
    }

    public String getSessionDataCol() {
        return this.sessionDataCol;
    }

    public void setSessionValidCol(String string) {
        String string2 = this.sessionValidCol;
        this.sessionValidCol = string;
        this.support.firePropertyChange("sessionValidCol", string2, this.sessionValidCol);
    }

    public String getSessionValidCol() {
        return this.sessionValidCol;
    }

    public void setSessionMaxInactiveCol(String string) {
        String string2 = this.sessionMaxInactiveCol;
        this.sessionMaxInactiveCol = string;
        this.support.firePropertyChange("sessionMaxInactiveCol", string2, this.sessionMaxInactiveCol);
    }

    public String getSessionMaxInactiveCol() {
        return this.sessionMaxInactiveCol;
    }

    public void setSessionLastAccessedCol(String string) {
        String string2 = this.sessionLastAccessedCol;
        this.sessionLastAccessedCol = string;
        this.support.firePropertyChange("sessionLastAccessedCol", string2, this.sessionLastAccessedCol);
    }

    public String getSessionLastAccessedCol() {
        return this.sessionLastAccessedCol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String[] keys() throws IOException {
        String[] stringArray;
        block17: {
            ResultSet resultSet;
            Connection connection;
            block15: {
                String string = "SELECT COUNT(s." + this.sessionIdCol + "), c." + this.sessionIdCol + " FROM " + this.sessionTable + " s, " + this.sessionTable + " c" + " GROUP BY c." + this.sessionIdCol;
                connection = this.getConnection();
                resultSet = null;
                stringArray = null;
                if (connection == null) {
                    return new String[0];
                }
                if (this.preparedKeysSql == null) {
                    this.preparedKeysSql = connection.prepareStatement(string);
                }
                if ((resultSet = this.preparedKeysSql.executeQuery()) != null && resultSet.next()) {
                    stringArray = new String[resultSet.getInt(1)];
                    stringArray[0] = resultSet.getString(2);
                    int n = 1;
                    while (resultSet.next()) {
                        stringArray[n++] = resultSet.getString(2);
                    }
                    break block15;
                }
                stringArray = new String[]{};
            }
            Object var8_6 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.release(connection);
            connection = null;
            {
                break block17;
                catch (SQLException sQLException) {
                    this.log(this.sm.getString(this.getStoreName() + ".SQLException", sQLException));
                    Object var8_7 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    this.release(connection);
                    connection = null;
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.release(connection);
                connection = null;
                throw throwable;
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int getSize() throws IOException {
        int n;
        block15: {
            ResultSet resultSet;
            Connection connection;
            block13: {
                n = 0;
                String string = "SELECT COUNT(" + this.sessionIdCol + ") FROM ".concat(this.sessionTable);
                connection = this.getConnection();
                resultSet = null;
                if (connection == null) {
                    return n;
                }
                if (this.preparedSizeSql == null) {
                    this.preparedSizeSql = connection.prepareStatement(string);
                }
                if (!(resultSet = this.preparedSizeSql.executeQuery()).next()) break block13;
                n = resultSet.getInt(1);
            }
            Object var7_5 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.release(connection);
            connection = null;
            {
                break block15;
                catch (SQLException sQLException) {
                    this.log(this.sm.getString(this.getStoreName() + ".SQLException", sQLException));
                    Object var7_6 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    this.release(connection);
                    connection = null;
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.release(connection);
                connection = null;
                throw throwable;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Session load(String var1_1) throws ClassNotFoundException, IOException {
        block27: {
            block25: {
                var2_2 = null;
                var3_3 = this.getConnection();
                var4_4 = null;
                var5_5 = null;
                var6_6 = null;
                var7_7 = null;
                var8_8 = null;
                var9_9 = this.manager.getContainer();
                var10_10 = "SELECT " + this.sessionIdCol + ", " + this.sessionDataCol + " FROM " + this.sessionTable + " WHERE " + this.sessionIdCol + " = ?";
                if (var3_3 == null) {
                    return null;
                }
                if (this.preparedLoadSql == null) {
                    this.preparedLoadSql = var3_3.prepareStatement(var10_10);
                }
                this.preparedLoadSql.setString(1, var1_1);
                var2_2 = this.preparedLoadSql.executeQuery();
                if (var2_2.next()) {
                    var8_8 = new BufferedInputStream(var2_2.getBinaryStream(2));
                    if (var9_9 != null) {
                        var5_5 = var9_9.getLoader();
                    }
                    if (var5_5 != null) {
                        var6_6 = var5_5.getClassLoader();
                    }
                    var7_7 = var6_6 != null ? new CustomObjectInputStream(var8_8, var6_6) : new ObjectInputStream(var8_8);
                    break block25;
                }
                if (this.debug <= 0) break block25;
                this.log(this.getStoreName() + ": No persisted data object found");
            }
            var13_11 = null;
            try {
                if (var2_2 != null) {
                    var2_2.close();
                }
            }
            catch (SQLException var14_14) {
                // empty catch block
            }
            this.release(var3_3);
            var3_3 = null;
            {
                break block27;
                catch (SQLException var11_17) {
                    this.log(this.sm.getString(this.getStoreName() + ".SQLException", var11_17));
                    var13_12 = null;
                    try {
                        if (var2_2 != null) {
                            var2_2.close();
                        }
                    }
                    catch (SQLException var14_15) {
                        // empty catch block
                    }
                    this.release(var3_3);
                    var3_3 = null;
                }
            }
            catch (Throwable var12_18) {
                var13_13 = null;
                try {
                    if (var2_2 != null) {
                        var2_2.close();
                    }
                }
                catch (SQLException var14_16) {
                    // empty catch block
                }
                this.release(var3_3);
                var3_3 = null;
                throw var12_18;
            }
        }
        if (var7_7 != null) {
            try {
                var4_4 = (StandardSession)this.manager.createSession();
                var4_4.readObjectData(var7_7);
                var4_4.setManager(this.manager);
                var16_19 = null;
                ** if (var7_7 == null) goto lbl-1000
            }
            catch (Throwable var15_23) {
                var16_20 = null;
                if (var7_7 != null) {
                    try {
                        var7_7.close();
                        var8_8 = null;
                    }
                    catch (IOException var17_22) {
                        // empty catch block
                    }
                }
                throw var15_23;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var7_7.close();
                    var8_8 = null;
                }
                catch (IOException var17_21) {}
            }
lbl-1000:
            // 2 sources

            {
            }
            if (this.debug > 0) {
                this.log(this.sm.getString(this.getStoreName() + ".loading", var1_1, this.sessionTable));
            }
        }
        return var4_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String string) throws IOException {
        Connection connection = this.getConnection();
        String string2 = "DELETE FROM " + this.sessionTable + " WHERE " + this.sessionIdCol + " = ?";
        if (connection == null) {
            return;
        }
        try {
            if (this.preparedRemoveSql == null) {
                this.preparedRemoveSql = connection.prepareStatement(string2);
            }
            this.preparedRemoveSql.setString(1, string);
            this.preparedRemoveSql.execute();
        }
        catch (SQLException sQLException) {
            this.log(this.sm.getString(this.getStoreName() + ".SQLException", sQLException));
        }
        finally {
            this.release(connection);
            connection = null;
        }
        if (this.debug > 0) {
            this.log(this.sm.getString(this.getStoreName() + ".removing", string, this.sessionTable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        Connection connection = this.getConnection();
        String string = "DELETE FROM ".concat(this.sessionTable);
        if (connection == null) {
            return;
        }
        try {
            if (this.preparedClearSql == null) {
                this.preparedClearSql = connection.prepareStatement(string);
            }
            this.preparedClearSql.execute();
        }
        catch (SQLException sQLException) {
            this.log(this.sm.getString(this.getStoreName() + ".SQLException", sQLException));
        }
        finally {
            this.release(connection);
            connection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(Session session) throws IOException {
        block15: {
            InputStream inputStream;
            ByteArrayInputStream byteArrayInputStream;
            ByteArrayOutputStream byteArrayOutputStream;
            ObjectOutputStream objectOutputStream;
            Connection connection;
            block16: {
                String string = "INSERT INTO " + this.sessionTable + " (" + this.sessionIdCol + ", " + this.sessionDataCol + ", " + this.sessionValidCol + ", " + this.sessionMaxInactiveCol + ", " + this.sessionLastAccessedCol + ") VALUES (?, ?, ?, ?, ?)";
                connection = this.getConnection();
                objectOutputStream = null;
                byteArrayOutputStream = null;
                byteArrayInputStream = null;
                inputStream = null;
                if (connection == null) {
                    return;
                }
                this.remove(session.getId());
                try {
                    try {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(byteArrayOutputStream));
                        ((StandardSession)session).writeObjectData(objectOutputStream);
                        objectOutputStream.close();
                        byte[] byArray = byteArrayOutputStream.toByteArray();
                        int n = byArray.length;
                        byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n);
                        inputStream = new BufferedInputStream(byteArrayInputStream, n);
                        if (this.preparedSaveSql == null) {
                            this.preparedSaveSql = connection.prepareStatement(string);
                        }
                        this.preparedSaveSql.setString(1, session.getId());
                        this.preparedSaveSql.setBinaryStream(2, inputStream, n);
                        this.preparedSaveSql.setString(3, session.isValid() ? "1" : "0");
                        this.preparedSaveSql.setInt(4, session.getMaxInactiveInterval());
                        this.preparedSaveSql.setLong(5, session.getLastAccessedTime());
                        this.preparedSaveSql.execute();
                    }
                    catch (SQLException sQLException) {
                        this.log(this.sm.getString(this.getStoreName() + ".SQLException", sQLException));
                        Object var11_13 = null;
                        if (byteArrayInputStream != null) {
                            byteArrayInputStream.close();
                        }
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        byteArrayInputStream = null;
                        byteArrayOutputStream = null;
                        objectOutputStream = null;
                        inputStream = null;
                        this.release(connection);
                        connection = null;
                        break block15;
                    }
                    catch (IOException iOException) {
                        Object var11_14 = null;
                        if (byteArrayInputStream != null) {
                            byteArrayInputStream.close();
                        }
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        byteArrayInputStream = null;
                        byteArrayOutputStream = null;
                        objectOutputStream = null;
                        inputStream = null;
                        this.release(connection);
                        connection = null;
                        break block15;
                    }
                    Object var11_12 = null;
                    if (byteArrayInputStream == null) break block16;
                }
                catch (Throwable throwable) {
                    Object var11_15 = null;
                    if (byteArrayInputStream != null) {
                        byteArrayInputStream.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    byteArrayInputStream = null;
                    byteArrayOutputStream = null;
                    objectOutputStream = null;
                    inputStream = null;
                    this.release(connection);
                    connection = null;
                    throw throwable;
                }
                byteArrayInputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            byteArrayInputStream = null;
            byteArrayOutputStream = null;
            objectOutputStream = null;
            inputStream = null;
            this.release(connection);
            connection = null;
        }
        if (this.debug > 0) {
            this.log(this.sm.getString(this.getStoreName() + ".saving", session.getId(), this.sessionTable));
        }
    }

    protected Connection getConnection() {
        try {
            if (this.conn == null || this.conn.isClosed()) {
                Class.forName(this.driverName);
                this.log(this.sm.getString(this.getStoreName() + ".checkConnectionDBClosed"));
                this.conn = DriverManager.getConnection(this.connString);
                this.conn.setAutoCommit(true);
                if (this.conn == null || this.conn.isClosed()) {
                    this.log(this.sm.getString(this.getStoreName() + ".checkConnectionDBReOpenFail"));
                }
            }
        }
        catch (SQLException sQLException) {
            this.log(this.sm.getString(this.getStoreName() + ".checkConnectionSQLException", sQLException.toString()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log(this.sm.getString(this.getStoreName() + ".checkConnectionClassNotFoundException", classNotFoundException.toString()));
        }
        return this.conn;
    }

    protected void release(Connection connection) {
    }

    public void start() throws LifecycleException {
        super.start();
        this.conn = this.getConnection();
    }

    public void stop() throws LifecycleException {
        super.stop();
        if (this.conn != null) {
            try {
                this.conn.commit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                this.preparedSizeSql.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                this.preparedKeysSql.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                this.preparedSaveSql.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                this.preparedClearSql.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                this.preparedRemoveSql.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                this.preparedLoadSql.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.preparedSizeSql = null;
            this.preparedKeysSql = null;
            this.preparedSaveSql = null;
            this.preparedClearSql = null;
            this.preparedRemoveSql = null;
            this.preparedLoadSql = null;
            this.conn = null;
        }
    }
}

