/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import com.sun.appserv.util.UuidGenerator;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.Session;
import org.apache.catalina.cluster.ClusterReceiver;
import org.apache.catalina.cluster.ClusterSender;
import org.apache.catalina.cluster.ReplicationWrapper;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.CustomObjectInputStream;

public final class DistributedManager
extends PersistentManagerBase {
    private static final String info = "DistributedManager/1.0";
    protected static String name = "DistributedManager";
    private ClusterSender clusterSender = null;
    private ClusterReceiver clusterReceiver = null;

    public String getInfo() {
        return info;
    }

    public String getName() {
        return name;
    }

    public Session createSession() {
        Session session = super.createSession();
        ObjectOutputStream objectOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        Object var4_4 = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(byteArrayOutputStream));
            ((StandardSession)session).writeObjectData(objectOutputStream);
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.clusterSender.send(byArray);
            if (this.debug > 0) {
                this.log("Replicating Session: " + session.getId());
            }
        }
        catch (IOException iOException) {
            this.log("An error occurred when replicating Session: " + session.getId());
        }
        return session;
    }

    public Session createSession(UuidGenerator uuidGenerator) {
        Session session = super.createSession(uuidGenerator);
        ObjectOutputStream objectOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        Object var5_5 = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(byteArrayOutputStream));
            ((StandardSession)session).writeObjectData(objectOutputStream);
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.clusterSender.send(byArray);
            if (this.debug > 0) {
                this.log("Replicating Session: " + session.getId());
            }
        }
        catch (IOException iOException) {
            this.log("An error occurred when replicating Session: " + session.getId());
        }
        return session;
    }

    public void start() throws LifecycleException {
        Container container = this.getContainer();
        Cluster cluster = null;
        if (container != null) {
            cluster = container.getCluster();
        }
        if (cluster != null) {
            this.clusterSender = cluster.getClusterSender(this.getName());
            this.clusterReceiver = cluster.getClusterReceiver(this.getName());
        }
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void processClusterReceiver() {
        Object[] objectArray = this.clusterReceiver.getObjects();
        StandardSession standardSession = null;
        ByteArrayInputStream byteArrayInputStream = null;
        Loader loader = null;
        ClassLoader classLoader = null;
        ObjectInputStream objectInputStream = null;
        byte[] byArray = new byte[5000];
        ReplicationWrapper replicationWrapper = null;
        for (int i = 0; i < objectArray.length; ++i) {
            block14: {
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                replicationWrapper = (ReplicationWrapper)objectArray[i];
                byArray = replicationWrapper.getDataStream();
                byteArrayInputStream = new ByteArrayInputStream(byArray, 0, byArray.length);
                if (this.container != null) {
                    loader = this.container.getLoader();
                }
                if (loader != null) {
                    classLoader = loader.getClassLoader();
                }
                objectInputStream = classLoader != null ? new CustomObjectInputStream(byteArrayInputStream, classLoader) : new ObjectInputStream(byteArrayInputStream);
                standardSession = (StandardSession)super.createSession();
                standardSession.readObjectData(objectInputStream);
                standardSession.setManager(this);
                if (this.debug <= 0) break block14;
                this.log("Loading replicated session: " + standardSession.getId());
            }
            Object var12_13 = null;
            if (objectInputStream == null) continue;
            try {
                objectInputStream.close();
                byteArrayInputStream = null;
            }
            catch (IOException iOException2) {}
            continue;
            {
                catch (IOException iOException) {
                    this.log("Error occurred when trying to read replicated session: " + iOException.toString());
                    var12_13 = null;
                    if (objectInputStream == null) continue;
                    try {
                        objectInputStream.close();
                        byteArrayInputStream = null;
                    }
                    catch (IOException iOException2) {}
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.log("Error occurred when trying to read replicated session: " + classNotFoundException.toString());
                    var12_13 = null;
                    if (objectInputStream == null) continue;
                    try {
                        objectInputStream.close();
                        byteArrayInputStream = null;
                    }
                    catch (IOException iOException2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var12_13 = null;
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                        byteArrayInputStream = null;
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            this.processClusterReceiver();
            this.processExpires();
            this.processPersistenceChecks();
        }
    }
}

