/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.TimeZone;
import java.util.Vector;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.catalina.servlets.WebdavStatus;
import org.apache.catalina.util.DOMWriter;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.XMLWriter;
import org.apache.naming.resources.Resource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class WebdavServlet
extends DefaultServlet {
    private static final String METHOD_HEAD = "HEAD";
    private static final String METHOD_PROPFIND = "PROPFIND";
    private static final String METHOD_PROPPATCH = "PROPPATCH";
    private static final String METHOD_MKCOL = "MKCOL";
    private static final String METHOD_COPY = "COPY";
    private static final String METHOD_MOVE = "MOVE";
    private static final String METHOD_LOCK = "LOCK";
    private static final String METHOD_UNLOCK = "UNLOCK";
    private static final int INFINITY = 3;
    private static final int FIND_BY_PROPERTY = 0;
    private static final int FIND_ALL_PROP = 1;
    private static final int FIND_PROPERTY_NAMES = 2;
    private static final int LOCK_CREATION = 0;
    private static final int LOCK_REFRESH = 1;
    private static final int DEFAULT_TIMEOUT = 3600;
    private static final int MAX_TIMEOUT = 604800;
    protected static final String DEFAULT_NAMESPACE = "DAV:";
    protected static final SimpleDateFormat creationDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private Hashtable resourceLocks = new Hashtable();
    private Hashtable lockNullResources = new Hashtable();
    private Vector collectionLocks = new Vector();
    private String secret = "catalina";

    public void init() throws ServletException {
        super.init();
        String string = null;
        try {
            string = this.getServletConfig().getInitParameter("secret");
            if (string != null) {
                this.secret = string;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected DocumentBuilder getDocumentBuilder() throws ServletException {
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ServletException(sm.getString("webdavservlet.jaxpfailed"));
        }
        return documentBuilder;
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getMethod();
        if (this.debug > 0) {
            String string2 = this.getRelativePath(httpServletRequest);
            System.out.println("[" + string + "] " + string2);
        }
        if (string.equals(METHOD_PROPFIND)) {
            this.doPropfind(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_PROPPATCH)) {
            this.doProppatch(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_MKCOL)) {
            this.doMkcol(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_COPY)) {
            this.doCopy(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_MOVE)) {
            this.doMove(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_LOCK)) {
            this.doLock(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_UNLOCK)) {
            this.doUnlock(httpServletRequest, httpServletResponse);
        } else {
            super.service(httpServletRequest, httpServletResponse);
        }
    }

    protected boolean checkIfHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, DefaultServlet.ResourceInfo resourceInfo) throws IOException {
        return super.checkIfHeaders(httpServletRequest, httpServletResponse, resourceInfo);
    }

    protected void doOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.getRelativePath(httpServletRequest);
        httpServletResponse.addHeader("DAV", "1,2");
        String string2 = null;
        DirContext dirContext = this.getResources();
        if (dirContext == null) {
            httpServletResponse.sendError(500);
            return;
        }
        boolean bl = true;
        Object object = null;
        try {
            object = dirContext.lookup(string);
        }
        catch (NamingException namingException) {
            bl = false;
        }
        if (!bl) {
            string2 = "OPTIONS, MKCOL, PUT, LOCK";
            httpServletResponse.addHeader("Allow", string2);
            return;
        }
        string2 = "OPTIONS, GET, HEAD, POST, DELETE, TRACE, PROPFIND, PROPPATCH, COPY, MOVE, LOCK, UNLOCK";
        if (!(object instanceof DirContext)) {
            string2 = string2 + ", PUT";
        }
        httpServletResponse.addHeader("Allow", string2);
        httpServletResponse.addHeader("MS-Author-Via", "DAV");
    }

    protected void doPropfind(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        Enumeration enumeration;
        Stack<Object> stack;
        Enumeration enumeration2;
        boolean bl;
        Object object2;
        Object object3;
        int n;
        int n2;
        Vector<Object> vector;
        String string;
        block44: {
            Object object4;
            if (!this.listings) {
                httpServletResponse.sendError(405);
                return;
            }
            string = this.getRelativePath(httpServletRequest);
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.toUpperCase().startsWith("/WEB-INF") || string.toUpperCase().startsWith("/META-INF")) {
                httpServletResponse.sendError(403);
                return;
            }
            vector = null;
            n2 = 3;
            n = 1;
            String string2 = httpServletRequest.getHeader("Depth");
            if (string2 == null) {
                n2 = 3;
            } else if (string2.equals("0")) {
                n2 = 0;
            } else if (string2.equals("1")) {
                n2 = 1;
            } else if (string2.equals("infinity")) {
                n2 = 3;
            }
            Node node = null;
            DocumentBuilder documentBuilder = this.getDocumentBuilder();
            try {
                object3 = documentBuilder.parse(new InputSource((InputStream)httpServletRequest.getInputStream()));
                Element element = object3.getDocumentElement();
                object2 = element.getChildNodes();
                block16: for (int i = 0; i < object2.getLength(); ++i) {
                    object4 = object2.item(i);
                    switch (object4.getNodeType()) {
                        case 3: {
                            continue block16;
                        }
                        case 1: {
                            if (object4.getNodeName().endsWith("prop")) {
                                n = 0;
                                node = object4;
                            }
                            if (object4.getNodeName().endsWith("propname")) {
                                n = 2;
                            }
                            if (!object4.getNodeName().endsWith("allprop")) continue block16;
                            n = 1;
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n == 0) {
                vector = new Vector<Object>();
                object3 = node.getChildNodes();
                block17: for (int i = 0; i < object3.getLength(); ++i) {
                    object2 = object3.item(i);
                    switch (object2.getNodeType()) {
                        case 3: {
                            continue block17;
                        }
                        case 1: {
                            String string3 = object2.getNodeName();
                            object4 = null;
                            object4 = string3.indexOf(58) != -1 ? string3.substring(string3.indexOf(58) + 1) : string3;
                            vector.addElement(object4);
                        }
                    }
                }
            }
            if ((object3 = this.getResources()) == null) {
                httpServletResponse.sendError(500);
                return;
            }
            bl = true;
            object2 = null;
            try {
                object2 = object3.lookup(string);
            }
            catch (NamingException namingException) {
                bl = false;
                int n3 = string.lastIndexOf(47);
                if (n3 == -1 || (enumeration2 = (Vector)this.lockNullResources.get(stack = string.substring(0, n3))) == null) break block44;
                enumeration = ((Vector)((Object)enumeration2)).elements();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    if (!((String)object).equals(string)) continue;
                    httpServletResponse.setStatus(207);
                    httpServletResponse.setContentType("text/xml; charset=UTF-8");
                    XMLWriter xMLWriter = new XMLWriter(httpServletResponse.getWriter());
                    xMLWriter.writeXMLHeader();
                    xMLWriter.writeElement(null, "multistatus" + this.generateNamespaceDeclarations(), 0);
                    this.parseLockNullProperties(httpServletRequest, xMLWriter, (String)object, n, vector);
                    xMLWriter.writeElement(null, "multistatus", 1);
                    xMLWriter.sendData();
                    return;
                }
            }
        }
        if (!bl) {
            httpServletResponse.sendError(404, string);
            return;
        }
        httpServletResponse.setStatus(207);
        httpServletResponse.setContentType("text/xml; charset=UTF-8");
        XMLWriter xMLWriter = new XMLWriter(httpServletResponse.getWriter());
        xMLWriter.writeXMLHeader();
        xMLWriter.writeElement(null, "multistatus" + this.generateNamespaceDeclarations(), 0);
        if (n2 == 0) {
            this.parseProperties(httpServletRequest, (DirContext)object3, xMLWriter, string, n, vector);
        } else {
            Object object5 = new Stack<String>();
            ((Stack)object5).push(string);
            stack = new Stack();
            while (!((Vector)object5).isEmpty() && n2 >= 0) {
                enumeration2 = (String)((Stack)object5).pop();
                this.parseProperties(httpServletRequest, (DirContext)object3, xMLWriter, (String)((Object)enumeration2), n, vector);
                try {
                    object2 = object3.lookup((String)((Object)enumeration2));
                }
                catch (NamingException namingException) {
                    continue;
                }
                if (object2 instanceof DirContext && n2 > 0) {
                    Enumeration enumeration3;
                    try {
                        enumeration = object3.list((String)((Object)enumeration2));
                        while (enumeration.hasMoreElements()) {
                            object = (NameClassPair)enumeration.nextElement();
                            enumeration3 = enumeration2;
                            if (!((String)((Object)enumeration3)).endsWith("/")) {
                                enumeration3 = (String)((Object)enumeration3) + "/";
                            }
                            enumeration3 = (String)((Object)enumeration3) + ((NameClassPair)object).getName();
                            stack.push(enumeration3);
                        }
                    }
                    catch (NamingException namingException) {
                        httpServletResponse.sendError(500, string);
                        return;
                    }
                    enumeration = enumeration2;
                    if (((String)((Object)enumeration)).endsWith("/")) {
                        enumeration = ((String)((Object)enumeration)).substring(0, ((String)((Object)enumeration)).length() - 1);
                    }
                    if ((object = (Vector)this.lockNullResources.get(enumeration)) != null) {
                        enumeration3 = ((Vector)object).elements();
                        while (enumeration3.hasMoreElements()) {
                            String string4 = (String)enumeration3.nextElement();
                            this.parseLockNullProperties(httpServletRequest, xMLWriter, string4, n, vector);
                        }
                    }
                }
                if (((Vector)object5).isEmpty()) {
                    --n2;
                    object5 = stack;
                    stack = new Stack<Object>();
                }
                xMLWriter.sendData();
            }
        }
        xMLWriter.writeElement(null, "multistatus", 1);
        xMLWriter.sendData();
    }

    protected void doProppatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        httpServletResponse.sendError(405);
    }

    protected void doMkcol(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        if (string.toUpperCase().startsWith("/WEB-INF") || string.toUpperCase().startsWith("/META-INF")) {
            httpServletResponse.sendError(403);
            return;
        }
        DirContext dirContext = this.getResources();
        if (dirContext == null) {
            httpServletResponse.sendError(500);
            return;
        }
        boolean bl = true;
        Object object = null;
        try {
            object = dirContext.lookup(string);
        }
        catch (NamingException namingException) {
            bl = false;
        }
        if (bl) {
            httpServletResponse.sendError(405);
            return;
        }
        boolean bl2 = true;
        try {
            dirContext.createSubcontext(string);
        }
        catch (NamingException namingException) {
            bl2 = false;
        }
        if (!bl2) {
            httpServletResponse.sendError(409, WebdavStatus.getStatusText(409));
        } else {
            httpServletResponse.setStatus(201);
            this.lockNullResources.remove(string);
        }
    }

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        this.deleteResource(httpServletRequest, httpServletResponse);
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        super.doPut(httpServletRequest, httpServletResponse);
        String string = this.getRelativePath(httpServletRequest);
        this.lockNullResources.remove(string);
    }

    protected void doCopy(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        this.copyResource(httpServletRequest, httpServletResponse);
    }

    protected void doMove(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        if (this.copyResource(httpServletRequest, httpServletResponse)) {
            this.deleteResource(string, httpServletRequest, httpServletResponse);
        }
    }

    protected void doLock(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Enumeration<Object> enumeration;
        Object object5;
        Object object6;
        Object object7;
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        Object object8 = new LockInfo();
        String string = httpServletRequest.getHeader("Depth");
        ((LockInfo)object8).depth = string == null ? 3 : (string.equals("0") ? 0 : 3);
        int n = 3600;
        String string2 = httpServletRequest.getHeader("Timeout");
        if (string2 == null) {
            n = 3600;
        } else {
            if (string2.startsWith("Second-")) {
                n = new Integer(string2.substring(7));
            } else if (string2.equalsIgnoreCase("infinity")) {
                n = 604800;
            } else {
                try {
                    n = new Integer(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 604800;
                }
            }
            if (n == 0) {
                n = 3600;
            }
            if (n > 604800) {
                n = 604800;
            }
        }
        ((LockInfo)object8).expiresAt = System.currentTimeMillis() + (long)(n * 1000);
        boolean bl = false;
        Node node = null;
        DocumentBuilder documentBuilder = this.getDocumentBuilder();
        try {
            object7 = documentBuilder.parse(new InputSource((InputStream)httpServletRequest.getInputStream()));
            object6 = object7.getDocumentElement();
            node = object6;
        }
        catch (Exception exception) {
            bl = true;
        }
        if (node != null) {
            int n2;
            object7 = node.getChildNodes();
            object6 = null;
            DOMWriter dOMWriter = null;
            object5 = null;
            enumeration = null;
            object4 = null;
            block24: for (n2 = 0; n2 < object7.getLength(); ++n2) {
                object3 = object7.item(n2);
                switch (object3.getNodeType()) {
                    case 3: {
                        continue block24;
                    }
                    case 1: {
                        object2 = object3.getNodeName();
                        if (((String)object2).endsWith("lockscope")) {
                            object5 = object3;
                        }
                        if (((String)object2).endsWith("locktype")) {
                            enumeration = object3;
                        }
                        if (!((String)object2).endsWith("owner")) continue block24;
                        object4 = object3;
                    }
                }
            }
            if (object5 != null) {
                object7 = object5.getChildNodes();
                block25: for (n2 = 0; n2 < object7.getLength(); ++n2) {
                    object3 = object7.item(n2);
                    switch (object3.getNodeType()) {
                        case 3: {
                            continue block25;
                        }
                        case 1: {
                            object2 = object3.getNodeName();
                            ((LockInfo)object8).scope = ((String)object2).indexOf(58) != -1 ? ((String)object2).substring(((String)object2).indexOf(58) + 1) : object2;
                        }
                    }
                }
                if (((LockInfo)object8).scope == null) {
                    httpServletResponse.setStatus(400);
                }
            } else {
                httpServletResponse.setStatus(400);
            }
            if (enumeration != null) {
                object7 = enumeration.getChildNodes();
                block26: for (n2 = 0; n2 < object7.getLength(); ++n2) {
                    object3 = object7.item(n2);
                    switch (object3.getNodeType()) {
                        case 3: {
                            continue block26;
                        }
                        case 1: {
                            object2 = object3.getNodeName();
                            ((LockInfo)object8).type = ((String)object2).indexOf(58) != -1 ? ((String)object2).substring(((String)object2).indexOf(58) + 1) : object2;
                        }
                    }
                }
                if (((LockInfo)object8).type == null) {
                    httpServletResponse.setStatus(400);
                }
            } else {
                httpServletResponse.setStatus(400);
            }
            if (object4 != null) {
                object7 = object4.getChildNodes();
                block27: for (n2 = 0; n2 < object7.getLength(); ++n2) {
                    object3 = object7.item(n2);
                    switch (object3.getNodeType()) {
                        case 3: {
                            ((LockInfo)object8).owner = ((LockInfo)object8).owner + object3.getNodeValue();
                            continue block27;
                        }
                        case 1: {
                            object6 = new StringWriter();
                            dOMWriter = new DOMWriter((Writer)object6, true);
                            dOMWriter.print((Node)object3);
                            ((LockInfo)object8).owner = ((LockInfo)object8).owner + ((StringWriter)object6).toString();
                        }
                    }
                }
                if (((LockInfo)object8).owner == null) {
                    httpServletResponse.setStatus(400);
                }
            } else {
                ((LockInfo)object8).owner = new String();
            }
        }
        ((LockInfo)object8).path = object7 = this.getRelativePath(httpServletRequest);
        object6 = this.getResources();
        if (object6 == null) {
            httpServletResponse.sendError(500);
            return;
        }
        boolean bl2 = true;
        object5 = null;
        try {
            object5 = object6.lookup((String)object7);
        }
        catch (NamingException namingException) {
            bl2 = false;
        }
        enumeration = null;
        if (!bl) {
            object4 = httpServletRequest.getServletPath() + "-" + ((LockInfo)object8).type + "-" + ((LockInfo)object8).scope + "-" + httpServletRequest.getUserPrincipal() + "-" + ((LockInfo)object8).depth + "-" + ((LockInfo)object8).owner + "-" + ((LockInfo)object8).tokens + "-" + ((LockInfo)object8).expiresAt + "-" + System.currentTimeMillis() + "-" + this.secret;
            String string3 = md5Encoder.encode(md5Helper.digest(((String)object4).getBytes()));
            if (bl2 && object5 instanceof DirContext && ((LockInfo)object8).depth == 3) {
                object3 = new Vector<String>();
                enumeration = this.collectionLocks.elements();
                while (enumeration.hasMoreElements()) {
                    object2 = (LockInfo)enumeration.nextElement();
                    if (((LockInfo)object2).hasExpired()) {
                        this.resourceLocks.remove(((LockInfo)object2).path);
                        continue;
                    }
                    if (!((LockInfo)object2).path.startsWith(((LockInfo)object8).path) || !((LockInfo)object2).isExclusive() && !((LockInfo)object8).isExclusive()) continue;
                    ((Vector)object3).addElement(((LockInfo)object2).path);
                }
                enumeration = this.resourceLocks.elements();
                while (enumeration.hasMoreElements()) {
                    object2 = (LockInfo)enumeration.nextElement();
                    if (((LockInfo)object2).hasExpired()) {
                        this.resourceLocks.remove(((LockInfo)object2).path);
                        continue;
                    }
                    if (!((LockInfo)object2).path.startsWith(((LockInfo)object8).path) || !((LockInfo)object2).isExclusive() && !((LockInfo)object8).isExclusive()) continue;
                    ((Vector)object3).addElement(((LockInfo)object2).path);
                }
                if (!((Vector)object3).isEmpty()) {
                    object2 = ((Vector)object3).elements();
                    httpServletResponse.setStatus(409);
                    XMLWriter xMLWriter = new XMLWriter();
                    xMLWriter.writeXMLHeader();
                    xMLWriter.writeElement(null, "multistatus" + this.generateNamespaceDeclarations(), 0);
                    while (object2.hasMoreElements()) {
                        xMLWriter.writeElement(null, "response", 0);
                        xMLWriter.writeElement(null, "href", 0);
                        xMLWriter.writeText((String)object2.nextElement());
                        xMLWriter.writeElement(null, "href", 1);
                        xMLWriter.writeElement(null, "status", 0);
                        xMLWriter.writeText("HTTP/1.1 423 " + WebdavStatus.getStatusText(423));
                        xMLWriter.writeElement(null, "status", 1);
                        xMLWriter.writeElement(null, "response", 1);
                    }
                    xMLWriter.writeElement(null, "multistatus", 1);
                    PrintWriter printWriter = httpServletResponse.getWriter();
                    ((Writer)printWriter).write(xMLWriter.toString());
                    ((Writer)printWriter).close();
                    return;
                }
                boolean bl3 = true;
                enumeration = this.collectionLocks.elements();
                while (enumeration.hasMoreElements()) {
                    object = (LockInfo)enumeration.nextElement();
                    if (!((LockInfo)object).path.equals(((LockInfo)object8).path)) continue;
                    if (((LockInfo)object).isExclusive()) {
                        httpServletResponse.sendError(423);
                        return;
                    }
                    if (((LockInfo)object8).isExclusive()) {
                        httpServletResponse.sendError(423);
                        return;
                    }
                    ((LockInfo)object).tokens.addElement(string3);
                    object8 = object;
                    bl3 = false;
                }
                if (bl3) {
                    ((LockInfo)object8).tokens.addElement(string3);
                    this.collectionLocks.addElement(object8);
                }
            } else {
                object3 = (LockInfo)this.resourceLocks.get(((LockInfo)object8).path);
                if (object3 != null) {
                    if (((LockInfo)object3).isExclusive() || ((LockInfo)object8).isExclusive()) {
                        httpServletResponse.sendError(412);
                        return;
                    }
                    ((LockInfo)object3).tokens.addElement(string3);
                    object8 = object3;
                } else {
                    ((LockInfo)object8).tokens.addElement(string3);
                    this.resourceLocks.put(((LockInfo)object8).path, object8);
                    bl2 = true;
                    try {
                        object5 = object6.lookup((String)object7);
                    }
                    catch (NamingException namingException) {
                        bl2 = false;
                    }
                    if (!bl2) {
                        int n3 = ((LockInfo)object8).path.lastIndexOf(47);
                        object = ((LockInfo)object8).path.substring(0, n3);
                        Vector<String> vector = (Vector<String>)this.lockNullResources.get(object);
                        if (vector == null) {
                            vector = new Vector<String>();
                            this.lockNullResources.put(object, vector);
                        }
                        vector.addElement(((LockInfo)object8).path);
                    }
                }
            }
        }
        if (bl) {
            object4 = httpServletRequest.getHeader("If");
            if (object4 == null) {
                object4 = "";
            }
            LockInfo lockInfo = (LockInfo)this.resourceLocks.get(object7);
            object3 = null;
            if (object8 != null) {
                object3 = lockInfo.tokens.elements();
                while (object3.hasMoreElements()) {
                    String string4 = (String)object3.nextElement();
                    if (((String)object4).indexOf(string4) == -1) continue;
                    lockInfo.expiresAt = ((LockInfo)object8).expiresAt;
                    object8 = lockInfo;
                }
            }
            Enumeration enumeration2 = this.collectionLocks.elements();
            while (enumeration2.hasMoreElements()) {
                lockInfo = (LockInfo)enumeration2.nextElement();
                if (!((String)object7).equals(lockInfo.path)) continue;
                object3 = lockInfo.tokens.elements();
                while (object3.hasMoreElements()) {
                    object = (String)object3.nextElement();
                    if (((String)object4).indexOf((String)object) == -1) continue;
                    lockInfo.expiresAt = ((LockInfo)object8).expiresAt;
                    object8 = lockInfo;
                }
            }
        }
        object4 = new XMLWriter();
        ((XMLWriter)object4).writeXMLHeader();
        ((XMLWriter)object4).writeElement(null, "prop" + this.generateNamespaceDeclarations(), 0);
        ((XMLWriter)object4).writeElement(null, "lockdiscovery", 0);
        ((LockInfo)object8).toXML((XMLWriter)object4, true);
        ((XMLWriter)object4).writeElement(null, "lockdiscovery", 1);
        ((XMLWriter)object4).writeElement(null, "prop", 1);
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType("text/xml; charset=UTF-8");
        PrintWriter printWriter = httpServletResponse.getWriter();
        ((Writer)printWriter).write(((XMLWriter)object4).toString());
        ((Writer)printWriter).close();
    }

    protected void doUnlock(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        String string2 = httpServletRequest.getHeader("Lock-Token");
        if (string2 == null) {
            string2 = "";
        }
        LockInfo lockInfo = (LockInfo)this.resourceLocks.get(string);
        Enumeration enumeration = null;
        if (lockInfo != null) {
            enumeration = lockInfo.tokens.elements();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                if (string2.indexOf((String)object) == -1) continue;
                lockInfo.tokens.removeElement(object);
            }
            if (lockInfo.tokens.isEmpty()) {
                this.resourceLocks.remove(string);
                this.lockNullResources.remove(string);
            }
        }
        object = this.collectionLocks.elements();
        while (object.hasMoreElements()) {
            lockInfo = (LockInfo)object.nextElement();
            if (!string.equals(lockInfo.path)) continue;
            enumeration = lockInfo.tokens.elements();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                if (string2.indexOf(string3) == -1) continue;
                lockInfo.tokens.removeElement(string3);
                break;
            }
            if (!lockInfo.tokens.isEmpty()) continue;
            this.collectionLocks.removeElement(lockInfo);
            this.lockNullResources.remove(string);
        }
        httpServletResponse.setStatus(204);
    }

    private String generateNamespaceDeclarations() {
        return " xmlns=\"DAV:\"";
    }

    private boolean isLocked(HttpServletRequest httpServletRequest) {
        String string;
        String string2 = this.getRelativePath(httpServletRequest);
        String string3 = httpServletRequest.getHeader("If");
        if (string3 == null) {
            string3 = "";
        }
        if ((string = httpServletRequest.getHeader("Lock-Token")) == null) {
            string = "";
        }
        return this.isLocked(string2, string3 + string);
    }

    private boolean isLocked(String string, String string2) {
        LockInfo lockInfo = (LockInfo)this.resourceLocks.get(string);
        Enumeration enumeration = null;
        if (lockInfo != null && lockInfo.hasExpired()) {
            this.resourceLocks.remove(string);
        } else if (lockInfo != null) {
            enumeration = lockInfo.tokens.elements();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                if (string2.indexOf(string3) == -1) continue;
                bl = true;
            }
            if (!bl) {
                return true;
            }
        }
        Enumeration enumeration2 = this.collectionLocks.elements();
        while (enumeration2.hasMoreElements()) {
            lockInfo = (LockInfo)enumeration2.nextElement();
            if (lockInfo.hasExpired()) {
                this.collectionLocks.removeElement(lockInfo);
                continue;
            }
            if (!string.startsWith(lockInfo.path)) continue;
            enumeration = lockInfo.tokens.elements();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                if (string2.indexOf(string4) == -1) continue;
                bl = true;
            }
            if (bl) continue;
            return true;
        }
        return false;
    }

    private boolean copyResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        DirContext dirContext;
        String string;
        String string2;
        String string3 = httpServletRequest.getHeader("Destination");
        if (string3 == null) {
            httpServletResponse.sendError(400);
            return false;
        }
        int n = string3.indexOf("://");
        if (n >= 0) {
            int n2 = string3.indexOf("/", n + 4);
            string3 = n2 < 0 ? "/" : string3.substring(n2);
        } else {
            int n3;
            String string4 = httpServletRequest.getServerName();
            if (string4 != null && string3.startsWith(string4)) {
                string3 = string3.substring(string4.length());
            }
            if ((n3 = string3.indexOf(":")) >= 0) {
                string3 = string3.substring(n3);
            }
            if (string3.startsWith(":")) {
                int n4 = string3.indexOf("/");
                string3 = n4 < 0 ? "/" : string3.substring(n4);
            }
        }
        String string5 = httpServletRequest.getContextPath();
        if (string5 != null && string3.startsWith(string5)) {
            string3 = string3.substring(string5.length());
        }
        if ((string2 = httpServletRequest.getPathInfo()) != null && (string = httpServletRequest.getServletPath()) != null && string3.startsWith(string)) {
            string3 = string3.substring(string.length());
        }
        string3 = RequestUtil.URLDecode(this.normalize(string3), "UTF8");
        if (this.debug > 0) {
            System.out.println("Dest path :" + string3);
        }
        if (string3.toUpperCase().startsWith("/WEB-INF") || string3.toUpperCase().startsWith("/META-INF")) {
            httpServletResponse.sendError(403);
            return false;
        }
        String string6 = this.getRelativePath(httpServletRequest);
        if (string6.toUpperCase().startsWith("/WEB-INF") || string6.toUpperCase().startsWith("/META-INF")) {
            httpServletResponse.sendError(403);
            return false;
        }
        if (string3.equals(string6)) {
            httpServletResponse.sendError(403);
            return false;
        }
        boolean bl = true;
        String string7 = httpServletRequest.getHeader("Overwrite");
        if (string7 != null) {
            bl = string7.equalsIgnoreCase("T");
        }
        if ((dirContext = this.getResources()) == null) {
            httpServletResponse.sendError(500);
            return false;
        }
        boolean bl2 = true;
        try {
            dirContext.lookup(string3);
        }
        catch (NamingException namingException) {
            bl2 = false;
        }
        if (bl) {
            if (bl2) {
                if (!this.deleteResource(string3, httpServletRequest, httpServletResponse)) {
                    return false;
                }
                httpServletResponse.setStatus(204);
            } else {
                httpServletResponse.setStatus(201);
            }
        } else if (bl2) {
            httpServletResponse.sendError(412);
            return false;
        }
        Hashtable hashtable = new Hashtable();
        boolean bl3 = this.copyResource(dirContext, hashtable, string6, string3);
        if (!bl3 || !hashtable.isEmpty()) {
            this.sendReport(httpServletRequest, httpServletResponse, hashtable);
            return false;
        }
        this.lockNullResources.remove(string3);
        return true;
    }

    private boolean copyResource(DirContext dirContext, Hashtable hashtable, String string, String string2) {
        if (this.debug > 1) {
            System.out.println("Copy: " + string + " To: " + string2);
        }
        Object object = null;
        try {
            object = dirContext.lookup(string);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (object instanceof DirContext) {
            try {
                dirContext.createSubcontext(string2);
            }
            catch (NamingException namingException) {
                hashtable.put(string2, new Integer(409));
                return false;
            }
            try {
                NamingEnumeration<NameClassPair> namingEnumeration = dirContext.list(string);
                while (namingEnumeration.hasMoreElements()) {
                    NameClassPair nameClassPair = (NameClassPair)namingEnumeration.nextElement();
                    String string3 = string2;
                    if (!string3.equals("/")) {
                        string3 = string3 + "/";
                    }
                    string3 = string3 + nameClassPair.getName();
                    String string4 = string;
                    if (!string4.equals("/")) {
                        string4 = string4 + "/";
                    }
                    string4 = string4 + nameClassPair.getName();
                    this.copyResource(dirContext, hashtable, string4, string3);
                }
            }
            catch (NamingException namingException) {
                hashtable.put(string2, new Integer(500));
                return false;
            }
        }
        if (object instanceof Resource) {
            try {
                dirContext.bind(string2, object);
            }
            catch (NamingException namingException) {
                hashtable.put(string, new Integer(500));
                return false;
            }
        } else {
            hashtable.put(string, new Integer(500));
            return false;
        }
        return true;
    }

    private boolean deleteResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.getRelativePath(httpServletRequest);
        return this.deleteResource(string, httpServletRequest, httpServletResponse);
    }

    private boolean deleteResource(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string2;
        if (string.toUpperCase().startsWith("/WEB-INF") || string.toUpperCase().startsWith("/META-INF")) {
            httpServletResponse.sendError(403);
            return false;
        }
        String string3 = httpServletRequest.getHeader("If");
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = httpServletRequest.getHeader("Lock-Token")) == null) {
            string2 = "";
        }
        if (this.isLocked(string, string3 + string2)) {
            httpServletResponse.sendError(423);
            return false;
        }
        DirContext dirContext = this.getResources();
        if (dirContext == null) {
            httpServletResponse.sendError(500);
            return false;
        }
        boolean bl = true;
        Object object = null;
        try {
            object = dirContext.lookup(string);
        }
        catch (NamingException namingException) {
            bl = false;
        }
        if (!bl) {
            httpServletResponse.sendError(404);
            return false;
        }
        boolean bl2 = object instanceof DirContext;
        if (!bl2) {
            try {
                dirContext.unbind(string);
            }
            catch (NamingException namingException) {
                httpServletResponse.sendError(500);
                return false;
            }
        }
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        this.deleteCollection(httpServletRequest, dirContext, string, hashtable);
        try {
            dirContext.unbind(string);
        }
        catch (NamingException namingException) {
            hashtable.put(string, new Integer(500));
        }
        if (!hashtable.isEmpty()) {
            this.sendReport(httpServletRequest, httpServletResponse, hashtable);
            return false;
        }
        httpServletResponse.setStatus(204);
        return true;
    }

    private void deleteCollection(HttpServletRequest httpServletRequest, DirContext dirContext, String string, Hashtable hashtable) {
        String string2;
        if (this.debug > 1) {
            System.out.println("Delete:" + string);
        }
        if (string.toUpperCase().startsWith("/WEB-INF") || string.toUpperCase().startsWith("/META-INF")) {
            hashtable.put(string, new Integer(403));
            return;
        }
        String string3 = httpServletRequest.getHeader("If");
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = httpServletRequest.getHeader("Lock-Token")) == null) {
            string2 = "";
        }
        NamingEnumeration<NameClassPair> namingEnumeration = null;
        try {
            namingEnumeration = dirContext.list(string);
        }
        catch (NamingException namingException) {
            hashtable.put(string, new Integer(500));
            return;
        }
        while (namingEnumeration.hasMoreElements()) {
            NameClassPair nameClassPair = (NameClassPair)namingEnumeration.nextElement();
            String string4 = string;
            if (!string4.equals("/")) {
                string4 = string4 + "/";
            }
            if (this.isLocked(string4 = string4 + nameClassPair.getName(), string3 + string2)) {
                hashtable.put(string4, new Integer(423));
                continue;
            }
            try {
                Object object = dirContext.lookup(string4);
                if (object instanceof DirContext) {
                    this.deleteCollection(httpServletRequest, dirContext, string4, hashtable);
                }
                try {
                    dirContext.unbind(string4);
                }
                catch (NamingException namingException) {
                    if (object instanceof DirContext) continue;
                    hashtable.put(string4, new Integer(500));
                }
            }
            catch (NamingException namingException) {
                hashtable.put(string4, new Integer(500));
            }
        }
    }

    private void sendReport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws ServletException, IOException {
        Object object;
        httpServletResponse.setStatus(207);
        String string = httpServletRequest.getRequestURI();
        String string2 = this.getRelativePath(httpServletRequest);
        XMLWriter xMLWriter = new XMLWriter();
        xMLWriter.writeXMLHeader();
        xMLWriter.writeElement(null, "multistatus" + this.generateNamespaceDeclarations(), 0);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            int n = (Integer)hashtable.get(object);
            xMLWriter.writeElement(null, "response", 0);
            xMLWriter.writeElement(null, "href", 0);
            String string3 = ((String)object).substring(string2.length());
            if (!string3.startsWith("/")) {
                string3 = "/" + string3;
            }
            xMLWriter.writeText(string + string3);
            xMLWriter.writeElement(null, "href", 1);
            xMLWriter.writeElement(null, "status", 0);
            xMLWriter.writeText("HTTP/1.1 " + n + " " + WebdavStatus.getStatusText(n));
            xMLWriter.writeElement(null, "status", 1);
            xMLWriter.writeElement(null, "response", 1);
        }
        xMLWriter.writeElement(null, "multistatus", 1);
        object = httpServletResponse.getWriter();
        ((Writer)object).write(xMLWriter.toString());
        ((Writer)object).close();
    }

    private void parseProperties(HttpServletRequest httpServletRequest, DirContext dirContext, XMLWriter xMLWriter, String string, int n, Vector vector) {
        if (string.toUpperCase().startsWith("/WEB-INF") || string.toUpperCase().startsWith("/META-INF")) {
            return;
        }
        DefaultServlet.ResourceInfo resourceInfo = new DefaultServlet.ResourceInfo(string, dirContext);
        xMLWriter.writeElement(null, "response", 0);
        String string2 = new String("HTTP/1.1 200 " + WebdavStatus.getStatusText(200));
        xMLWriter.writeElement(null, "href", 0);
        String string3 = httpServletRequest.getContextPath();
        string3 = string3.endsWith("/") && string.startsWith("/") ? string3 + string.substring(1) : string3 + string;
        if (resourceInfo.collection && !string3.endsWith("/")) {
            string3 = string3 + "/";
        }
        xMLWriter.writeText(this.rewriteUrl(string3));
        xMLWriter.writeElement(null, "href", 1);
        String string4 = string;
        int n2 = string.lastIndexOf(47);
        if (n2 != -1) {
            string4 = string4.substring(n2 + 1);
        }
        switch (n) {
            case 1: {
                xMLWriter.writeElement(null, "propstat", 0);
                xMLWriter.writeElement(null, "prop", 0);
                xMLWriter.writeProperty(null, "creationdate", this.getISOCreationDate(resourceInfo.creationDate));
                xMLWriter.writeElement(null, "displayname", 0);
                xMLWriter.writeData(string4);
                xMLWriter.writeElement(null, "displayname", 1);
                xMLWriter.writeProperty(null, "getcontentlanguage", Locale.getDefault().toString());
                if (!resourceInfo.collection) {
                    xMLWriter.writeProperty(null, "getlastmodified", resourceInfo.httpDate);
                    xMLWriter.writeProperty(null, "getcontentlength", String.valueOf(resourceInfo.length));
                    xMLWriter.writeProperty(null, "getcontenttype", this.getServletContext().getMimeType(resourceInfo.path));
                    xMLWriter.writeProperty(null, "getetag", this.getETagValue(resourceInfo, true));
                    xMLWriter.writeElement(null, "resourcetype", 2);
                } else {
                    xMLWriter.writeElement(null, "resourcetype", 0);
                    xMLWriter.writeElement(null, "collection", 2);
                    xMLWriter.writeElement(null, "resourcetype", 1);
                }
                xMLWriter.writeProperty(null, "source", "");
                String string5 = "<lockentry><lockscope><exclusive/></lockscope><locktype><write/></locktype></lockentry><lockentry><lockscope><shared/></lockscope><locktype><write/></locktype></lockentry>";
                xMLWriter.writeElement(null, "supportedlock", 0);
                xMLWriter.writeText(string5);
                xMLWriter.writeElement(null, "supportedlock", 1);
                this.generateLockDiscovery(string, xMLWriter);
                xMLWriter.writeElement(null, "prop", 1);
                xMLWriter.writeElement(null, "status", 0);
                xMLWriter.writeText(string2);
                xMLWriter.writeElement(null, "status", 1);
                xMLWriter.writeElement(null, "propstat", 1);
                break;
            }
            case 2: {
                xMLWriter.writeElement(null, "propstat", 0);
                xMLWriter.writeElement(null, "prop", 0);
                xMLWriter.writeElement(null, "creationdate", 2);
                xMLWriter.writeElement(null, "displayname", 2);
                if (!resourceInfo.collection) {
                    xMLWriter.writeElement(null, "getcontentlanguage", 2);
                    xMLWriter.writeElement(null, "getcontentlength", 2);
                    xMLWriter.writeElement(null, "getcontenttype", 2);
                    xMLWriter.writeElement(null, "getetag", 2);
                    xMLWriter.writeElement(null, "getlastmodified", 2);
                }
                xMLWriter.writeElement(null, "resourcetype", 2);
                xMLWriter.writeElement(null, "source", 2);
                xMLWriter.writeElement(null, "lockdiscovery", 2);
                xMLWriter.writeElement(null, "prop", 1);
                xMLWriter.writeElement(null, "status", 0);
                xMLWriter.writeText(string2);
                xMLWriter.writeElement(null, "status", 1);
                xMLWriter.writeElement(null, "propstat", 1);
                break;
            }
            case 0: {
                Object object;
                Vector<Object> vector2 = new Vector<Object>();
                xMLWriter.writeElement(null, "propstat", 0);
                xMLWriter.writeElement(null, "prop", 0);
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    if (((String)object).equals("creationdate")) {
                        xMLWriter.writeProperty(null, "creationdate", this.getISOCreationDate(resourceInfo.creationDate));
                        continue;
                    }
                    if (((String)object).equals("displayname")) {
                        xMLWriter.writeElement(null, "displayname", 0);
                        xMLWriter.writeData(string4);
                        xMLWriter.writeElement(null, "displayname", 1);
                        continue;
                    }
                    if (((String)object).equals("getcontentlanguage")) {
                        if (resourceInfo.collection) {
                            vector2.addElement(object);
                            continue;
                        }
                        xMLWriter.writeProperty(null, "getcontentlanguage", Locale.getDefault().toString());
                        continue;
                    }
                    if (((String)object).equals("getcontentlength")) {
                        if (resourceInfo.collection) {
                            vector2.addElement(object);
                            continue;
                        }
                        xMLWriter.writeProperty(null, "getcontentlength", String.valueOf(resourceInfo.length));
                        continue;
                    }
                    if (((String)object).equals("getcontenttype")) {
                        if (resourceInfo.collection) {
                            vector2.addElement(object);
                            continue;
                        }
                        xMLWriter.writeProperty(null, "getcontenttype", this.getServletContext().getMimeType(resourceInfo.path));
                        continue;
                    }
                    if (((String)object).equals("getetag")) {
                        if (resourceInfo.collection) {
                            vector2.addElement(object);
                            continue;
                        }
                        xMLWriter.writeProperty(null, "getetag", this.getETagValue(resourceInfo, true));
                        continue;
                    }
                    if (((String)object).equals("getlastmodified")) {
                        if (resourceInfo.collection) {
                            vector2.addElement(object);
                            continue;
                        }
                        xMLWriter.writeProperty(null, "getlastmodified", resourceInfo.httpDate);
                        continue;
                    }
                    if (((String)object).equals("resourcetype")) {
                        if (resourceInfo.collection) {
                            xMLWriter.writeElement(null, "resourcetype", 0);
                            xMLWriter.writeElement(null, "collection", 2);
                            xMLWriter.writeElement(null, "resourcetype", 1);
                            continue;
                        }
                        xMLWriter.writeElement(null, "resourcetype", 2);
                        continue;
                    }
                    if (((String)object).equals("source")) {
                        xMLWriter.writeProperty(null, "source", "");
                        continue;
                    }
                    if (((String)object).equals("supportedlock")) {
                        String string6 = "<lockentry><lockscope><exclusive/></lockscope><locktype><write/></locktype></lockentry><lockentry><lockscope><shared/></lockscope><locktype><write/></locktype></lockentry>";
                        xMLWriter.writeElement(null, "supportedlock", 0);
                        xMLWriter.writeText(string6);
                        xMLWriter.writeElement(null, "supportedlock", 1);
                        continue;
                    }
                    if (((String)object).equals("lockdiscovery")) {
                        if (this.generateLockDiscovery(string, xMLWriter)) continue;
                        vector2.addElement(object);
                        continue;
                    }
                    vector2.addElement(object);
                }
                xMLWriter.writeElement(null, "prop", 1);
                xMLWriter.writeElement(null, "status", 0);
                xMLWriter.writeText(string2);
                xMLWriter.writeElement(null, "status", 1);
                xMLWriter.writeElement(null, "propstat", 1);
                object = vector2.elements();
                if (!object.hasMoreElements()) break;
                string2 = new String("HTTP/1.1 404 " + WebdavStatus.getStatusText(404));
                xMLWriter.writeElement(null, "propstat", 0);
                xMLWriter.writeElement(null, "prop", 0);
                while (object.hasMoreElements()) {
                    xMLWriter.writeElement(null, (String)object.nextElement(), 2);
                }
                xMLWriter.writeElement(null, "prop", 1);
                xMLWriter.writeElement(null, "status", 0);
                xMLWriter.writeText(string2);
                xMLWriter.writeElement(null, "status", 1);
                xMLWriter.writeElement(null, "propstat", 1);
            }
        }
        xMLWriter.writeElement(null, "response", 1);
    }

    private void parseLockNullProperties(HttpServletRequest httpServletRequest, XMLWriter xMLWriter, String string, int n, Vector vector) {
        if (string.toUpperCase().startsWith("/WEB-INF") || string.toUpperCase().startsWith("/META-INF")) {
            return;
        }
        LockInfo lockInfo = (LockInfo)this.resourceLocks.get(string);
        if (lockInfo == null) {
            return;
        }
        xMLWriter.writeElement(null, "response", 0);
        String string2 = new String("HTTP/1.1 200 " + WebdavStatus.getStatusText(200));
        xMLWriter.writeElement(null, "href", 0);
        String string3 = httpServletRequest.getRequestURI();
        String string4 = this.getRelativePath(httpServletRequest);
        String string5 = string.substring(string4.length());
        if (!string5.startsWith("/")) {
            string5 = "/" + string5;
        }
        xMLWriter.writeText(this.rewriteUrl(this.normalize(string3 + string5)));
        xMLWriter.writeElement(null, "href", 1);
        String string6 = string;
        int n2 = string.lastIndexOf(47);
        if (n2 != -1) {
            string6 = string6.substring(n2 + 1);
        }
        switch (n) {
            case 1: {
                xMLWriter.writeElement(null, "propstat", 0);
                xMLWriter.writeElement(null, "prop", 0);
                xMLWriter.writeProperty(null, "creationdate", this.getISOCreationDate(lockInfo.creationDate.getTime()));
                xMLWriter.writeElement(null, "displayname", 0);
                xMLWriter.writeData(string6);
                xMLWriter.writeElement(null, "displayname", 1);
                xMLWriter.writeProperty(null, "getcontentlanguage", Locale.getDefault().toString());
                xMLWriter.writeProperty(null, "getlastmodified", formats[0].format(lockInfo.creationDate));
                xMLWriter.writeProperty(null, "getcontentlength", String.valueOf(0));
                xMLWriter.writeProperty(null, "getcontenttype", "");
                xMLWriter.writeProperty(null, "getetag", "");
                xMLWriter.writeElement(null, "resourcetype", 0);
                xMLWriter.writeElement(null, "lock-null", 2);
                xMLWriter.writeElement(null, "resourcetype", 1);
                xMLWriter.writeProperty(null, "source", "");
                String string7 = "<lockentry><lockscope><exclusive/></lockscope><locktype><write/></locktype></lockentry><lockentry><lockscope><shared/></lockscope><locktype><write/></locktype></lockentry>";
                xMLWriter.writeElement(null, "supportedlock", 0);
                xMLWriter.writeText(string7);
                xMLWriter.writeElement(null, "supportedlock", 1);
                this.generateLockDiscovery(string, xMLWriter);
                xMLWriter.writeElement(null, "prop", 1);
                xMLWriter.writeElement(null, "status", 0);
                xMLWriter.writeText(string2);
                xMLWriter.writeElement(null, "status", 1);
                xMLWriter.writeElement(null, "propstat", 1);
                break;
            }
            case 2: {
                xMLWriter.writeElement(null, "propstat", 0);
                xMLWriter.writeElement(null, "prop", 0);
                xMLWriter.writeElement(null, "creationdate", 2);
                xMLWriter.writeElement(null, "displayname", 2);
                xMLWriter.writeElement(null, "getcontentlanguage", 2);
                xMLWriter.writeElement(null, "getcontentlength", 2);
                xMLWriter.writeElement(null, "getcontenttype", 2);
                xMLWriter.writeElement(null, "getetag", 2);
                xMLWriter.writeElement(null, "getlastmodified", 2);
                xMLWriter.writeElement(null, "resourcetype", 2);
                xMLWriter.writeElement(null, "source", 2);
                xMLWriter.writeElement(null, "lockdiscovery", 2);
                xMLWriter.writeElement(null, "prop", 1);
                xMLWriter.writeElement(null, "status", 0);
                xMLWriter.writeText(string2);
                xMLWriter.writeElement(null, "status", 1);
                xMLWriter.writeElement(null, "propstat", 1);
                break;
            }
            case 0: {
                Object object;
                Vector<Object> vector2 = new Vector<Object>();
                xMLWriter.writeElement(null, "propstat", 0);
                xMLWriter.writeElement(null, "prop", 0);
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    if (((String)object).equals("creationdate")) {
                        xMLWriter.writeProperty(null, "creationdate", this.getISOCreationDate(lockInfo.creationDate.getTime()));
                        continue;
                    }
                    if (((String)object).equals("displayname")) {
                        xMLWriter.writeElement(null, "displayname", 0);
                        xMLWriter.writeData(string6);
                        xMLWriter.writeElement(null, "displayname", 1);
                        continue;
                    }
                    if (((String)object).equals("getcontentlanguage")) {
                        xMLWriter.writeProperty(null, "getcontentlanguage", Locale.getDefault().toString());
                        continue;
                    }
                    if (((String)object).equals("getcontentlength")) {
                        xMLWriter.writeProperty(null, "getcontentlength", String.valueOf(0));
                        continue;
                    }
                    if (((String)object).equals("getcontenttype")) {
                        xMLWriter.writeProperty(null, "getcontenttype", "");
                        continue;
                    }
                    if (((String)object).equals("getetag")) {
                        xMLWriter.writeProperty(null, "getetag", "");
                        continue;
                    }
                    if (((String)object).equals("getlastmodified")) {
                        xMLWriter.writeProperty(null, "getlastmodified", formats[0].format(lockInfo.creationDate));
                        continue;
                    }
                    if (((String)object).equals("resourcetype")) {
                        xMLWriter.writeElement(null, "resourcetype", 0);
                        xMLWriter.writeElement(null, "lock-null", 2);
                        xMLWriter.writeElement(null, "resourcetype", 1);
                        continue;
                    }
                    if (((String)object).equals("source")) {
                        xMLWriter.writeProperty(null, "source", "");
                        continue;
                    }
                    if (((String)object).equals("supportedlock")) {
                        String string8 = "<lockentry><lockscope><exclusive/></lockscope><locktype><write/></locktype></lockentry><lockentry><lockscope><shared/></lockscope><locktype><write/></locktype></lockentry>";
                        xMLWriter.writeElement(null, "supportedlock", 0);
                        xMLWriter.writeText(string8);
                        xMLWriter.writeElement(null, "supportedlock", 1);
                        continue;
                    }
                    if (((String)object).equals("lockdiscovery")) {
                        if (this.generateLockDiscovery(string, xMLWriter)) continue;
                        vector2.addElement(object);
                        continue;
                    }
                    vector2.addElement(object);
                }
                xMLWriter.writeElement(null, "prop", 1);
                xMLWriter.writeElement(null, "status", 0);
                xMLWriter.writeText(string2);
                xMLWriter.writeElement(null, "status", 1);
                xMLWriter.writeElement(null, "propstat", 1);
                object = vector2.elements();
                if (!object.hasMoreElements()) break;
                string2 = new String("HTTP/1.1 404 " + WebdavStatus.getStatusText(404));
                xMLWriter.writeElement(null, "propstat", 0);
                xMLWriter.writeElement(null, "prop", 0);
                while (object.hasMoreElements()) {
                    xMLWriter.writeElement(null, (String)object.nextElement(), 2);
                }
                xMLWriter.writeElement(null, "prop", 1);
                xMLWriter.writeElement(null, "status", 0);
                xMLWriter.writeText(string2);
                xMLWriter.writeElement(null, "status", 1);
                xMLWriter.writeElement(null, "propstat", 1);
            }
        }
        xMLWriter.writeElement(null, "response", 1);
    }

    private boolean generateLockDiscovery(String string, XMLWriter xMLWriter) {
        LockInfo lockInfo = (LockInfo)this.resourceLocks.get(string);
        Enumeration enumeration = this.collectionLocks.elements();
        boolean bl = false;
        if (lockInfo != null) {
            bl = true;
            xMLWriter.writeElement(null, "lockdiscovery", 0);
            lockInfo.toXML(xMLWriter);
        }
        while (enumeration.hasMoreElements()) {
            LockInfo lockInfo2 = (LockInfo)enumeration.nextElement();
            if (!string.startsWith(lockInfo2.path)) continue;
            if (!bl) {
                bl = true;
                xMLWriter.writeElement(null, "lockdiscovery", 0);
            }
            lockInfo2.toXML(xMLWriter);
        }
        if (!bl) {
            return false;
        }
        xMLWriter.writeElement(null, "lockdiscovery", 1);
        return true;
    }

    private String getISOCreationDate(long l) {
        StringBuffer stringBuffer = new StringBuffer(creationDateFormat.format(new Date(l)));
        return stringBuffer.toString();
    }

    static {
        creationDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private class Property {
        public String name;
        public String value;
        public String namespace;
        public String namespaceAbbrev;
        public int status = 200;

        private Property() {
        }
    }

    private class LockInfo {
        String path = "/";
        String type = "write";
        String scope = "exclusive";
        int depth = 0;
        String owner = "";
        Vector tokens = new Vector();
        long expiresAt = 0L;
        Date creationDate = new Date();

        public String toString() {
            String string = "Type:" + this.type + "\n";
            string = string + "Scope:" + this.scope + "\n";
            string = string + "Depth:" + this.depth + "\n";
            string = string + "Owner:" + this.owner + "\n";
            string = string + "Expiration:" + DefaultServlet.formats[0].format(new Date(this.expiresAt)) + "\n";
            Enumeration enumeration = this.tokens.elements();
            while (enumeration.hasMoreElements()) {
                string = string + "Token:" + enumeration.nextElement() + "\n";
            }
            return string;
        }

        public boolean hasExpired() {
            return System.currentTimeMillis() > this.expiresAt;
        }

        public boolean isExclusive() {
            return this.scope.equals("exclusive");
        }

        public void toXML(XMLWriter xMLWriter) {
            this.toXML(xMLWriter, false);
        }

        public void toXML(XMLWriter xMLWriter, boolean bl) {
            xMLWriter.writeElement(null, "activelock", 0);
            xMLWriter.writeElement(null, "locktype", 0);
            xMLWriter.writeElement(null, this.type, 2);
            xMLWriter.writeElement(null, "locktype", 1);
            xMLWriter.writeElement(null, "lockscope", 0);
            xMLWriter.writeElement(null, this.scope, 2);
            xMLWriter.writeElement(null, "lockscope", 1);
            xMLWriter.writeElement(null, "depth", 0);
            if (this.depth == 3) {
                xMLWriter.writeText("Infinity");
            } else {
                xMLWriter.writeText("0");
            }
            xMLWriter.writeElement(null, "depth", 1);
            xMLWriter.writeElement(null, "owner", 0);
            xMLWriter.writeText(this.owner);
            xMLWriter.writeElement(null, "owner", 1);
            xMLWriter.writeElement(null, "timeout", 0);
            long l = (this.expiresAt - System.currentTimeMillis()) / 1000L;
            xMLWriter.writeText("Second-" + l);
            xMLWriter.writeElement(null, "timeout", 1);
            xMLWriter.writeElement(null, "locktoken", 0);
            if (bl) {
                Enumeration enumeration = this.tokens.elements();
                while (enumeration.hasMoreElements()) {
                    xMLWriter.writeElement(null, "href", 0);
                    xMLWriter.writeText("opaquelocktoken:" + enumeration.nextElement());
                    xMLWriter.writeElement(null, "href", 1);
                }
            } else {
                xMLWriter.writeElement(null, "href", 0);
                xMLWriter.writeText("opaquelocktoken:dummytoken");
                xMLWriter.writeElement(null, "href", 1);
            }
            xMLWriter.writeElement(null, "locktoken", 1);
            xMLWriter.writeElement(null, "activelock", 1);
        }
    }
}

