/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.util.ssi.ServletOutputStreamWrapper;
import org.apache.catalina.util.ssi.SsiCommand;
import org.apache.catalina.util.ssi.SsiMediator;

public final class SsiInvokerServlet
extends HttpServlet {
    private int debug = 0;
    private boolean buffered = false;
    private Long expires = null;
    private boolean ignoreUnsupportedDirective = false;
    private boolean isVirtualWebappRelative = false;
    private static SsiMediator ssiMediator = null;
    private static final byte[] bStart = new byte[]{60, 33, 45, 45, 35};
    private static final byte[] bEnd = new byte[]{45, 45, 62};

    public void init() throws ServletException {
        String string = null;
        try {
            string = this.getServletConfig().getInitParameter("debug");
            this.debug = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            string = this.getServletConfig().getInitParameter("isVirtualWebappRelative");
            this.isVirtualWebappRelative = Integer.parseInt(string) > 0;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            string = this.getServletConfig().getInitParameter("ignoreUnsupportedDirective");
            this.ignoreUnsupportedDirective = Integer.parseInt(string) > 0;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            string = this.getServletConfig().getInitParameter("expires");
            this.expires = Long.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.expires = null;
            this.log("Invalid format for expires initParam; expected integer (seconds)");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            string = this.getServletConfig().getInitParameter("buffered");
            this.buffered = Integer.parseInt(string) > 0;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.debug > 0) {
            this.log("SsiInvokerServlet.init() SSI invoker started with 'debug'=" + this.debug);
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (this.debug > 0) {
            this.log("SsiInvokerServlet.doGet()");
        }
        this.requestHandler(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (this.debug > 0) {
            this.log("SsiInvokerServlet.doPut()");
        }
        this.requestHandler(httpServletRequest, httpServletResponse);
    }

    private void requestHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        ServletContext servletContext = this.getServletContext();
        String string = this.getRelativePath(httpServletRequest);
        URL uRL = servletContext.getResource(string);
        if (this.debug > 0) {
            this.log("SsiInvokerServlet.requestHandler()\nServing " + (this.buffered ? "buffered " : "unbuffered ") + "resource '" + string + "'");
        }
        if (string == null || string.toUpperCase().startsWith("/WEB-INF") || string.toUpperCase().startsWith("/META-INF")) {
            httpServletResponse.sendError(404, string);
            return;
        }
        if (uRL == null) {
            httpServletResponse.sendError(404, string);
            return;
        }
        httpServletResponse.setContentType("text/html;charset=UTF-8");
        if (this.expires != null) {
            httpServletResponse.setDateHeader("Expires", new Date().getTime() + this.expires * 1000L);
        }
        ServletOutputStream servletOutputStream = null;
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 4096);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(uRLConnection.getContentLength());
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = new byte[4096];
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        SsiCommand ssiCommand = null;
        servletOutputStream = this.buffered ? new ServletOutputStreamWrapper() : httpServletResponse.getOutputStream();
        if (ssiMediator == null) {
            ssiMediator = new SsiMediator(httpServletRequest, httpServletResponse, (OutputStream)servletOutputStream, servletContext, this.debug, string, this.isVirtualWebappRelative);
        } else {
            ssiMediator.flush(httpServletRequest, httpServletResponse, (OutputStream)servletOutputStream, servletContext, string, this.isVirtualWebappRelative);
        }
        while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream = null;
        byArray = null;
        while (n2 < byArray2.length) {
            if (!bl) {
                if (byArray2[n2] == bStart[0] && this.byteCmp(byArray2, n2, bStart)) {
                    bl = true;
                    n2 += bStart.length;
                    stringBuffer.delete(0, stringBuffer.length());
                    continue;
                }
                servletOutputStream.write(byArray2[n2]);
                ++n2;
                continue;
            }
            if (byArray2[n2] == bEnd[0] && this.byteCmp(byArray2, n2, bEnd)) {
                String string2;
                bl = false;
                n2 += bEnd.length;
                try {
                    string2 = this.parseCmd(stringBuffer);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    servletOutputStream.write(ssiMediator.getError());
                    continue;
                }
                string2 = this.parseCmd(stringBuffer);
                String[] stringArray = this.parseParamType(stringBuffer, string2.length());
                String[] stringArray2 = this.parseParam(stringBuffer, string2.length());
                if (this.debug > 0) {
                    this.log("Serving SSI resource: " + string2);
                }
                if ((ssiCommand = ssiMediator.getCommand(string2)) != null && stringArray.length == stringArray2.length && stringArray.length > 0) {
                    if (ssiCommand.isPrintable()) {
                        servletOutputStream.write(ssiCommand.getStream(stringArray, stringArray2).getBytes());
                        continue;
                    }
                    ssiCommand.process(stringArray, stringArray2);
                    continue;
                }
                if (this.ignoreUnsupportedDirective && ssiCommand == null) continue;
                servletOutputStream.write(ssiMediator.getError());
                continue;
            }
            stringBuffer.append((char)byArray2[n2]);
            ++n2;
        }
        if (this.buffered) {
            ((ServletOutputStreamWrapper)servletOutputStream).writeTo((OutputStream)httpServletResponse.getOutputStream());
        }
        servletOutputStream = null;
    }

    private String parseCmd(StringBuffer stringBuffer) throws IndexOutOfBoundsException {
        String string = stringBuffer.toString().trim().toLowerCase();
        return string.substring(0, string.indexOf(32));
    }

    private String[] parseParamType(StringBuffer stringBuffer, int n) {
        int n2 = n;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        StringBuffer stringBuffer2 = new StringBuffer();
        while (n2 < stringBuffer.length()) {
            if (!bl) {
                while (n2 < stringBuffer.length() && this.isSpace(stringBuffer.charAt(n2))) {
                    ++n2;
                }
                if (n2 >= stringBuffer.length()) break;
                bl = !bl;
                continue;
            }
            while (n2 < stringBuffer.length() && stringBuffer.charAt(n2) != '=') {
                stringBuffer2.append(stringBuffer.charAt(n2));
                ++n2;
            }
            stringBuffer2.append('\"');
            bl = !bl;
            n4 = 0;
            while (n2 < stringBuffer.length() && n4 != 2) {
                if (stringBuffer.charAt(n2) == '\"') {
                    ++n4;
                }
                ++n2;
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer2.toString(), "\"");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n3++] = stringTokenizer.nextToken().trim();
        }
        return stringArray;
    }

    private String[] parseParam(StringBuffer stringBuffer, int n) {
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = n; i < stringBuffer.length(); ++i) {
            if (!bl2) {
                while (i < stringBuffer.length() && stringBuffer.charAt(i) != '\"') {
                    ++i;
                }
                if (i >= stringBuffer.length()) break;
                bl2 = !bl2;
                continue;
            }
            while (i < stringBuffer.length() && stringBuffer.charAt(i) != '\"') {
                stringBuffer2.append(stringBuffer.charAt(i));
                ++i;
            }
            stringBuffer2.append('\"');
            bl2 = !bl2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer2.toString(), "\"");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private boolean byteCmp(byte[] byArray, int n, byte[] byArray2) {
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray[n + i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean isSpace(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    private String getRelativePath(HttpServletRequest httpServletRequest) {
        if (httpServletRequest.getAttribute("javax.servlet.include.request_uri") != null) {
            String string = (String)httpServletRequest.getAttribute("javax.servlet.include.path_info");
            if (string == null) {
                string = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
            }
            if (string == null || string.equals("")) {
                string = "/";
            }
            return string;
        }
        String string = httpServletRequest.getPathInfo();
        if (string == null) {
            string = httpServletRequest.getServletPath();
        }
        if (string == null || string.equals("")) {
            string = "/";
        }
        return this.normalize(string);
    }

    private String normalize(String string) {
        int n;
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (string2 == null) {
            return null;
        }
        if (string2.indexOf(92) >= 0) {
            string2 = string2.replace('\\', '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        while ((n = string2.indexOf("//")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 1);
        }
        while ((n = string2.indexOf("/./")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 2);
        }
        while ((n = string2.indexOf("/../")) >= 0) {
            if (n == 0) {
                return null;
            }
            int n2 = string2.lastIndexOf(47, n - 1);
            string2 = string2.substring(0, n2) + string2.substring(n + 3);
        }
        return string2;
    }
}

