/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.Deployer;
import org.apache.catalina.Session;
import org.apache.catalina.Wrapper;
import org.apache.catalina.util.StringManager;

public class ManagerServlet
extends HttpServlet
implements ContainerServlet {
    protected Context context = null;
    protected int debug = 1;
    protected Deployer deployer = null;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.servlets");
    protected Wrapper wrapper = null;

    public Wrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
        if (wrapper == null) {
            this.context = null;
            this.deployer = null;
        } else {
            this.context = (Context)wrapper.getParent();
            this.deployer = (Deployer)this.context.getParent();
        }
    }

    public void destroy() {
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (httpServletRequest.getAttribute("org.apache.catalina.INVOKED") != null) {
            throw new UnavailableException(sm.getString("managerServlet.cannotInvoke"));
        }
        String string = httpServletRequest.getPathInfo();
        if (string == null) {
            string = httpServletRequest.getServletPath();
        }
        String string2 = httpServletRequest.getParameter("path");
        String string3 = httpServletRequest.getParameter("war");
        httpServletResponse.setContentType("text/plain");
        PrintWriter printWriter = httpServletResponse.getWriter();
        if (string == null) {
            printWriter.println(sm.getString("managerServlet.noCommand"));
        } else if (string.equals("/install")) {
            this.install(printWriter, string2, string3);
        } else if (string.equals("/list")) {
            this.list(printWriter);
        } else if (string.equals("/reload")) {
            this.reload(printWriter, string2);
        } else if (string.equals("/remove")) {
            this.remove(printWriter, string2);
        } else if (string.equals("/sessions")) {
            this.sessions(printWriter, string2);
        } else if (string.equals("/start")) {
            this.start(printWriter, string2);
        } else if (string.equals("/stop")) {
            this.stop(printWriter, string2);
        } else {
            printWriter.println(sm.getString("managerServlet.unknownCommand", string));
        }
        printWriter.flush();
        printWriter.close();
    }

    public void init() throws ServletException {
        if (this.wrapper == null || this.context == null) {
            throw new UnavailableException(sm.getString("managerServlet.noWrapper"));
        }
        String string = this.getServletConfig().getServletName();
        if (string == null) {
            string = "";
        }
        if (string.startsWith("org.apache.catalina.INVOKER.")) {
            throw new UnavailableException(sm.getString("managerServlet.cannotInvoke"));
        }
        String string2 = null;
        try {
            string2 = this.getServletConfig().getInitParameter("debug");
            this.debug = Integer.parseInt(string2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.debug >= 1) {
            this.log("init: Associated with Deployer '" + this.deployer.getName() + "'");
        }
    }

    protected void install(PrintWriter printWriter, String string, String string2) {
        if (this.debug >= 1) {
            this.log("install: Installing web application at '" + string + "' from '" + string2 + "'");
        }
        if (string == null || !string.startsWith("/") && string.equals("")) {
            printWriter.println(sm.getString("managerServlet.invalidPath", string));
            return;
        }
        String string3 = string;
        if (string.equals("/")) {
            string = "";
        }
        if (string2 == null || !string2.startsWith("file:") && !string2.startsWith("jar:")) {
            printWriter.println(sm.getString("managerServlet.invalidWar", string2));
            return;
        }
        try {
            Context context = this.deployer.findDeployedApp(string);
            if (context != null) {
                printWriter.println(sm.getString("managerServlet.alreadyContext", string3));
                return;
            }
            this.deployer.install(string, new URL(string2));
            printWriter.println(sm.getString("managerServlet.installed", string3));
        }
        catch (Throwable throwable) {
            this.getServletContext().log("ManagerServlet.install[" + string3 + "]", throwable);
            printWriter.println(sm.getString("managerServlet.exception", throwable.toString()));
        }
    }

    protected void list(PrintWriter printWriter) {
        if (this.debug >= 1) {
            this.log("list: Listing contexts for virtual host '" + this.deployer.getName() + "'");
        }
        printWriter.println(sm.getString("managerServlet.listed", this.deployer.getName()));
        String[] stringArray = this.deployer.findDeployedApps();
        for (int i = 0; i < stringArray.length; ++i) {
            Context context = this.deployer.findDeployedApp(stringArray[i]);
            String string = stringArray[i];
            if (string.equals("")) {
                string = "/";
            }
            if (context == null) continue;
            if (context.getAvailable()) {
                printWriter.println(sm.getString("managerServlet.listitem", string, "running", "" + context.getManager().findSessions().length));
                continue;
            }
            printWriter.println(sm.getString("managerServlet.listitem", string, "stopped", "0"));
        }
    }

    protected void reload(PrintWriter printWriter, String string) {
        if (this.debug >= 1) {
            this.log("restart: Reloading web application at '" + string + "'");
        }
        if (string == null || !string.startsWith("/") && string.equals("")) {
            printWriter.println(sm.getString("managerServlet.invalidPath", string));
            return;
        }
        String string2 = string;
        if (string.equals("/")) {
            string = "";
        }
        try {
            Context context = this.deployer.findDeployedApp(string);
            if (context == null) {
                printWriter.println(sm.getString("managerServlet.noContext", string2));
                return;
            }
            context.reload();
            printWriter.println(sm.getString("managerServlet.reloaded", string2));
        }
        catch (Throwable throwable) {
            this.getServletContext().log("ManagerServlet.reload[" + string2 + "]", throwable);
            printWriter.println(sm.getString("managerServlet.exception", throwable.toString()));
        }
    }

    protected void remove(PrintWriter printWriter, String string) {
        if (this.debug >= 1) {
            this.log("remove: Removing web application at '" + string + "'");
        }
        if (string == null || !string.startsWith("/") && string.equals("")) {
            printWriter.println(sm.getString("managerServlet.invalidPath", string));
            return;
        }
        String string2 = string;
        if (string.equals("/")) {
            string = "";
        }
        try {
            Context context = this.deployer.findDeployedApp(string);
            if (context == null) {
                printWriter.println(sm.getString("managerServlet.noContext", string2));
                return;
            }
            this.deployer.remove(string);
            printWriter.println(sm.getString("managerServlet.removed", string2));
        }
        catch (Throwable throwable) {
            this.getServletContext().log("ManagerServlet.remove[" + string2 + "]", throwable);
            printWriter.println(sm.getString("managerServlet.exception", throwable.toString()));
        }
    }

    protected void sessions(PrintWriter printWriter, String string) {
        if (this.debug >= 1) {
            this.log("sessions: Session information for web application at '" + string + "'");
        }
        if (string == null || !string.startsWith("/") && string.equals("")) {
            printWriter.println(sm.getString("managerServlet.invalidPath", string));
            return;
        }
        String string2 = string;
        if (string.equals("/")) {
            string = "";
        }
        try {
            int n;
            Context context = this.deployer.findDeployedApp(string);
            if (context == null) {
                printWriter.println(sm.getString("managerServlet.noContext", string2));
                return;
            }
            printWriter.println(sm.getString("managerServlet.sessions", string2));
            printWriter.println(sm.getString("managerServlet.sessiondefaultmax", "" + context.getManager().getMaxInactiveInterval() / 60));
            Session[] sessionArray = context.getManager().findSessions();
            int[] nArray = new int[60];
            int n2 = 0;
            for (n = 0; n < sessionArray.length; ++n) {
                int n3 = sessionArray[n].getMaxInactiveInterval() / 600;
                if (n3 < 0) {
                    ++n2;
                    continue;
                }
                if (n3 >= nArray.length) {
                    int n4 = nArray.length - 1;
                    nArray[n4] = nArray[n4] + 1;
                    continue;
                }
                int n5 = n3;
                nArray[n5] = nArray[n5] + 1;
            }
            if (nArray[0] > 0) {
                printWriter.println(sm.getString("managerServlet.sessiontimeout", "<10" + nArray[0]));
            }
            for (n = 1; n < nArray.length - 1; ++n) {
                if (nArray[n] <= 0) continue;
                printWriter.println(sm.getString("managerServlet.sessiontimeout", "" + n * 10 + " - <" + (n + 1) * 10, "" + nArray[n]));
            }
            if (nArray[nArray.length - 1] > 0) {
                printWriter.println(sm.getString("managerServlet.sessiontimeout", ">=" + nArray.length * 10, "" + nArray[nArray.length - 1]));
            }
            if (n2 > 0) {
                printWriter.println(sm.getString("managerServlet.sessiontimeout", "unlimited", "" + n2));
            }
        }
        catch (Throwable throwable) {
            this.getServletContext().log("ManagerServlet.sessions[" + string2 + "]", throwable);
            printWriter.println(sm.getString("managerServlet.exception", throwable.toString()));
        }
    }

    protected void start(PrintWriter printWriter, String string) {
        if (this.debug >= 1) {
            this.log("start: Starting web application at '" + string + "'");
        }
        if (string == null || !string.startsWith("/") && string.equals("")) {
            printWriter.println(sm.getString("managerServlet.invalidPath", string));
            return;
        }
        String string2 = string;
        if (string.equals("/")) {
            string = "";
        }
        try {
            Context context = this.deployer.findDeployedApp(string);
            if (context == null) {
                printWriter.println(sm.getString("managerServlet.noContext", string2));
                return;
            }
            this.deployer.start(string);
            if (context.getAvailable()) {
                printWriter.println(sm.getString("managerServlet.started", string2));
            } else {
                printWriter.println(sm.getString("managerServlet.startFailed", string2));
            }
        }
        catch (Throwable throwable) {
            this.getServletContext().log(sm.getString("managerServlet.startFailed", string2), throwable);
            printWriter.println(sm.getString("managerServlet.startFailed", string2));
            printWriter.println(sm.getString("managerServlet.exception", throwable.toString()));
        }
    }

    protected void stop(PrintWriter printWriter, String string) {
        if (this.debug >= 1) {
            this.log("stop: Stopping web application at '" + string + "'");
        }
        if (string == null || !string.startsWith("/") && string.equals("")) {
            printWriter.println(sm.getString("managerServlet.invalidPath", string));
            return;
        }
        String string2 = string;
        if (string.equals("/")) {
            string = "";
        }
        try {
            Context context = this.deployer.findDeployedApp(string);
            if (context == null) {
                printWriter.println(sm.getString("managerServlet.noContext", string2));
                return;
            }
            this.deployer.stop(string);
            printWriter.println(sm.getString("managerServlet.stopped", string2));
        }
        catch (Throwable throwable) {
            this.getServletContext().log("ManagerServlet.stop[" + string2 + "]", throwable);
            printWriter.println(sm.getString("managerServlet.exception", throwable.toString()));
        }
    }
}

