/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.servlets.ManagerServlet;

public final class HTMLManagerServlet
extends ManagerServlet {
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string = httpServletRequest.getPathInfo();
        String string2 = httpServletRequest.getParameter("path");
        String string3 = httpServletRequest.getParameter("war");
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        if (string == null) {
            httpServletResponse.sendRedirect(httpServletRequest.getRequestURI() + "/list");
        } else if (string.equals("/install")) {
            this.install(printWriter, string2, string3);
        } else if (string.equals("/list")) {
            this.list(printWriter);
        } else if (string.equals("/reload")) {
            this.reload(printWriter, string2);
        } else if (string.equals("/remove")) {
            this.remove(printWriter, string2);
        } else if (string.equals("/sessions")) {
            this.sessions(printWriter, string2);
        } else if (string.equals("/start")) {
            this.start(printWriter, string2);
        } else if (string.equals("/stop")) {
            this.stop(printWriter, string2);
        } else {
            printWriter.println(sm.getString("managerServlet.unknownCommand", string));
        }
        printWriter.flush();
        printWriter.close();
    }

    public void list(PrintWriter printWriter) {
        if (this.debug >= 1) {
            this.log("list: Listing contexts for virtual host '" + this.deployer.getName() + "'");
        }
        printWriter.print("<html>\n<head>\n<title>");
        printWriter.print("Listed applications for virtual host ");
        printWriter.print(this.deployer.getName() + "</title>\n</head>\n");
        printWriter.print("<body bgcolor=\"#FFFFFF\">\n");
        printWriter.print("<form method=\"get\" action=\"install\">");
        printWriter.print("<table cellspacing=\"0\"");
        printWriter.print("cellpadding=\"3\" align=\"center\">\n");
        printWriter.print("<tr><td colspan=\"3\"><font size=\"+2\"");
        printWriter.print(" face=\"Arial, Helvetica, sans-serif\">\n");
        printWriter.print("<strong>Listed applications for virtual host ");
        printWriter.print(this.deployer.getName() + "</strong>\n</font></td>\n</tr>\n");
        printWriter.print("<tr bgcolor=\"#CCCCCC\">\n");
        printWriter.print("<td align=\"left\"><font size=\"+1\"");
        printWriter.print(" face=\"Arial, Helvetica, sans-serif\">\n");
        printWriter.print("<strong>Path</strong></font>\n</td>");
        printWriter.print("<td align=\"center\"><font size=\"+1\"");
        printWriter.print(" face=\"Arial, Helvetica, sans-serif\">\n");
        printWriter.print("<strong>Status</strong></font></td>\n");
        printWriter.print("<td align=\"right\"><font size=\"+1\"");
        printWriter.print(" face=\"Arial, Helvetica, sans-serif\">\n");
        printWriter.print("<strong>Sessions</strong></font></td>\n");
        printWriter.print("<td align=\"right\"><font size=\"+1\"");
        printWriter.print(" face=\"Arial, Helvetica, sans-serif\">\n");
        printWriter.print("<strong>Reload</strong></font></td>\n");
        printWriter.print("<td align=\"right\"><font size=\"+1\"");
        printWriter.print(" face=\"Arial, Helvetica, sans-serif\">\n");
        printWriter.print("<strong>Remove</strong></font></td>\n</tr>\n");
        String[] stringArray = this.deployer.findDeployedApps();
        for (int i = 0; i < stringArray.length; ++i) {
            Context context = this.deployer.findDeployedApp(stringArray[i]);
            String string = stringArray[i];
            if (string.equals("")) {
                string = "/";
            }
            if (context == null) continue;
            printWriter.print("<tr bgcolor=\"#FFFFFF\">\n");
            printWriter.print("<td align=\"left\"><font size=\"1\"");
            printWriter.print(" face=\"Arial, Helvetica, sans-serif\">\n");
            printWriter.print(string + "</font>\n</td>");
            printWriter.print("<td align=\"center\"><font size=\"1\"");
            printWriter.print(" face=\"Arial, Helvetica, sans-serif\">\n");
            if (context.getAvailable()) {
                printWriter.print("running / <a href=\"stop?path=" + string);
                printWriter.print("\">stop</a>");
            } else {
                printWriter.print("<a href=\"start?path=" + string);
                printWriter.print("\">start</a> / stopped");
            }
            printWriter.print("</font></td>\n");
            printWriter.print("<td align=\"right\"><font size=\"1\"");
            printWriter.print(" face=\"Arial, Helvetica, sans-serif\">\n");
            printWriter.print("<a href=\"sessions?path=" + string + "\">");
            printWriter.print(context.getManager().findSessions().length);
            printWriter.print("</a></font></td>\n");
            printWriter.print("<td align=\"right\"><font size=\"1\"");
            printWriter.print(" face=\"Arial, Helvetica, sans-serif\">\n");
            if (context.getAvailable()) {
                printWriter.print("<a href=\"reload?path=" + string + "\">");
                printWriter.print("Reload &#187;");
                printWriter.print("</a></font></td>\n");
            } else {
                printWriter.print("-</font></td>");
            }
            printWriter.print("<td align=\"right\"><font size=\"1\"");
            printWriter.print(" face=\"Arial, Helvetica, sans-serif\">\n");
            printWriter.print("<a href=\"remove?path=" + string + "\">");
            printWriter.print("Remove &#187;");
            printWriter.print("</a></font></td>\n</tr>\n");
        }
        printWriter.print("<tr><td colspan=\"5\">&nbsp;</td></tr>");
        printWriter.print("<tr><td>");
        printWriter.print("<font size=\"2\"");
        printWriter.print(" face=\"Arial, Helvetica, sans-serif\">");
        printWriter.print("<b>Install a webapp</b></font></td>\n");
        printWriter.print("<td><font size=\"2\" face=\"Arial, Helvetica, sans-serif\">");
        printWriter.print("Path:&nbsp;</font>");
        printWriter.print("<input type=\"text\" name=\"path\" size=\"25\"></td>");
        printWriter.print("<td><font size=\"2\" face=\"Arial, Helvetica, sans-serif\">");
        printWriter.print("War-URL:&nbsp;</font>");
        printWriter.print("<input type=\"text\" name=\"war\" size=\"25\"></td>");
        printWriter.print("<td colspan=\"2\">");
        printWriter.print("&nbsp;<input type=\"submit\" value=\"install\"></td></tr>\n");
        printWriter.print("<tr><td colspan=\"5\" bgcolor=\"#CCCCCC\"><font size=\"-1\" ");
        printWriter.print(" face=\"Arial, Helvetica, sans-serif\">\n");
        printWriter.print("Sun Java System Application Server</font></td>\n</tr>\n");
        printWriter.print("</table>\n</form>\n</body>\n</html>");
    }

    protected void reload(PrintWriter printWriter, String string) {
        if (this.debug >= 1) {
            this.log("restart: Reloading web application at '" + string + "'");
        }
        if (string == null || !string.startsWith("/") && string.equals("")) {
            printWriter.println(sm.getString("managerServlet.invalidPath", string));
            this.list(printWriter);
            return;
        }
        String string2 = string;
        if (string.equals("/")) {
            string = "";
        }
        try {
            Context context = this.deployer.findDeployedApp(string);
            if (context == null) {
                printWriter.println(sm.getString("managerServlet.noContext", string2));
                this.list(printWriter);
                return;
            }
            context.reload();
            this.list(printWriter);
        }
        catch (Throwable throwable) {
            this.getServletContext().log("ManagerServlet.reload[" + string2 + "]", throwable);
            printWriter.println(sm.getString("managerServlet.exception", throwable.toString()));
        }
    }

    protected void remove(PrintWriter printWriter, String string) {
        if (this.debug >= 1) {
            this.log("remove: Removing web application at '" + string + "'");
        }
        if (string == null || !string.startsWith("/") && string.equals("")) {
            printWriter.println(sm.getString("managerServlet.invalidPath", string));
            this.list(printWriter);
            return;
        }
        String string2 = string;
        if (string.equals("/")) {
            string = "";
        }
        try {
            Context context = this.deployer.findDeployedApp(string);
            if (context == null) {
                printWriter.println(sm.getString("managerServlet.noContext", string2));
                this.list(printWriter);
                return;
            }
            this.deployer.remove(string);
            this.list(printWriter);
        }
        catch (Throwable throwable) {
            this.getServletContext().log("ManagerServlet.remove[" + string2 + "]", throwable);
            printWriter.println(sm.getString("managerServlet.exception", throwable.toString()));
        }
    }

    public void start(PrintWriter printWriter, String string) {
        if (this.debug >= 1) {
            this.log("start: Starting web application at '" + string + "'");
        }
        if (string == null || !string.startsWith("/") && string.equals("")) {
            printWriter.println(sm.getString("managerServlet.invalidPath", string));
            this.list(printWriter);
            return;
        }
        String string2 = string;
        if (string.equals("/")) {
            string = "";
        }
        try {
            Context context = this.deployer.findDeployedApp(string);
            if (context == null) {
                printWriter.println(sm.getString("managerServlet.noContext", string2));
                this.list(printWriter);
                return;
            }
            this.deployer.start(string);
            this.list(printWriter);
        }
        catch (Throwable throwable) {
            this.getServletContext().log("ManagerServlet.start[" + string2 + "]", throwable);
            printWriter.println(sm.getString("managerServlet.exception", throwable.toString()));
        }
    }

    protected void stop(PrintWriter printWriter, String string) {
        if (this.debug >= 1) {
            this.log("stop: Stopping web application at '" + string + "'");
        }
        if (string == null || !string.startsWith("/") && string.equals("")) {
            printWriter.println(sm.getString("managerServlet.invalidPath", string));
            this.list(printWriter);
            return;
        }
        String string2 = string;
        if (string.equals("/")) {
            string = "";
        }
        try {
            Context context = this.deployer.findDeployedApp(string);
            if (context == null) {
                printWriter.println(sm.getString("managerServlet.noContext", string2));
                this.list(printWriter);
                return;
            }
            this.deployer.stop(string);
            this.list(printWriter);
        }
        catch (Throwable throwable) {
            this.getServletContext().log("ManagerServlet.stop[" + string2 + "]", throwable);
            printWriter.println(sm.getString("managerServlet.exception", throwable.toString()));
        }
    }
}

