/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.util.MD5Encoder;
import org.apache.catalina.util.StringManager;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;

public class DefaultServlet
extends HttpServlet {
    protected int debug = 0;
    protected int input = 2048;
    protected boolean listings = true;
    protected boolean readOnly = true;
    protected int output = 2048;
    protected String[] welcomes = new String[0];
    protected static MessageDigest md5Helper;
    protected static final MD5Encoder md5Encoder;
    protected static final SimpleDateFormat[] formats;
    protected static final TimeZone gmtZone;
    protected static final String mimeSeparation = "CATALINA_MIME_BOUNDARY";
    protected static final String RESOURCES_JNDI_NAME = "java:/comp/Resources";
    protected static StringManager sm;
    protected static BitSet safeCharacters;
    protected static final char[] hexadecimal;

    public void destroy() {
    }

    public void init() throws ServletException {
        String string = null;
        try {
            string = this.getServletConfig().getInitParameter("debug");
            this.debug = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            string = this.getServletConfig().getInitParameter("input");
            this.input = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            string = this.getServletConfig().getInitParameter("listings");
            this.listings = new Boolean(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            string = this.getServletConfig().getInitParameter("readonly");
            if (string != null) {
                this.readOnly = new Boolean(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            string = this.getServletConfig().getInitParameter("output");
            this.output = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.input < 256) {
            this.input = 256;
        }
        if (this.output < 256) {
            this.output = 256;
        }
        this.welcomes = (String[])this.getServletContext().getAttribute("org.apache.catalina.WELCOME_FILES");
        if (this.welcomes == null) {
            this.welcomes = new String[0];
        }
        if (this.debug > 0) {
            this.log("DefaultServlet.init:  input buffer size=" + this.input + ", output buffer size=" + this.output);
            for (int i = 0; i < this.welcomes.length; ++i) {
                this.log("DefaultServlet.init:  welcome file=" + this.welcomes[i]);
            }
        }
        try {
            md5Helper = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            throw new IllegalStateException();
        }
    }

    protected DirContext getResources() {
        DirContext dirContext = null;
        try {
            dirContext = (DirContext)this.getServletContext().getAttribute("org.apache.catalina.resources");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (dirContext != null) {
            return dirContext;
        }
        try {
            dirContext = (DirContext)new InitialContext().lookup(RESOURCES_JNDI_NAME);
        }
        catch (NamingException namingException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return dirContext;
    }

    protected void showRequestInfo(HttpServletRequest httpServletRequest) {
        Object object;
        Object object2;
        System.out.println();
        System.out.println("SlideDAV Request Info");
        System.out.println();
        System.out.println("Encoding : " + httpServletRequest.getCharacterEncoding());
        System.out.println("Length : " + httpServletRequest.getContentLength());
        System.out.println("Type : " + httpServletRequest.getContentType());
        System.out.println();
        System.out.println("Parameters");
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = httpServletRequest.getParameterValues((String)object2);
            System.out.print((String)object2 + " : ");
            for (int i = 0; i < ((String[])object).length; ++i) {
                System.out.print(object[i] + ", ");
            }
            System.out.println();
        }
        System.out.println();
        System.out.println("Protocol : " + httpServletRequest.getProtocol());
        System.out.println("Address : " + httpServletRequest.getRemoteAddr());
        System.out.println("Host : " + httpServletRequest.getRemoteHost());
        System.out.println("Scheme : " + httpServletRequest.getScheme());
        System.out.println("Server Name : " + httpServletRequest.getServerName());
        System.out.println("Server Port : " + httpServletRequest.getServerPort());
        System.out.println();
        System.out.println("Attributes");
        object2 = httpServletRequest.getAttributeNames();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            System.out.print((String)object + " : ");
            System.out.println(httpServletRequest.getAttribute((String)object).toString());
        }
        System.out.println();
        System.out.println();
        System.out.println("HTTP Header Info");
        System.out.println();
        System.out.println("Authentication Type : " + httpServletRequest.getAuthType());
        System.out.println("HTTP Method : " + httpServletRequest.getMethod());
        System.out.println("Path Info : " + httpServletRequest.getPathInfo());
        System.out.println("Path translated : " + httpServletRequest.getPathTranslated());
        System.out.println("Query string : " + httpServletRequest.getQueryString());
        System.out.println("Remote user : " + httpServletRequest.getRemoteUser());
        System.out.println("Requested session id : " + httpServletRequest.getRequestedSessionId());
        System.out.println("Request URI : " + httpServletRequest.getRequestURI());
        System.out.println("Context path : " + httpServletRequest.getContextPath());
        System.out.println("Servlet path : " + httpServletRequest.getServletPath());
        System.out.println("User principal : " + httpServletRequest.getUserPrincipal());
        System.out.println();
        System.out.println("Headers : ");
        object = httpServletRequest.getHeaderNames();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            System.out.print(string + " : ");
            System.out.println(httpServletRequest.getHeader(string));
        }
        System.out.println();
        System.out.println();
    }

    protected String getRelativePath(HttpServletRequest httpServletRequest) {
        if (httpServletRequest.getAttribute("javax.servlet.include.request_uri") != null) {
            String string = (String)httpServletRequest.getAttribute("javax.servlet.include.path_info");
            if (string == null) {
                string = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
            }
            if (string == null || string.equals("")) {
                string = "/";
            }
            return string;
        }
        String string = httpServletRequest.getPathInfo();
        if (string == null) {
            string = httpServletRequest.getServletPath();
        }
        if (string == null || string.equals("")) {
            string = "/";
        }
        return this.normalize(string);
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (this.debug > 999) {
            this.showRequestInfo(httpServletRequest);
        }
        this.serveResource(httpServletRequest, httpServletResponse, true);
    }

    protected void doHead(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.serveResource(httpServletRequest, httpServletResponse, false);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        DirContext dirContext;
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        if (string.toUpperCase().startsWith("/WEB-INF") || string.toUpperCase().startsWith("/META-INF")) {
            httpServletResponse.sendError(403);
            return;
        }
        if (httpServletRequest.getHeader("Content-Range") != null) {
            httpServletResponse.sendError(501);
        }
        if ((dirContext = this.getResources()) == null) {
            httpServletResponse.sendError(500);
            return;
        }
        boolean bl = true;
        try {
            dirContext.lookup(string);
        }
        catch (NamingException namingException) {
            bl = false;
        }
        boolean bl2 = true;
        try {
            Resource resource = new Resource((InputStream)httpServletRequest.getInputStream());
            if (bl) {
                dirContext.rebind(string, (Object)resource);
            } else {
                dirContext.bind(string, (Object)resource);
            }
        }
        catch (NamingException namingException) {
            bl2 = false;
        }
        if (bl2) {
            if (bl) {
                httpServletResponse.setStatus(204);
            } else {
                httpServletResponse.setStatus(201);
            }
        } else {
            httpServletResponse.sendError(409);
        }
    }

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        if (string.toUpperCase().startsWith("/WEB-INF") || string.toUpperCase().startsWith("/META-INF")) {
            httpServletResponse.sendError(403);
            return;
        }
        DirContext dirContext = this.getResources();
        if (dirContext == null) {
            httpServletResponse.sendError(500);
            return;
        }
        boolean bl = true;
        try {
            dirContext.lookup(string);
        }
        catch (NamingException namingException) {
            bl = false;
        }
        if (bl) {
            boolean bl2 = true;
            try {
                dirContext.unbind(string);
            }
            catch (NamingException namingException) {
                bl2 = false;
            }
            if (bl2) {
                httpServletResponse.setStatus(204);
            } else {
                httpServletResponse.sendError(405);
            }
        } else {
            httpServletResponse.sendError(404);
        }
    }

    protected boolean checkIfHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ResourceInfo resourceInfo) throws IOException {
        return this.checkIfMatch(httpServletRequest, httpServletResponse, resourceInfo) && this.checkIfModifiedSince(httpServletRequest, httpServletResponse, resourceInfo) && this.checkIfNoneMatch(httpServletRequest, httpServletResponse, resourceInfo) && this.checkIfUnmodifiedSince(httpServletRequest, httpServletResponse, resourceInfo);
    }

    protected String getETagValue(ResourceInfo resourceInfo, boolean bl) {
        return resourceInfo.length + "-" + resourceInfo.date;
    }

    protected String getETag(ResourceInfo resourceInfo, boolean bl) {
        if (bl) {
            return "\"" + this.getETagValue(resourceInfo, bl) + "\"";
        }
        return "W/\"" + this.getETagValue(resourceInfo, bl) + "\"";
    }

    protected String normalize(String string) {
        int n;
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (string2 == null) {
            return null;
        }
        if (string2.equals("/.")) {
            return "/";
        }
        if (string2.indexOf(92) >= 0) {
            string2 = string2.replace('\\', '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        while ((n = string2.indexOf("//")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 1);
        }
        while ((n = string2.indexOf("/./")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 2);
        }
        while ((n = string2.indexOf("/../")) >= 0) {
            if (n == 0) {
                return null;
            }
            int n2 = string2.lastIndexOf(47, n - 1);
            string2 = string2.substring(0, n2) + string2.substring(n + 3);
        }
        return string2;
    }

    protected String rewriteUrl(String string) {
        int n = 10;
        int n2 = 32;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (safeCharacters.get(c)) {
                stringBuffer.append(c);
                continue;
            }
            try {
                outputStreamWriter.write(c);
                outputStreamWriter.flush();
            }
            catch (IOException iOException) {
                byteArrayOutputStream.reset();
                continue;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            for (int j = 0; j < byArray.length; ++j) {
                byte by = byArray[j];
                stringBuffer.append('%');
                int n3 = by & 0xF;
                int n4 = (by & 0xF0) >> 4;
                stringBuffer.append(hexadecimal[n4]);
                stringBuffer.append(hexadecimal[n3]);
            }
            byteArrayOutputStream.reset();
        }
        return stringBuffer.toString();
    }

    protected void displaySize(StringBuffer stringBuffer, int n) {
        int n2 = n / 1024;
        int n3 = n % 1024 / 103;
        if (n2 == 0 && n3 == 0 && n != 0) {
            n3 = 1;
        }
        stringBuffer.append(n2).append(".").append(n3);
        stringBuffer.append(" KB");
    }

    protected void serveResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) throws IOException, ServletException {
        String string = this.getRelativePath(httpServletRequest);
        if (this.debug > 0) {
            if (bl) {
                this.log("DefaultServlet.serveResource:  Serving resource '" + string + "' headers and data");
            } else {
                this.log("DefaultServlet.serveResource:  Serving resource '" + string + "' headers only");
            }
        }
        if (string == null || string.toUpperCase().startsWith("/WEB-INF") || string.toUpperCase().startsWith("/META-INF")) {
            httpServletResponse.sendError(404, string);
            return;
        }
        DirContext dirContext = this.getResources();
        ResourceInfo resourceInfo = new ResourceInfo(string, dirContext);
        if (!resourceInfo.exists) {
            String string2 = (String)httpServletRequest.getAttribute("javax.servlet.include.request_uri");
            if (string2 != null) {
                throw new FileNotFoundException(string);
            }
            httpServletResponse.sendError(404, string);
            return;
        }
        if (!resourceInfo.collection && (string.endsWith("/") || string.endsWith("\\"))) {
            httpServletResponse.sendError(404, string);
            return;
        }
        if (resourceInfo.collection) {
            if (!httpServletRequest.getRequestURI().endsWith("/")) {
                String string3 = httpServletRequest.getRequestURI() + "/";
                string3 = this.appendParameters(httpServletRequest, string3);
                httpServletResponse.sendRedirect(string3);
                return;
            }
            ResourceInfo resourceInfo2 = this.checkWelcomeFiles(string, dirContext);
            if (resourceInfo2 != null) {
                String string4 = resourceInfo2.path;
                String string5 = httpServletRequest.getContextPath();
                if (string5 != null && !string5.equals("/")) {
                    string4 = string5 + string4;
                }
                string4 = this.appendParameters(httpServletRequest, string4);
                httpServletResponse.sendRedirect(string4);
                return;
            }
        } else {
            boolean bl2;
            boolean bl3 = bl2 = httpServletRequest.getAttribute("javax.servlet.include.context_path") != null;
            if (!bl2 && !this.checkIfHeaders(httpServletRequest, httpServletResponse, resourceInfo)) {
                return;
            }
        }
        String string6 = this.getServletContext().getMimeType(resourceInfo.path);
        Vector vector = null;
        if (resourceInfo.collection) {
            if (!this.listings) {
                httpServletResponse.sendError(404, resourceInfo.path);
                return;
            }
            string6 = "text/html;charset=UTF-8";
        } else {
            vector = this.parseRange(httpServletRequest, httpServletResponse, resourceInfo);
            httpServletResponse.setHeader("ETag", this.getETag(resourceInfo, true));
            if (this.debug > 0) {
                this.log("DefaultServlet.serveFile:  lastModified='" + new Timestamp(resourceInfo.date).toString() + "'");
            }
            httpServletResponse.setDateHeader("Last-Modified", resourceInfo.date);
        }
        ServletOutputStream servletOutputStream = null;
        PrintWriter printWriter = null;
        if (bl) {
            try {
                servletOutputStream = httpServletResponse.getOutputStream();
            }
            catch (IllegalStateException illegalStateException) {
                if (string6 != null && string6.startsWith("text")) {
                    printWriter = httpServletResponse.getWriter();
                }
                throw illegalStateException;
            }
        }
        if (resourceInfo.collection || (vector == null || vector.isEmpty()) && httpServletRequest.getHeader("Range") == null) {
            if (string6 != null) {
                if (this.debug > 0) {
                    this.log("DefaultServlet.serveFile:  contentType='" + string6 + "'");
                }
                httpServletResponse.setContentType(string6);
            }
            long l = resourceInfo.length;
            if (!resourceInfo.collection && l >= 0L) {
                if (this.debug > 0) {
                    this.log("DefaultServlet.serveFile:  contentLength=" + l);
                }
                httpServletResponse.setContentLength((int)l);
            }
            if (resourceInfo.collection && bl) {
                resourceInfo.setStream(this.render(httpServletRequest.getContextPath(), resourceInfo));
            }
            if (bl) {
                try {
                    httpServletResponse.setBufferSize(this.output);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                if (servletOutputStream != null) {
                    this.copy(resourceInfo, servletOutputStream);
                } else {
                    this.copy(resourceInfo, printWriter);
                }
            }
        } else {
            if (vector == null || vector.isEmpty()) {
                return;
            }
            httpServletResponse.setStatus(206);
            if (vector.size() == 1) {
                Range range = (Range)vector.elementAt(0);
                httpServletResponse.addHeader("Content-Range", "bytes " + range.start + "-" + range.end + "/" + range.length);
                httpServletResponse.setContentLength((int)(range.end - range.start + 1L));
                if (string6 != null) {
                    if (this.debug > 0) {
                        this.log("DefaultServlet.serveFile:  contentType='" + string6 + "'");
                    }
                    httpServletResponse.setContentType(string6);
                }
                if (bl) {
                    try {
                        httpServletResponse.setBufferSize(this.output);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    if (servletOutputStream != null) {
                        this.copy(resourceInfo, servletOutputStream, range);
                    } else {
                        this.copy(resourceInfo, printWriter, range);
                    }
                }
            } else {
                httpServletResponse.setContentType("multipart/byteranges; boundary=CATALINA_MIME_BOUNDARY");
                if (bl) {
                    try {
                        httpServletResponse.setBufferSize(this.output);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    if (servletOutputStream != null) {
                        this.copy(resourceInfo, servletOutputStream, vector.elements(), string6);
                    } else {
                        this.copy(resourceInfo, printWriter, vector.elements(), string6);
                    }
                }
            }
        }
    }

    protected Vector parseRange(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ResourceInfo resourceInfo) throws IOException {
        long l;
        Cloneable cloneable;
        String string = httpServletRequest.getHeader("If-Range");
        if (string != null) {
            String string2 = this.getETag(resourceInfo, true);
            long l2 = resourceInfo.date;
            cloneable = null;
            for (int i = 0; cloneable == null && i < formats.length; ++i) {
                try {
                    cloneable = formats[i].parse(string);
                    continue;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (cloneable == null ? !string2.equals(string.trim()) : l2 > ((Date)cloneable).getTime() + 1000L) {
                return null;
            }
        }
        if ((l = resourceInfo.length) == 0L) {
            return null;
        }
        String string3 = httpServletRequest.getHeader("Range");
        if (string3 == null) {
            return null;
        }
        if (!string3.startsWith("bytes")) {
            httpServletResponse.addHeader("Content-Range", "bytes */" + l);
            httpServletResponse.sendError(416);
            return null;
        }
        string3 = string3.substring(6);
        cloneable = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            Range range = new Range();
            range.length = l;
            int n = string4.indexOf(45);
            if (n == -1) {
                httpServletResponse.addHeader("Content-Range", "bytes */" + l);
                httpServletResponse.sendError(416);
                return null;
            }
            if (n == 0) {
                try {
                    long l3 = Long.parseLong(string4);
                    range.start = l + l3;
                    range.end = l - 1L;
                }
                catch (NumberFormatException numberFormatException) {
                    httpServletResponse.addHeader("Content-Range", "bytes */" + l);
                    httpServletResponse.sendError(416);
                    return null;
                }
            }
            try {
                range.start = Long.parseLong(string4.substring(0, n));
                range.end = n < string4.length() - 1 ? Long.parseLong(string4.substring(n + 1, string4.length())) : l - 1L;
            }
            catch (NumberFormatException numberFormatException) {
                httpServletResponse.addHeader("Content-Range", "bytes */" + l);
                httpServletResponse.sendError(416);
                return null;
            }
            if (!range.validate()) {
                httpServletResponse.addHeader("Content-Range", "bytes */" + l);
                httpServletResponse.sendError(416);
                return null;
            }
            ((Vector)cloneable).addElement(range);
        }
        return cloneable;
    }

    protected String appendParameters(HttpServletRequest httpServletRequest, String string) {
        StringBuffer stringBuffer = new StringBuffer(this.rewriteUrl(string));
        Enumeration enumeration = httpServletRequest.getParameterNames();
        if (enumeration.hasMoreElements()) {
            stringBuffer.append("?");
        }
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String[] stringArray = httpServletRequest.getParameterValues(string2);
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(this.rewriteUrl(string2));
                stringBuffer.append("=");
                stringBuffer.append(this.rewriteUrl(stringArray[i]));
                if (i >= stringArray.length - 1) continue;
                stringBuffer.append("&");
            }
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append("&");
        }
        return stringBuffer.toString();
    }

    protected InputStream render(String string, ResourceInfo resourceInfo) {
        Object object;
        int n;
        String string2 = resourceInfo.path;
        int n2 = string2.length();
        if (!string2.endsWith("/")) {
            ++n2;
        }
        if (string2.equals("/")) {
            n2 = 1;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8");
        }
        catch (Exception exception) {
            outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        }
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        printWriter.print("<html>\r\n");
        printWriter.print("<head>\r\n");
        printWriter.print("<title>");
        printWriter.print(sm.getString("directory.title", string2));
        printWriter.print("</title>\r\n</head>\r\n");
        printWriter.print("<body bgcolor=\"white\">\r\n");
        printWriter.print("<table width=\"90%\" cellspacing=\"0\" cellpadding=\"5\" align=\"center\">\r\n");
        printWriter.print("<tr><td colspan=\"3\"><font size=\"+2\">\r\n<strong>");
        printWriter.print(sm.getString("directory.title", string2));
        printWriter.print("</strong>\r\n</font></td></tr>\r\n");
        String string3 = string2;
        if (string3.endsWith("/")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        if ((n = string3.lastIndexOf(47)) >= 0) {
            object = string2.substring(0, n);
            printWriter.print("<tr><td colspan=\"3\" bgcolor=\"#ffffff\">\r\n");
            printWriter.print("<a href=\"");
            printWriter.print(this.rewriteUrl(string));
            if (((String)object).equals("")) {
                object = "/";
            }
            printWriter.print(this.rewriteUrl((String)object));
            if (!((String)object).endsWith("/")) {
                printWriter.print("/");
            }
            printWriter.print("\">");
            printWriter.print(sm.getString("directory.parent", object));
            printWriter.print("</a>\r\n");
            printWriter.print("</td></tr>\r\n");
        }
        printWriter.print("<tr bgcolor=\"#cccccc\">\r\n");
        printWriter.print("<td align=\"left\"><font size=\"+1\"><strong>");
        printWriter.print(sm.getString("directory.filename"));
        printWriter.print("</strong></font></td>\r\n");
        printWriter.print("<td align=\"center\"><font size=\"+1\"><strong>");
        printWriter.print(sm.getString("directory.size"));
        printWriter.print("</strong></font></td>\r\n");
        printWriter.print("<td align=\"right\"><font size=\"+1\"><strong>");
        printWriter.print(sm.getString("directory.lastModified"));
        printWriter.print("</strong></font></td>\r\n");
        printWriter.print("</tr>\r\n");
        try {
            object = resourceInfo.directory;
            NamingEnumeration<NameClassPair> namingEnumeration = resourceInfo.resources.list(resourceInfo.path);
            boolean bl = false;
            while (namingEnumeration.hasMoreElements()) {
                NameClassPair nameClassPair = (NameClassPair)namingEnumeration.nextElement();
                String string4 = nameClassPair.getName();
                ResourceInfo resourceInfo2 = new ResourceInfo(string4, (DirContext)object);
                String string5 = string4;
                if (string5.equalsIgnoreCase("WEB-INF") || string5.equalsIgnoreCase("META-INF")) continue;
                printWriter.print("<tr");
                if (bl) {
                    printWriter.print(" bgcolor=\"eeeeee\"");
                }
                printWriter.print(">\r\n");
                bl = !bl;
                printWriter.print("<td align=\"left\">&nbsp;&nbsp;\r\n");
                printWriter.print("<a href=\"");
                printWriter.print(this.rewriteUrl(string));
                string4 = this.rewriteUrl(string2 + string4);
                printWriter.print(string4);
                if (resourceInfo2.collection) {
                    printWriter.print("/");
                }
                printWriter.print("\"><tt>");
                printWriter.print(string5);
                if (resourceInfo2.collection) {
                    printWriter.print("/");
                }
                printWriter.print("</tt></a></td>\r\n");
                printWriter.print("<td align=\"right\"><tt>");
                if (resourceInfo2.collection) {
                    printWriter.print("&nbsp;");
                } else {
                    printWriter.print(this.renderSize(resourceInfo2.length));
                }
                printWriter.print("</tt></td>\r\n");
                printWriter.print("<td align=\"right\"><tt>");
                printWriter.print(this.renderLastModified(resourceInfo2.date));
                printWriter.print("</tt></td>\r\n");
                printWriter.print("</tr>\r\n");
            }
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
        }
        printWriter.print("<tr><td colspan=\"3\">&nbsp;</td></tr>\r\n");
        printWriter.print("<tr><td colspan=\"3\" bgcolor=\"#cccccc\">");
        printWriter.print("<font size=\"-1\">");
        printWriter.print("Sun Java System Application Server");
        printWriter.print("</font></td></tr>\r\n");
        printWriter.print("</table>\r\n");
        printWriter.print("</body>\r\n");
        printWriter.print("</html>\r\n");
        printWriter.flush();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    protected String renderLastModified(long l) {
        return formats[0].format(new Date(l));
    }

    protected String renderSize(long l) {
        long l2 = l / 1024L;
        long l3 = l % 1024L / 103L;
        if (l2 == 0L && l3 == 0L && l > 0L) {
            l3 = 1L;
        }
        return "" + l2 + "." + l3 + " kb";
    }

    private boolean checkIfMatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ResourceInfo resourceInfo) throws IOException {
        String string = this.getETag(resourceInfo, true);
        String string2 = httpServletRequest.getHeader("If-Match");
        if (string2 != null && string2.indexOf(42) == -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            boolean bl = false;
            while (!bl && stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (!string3.trim().equals(string)) continue;
                bl = true;
            }
            if (!bl) {
                httpServletResponse.sendError(412);
                return false;
            }
        }
        return true;
    }

    private boolean checkIfModifiedSince(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ResourceInfo resourceInfo) throws IOException {
        try {
            long l = httpServletRequest.getDateHeader("If-Modified-Since");
            long l2 = resourceInfo.date;
            if (l != -1L && httpServletRequest.getHeader("If-None-Match") == null && l2 <= l + 1000L) {
                httpServletResponse.setStatus(304);
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
        return true;
    }

    private boolean checkIfNoneMatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ResourceInfo resourceInfo) throws IOException {
        String string = this.getETag(resourceInfo, true);
        String string2 = httpServletRequest.getHeader("If-None-Match");
        if (string2 != null) {
            boolean bl = false;
            if (!string2.equals("*")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                while (!bl && stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (!string3.trim().equals(string)) continue;
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl) {
                if ("GET".equals(httpServletRequest.getMethod()) || "HEAD".equals(httpServletRequest.getMethod())) {
                    httpServletResponse.setStatus(304);
                    return false;
                }
                httpServletResponse.sendError(412);
                return false;
            }
        }
        return true;
    }

    private boolean checkIfUnmodifiedSince(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ResourceInfo resourceInfo) throws IOException {
        try {
            long l = resourceInfo.date;
            long l2 = httpServletRequest.getDateHeader("If-Unmodified-Since");
            if (l2 != -1L && l > l2) {
                httpServletResponse.sendError(412);
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
        return true;
    }

    private void copy(ResourceInfo resourceInfo, ServletOutputStream servletOutputStream) throws IOException {
        IOException iOException = null;
        InputStream inputStream = resourceInfo.getStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, this.input);
        iOException = this.copyRange(bufferedInputStream, servletOutputStream);
        try {
            ((InputStream)bufferedInputStream).close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    private void copy(ResourceInfo resourceInfo, PrintWriter printWriter) throws IOException {
        IOException iOException = null;
        InputStream inputStream = resourceInfo.getStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        iOException = this.copyRange(inputStreamReader, printWriter);
        try {
            ((Reader)inputStreamReader).close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    private void copy(ResourceInfo resourceInfo, ServletOutputStream servletOutputStream, Range range) throws IOException {
        IOException iOException = null;
        InputStream inputStream = resourceInfo.getStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, this.input);
        iOException = this.copyRange(bufferedInputStream, servletOutputStream, range.start, range.end);
        try {
            ((InputStream)bufferedInputStream).close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    private void copy(ResourceInfo resourceInfo, PrintWriter printWriter, Range range) throws IOException {
        IOException iOException = null;
        InputStream inputStream = resourceInfo.getStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        iOException = this.copyRange(inputStreamReader, printWriter, range.start, range.end);
        try {
            ((Reader)inputStreamReader).close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    private void copy(ResourceInfo resourceInfo, ServletOutputStream servletOutputStream, Enumeration enumeration, String string) throws IOException {
        IOException iOException = null;
        while (iOException == null && enumeration.hasMoreElements()) {
            InputStream inputStream = resourceInfo.getStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, this.input);
            Range range = (Range)enumeration.nextElement();
            servletOutputStream.println("--CATALINA_MIME_BOUNDARY");
            if (string != null) {
                servletOutputStream.println("Content-Type: " + string);
            }
            servletOutputStream.println("Content-Range: bytes " + range.start + "-" + range.end + "/" + range.length);
            servletOutputStream.println();
            iOException = this.copyRange(bufferedInputStream, servletOutputStream, range.start, range.end);
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (Throwable throwable) {}
        }
        servletOutputStream.print("--CATALINA_MIME_BOUNDARY--");
        if (iOException != null) {
            throw iOException;
        }
    }

    private void copy(ResourceInfo resourceInfo, PrintWriter printWriter, Enumeration enumeration, String string) throws IOException {
        IOException iOException = null;
        while (iOException == null && enumeration.hasMoreElements()) {
            InputStream inputStream = resourceInfo.getStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            Range range = (Range)enumeration.nextElement();
            printWriter.println("--CATALINA_MIME_BOUNDARY");
            if (string != null) {
                printWriter.println("Content-Type: " + string);
            }
            printWriter.println("Content-Range: bytes " + range.start + "-" + range.end + "/" + range.length);
            printWriter.println();
            iOException = this.copyRange(inputStreamReader, printWriter, range.start, range.end);
            try {
                ((Reader)inputStreamReader).close();
            }
            catch (Throwable throwable) {}
        }
        printWriter.print("--CATALINA_MIME_BOUNDARY--");
        if (iOException != null) {
            throw iOException;
        }
    }

    private IOException copyRange(InputStream inputStream, ServletOutputStream servletOutputStream) {
        IOException iOException = null;
        byte[] byArray = new byte[this.input];
        int n = byArray.length;
        try {
            while ((n = inputStream.read(byArray)) != -1) {
                servletOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            n = -1;
        }
        return iOException;
    }

    private IOException copyRange(Reader reader, PrintWriter printWriter) {
        IOException iOException = null;
        char[] cArray = new char[this.input];
        int n = cArray.length;
        try {
            while ((n = reader.read(cArray)) != -1) {
                printWriter.write(cArray, 0, n);
            }
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            n = -1;
        }
        return iOException;
    }

    private IOException copyRange(InputStream inputStream, ServletOutputStream servletOutputStream, long l, long l2) {
        if (this.debug > 10) {
            System.out.println("Serving bytes:" + l + "-" + l2);
        }
        try {
            inputStream.skip(l);
        }
        catch (IOException iOException) {
            return iOException;
        }
        IOException iOException = null;
        long l3 = l2 - l + 1L;
        byte[] byArray = new byte[this.input];
        int n = byArray.length;
        while (l3 > 0L && n >= byArray.length) {
            try {
                n = inputStream.read(byArray);
                if (l3 >= (long)n) {
                    servletOutputStream.write(byArray, 0, n);
                    l3 -= (long)n;
                } else {
                    servletOutputStream.write(byArray, 0, (int)l3);
                    l3 = 0L;
                }
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                n = -1;
            }
            if (n >= byArray.length) continue;
            break;
        }
        return iOException;
    }

    private IOException copyRange(Reader reader, PrintWriter printWriter, long l, long l2) {
        try {
            reader.skip(l);
        }
        catch (IOException iOException) {
            return iOException;
        }
        IOException iOException = null;
        long l3 = l2 - l + 1L;
        char[] cArray = new char[this.input];
        int n = cArray.length;
        while (l3 > 0L && n >= cArray.length) {
            try {
                n = reader.read(cArray);
                if (l3 >= (long)n) {
                    printWriter.write(cArray, 0, n);
                    l3 -= (long)n;
                } else {
                    printWriter.write(cArray, 0, (int)l3);
                    l3 = 0L;
                }
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                n = -1;
            }
            if (n >= cArray.length) continue;
            break;
        }
        return iOException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceInfo checkWelcomeFiles(String string, DirContext dirContext) {
        String string2 = string;
        if (!string.endsWith("/")) {
            string2 = string2 + "/";
        }
        String[] stringArray = this.welcomes;
        synchronized (this.welcomes) {
            this.welcomes = (String[])this.getServletContext().getAttribute("org.apache.catalina.WELCOME_FILES");
            if (this.welcomes == null) {
                this.welcomes = new String[0];
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            for (int i = 0; i < this.welcomes.length; ++i) {
                String string3 = string2 + this.welcomes[i];
                ResourceInfo resourceInfo = new ResourceInfo(string3, dirContext);
                if (!resourceInfo.exists()) continue;
                return resourceInfo;
            }
            return null;
        }
    }

    static {
        int n;
        md5Encoder = new MD5Encoder();
        formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
        gmtZone = TimeZone.getTimeZone("GMT");
        formats[0].setTimeZone(gmtZone);
        formats[1].setTimeZone(gmtZone);
        formats[2].setTimeZone(gmtZone);
        sm = StringManager.getManager("org.apache.catalina.servlets");
        hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        safeCharacters = new BitSet(256);
        for (n = 97; n <= 122; ++n) {
            safeCharacters.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            safeCharacters.set(n);
        }
        for (n = 48; n <= 57; ++n) {
            safeCharacters.set(n);
        }
        safeCharacters.set(45);
        safeCharacters.set(95);
        safeCharacters.set(46);
        safeCharacters.set(42);
        safeCharacters.set(47);
    }

    protected class ResourceInfo {
        public Object object;
        public DirContext directory;
        public Resource file;
        public Attributes attributes;
        public String path;
        public long creationDate;
        public String httpDate;
        public long date;
        public long length;
        public boolean collection;
        public boolean exists;
        public DirContext resources;
        protected InputStream is;

        public ResourceInfo(String string, DirContext dirContext) {
            this.set(string, dirContext);
        }

        public void recycle() {
            this.object = null;
            this.directory = null;
            this.file = null;
            this.attributes = null;
            this.path = null;
            this.creationDate = 0L;
            this.httpDate = null;
            this.date = 0L;
            this.length = -1L;
            this.collection = true;
            this.exists = false;
            this.resources = null;
            this.is = null;
        }

        public void set(String string, DirContext dirContext) {
            this.recycle();
            this.path = string;
            this.resources = dirContext;
            this.exists = true;
            try {
                this.object = dirContext.lookup(string);
                if (this.object instanceof Resource) {
                    this.file = (Resource)this.object;
                    this.collection = false;
                } else if (this.object instanceof DirContext) {
                    this.directory = (DirContext)this.object;
                    this.collection = true;
                } else {
                    this.exists = false;
                }
            }
            catch (NamingException namingException) {
                this.exists = false;
            }
            if (this.exists) {
                try {
                    this.attributes = dirContext.getAttributes(string);
                    if (this.attributes instanceof ResourceAttributes) {
                        ResourceAttributes resourceAttributes = (ResourceAttributes)this.attributes;
                        Date date = resourceAttributes.getCreationDate();
                        if (date != null) {
                            this.creationDate = date.getTime();
                        }
                        if ((date = resourceAttributes.getLastModifiedDate()) != null) {
                            this.date = date.getTime();
                            this.httpDate = formats[0].format(date);
                        } else {
                            this.httpDate = formats[0].format(new Date());
                        }
                        this.length = resourceAttributes.getContentLength();
                    }
                }
                catch (NamingException namingException) {
                    this.exists = false;
                }
            }
        }

        public boolean exists() {
            return this.exists;
        }

        public String toString() {
            return this.path;
        }

        public void setStream(InputStream inputStream) {
            this.is = inputStream;
        }

        public InputStream getStream() throws IOException {
            if (this.is != null) {
                return this.is;
            }
            if (this.file != null) {
                return this.file.streamContent();
            }
            return null;
        }
    }

    private class Range {
        public long start;
        public long end;
        public long length;

        private Range() {
        }

        public boolean validate() {
            if (this.end >= this.length) {
                this.end = this.length - 1L;
            }
            return this.start >= 0L && this.end >= 0L && this.length > 0L && this.start <= this.end;
        }

        public void recycle() {
            this.start = 0L;
            this.end = 0L;
            this.length = 0L;
        }
    }
}

