/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.UnavailableException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class CGIServlet
extends HttpServlet {
    private ServletContext context = null;
    private int debug = 0;
    private int iClientInputTimeout = 100;
    private String cgiPathPrefix = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        String string = this.getServletConfig().getServletName();
        if (string == null) {
            string = "";
        }
        if (string.startsWith("org.apache.catalina.INVOKER.")) {
            throw new UnavailableException("Cannot invoke CGIServlet through the invoker");
        }
        String string2 = null;
        try {
            string2 = this.getServletConfig().getInitParameter("debug");
            this.debug = Integer.parseInt(string2);
            this.cgiPathPrefix = this.getServletConfig().getInitParameter("cgiPathPrefix");
            string2 = this.getServletConfig().getInitParameter("iClientInputTimeout");
            this.iClientInputTimeout = Integer.parseInt(string2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.log("init: loglevel set to " + this.debug);
        this.context = servletConfig.getServletContext();
        if (this.debug >= 1) {
            // empty if block
        }
    }

    protected void printServletEnvironment(ServletOutputStream servletOutputStream, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string;
        String string2;
        Cookie[] cookieArray;
        Object object;
        Object object2;
        servletOutputStream.println("<h1>ServletRequest Properties</h1>");
        servletOutputStream.println("<ul>");
        Enumeration enumeration = httpServletRequest.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            servletOutputStream.println("<li><b>attribute</b> " + (String)object2 + " = " + httpServletRequest.getAttribute((String)object2));
        }
        servletOutputStream.println("<li><b>characterEncoding</b> = " + httpServletRequest.getCharacterEncoding());
        servletOutputStream.println("<li><b>contentLength</b> = " + httpServletRequest.getContentLength());
        servletOutputStream.println("<li><b>contentType</b> = " + httpServletRequest.getContentType());
        object2 = httpServletRequest.getLocales();
        while (object2.hasMoreElements()) {
            object = (Locale)object2.nextElement();
            servletOutputStream.println("<li><b>locale</b> = " + object);
        }
        object = httpServletRequest.getParameterNames();
        while (object.hasMoreElements()) {
            cookieArray = (Cookie[])object.nextElement();
            String[] stringArray = httpServletRequest.getParameterValues((String)cookieArray);
            for (int i = 0; i < stringArray.length; ++i) {
                servletOutputStream.println("<li><b>parameter</b> " + (String)cookieArray + " = " + stringArray[i]);
            }
        }
        servletOutputStream.println("<li><b>protocol</b> = " + httpServletRequest.getProtocol());
        servletOutputStream.println("<li><b>remoteAddr</b> = " + httpServletRequest.getRemoteAddr());
        servletOutputStream.println("<li><b>remoteHost</b> = " + httpServletRequest.getRemoteHost());
        servletOutputStream.println("<li><b>scheme</b> = " + httpServletRequest.getScheme());
        servletOutputStream.println("<li><b>secure</b> = " + httpServletRequest.isSecure());
        servletOutputStream.println("<li><b>serverName</b> = " + httpServletRequest.getServerName());
        servletOutputStream.println("<li><b>serverPort</b> = " + httpServletRequest.getServerPort());
        servletOutputStream.println("</ul>");
        servletOutputStream.println("<hr>");
        servletOutputStream.println("<h1>HttpServletRequest Properties</h1>");
        servletOutputStream.println("<ul>");
        servletOutputStream.println("<li><b>authType</b> = " + httpServletRequest.getAuthType());
        servletOutputStream.println("<li><b>contextPath</b> = " + httpServletRequest.getContextPath());
        cookieArray = httpServletRequest.getCookies();
        if (cookieArray != null) {
            for (int i = 0; i < cookieArray.length; ++i) {
                servletOutputStream.println("<li><b>cookie</b> " + cookieArray[i].getName() + " = " + cookieArray[i].getValue());
            }
        }
        Enumeration enumeration2 = httpServletRequest.getHeaderNames();
        while (enumeration2.hasMoreElements()) {
            String string3 = (String)enumeration2.nextElement();
            servletOutputStream.println("<li><b>header</b> " + string3 + " = " + httpServletRequest.getHeader(string3));
        }
        servletOutputStream.println("<li><b>method</b> = " + httpServletRequest.getMethod());
        servletOutputStream.println("<li><a name=\"pathInfo\"><b>pathInfo</b></a> = " + httpServletRequest.getPathInfo());
        servletOutputStream.println("<li><b>pathTranslated</b> = " + httpServletRequest.getPathTranslated());
        servletOutputStream.println("<li><b>queryString</b> = " + httpServletRequest.getQueryString());
        servletOutputStream.println("<li><b>remoteUser</b> = " + httpServletRequest.getRemoteUser());
        servletOutputStream.println("<li><b>requestedSessionId</b> = " + httpServletRequest.getRequestedSessionId());
        servletOutputStream.println("<li><b>requestedSessionIdFromCookie</b> = " + httpServletRequest.isRequestedSessionIdFromCookie());
        servletOutputStream.println("<li><b>requestedSessionIdFromURL</b> = " + httpServletRequest.isRequestedSessionIdFromURL());
        servletOutputStream.println("<li><b>requestedSessionIdValid</b> = " + httpServletRequest.isRequestedSessionIdValid());
        servletOutputStream.println("<li><b>requestURI</b> = " + httpServletRequest.getRequestURI());
        servletOutputStream.println("<li><b>servletPath</b> = " + httpServletRequest.getServletPath());
        servletOutputStream.println("<li><b>userPrincipal</b> = " + httpServletRequest.getUserPrincipal());
        servletOutputStream.println("</ul>");
        servletOutputStream.println("<hr>");
        servletOutputStream.println("<h1>ServletRequest Attributes</h1>");
        servletOutputStream.println("<ul>");
        enumeration = httpServletRequest.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            servletOutputStream.println("<li><b>" + string4 + "</b> = " + httpServletRequest.getAttribute(string4));
        }
        servletOutputStream.println("</ul>");
        servletOutputStream.println("<hr>");
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            servletOutputStream.println("<h1>HttpSession Properties</h1>");
            servletOutputStream.println("<ul>");
            servletOutputStream.println("<li><b>id</b> = " + httpSession.getId());
            servletOutputStream.println("<li><b>creationTime</b> = " + new Date(httpSession.getCreationTime()));
            servletOutputStream.println("<li><b>lastAccessedTime</b> = " + new Date(httpSession.getLastAccessedTime()));
            servletOutputStream.println("<li><b>maxInactiveInterval</b> = " + httpSession.getMaxInactiveInterval());
            servletOutputStream.println("</ul>");
            servletOutputStream.println("<hr>");
            servletOutputStream.println("<h1>HttpSession Attributes</h1>");
            servletOutputStream.println("<ul>");
            enumeration = httpSession.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                servletOutputStream.println("<li><b>" + string2 + "</b> = " + httpSession.getAttribute(string2));
            }
            servletOutputStream.println("</ul>");
            servletOutputStream.println("<hr>");
        }
        servletOutputStream.println("<h1>ServletConfig Properties</h1>");
        servletOutputStream.println("<ul>");
        servletOutputStream.println("<li><b>servletName</b> = " + this.getServletConfig().getServletName());
        servletOutputStream.println("</ul>");
        servletOutputStream.println("<hr>");
        servletOutputStream.println("<h1>ServletConfig Initialization Parameters</h1>");
        servletOutputStream.println("<ul>");
        object = this.getServletConfig().getInitParameterNames();
        while (object.hasMoreElements()) {
            string2 = (String)object.nextElement();
            string = this.getServletConfig().getInitParameter(string2);
            servletOutputStream.println("<li><b>" + string2 + "</b> = " + string);
        }
        servletOutputStream.println("</ul>");
        servletOutputStream.println("<hr>");
        servletOutputStream.println("<h1>ServletContext Properties</h1>");
        servletOutputStream.println("<ul>");
        servletOutputStream.println("<li><b>majorVersion</b> = " + this.getServletContext().getMajorVersion());
        servletOutputStream.println("<li><b>minorVersion</b> = " + this.getServletContext().getMinorVersion());
        servletOutputStream.println("<li><b>realPath('/')</b> = " + this.getServletContext().getRealPath("/"));
        servletOutputStream.println("<li><b>serverInfo</b> = " + this.getServletContext().getServerInfo());
        servletOutputStream.println("</ul>");
        servletOutputStream.println("<hr>");
        servletOutputStream.println("<h1>ServletContext Initialization Parameters</h1>");
        servletOutputStream.println("<ul>");
        object = this.getServletContext().getInitParameterNames();
        while (object.hasMoreElements()) {
            string2 = (String)object.nextElement();
            string = this.getServletContext().getInitParameter(string2);
            servletOutputStream.println("<li><b>" + string2 + "</b> = " + string);
        }
        servletOutputStream.println("</ul>");
        servletOutputStream.println("<hr>");
        servletOutputStream.println("<h1>ServletContext Attributes</h1>");
        servletOutputStream.println("<ul>");
        enumeration = this.getServletContext().getAttributeNames();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            servletOutputStream.println("<li><b>" + string2 + "</b> = " + this.getServletContext().getAttribute(string2));
        }
        servletOutputStream.println("</ul>");
        servletOutputStream.println("<hr>");
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        if (httpServletRequest.getAttribute("org.apache.catalina.INVOKED") != null) {
            throw new UnavailableException("Cannot invoke CGIServlet through the invoker");
        }
        CGIEnvironment cGIEnvironment = new CGIEnvironment(httpServletRequest, this.getServletContext());
        if (cGIEnvironment.isValid()) {
            object = new CGIRunner(cGIEnvironment.getCommand(), cGIEnvironment.getEnvironment(), cGIEnvironment.getWorkingDirectory(), cGIEnvironment.getParameters());
            if ("POST".equals(httpServletRequest.getMethod())) {
                ((CGIRunner)object).setInput((InputStream)httpServletRequest.getInputStream());
            }
            ((CGIRunner)object).setResponse(httpServletResponse);
            ((CGIRunner)object).run();
        }
        if (httpServletRequest.getParameter("X_TOMCAT_CGI_DEBUG") != null || !cGIEnvironment.isValid()) {
            try {
                object = httpServletResponse.getOutputStream();
                object.println("<HTML><HEAD><TITLE>$Name:  $</TITLE></HEAD>");
                object.println("<BODY>$Header: /m/src/iplanet/ias/server/src/java/org/apache/catalina/servlets/CGIServlet.java,v 1.1.2.1 2002/01/04 10:32:51 kebbs Exp $<p>");
                if (cGIEnvironment.isValid()) {
                    object.println(cGIEnvironment.toString());
                } else {
                    httpServletResponse.setStatus(404);
                    object.println("<H3>");
                    object.println("CGI script not found or not specified.");
                    object.println("</H3>");
                    object.println("<H4>");
                    object.println("Check the <b>HttpServletRequest ");
                    object.println("<a href=\"#pathInfo\">pathInfo</a></b> ");
                    object.println("property to see if it is what you meant ");
                    object.println("it to be.  You must specify an existant ");
                    object.println("and executable file as part of the ");
                    object.println("path-info.");
                    object.println("</H4>");
                    object.println("<H4>");
                    object.println("For a good discussion of how CGI scripts ");
                    object.println("work and what their environment variables ");
                    object.println("mean, please visit the <a ");
                    object.println("href=\"http://cgi-spec.golux.com\">CGI ");
                    object.println("Specification page</a>.");
                    object.println("</H4>");
                }
                this.printServletEnvironment((ServletOutputStream)object, httpServletRequest, httpServletResponse);
                object.println("</BODY></HTML>");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("$Header: /m/src/iplanet/ias/server/src/java/org/apache/catalina/servlets/CGIServlet.java,v 1.1.2.1 2002/01/04 10:32:51 kebbs Exp $");
    }

    protected class CGIRunner {
        private String command = null;
        private Hashtable env = null;
        private File wd = null;
        private Hashtable params = null;
        private InputStream stdin = null;
        private HttpServletResponse response = null;
        private boolean readyToRun = false;

        protected CGIRunner(String string, Hashtable hashtable, File file, Hashtable hashtable2) {
            this.command = string;
            this.env = hashtable;
            this.wd = file;
            this.params = hashtable2;
            this.updateReadyStatus();
        }

        protected void updateReadyStatus() {
            this.readyToRun = this.command != null && this.env != null && this.wd != null && this.params != null && this.response != null;
        }

        protected boolean isReady() {
            return this.readyToRun;
        }

        protected void setResponse(HttpServletResponse httpServletResponse) {
            this.response = httpServletResponse;
            this.updateReadyStatus();
        }

        protected void setInput(InputStream inputStream) {
            this.stdin = inputStream;
            this.updateReadyStatus();
        }

        protected String[] hashToStringArray(Hashtable hashtable) throws NullPointerException {
            Object[] objectArray;
            Vector<String> vector = new Vector<String>();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                objectArray = enumeration.nextElement().toString();
                vector.add((String)objectArray + "=" + hashtable.get(objectArray));
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }

        protected void run() throws IOException {
            String string;
            CharSequence charSequence;
            if (!this.isReady()) {
                throw new IOException(this.getClass().getName() + ": not ready to run.");
            }
            if (CGIServlet.this.debug >= 1) {
                CGIServlet.this.log("runCGI(envp=[" + this.env + "], command=" + this.command + ")");
            }
            if (this.command.indexOf(File.separator + "." + File.separator) >= 0 || this.command.indexOf(File.separator + "..") >= 0 || this.command.indexOf(".." + File.separator) >= 0) {
                throw new IOException(this.getClass().getName() + "Illegal Character in CGI command " + "path ('.' or '..') detected.  Not " + "running CGI [" + this.command + "].");
            }
            Runtime runtime = null;
            BufferedReader bufferedReader = null;
            BufferedReader bufferedReader2 = null;
            BufferedOutputStream bufferedOutputStream = null;
            Process process = null;
            byte[] byArray = new byte[1024];
            char[] cArray = new char[1024];
            int n = -1;
            Enumeration enumeration = this.params.keys();
            StringBuffer stringBuffer = new StringBuffer(this.command);
            if (enumeration != null && enumeration.hasMoreElements()) {
                stringBuffer.append(" ");
                while (enumeration.hasMoreElements()) {
                    charSequence = (String)enumeration.nextElement();
                    string = this.params.get(charSequence).toString();
                    if (((String)charSequence).indexOf("=") >= 0 || string.indexOf("=") >= 0) continue;
                    stringBuffer.append((String)charSequence);
                    stringBuffer.append("=");
                    string = URLEncoder.encode(string);
                    stringBuffer.append(string);
                    stringBuffer.append(" ");
                }
            }
            charSequence = new StringBuffer("perl ");
            if (this.command.endsWith(".pl") || this.command.endsWith(".cgi")) {
                ((StringBuffer)charSequence).append(stringBuffer.toString());
                stringBuffer = charSequence;
            }
            runtime = Runtime.getRuntime();
            process = runtime.exec(stringBuffer.toString(), this.hashToStringArray(this.env), this.wd);
            string = (String)this.env.get("CONTENT_LENGTH");
            if (!"".equals(string)) {
                bufferedOutputStream = new BufferedOutputStream(process.getOutputStream());
                byte[] byArray2 = new byte[Integer.parseInt(string)];
                this.stdin.read(byArray2);
                bufferedOutputStream.write(byArray2);
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
            boolean bl = true;
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            BufferedWriter bufferedWriter = null;
            try {
                if (this.response.getOutputStream() != null) {
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)this.response.getOutputStream()));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            while (bl) {
                try {
                    cArray = new char[1024];
                    while ((n = bufferedReader2.read(cArray)) != -1) {
                        if (bufferedWriter == null) continue;
                        bufferedWriter.write(cArray, 0, n);
                    }
                    String string2 = null;
                    while ((string2 = bufferedReader.readLine()) != null && !"".equals(string2)) {
                        if (CGIServlet.this.debug >= 2) {
                            CGIServlet.this.log("runCGI: addHeader(\"" + string2 + "\")");
                        }
                        if (string2.startsWith("HTTP")) continue;
                        this.response.addHeader(string2.substring(0, string2.indexOf(":")).trim(), string2.substring(string2.indexOf(":") + 1).trim());
                    }
                    cArray = new char[1024];
                    while ((n = bufferedReader.read(cArray)) != -1) {
                        if (bufferedWriter == null) continue;
                        if (CGIServlet.this.debug >= 4) {
                            CGIServlet.this.log("runCGI: write(\"" + cArray + "\")");
                        }
                        bufferedWriter.write(cArray, 0, n);
                    }
                    if (bufferedWriter != null) {
                        bufferedWriter.flush();
                    }
                    process.exitValue();
                    bl = false;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        protected String getPostInput(Hashtable hashtable) {
            String string = System.getProperty("line.separator");
            Enumeration enumeration = hashtable.keys();
            StringBuffer stringBuffer = new StringBuffer("");
            StringBuffer stringBuffer2 = new StringBuffer("");
            if (enumeration != null && enumeration.hasMoreElements()) {
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    String string3 = hashtable.get(string2).toString();
                    if (string2.indexOf("=") >= 0 || string3.indexOf("=") >= 0) continue;
                    stringBuffer.append(string2);
                    stringBuffer2.append(string2);
                    stringBuffer.append("=");
                    stringBuffer2.append("=");
                    stringBuffer.append(string3);
                    stringBuffer2.append(string3);
                    stringBuffer.append(string);
                    stringBuffer2.append("&");
                }
            }
            stringBuffer2.append(string);
            return stringBuffer2.append(stringBuffer).toString();
        }
    }

    protected class CGIEnvironment {
        private ServletContext context = null;
        private String contextPath = null;
        private String servletPath = null;
        private String pathInfo = null;
        private String webAppRootDir = null;
        private Hashtable env = null;
        private String command = null;
        private File workingDirectory = null;
        private Hashtable queryParameters = null;
        private boolean valid = false;

        protected CGIEnvironment(HttpServletRequest httpServletRequest, ServletContext servletContext) {
            this.setupFromContext(servletContext);
            this.setupFromRequest(httpServletRequest);
            this.queryParameters = new Hashtable();
            Enumeration enumeration = httpServletRequest.getParameterNames();
            while (enumeration != null && enumeration.hasMoreElements()) {
                String string = enumeration.nextElement().toString();
                if (string == null) continue;
                this.queryParameters.put(string, URLEncoder.encode(httpServletRequest.getParameter(string)));
            }
            this.valid = this.setCGIEnvironment(httpServletRequest);
            if (this.valid) {
                this.workingDirectory = new File(this.command.substring(0, this.command.lastIndexOf(File.separator)));
            }
        }

        protected void setupFromContext(ServletContext servletContext) {
            this.context = servletContext;
            this.webAppRootDir = servletContext.getRealPath("/");
        }

        protected void setupFromRequest(HttpServletRequest httpServletRequest) {
            this.contextPath = httpServletRequest.getContextPath();
            this.pathInfo = httpServletRequest.getPathInfo();
            this.servletPath = httpServletRequest.getServletPath();
        }

        protected String[] findCGI(String string, String string2, String string3, String string4, String string5) {
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            if (string2 != null && string2.lastIndexOf(File.separator) == string2.length() - 1) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string5 != null) {
                string2 = string2 + File.separator + string5;
            }
            if (CGIServlet.this.debug >= 2) {
                CGIServlet.this.log("findCGI: path=" + string + ", " + string2);
            }
            File file = new File(string2);
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
            if (CGIServlet.this.debug >= 3) {
                CGIServlet.this.log("findCGI: currentLoc=" + file);
            }
            while (!file.isFile() && stringTokenizer.hasMoreElements()) {
                if (CGIServlet.this.debug >= 3) {
                    CGIServlet.this.log("findCGI: currentLoc=" + file);
                }
                file = new File(file, (String)stringTokenizer.nextElement());
            }
            if (!file.isFile()) {
                return new String[]{null, null, null, null};
            }
            if (CGIServlet.this.debug >= 2) {
                CGIServlet.this.log("findCGI: FOUND cgi at " + file);
            }
            string6 = file.getAbsolutePath();
            string7 = file.getName();
            string9 = file.getParent().substring(string2.length()) + File.separator + string7;
            string8 = ".".equals(string3) ? string4 + string9 : string3 + string4 + string9;
            if (CGIServlet.this.debug >= 1) {
                CGIServlet.this.log("findCGI calc: name=" + string7 + ", path=" + string6 + ", scriptname=" + string8 + ", cginame=" + string9);
            }
            return new String[]{string6, string8, string9, string7};
        }

        protected boolean setCGIEnvironment(HttpServletRequest httpServletRequest) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            string = this.pathInfo;
            string = string == null ? "" : string;
            string2 = httpServletRequest.getPathTranslated();
            string2 = string2 == null ? "" : string2;
            String[] stringArray = this.findCGI(string, this.webAppRootDir, this.contextPath, this.servletPath, CGIServlet.this.cgiPathPrefix);
            string5 = stringArray[0];
            string6 = stringArray[1];
            string7 = stringArray[2];
            string8 = stringArray[3];
            if (string5 == null || string6 == null || string7 == null || string8 == null) {
                return false;
            }
            hashtable.put("SERVER_SOFTWARE", "TOMCAT");
            hashtable.put("SERVER_NAME", this.nullsToBlanks(httpServletRequest.getServerName()));
            hashtable.put("GATEWAY_INTERFACE", "CGI/1.1");
            hashtable.put("SERVER_PROTOCOL", this.nullsToBlanks(httpServletRequest.getProtocol()));
            int n = httpServletRequest.getServerPort();
            Integer n2 = n == 0 ? new Integer(-1) : new Integer(n);
            hashtable.put("SERVER_PORT", n2.toString());
            hashtable.put("REQUEST_METHOD", this.nullsToBlanks(httpServletRequest.getMethod()));
            string3 = this.pathInfo == null || this.pathInfo.substring(string7.length()).length() <= 0 ? "" : this.pathInfo.substring(string7.length());
            hashtable.put("PATH_INFO", string3);
            string4 = string3 != null && !"".equals(string3) ? this.context.getRealPath(string3) : null;
            if (string4 != null && !"".equals(string4)) {
                hashtable.put("PATH_TRANSLATED", this.nullsToBlanks(string4));
            }
            hashtable.put("SCRIPT_NAME", this.nullsToBlanks(string6));
            hashtable.put("QUERY_STRING", this.nullsToBlanks(httpServletRequest.getQueryString()));
            hashtable.put("REMOTE_HOST", this.nullsToBlanks(httpServletRequest.getRemoteHost()));
            hashtable.put("REMOTE_ADDR", this.nullsToBlanks(httpServletRequest.getRemoteAddr()));
            hashtable.put("AUTH_TYPE", this.nullsToBlanks(httpServletRequest.getAuthType()));
            hashtable.put("REMOTE_USER", this.nullsToBlanks(httpServletRequest.getRemoteUser()));
            hashtable.put("REMOTE_IDENT", "");
            hashtable.put("CONTENT_TYPE", this.nullsToBlanks(httpServletRequest.getContentType()));
            int n3 = httpServletRequest.getContentLength();
            String string9 = n3 <= 0 ? "" : new Integer(n3).toString();
            hashtable.put("CONTENT_LENGTH", string9);
            Enumeration enumeration = httpServletRequest.getHeaderNames();
            String string10 = null;
            while (enumeration.hasMoreElements()) {
                string10 = null;
                string10 = ((String)enumeration.nextElement()).toUpperCase();
                if ("AUTHORIZATION".equalsIgnoreCase(string10) || "PROXY_AUTHORIZATION".equalsIgnoreCase(string10)) continue;
                if ("HOST".equalsIgnoreCase(string10)) {
                    String string11 = httpServletRequest.getHeader(string10);
                    int n4 = string11.indexOf(":");
                    if (n4 < 0) {
                        n4 = string11.length();
                    }
                    hashtable.put("HTTP_" + string10.replace('-', '_'), string11.substring(0, n4));
                    continue;
                }
                hashtable.put("HTTP_" + string10.replace('-', '_'), httpServletRequest.getHeader(string10));
            }
            this.command = string5;
            hashtable.put("X_TOMCAT_SCRIPT_PATH", this.command);
            this.env = hashtable;
            return true;
        }

        public String toString() {
            String string;
            Enumeration enumeration;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<TABLE border=2>");
            stringBuffer.append("<tr><th colspan=2 bgcolor=grey>");
            stringBuffer.append("CGIEnvironment Info</th></tr>");
            stringBuffer.append("<tr><td>Debug Level</td><td>");
            stringBuffer.append(CGIServlet.this.debug);
            stringBuffer.append("</td></tr>");
            stringBuffer.append("<tr><td>Validity:</td><td>");
            stringBuffer.append(this.isValid());
            stringBuffer.append("</td></tr>");
            if (this.isValid()) {
                enumeration = this.env.keys();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    stringBuffer.append("<tr><td>");
                    stringBuffer.append(string);
                    stringBuffer.append("</td><td>");
                    stringBuffer.append(this.blanksToString((String)this.env.get(string), "[will be set to blank]"));
                    stringBuffer.append("</td></tr>");
                }
            }
            stringBuffer.append("<tr><td colspan=2><HR></td></tr>");
            stringBuffer.append("<tr><td>Derived Command</td><td>");
            stringBuffer.append(this.nullsToBlanks(this.command));
            stringBuffer.append("</td></tr>");
            stringBuffer.append("<tr><td>Working Directory</td><td>");
            if (this.workingDirectory != null) {
                stringBuffer.append(this.workingDirectory.toString());
            }
            stringBuffer.append("</td></tr>");
            stringBuffer.append("<tr><td colspan=2>Query Params</td></tr>");
            enumeration = this.queryParameters.keys();
            while (enumeration.hasMoreElements()) {
                string = enumeration.nextElement().toString();
                stringBuffer.append("<tr><td>");
                stringBuffer.append(string);
                stringBuffer.append("</td><td>");
                stringBuffer.append(this.queryParameters.get(string).toString());
                stringBuffer.append("</td></tr>");
            }
            stringBuffer.append("</TABLE><p>end.");
            return stringBuffer.toString();
        }

        protected String getCommand() {
            return this.command;
        }

        protected File getWorkingDirectory() {
            return this.workingDirectory;
        }

        protected Hashtable getEnvironment() {
            return this.env;
        }

        protected Hashtable getParameters() {
            return this.queryParameters;
        }

        protected boolean isValid() {
            return this.valid;
        }

        protected String nullsToBlanks(String string) {
            return this.nullsToString(string, "");
        }

        protected String nullsToString(String string, String string2) {
            return string == null ? string2 : string;
        }

        protected String blanksToString(String string, String string2) {
            return "".equals(string) || string == null ? string2 : string;
        }
    }
}

