/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import org.apache.catalina.Realm;

public class GenericPrincipal
implements Principal {
    protected String name = null;
    protected String password = null;
    protected Realm realm = null;
    protected String[] roles = new String[0];

    public GenericPrincipal(Realm realm, String string, String string2) {
        this(realm, string, string2, null);
    }

    public GenericPrincipal(Realm realm, String string, String string2, List list) {
        this.realm = realm;
        this.name = string;
        this.password = string2;
        if (list != null) {
            this.roles = new String[list.size()];
            this.roles = list.toArray(this.roles);
            if (this.roles.length > 0) {
                Arrays.sort(this.roles);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public boolean hasRole(String string) {
        if (string == null) {
            return false;
        }
        return Arrays.binarySearch(this.roles, string) >= 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("GenericPrincipal[");
        stringBuffer.append(this.name);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

