/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.net;

import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.net.ssl.SSLServerSocket;
import org.apache.catalina.net.ServerSocketFactory;

public class SSLServerSocketFactory
implements ServerSocketFactory {
    private static final String PROTOCOL_HANDLER = "com.sun.net.ssl.internal.www.protocol";
    private static final String PROTOCOL_PACKAGES = "java.protocol.handler.pkgs";
    private javax.net.ssl.SSLServerSocketFactory sslProxy = null;
    private String algorithm = "SunX509";
    private boolean clientAuth = false;
    private KeyStore keyStore = null;
    private String keystoreFile = System.getProperty("user.home") + File.separator + ".keystore";
    private String keystorePass = "changeit";
    private String keystoreType = "JKS";
    private String protocol = "TLS";

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String string) {
        this.algorithm = string;
    }

    public boolean getClientAuth() {
        return this.clientAuth;
    }

    public void setClientAuth(boolean bl) {
        this.clientAuth = bl;
    }

    public KeyStore getKeyStore() throws IOException {
        if (this.sslProxy == null) {
            this.initialize();
        }
        return this.keyStore;
    }

    public String getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(String string) {
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), string);
        }
        this.keystoreFile = file.getAbsolutePath();
    }

    public String getKeystorePass() {
        return this.keystorePass;
    }

    public void setKeystorePass(String string) {
        this.keystorePass = string;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String string) {
        this.keystoreType = string;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public ServerSocket createSocket(int n) throws IOException {
        if (this.sslProxy == null) {
            this.initialize();
        }
        ServerSocket serverSocket = this.sslProxy.createServerSocket(n);
        this.initServerSocket(serverSocket);
        return serverSocket;
    }

    public ServerSocket createSocket(int n, int n2) throws IOException {
        if (this.sslProxy == null) {
            this.initialize();
        }
        ServerSocket serverSocket = this.sslProxy.createServerSocket(n, n2);
        this.initServerSocket(serverSocket);
        return serverSocket;
    }

    public ServerSocket createSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        if (this.sslProxy == null) {
            this.initialize();
        }
        ServerSocket serverSocket = this.sslProxy.createServerSocket(n, n2, inetAddress);
        this.initServerSocket(serverSocket);
        return serverSocket;
    }

    private synchronized void initialize() throws IOException {
        this.initHandler();
        this.initKeyStore();
        this.initProxy();
    }

    private void initHandler() {
        String string = System.getProperty(PROTOCOL_PACKAGES);
        if (string == null) {
            string = PROTOCOL_HANDLER;
        } else if (string.indexOf(PROTOCOL_HANDLER) < 0) {
            string = string + "|com.sun.net.ssl.internal.www.protocol";
        }
        System.setProperty(PROTOCOL_PACKAGES, string);
    }

    private void initKeyStore() throws IOException {
        FileInputStream fileInputStream = null;
        try {
            this.keyStore = KeyStore.getInstance(this.keystoreType);
            fileInputStream = new FileInputStream(this.keystoreFile);
            this.keyStore.load(fileInputStream, this.keystorePass.toCharArray());
        }
        catch (Exception exception) {
            System.out.println("initKeyStore:  " + exception);
            exception.printStackTrace(System.out);
            throw new IOException(exception.toString());
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    private void initProxy() throws IOException {
        try {
            try {
                Security.addProvider((Provider)Class.forName("com.sun.net.ssl.internal.ssl.Provider").newInstance());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            SSLContext sSLContext = SSLContext.getInstance((String)this.protocol);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance((String)this.algorithm);
            keyManagerFactory.init(this.keyStore, this.keystorePass.toCharArray());
            sSLContext.init(keyManagerFactory.getKeyManagers(), null, new SecureRandom());
            this.sslProxy = sSLContext.getServerSocketFactory();
        }
        catch (Exception exception) {
            System.out.println("initProxy:  " + exception);
            exception.printStackTrace(System.out);
            throw new IOException(exception.toString());
        }
    }

    private void initServerSocket(ServerSocket serverSocket) {
        SSLServerSocket sSLServerSocket = (SSLServerSocket)serverSocket;
        String[] stringArray = sSLServerSocket.getSupportedCipherSuites();
        sSLServerSocket.setEnabledCipherSuites(stringArray);
        sSLServerSocket.setNeedClientAuth(this.clientAuth);
    }
}

