/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlException;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.apache.catalina.loader.Extension;
import org.apache.catalina.loader.Reloader;
import org.apache.naming.JndiPermission;

public class StandardClassLoader
extends URLClassLoader
implements Reloader {
    protected ArrayList available = new ArrayList();
    protected HashMap classCache = new HashMap();
    protected int debug = 0;
    protected boolean delegate = false;
    protected String[] repositories = new String[0];
    protected ArrayList required = new ArrayList();
    private ArrayList permissionList = new ArrayList();
    private HashMap loaderPC = new HashMap();
    private SecurityManager securityManager = null;
    private boolean policy_refresh = false;
    private ClassLoader parent = null;
    private ClassLoader system = null;
    protected URLStreamHandlerFactory factory = null;

    public StandardClassLoader() {
        super(new URL[0]);
        this.parent = this.getParent();
        this.system = StandardClassLoader.getSystemClassLoader();
        this.securityManager = System.getSecurityManager();
    }

    public StandardClassLoader(URLStreamHandlerFactory uRLStreamHandlerFactory) {
        super(new URL[0], null, uRLStreamHandlerFactory);
        this.factory = uRLStreamHandlerFactory;
    }

    public StandardClassLoader(ClassLoader classLoader) {
        super(new URL[0], classLoader);
        this.parent = classLoader;
        this.system = StandardClassLoader.getSystemClassLoader();
        this.securityManager = System.getSecurityManager();
    }

    public StandardClassLoader(ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        super(new URL[0], classLoader, uRLStreamHandlerFactory);
        this.factory = uRLStreamHandlerFactory;
    }

    public StandardClassLoader(String[] stringArray) {
        super(StandardClassLoader.convert(stringArray));
        this.parent = this.getParent();
        this.system = StandardClassLoader.getSystemClassLoader();
        this.securityManager = System.getSecurityManager();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.addRepositoryInternal(stringArray[i]);
            }
        }
    }

    public StandardClassLoader(String[] stringArray, ClassLoader classLoader) {
        super(StandardClassLoader.convert(stringArray), classLoader);
        this.parent = classLoader;
        this.system = StandardClassLoader.getSystemClassLoader();
        this.securityManager = System.getSecurityManager();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.addRepositoryInternal(stringArray[i]);
            }
        }
    }

    public StandardClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        super(uRLArray, classLoader);
        this.parent = classLoader;
        this.system = StandardClassLoader.getSystemClassLoader();
        this.securityManager = System.getSecurityManager();
        if (uRLArray != null) {
            for (int i = 0; i < uRLArray.length; ++i) {
                this.addRepositoryInternal(uRLArray[i].toString());
            }
        }
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int n) {
        this.debug = n;
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean bl) {
        this.delegate = bl;
    }

    public void setPermissions(String string) {
        if (this.securityManager != null) {
            if (string.startsWith("jndi:") || string.startsWith("jar:jndi:")) {
                this.permissionList.add(new JndiPermission(string + "*"));
            } else {
                this.permissionList.add(new FilePermission(string + "-", "read"));
            }
        }
    }

    public void setPermissions(URL uRL) {
        this.setPermissions(uRL.toString());
    }

    public void addRepository(String string) {
        if (this.debug >= 1) {
            this.log("addRepository(" + string + ")");
        }
        try {
            URLStreamHandler uRLStreamHandler = null;
            String string2 = StandardClassLoader.parseProtocol(string);
            if (this.factory != null) {
                uRLStreamHandler = this.factory.createURLStreamHandler(string2);
            }
            URL uRL = new URL(null, string, uRLStreamHandler);
            super.addURL(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException.toString());
        }
        this.addRepositoryInternal(string);
    }

    public Extension[] findAvailable() {
        Extension[] extensionArray;
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.available.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        ClassLoader classLoader = this;
        while ((classLoader = classLoader.getParent()) != null) {
            if (!(classLoader instanceof StandardClassLoader)) continue;
            extensionArray = ((StandardClassLoader)classLoader).findAvailable();
            for (int i = 0; i < extensionArray.length; ++i) {
                arrayList.add(extensionArray[i]);
            }
        }
        extensionArray = new Extension[arrayList.size()];
        return arrayList.toArray(extensionArray);
    }

    public String[] findRepositories() {
        return this.repositories;
    }

    public Extension[] findRequired() {
        Extension[] extensionArray;
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.required.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        ClassLoader classLoader = this;
        while ((classLoader = classLoader.getParent()) != null) {
            if (!(classLoader instanceof StandardClassLoader)) continue;
            extensionArray = ((StandardClassLoader)classLoader).findRequired();
            for (int i = 0; i < extensionArray.length; ++i) {
                arrayList.add(extensionArray[i]);
            }
        }
        extensionArray = new Extension[arrayList.size()];
        return arrayList.toArray(extensionArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modified() {
        if (this.debug >= 2) {
            this.log("modified()");
        }
        if (this.classCache.size() < 1) {
            return false;
        }
        ClassCacheEntry[] classCacheEntryArray = new ClassCacheEntry[]{};
        HashMap hashMap = this.classCache;
        synchronized (hashMap) {
            classCacheEntryArray = this.classCache.values().toArray(classCacheEntryArray);
        }
        for (int i = 0; i < classCacheEntryArray.length; ++i) {
            Serializable serializable;
            if (classCacheEntryArray[i].origin instanceof File) {
                serializable = (File)classCacheEntryArray[i].origin;
                if (classCacheEntryArray[i].lastModified == ((File)serializable).lastModified()) continue;
                if (this.debug >= 2) {
                    this.log("  Class '" + classCacheEntryArray[i].loadedClass.getName() + "' was modified");
                }
                return true;
            }
            if (!(classCacheEntryArray[i].origin instanceof URL)) continue;
            serializable = (URL)classCacheEntryArray[i].origin;
            try {
                URLConnection uRLConnection = ((URL)serializable).openConnection();
                if (classCacheEntryArray[i].lastModified == uRLConnection.getLastModified()) continue;
                if (this.debug >= 2) {
                    this.log("  Class '" + classCacheEntryArray[i].loadedClass.getName() + "' was modified");
                }
                return true;
            }
            catch (IOException iOException) {
                this.log("    Failed tracking modifications of '" + serializable + "'");
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("StandardClassLoader\r\n");
        stringBuffer.append("  available:\r\n");
        Iterator iterator = this.available.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("    ");
            stringBuffer.append(iterator.next().toString());
            stringBuffer.append("\r\n");
        }
        stringBuffer.append("  delegate: ");
        stringBuffer.append(this.delegate);
        stringBuffer.append("\r\n");
        stringBuffer.append("  repositories:\r\n");
        for (int i = 0; i < this.repositories.length; ++i) {
            stringBuffer.append("    ");
            stringBuffer.append(this.repositories[i]);
            stringBuffer.append("\r\n");
        }
        stringBuffer.append("  required:\r\n");
        Iterator iterator2 = this.required.iterator();
        while (iterator2.hasNext()) {
            stringBuffer.append("    ");
            stringBuffer.append(iterator2.next().toString());
            stringBuffer.append("\r\n");
        }
        if (this.getParent() != null) {
            stringBuffer.append("----------> Parent Classloader:\r\n");
            stringBuffer.append(this.getParent().toString());
            stringBuffer.append("\r\n");
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class findClass(String string) throws ClassNotFoundException {
        int n;
        if (this.debug >= 3) {
            this.log("    findClass(" + string + ")");
        }
        if (this.securityManager != null && (n = string.lastIndexOf(46)) >= 0) {
            try {
                if (this.debug >= 4) {
                    this.log("      securityManager.checkPackageDefinition");
                }
                this.securityManager.checkPackageDefinition(string.substring(0, n));
            }
            catch (Exception exception) {
                if (this.debug >= 4) {
                    this.log("      -->Exception-->ClassNotFoundException", exception);
                }
                throw new ClassNotFoundException(string);
            }
        }
        Class<?> clazz = null;
        try {
            if (this.debug >= 4) {
                this.log("      super.findClass(" + string + ")");
            }
            try {
                StandardClassLoader standardClassLoader = this;
                synchronized (standardClassLoader) {
                    clazz = this.findLoadedClass(string);
                    if (clazz != null) {
                        return clazz;
                    }
                    clazz = super.findClass(string);
                }
            }
            catch (AccessControlException accessControlException) {
                throw new ClassNotFoundException(string);
            }
            catch (RuntimeException runtimeException) {
                if (this.debug >= 4) {
                    this.log("      -->RuntimeException Rethrown", runtimeException);
                }
                throw runtimeException;
            }
            if (clazz == null) {
                if (this.debug >= 3) {
                    this.log("    --> Returning ClassNotFoundException");
                }
                throw new ClassNotFoundException(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.debug >= 3) {
                this.log("    --> Passing on ClassNotFoundException", classNotFoundException);
            }
            throw classNotFoundException;
        }
        for (int i = 0; i < this.repositories.length; ++i) {
            Object object;
            Object object2;
            if (!this.repositories[i].endsWith("/")) continue;
            String string2 = this.repositories[i].substring(0, this.repositories[i].length() - 1);
            if (this.debug >= 4) {
                this.log("      Checking repository " + string2);
            }
            if (string2.startsWith("file://") || string2.startsWith("file:")) {
                if (string2.startsWith("file://")) {
                    string2 = string2.substring(7);
                } else if (string2.startsWith("file:")) {
                    string2 = string2.substring(5);
                }
                string2 = string2 + File.separatorChar + string.replace('.', File.separatorChar) + ".class";
                try {
                    object2 = new File(string2);
                    if (!((File)object2).exists() || !((File)object2).canRead()) continue;
                    if (this.debug >= 3) {
                        this.log("    Caching from '" + ((File)object2).getAbsolutePath() + "' modified '" + new Timestamp(((File)object2).lastModified()) + "'");
                    }
                    object = this.classCache;
                    synchronized (object) {
                        this.classCache.put(string, new ClassCacheEntry(clazz, object2, ((File)object2).lastModified()));
                    }
                }
                catch (AccessControlException accessControlException) {}
                continue;
            }
            string2 = string2 + "/" + string.replace('.', '/') + ".class";
            try {
                object2 = null;
                object = StandardClassLoader.parseProtocol(string2);
                if (this.factory != null) {
                    object2 = this.factory.createURLStreamHandler((String)object);
                }
                URL uRL = new URL(null, string2, (URLStreamHandler)object2);
                try {
                    URLConnection uRLConnection = uRL.openConnection();
                    InputStream inputStream = uRLConnection.getInputStream();
                    inputStream.close();
                    if (this.debug >= 4) {
                        this.log("    Caching from '" + uRL.toString() + "' modified '" + new Timestamp(uRLConnection.getLastModified()) + "'");
                    }
                    HashMap hashMap = this.classCache;
                    synchronized (hashMap) {
                        this.classCache.put(string, new ClassCacheEntry(clazz, uRL, uRLConnection.getLastModified()));
                    }
                }
                catch (IOException iOException) {}
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                continue;
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        if (this.debug >= 4) {
            this.log("      Returning class " + clazz);
        }
        if (this.debug >= 4 && clazz != null) {
            this.log("      Loaded by " + clazz.getClassLoader());
        }
        return clazz;
    }

    public URL findResource(String string) {
        if (this.debug >= 3) {
            this.log("    findResource(" + string + ")");
        }
        URL uRL = super.findResource(string);
        if (this.debug >= 3) {
            if (uRL != null) {
                this.log("    --> Returning '" + uRL.toString() + "'");
            } else {
                this.log("    --> Resource not found, returning null");
            }
        }
        return uRL;
    }

    public Enumeration findResources(String string) throws IOException {
        if (this.debug >= 3) {
            this.log("    findResources(" + string + ")");
        }
        return super.findResources(string);
    }

    public URL getResource(String string) {
        ClassLoader classLoader;
        if (this.debug >= 2) {
            this.log("getResource(" + string + ")");
        }
        URL uRL = null;
        if (this.delegate) {
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((classLoader = this.parent) == null) {
                classLoader = this.system;
            }
            if ((uRL = classLoader.getResource(string)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning '" + uRL.toString() + "'");
                }
                return uRL;
            }
        }
        if (this.debug >= 3) {
            this.log("  Searching local repositories");
        }
        if ((uRL = this.findResource(string)) != null) {
            if (this.debug >= 2) {
                this.log("  --> Returning '" + uRL.toString() + "'");
            }
            return uRL;
        }
        if (!this.delegate) {
            classLoader = this.parent;
            if (classLoader == null) {
                classLoader = this.system;
            }
            if ((uRL = classLoader.getResource(string)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning '" + uRL.toString() + "'");
                }
                return uRL;
            }
        }
        if (this.debug >= 2) {
            this.log("  --> Resource not found, returning null");
        }
        return null;
    }

    public InputStream getResourceAsStream(String string) {
        Object object;
        if (this.debug >= 2) {
            this.log("getResourceAsStream(" + string + ")");
        }
        InputStream inputStream = null;
        inputStream = this.findLoadedResource(string);
        if (inputStream != null) {
            if (this.debug >= 2) {
                this.log("  --> Returning stream from cache");
            }
            return inputStream;
        }
        if (this.delegate) {
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((object = this.parent) == null) {
                object = this.system;
            }
            if ((inputStream = ((ClassLoader)object).getResourceAsStream(string)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning stream from parent");
                }
                return inputStream;
            }
        }
        if (this.debug >= 3) {
            this.log("  Searching local repositories");
        }
        if ((object = this.findResource(string)) != null) {
            if (this.debug >= 2) {
                this.log("  --> Returning stream from local");
            }
            try {
                return ((URL)object).openStream();
            }
            catch (IOException iOException) {
                this.log("url.openStream(" + ((URL)object).toString() + ")", iOException);
                return null;
            }
        }
        if (!this.delegate) {
            ClassLoader classLoader;
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((classLoader = this.parent) == null) {
                classLoader = this.system;
            }
            if ((inputStream = classLoader.getResourceAsStream(string)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning stream from parent");
                }
                return inputStream;
            }
        }
        if (this.debug >= 2) {
            this.log("  --> Resource not found, returning null");
        }
        return null;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        int n;
        if (this.debug >= 2) {
            this.log("loadClass(" + string + ", " + bl + ")");
        }
        Class<?> clazz = null;
        clazz = this.findLoadedClass(string);
        if (clazz != null) {
            if (this.debug >= 3) {
                this.log("  Returning class from cache");
            }
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (string.startsWith("java.")) {
            ClassLoader classLoader = this.system;
            clazz = classLoader.loadClass(string);
            if (clazz != null) {
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            throw new ClassNotFoundException(string);
        }
        if (this.securityManager != null && (n = string.lastIndexOf(46)) >= 0) {
            try {
                this.securityManager.checkPackageAccess(string.substring(0, n));
            }
            catch (SecurityException securityException) {
                String string2 = "Security Violation, attempt to use Restricted Class: " + string;
                System.out.println(string2);
                securityException.printStackTrace();
                this.log(string2);
                throw new ClassNotFoundException(string2);
            }
        }
        if (this.delegate) {
            ClassLoader classLoader;
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((classLoader = this.parent) == null) {
                classLoader = this.system;
            }
            try {
                clazz = classLoader.loadClass(string);
                if (clazz != null) {
                    if (this.debug >= 3) {
                        this.log("  Loading class from parent");
                    }
                    if (bl) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (this.debug >= 3) {
            this.log("  Searching local repositories");
        }
        try {
            clazz = this.findClass(string);
            if (clazz != null) {
                if (this.debug >= 3) {
                    this.log("  Loading class from local repository");
                }
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!this.delegate) {
            ClassLoader classLoader;
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((classLoader = this.parent) == null) {
                classLoader = this.system;
            }
            try {
                clazz = classLoader.loadClass(string);
                if (clazz != null) {
                    if (this.debug >= 3) {
                        this.log("  Loading class from parent");
                    }
                    if (bl) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(string);
    }

    protected final PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection;
        Object object;
        if (!this.policy_refresh) {
            object = Policy.getPolicy();
            ((Policy)object).refresh();
            this.policy_refresh = true;
        }
        if ((permissionCollection = (PermissionCollection)this.loaderPC.get(object = codeSource.getLocation().toString())) == null && (permissionCollection = super.getPermissions(codeSource)) != null) {
            Iterator iterator = this.permissionList.iterator();
            while (iterator.hasNext()) {
                Permission permission = (Permission)iterator.next();
                permissionCollection.add(permission);
            }
            this.loaderPC.put(object, permissionCollection);
        }
        return permissionCollection;
    }

    protected static String parseProtocol(String string) {
        if (string == null) {
            return "";
        }
        int n = string.indexOf(58);
        if (n <= 0) {
            return "";
        }
        return string.substring(0, n).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRepositoryInternal(String string) {
        Object object;
        Object object2;
        URLStreamHandler uRLStreamHandler = null;
        String string2 = StandardClassLoader.parseProtocol(string);
        if (this.factory != null) {
            uRLStreamHandler = this.factory.createURLStreamHandler(string2);
        }
        if (!string.endsWith(File.separator)) {
            try {
                URLConnection uRLConnection;
                Iterator iterator;
                object2 = null;
                object = null;
                if (string.startsWith("jar:")) {
                    iterator = new URL(null, string, uRLStreamHandler);
                    uRLConnection = (JarURLConnection)((URL)((Object)iterator)).openConnection();
                    uRLConnection.setAllowUserInteraction(false);
                    uRLConnection.setDoInput(true);
                    uRLConnection.setDoOutput(false);
                    uRLConnection.connect();
                    object2 = ((JarURLConnection)uRLConnection).getJarFile();
                } else if (string.startsWith("file://")) {
                    object2 = new JarFile(string.substring(7));
                } else if (string.startsWith("file:")) {
                    object2 = new JarFile(string.substring(5));
                } else if (string.endsWith(".jar")) {
                    iterator = new URL(null, string, uRLStreamHandler);
                    uRLConnection = ((URL)((Object)iterator)).openConnection();
                    JarInputStream jarInputStream = new JarInputStream(uRLConnection.getInputStream());
                    object = jarInputStream.getManifest();
                } else {
                    throw new IllegalArgumentException("addRepositoryInternal:  Invalid URL '" + string + "'");
                }
                if (object != null || object2 != null) {
                    if (object == null && object2 != null) {
                        object = ((JarFile)object2).getManifest();
                    }
                    if (object != null) {
                        iterator = Extension.getAvailable((Manifest)object).iterator();
                        while (iterator.hasNext()) {
                            this.available.add(iterator.next());
                        }
                        iterator = Extension.getRequired((Manifest)object).iterator();
                        while (iterator.hasNext()) {
                            this.required.add(iterator.next());
                        }
                    }
                }
                if (object2 != null) {
                    ((ZipFile)object2).close();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new IllegalArgumentException("addRepositoryInternal: " + throwable);
            }
        }
        object2 = this.repositories;
        synchronized (this.repositories) {
            object = new String[this.repositories.length + 1];
            System.arraycopy(this.repositories, 0, object, 0, this.repositories.length);
            object[this.repositories.length] = string;
            this.repositories = object;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    protected static URL[] convert(String[] stringArray) {
        return StandardClassLoader.convert(stringArray, null);
    }

    protected static URL[] convert(String[] stringArray, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        URLStreamHandler uRLStreamHandler = null;
        URL[] uRLArray = new URL[stringArray.length];
        for (int i = 0; i < uRLArray.length; ++i) {
            try {
                String string = StandardClassLoader.parseProtocol(stringArray[i]);
                uRLStreamHandler = uRLStreamHandlerFactory != null ? uRLStreamHandlerFactory.createURLStreamHandler(string) : null;
                uRLArray[i] = new URL(null, stringArray[i], uRLStreamHandler);
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                uRLArray[i] = null;
            }
        }
        return uRLArray;
    }

    protected InputStream findLoadedResource(String string) {
        return null;
    }

    private void log(String string) {
        System.out.println("StandardClassLoader: " + string);
    }

    private void log(String string, Throwable throwable) {
        System.out.println("StandardClassLoader: " + string);
        throwable.printStackTrace(System.out);
    }

    private static class ResourceCacheEntry {
        long lastModified;
        byte[] loadedResource;
        Object origin;

        public ResourceCacheEntry(byte[] byArray, Object object, long l) {
            this.loadedResource = byArray;
            this.origin = object;
            this.lastModified = l;
        }
    }

    private static class ClassCacheEntry {
        long lastModified;
        Class loadedClass;
        Object origin;

        public ClassCacheEntry(Class clazz, Object object, long l) {
            this.loadedClass = clazz;
            this.origin = object;
            this.lastModified = l;
        }
    }
}

