/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.deploy;

import org.apache.catalina.deploy.SecurityCollection;

public final class SecurityConstraint {
    private boolean allRoles = false;
    private boolean authConstraint = false;
    private String[] authRoles = new String[0];
    private SecurityCollection[] collections = new SecurityCollection[0];
    private String displayName = null;
    private String userConstraint = "NONE";

    public boolean getAllRoles() {
        return this.allRoles;
    }

    public boolean getAuthConstraint() {
        return this.authConstraint;
    }

    public void setAuthConstraint(boolean bl) {
        this.authConstraint = bl;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getUserConstraint() {
        return this.userConstraint;
    }

    public void setUserConstraint(String string) {
        if (string != null) {
            this.userConstraint = string;
        }
    }

    public void addAuthRole(String string) {
        if (string == null) {
            return;
        }
        if ("*".equals(string)) {
            this.allRoles = true;
            return;
        }
        String[] stringArray = new String[this.authRoles.length + 1];
        for (int i = 0; i < this.authRoles.length; ++i) {
            stringArray[i] = this.authRoles[i];
        }
        stringArray[this.authRoles.length] = string;
        this.authRoles = stringArray;
        this.authConstraint = true;
    }

    public void addCollection(SecurityCollection securityCollection) {
        if (securityCollection == null) {
            return;
        }
        SecurityCollection[] securityCollectionArray = new SecurityCollection[this.collections.length + 1];
        for (int i = 0; i < this.collections.length; ++i) {
            securityCollectionArray[i] = this.collections[i];
        }
        securityCollectionArray[this.collections.length] = securityCollection;
        this.collections = securityCollectionArray;
    }

    public boolean findAuthRole(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < this.authRoles.length; ++i) {
            if (!string.equals(this.authRoles[i])) continue;
            return true;
        }
        return false;
    }

    public String[] findAuthRoles() {
        return this.authRoles;
    }

    public SecurityCollection findCollection(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this.collections.length; ++i) {
            if (!string.equals(this.collections[i].getName())) continue;
            return this.collections[i];
        }
        return null;
    }

    public SecurityCollection[] findCollections() {
        return this.collections;
    }

    public boolean included(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        for (int i = 0; i < this.collections.length; ++i) {
            if (!this.collections[i].findMethod(string2)) continue;
            String[] stringArray = this.collections[i].findPatterns();
            for (int j = 0; j < stringArray.length; ++j) {
                if (!this.matchPattern(string, stringArray[j])) continue;
                return true;
            }
        }
        return false;
    }

    public void removeAuthRole(String string) {
        int n;
        if (string == null) {
            return;
        }
        int n2 = -1;
        for (n = 0; n < this.authRoles.length; ++n) {
            if (!this.authRoles[n].equals(string)) continue;
            n2 = n;
            break;
        }
        if (n2 >= 0) {
            n = 0;
            String[] stringArray = new String[this.authRoles.length - 1];
            for (int i = 0; i < this.authRoles.length; ++i) {
                if (i == n2) continue;
                stringArray[n++] = this.authRoles[i];
            }
            this.authRoles = stringArray;
        }
    }

    public void removeCollection(SecurityCollection securityCollection) {
        int n;
        if (securityCollection == null) {
            return;
        }
        int n2 = -1;
        for (n = 0; n < this.collections.length; ++n) {
            if (!this.collections[n].equals(securityCollection)) continue;
            n2 = n;
            break;
        }
        if (n2 >= 0) {
            n = 0;
            SecurityCollection[] securityCollectionArray = new SecurityCollection[this.collections.length - 1];
            for (int i = 0; i < this.collections.length; ++i) {
                if (i == n2) continue;
                securityCollectionArray[n++] = this.collections[i];
            }
            this.collections = securityCollectionArray;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SecurityConstraint[");
        for (int i = 0; i < this.collections.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.collections[i].getName());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private boolean matchPattern(String string, String string2) {
        if (string == null || string.length() == 0) {
            string = "/";
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "/";
        }
        if (string.equals(string2)) {
            return true;
        }
        if (string2.startsWith("/") && string2.endsWith("/*")) {
            if ((string2 = string2.substring(0, string2.length() - 2)).length() == 0) {
                return true;
            }
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            while (true) {
                if (string2.equals(string)) {
                    return true;
                }
                int n = string.lastIndexOf(47);
                if (n <= 0) break;
                string = string.substring(0, n);
            }
            return false;
        }
        if (string2.startsWith("*.")) {
            int n = string.lastIndexOf(47);
            int n2 = string.lastIndexOf(46);
            return n >= 0 && n2 > n && string.endsWith(string2.substring(1));
        }
        return string2.equals("/");
    }
}

