/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Service;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public final class StandardService
implements Lifecycle,
Service {
    private Connector[] connectors = new Connector[0];
    private Container container = null;
    private static final String info = "org.apache.catalina.core.StandardService/1.0";
    private String name = null;
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private boolean started = false;
    private boolean initialized = false;

    public Container getContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContainer(Container container) {
        Container container2 = this.container;
        if (container2 != null && container2 instanceof Engine) {
            ((Engine)container2).setService(null);
        }
        this.container = container;
        if (this.container != null && this.container instanceof Engine) {
            ((Engine)this.container).setService(this);
        }
        if (this.started && this.container != null && this.container instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.container)).start();
            }
            catch (LifecycleException lifecycleException) {
                // empty catch block
            }
        }
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            for (int i = 0; i < this.connectors.length; ++i) {
                this.connectors[i].setContainer(this.container);
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            if (this.started && container2 != null && container2 instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)container2)).stop();
                }
                catch (LifecycleException lifecycleException) {
                    // empty catch block
                }
            }
            return;
        }
    }

    public String getInfo() {
        return info;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnector(Connector connector) {
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            connector.setContainer(this.container);
            connector.setService(this);
            Connector[] connectorArray2 = new Connector[this.connectors.length + 1];
            System.arraycopy(this.connectors, 0, connectorArray2, 0, this.connectors.length);
            connectorArray2[this.connectors.length] = connector;
            this.connectors = connectorArray2;
            if (this.initialized) {
                try {
                    connector.initialize();
                }
                catch (LifecycleException lifecycleException) {
                    lifecycleException.printStackTrace(System.err);
                }
            }
            if (this.started && connector instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)connector)).start();
                }
                catch (LifecycleException lifecycleException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Connector[] findConnectors() {
        return this.connectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnector(Connector connector) {
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            int n;
            int n2 = -1;
            for (n = 0; n < this.connectors.length; ++n) {
                if (connector != this.connectors[n]) continue;
                n2 = n;
                break;
            }
            if (n2 < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.started && this.connectors[n2] instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)this.connectors[n2])).stop();
                }
                catch (LifecycleException lifecycleException) {
                    // empty catch block
                }
            }
            this.connectors[n2].setContainer(null);
            connector.setService(null);
            n = 0;
            Connector[] connectorArray2 = new Connector[this.connectors.length - 1];
            for (int i = 0; i < this.connectors.length; ++i) {
                if (i == n2) continue;
                connectorArray2[n++] = this.connectors[i];
            }
            this.connectors = connectorArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("StandardService[");
        stringBuffer.append(this.getName());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.removeLifecycleListener(lifecycleListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("standardService.start.started"));
        }
        System.out.println(sm.getString("standardService.start.name", this.name));
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        Connector[] connectorArray = this.container;
        synchronized (this.container) {
            if (this.container != null && this.container instanceof Lifecycle) {
                ((Lifecycle)((Object)this.container)).start();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            connectorArray = this.connectors;
            synchronized (this.connectors) {
                for (int i = 0; i < this.connectors.length; ++i) {
                    if (!(this.connectors[i] instanceof Lifecycle)) continue;
                    ((Lifecycle)((Object)this.connectors[i])).start();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("standardService.stop.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        System.out.println(sm.getString("standardService.stop.name", this.name));
        this.started = false;
        Object object = this.connectors;
        synchronized (this.connectors) {
            for (int i = 0; i < this.connectors.length; ++i) {
                if (!(this.connectors[i] instanceof Lifecycle)) continue;
                ((Lifecycle)((Object)this.connectors[i])).stop();
            }
            // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
            object = this.container;
            synchronized (object) {
                if (this.container != null && this.container instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.container)).stop();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws LifecycleException {
        if (this.initialized) {
            throw new LifecycleException(sm.getString("standardService.initialize.initialized"));
        }
        this.initialized = true;
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            for (int i = 0; i < this.connectors.length; ++i) {
                this.connectors[i].initialize();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

