/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Deployer;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Valve;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.DefaultContext;
import org.apache.catalina.core.StandardHostValve;
import org.apache.catalina.valves.ErrorDispatcherValve;

public class StandardHost
extends ContainerBase
implements Deployer,
Host {
    private String[] aliases = new String[0];
    private String appBase = ".";
    private String configClass = "org.apache.catalina.startup.ContextConfig";
    private String contextClass = "org.apache.catalina.core.StandardContext";
    private String errorReportValveClass = "org.apache.catalina.valves.ErrorReportValve";
    private static final String info = "org.apache.catalina.core.StandardHost/1.0";
    private String mapperClass = "org.apache.catalina.core.StandardHostMapper";
    private boolean unpackWARs = true;
    private String workDir = null;
    private DefaultContext defaultContext;

    public StandardHost() {
        this.pipeline.setBasic(new StandardHostValve());
    }

    public String getAppBase() {
        return this.appBase;
    }

    public void setAppBase(String string) {
        String string2 = this.appBase;
        this.appBase = string;
        this.support.firePropertyChange("appBase", string2, this.appBase);
    }

    public String getConfigClass() {
        return this.configClass;
    }

    public void setConfigClass(String string) {
        String string2 = this.configClass;
        this.configClass = string;
        this.support.firePropertyChange("configClass", string2, this.configClass);
    }

    public void addDefaultContext(DefaultContext defaultContext) {
        DefaultContext defaultContext2 = this.defaultContext;
        this.defaultContext = defaultContext;
        this.support.firePropertyChange("defaultContext", defaultContext2, this.defaultContext);
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(String string) {
        String string2 = this.contextClass;
        this.contextClass = string;
        this.support.firePropertyChange("contextClass", string2, this.contextClass);
    }

    public String getMapperClass() {
        return this.mapperClass;
    }

    public void setMapperClass(String string) {
        String string2 = this.mapperClass;
        this.mapperClass = string;
        this.support.firePropertyChange("mapperClass", string2, this.mapperClass);
    }

    public String getErrorReportValveClass() {
        return this.errorReportValveClass;
    }

    public void setErrorReportValveClass(String string) {
        String string2 = this.errorReportValveClass;
        this.errorReportValveClass = string;
        this.support.firePropertyChange("errorReportValveClass", string2, this.errorReportValveClass);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.nullName"));
        }
        string = string.toLowerCase();
        String string2 = this.name;
        this.name = string;
        this.support.firePropertyChange("name", string2, this.name);
    }

    public boolean isUnpackWARs() {
        return this.unpackWARs;
    }

    public void setUnpackWARs(boolean bl) {
        this.unpackWARs = bl;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String string) {
        this.workDir = string;
    }

    public void importDefaultContext(Context context) {
        if (this.defaultContext != null) {
            this.defaultContext.importDefaultContext(context);
        }
    }

    public void addAlias(String string) {
        string = string.toLowerCase();
        for (int i = 0; i < this.aliases.length; ++i) {
            if (!this.aliases[i].equals(string)) continue;
            return;
        }
        String[] stringArray = new String[this.aliases.length + 1];
        for (int i = 0; i < this.aliases.length; ++i) {
            stringArray[i] = this.aliases[i];
        }
        stringArray[this.aliases.length] = string;
        this.aliases = stringArray;
        this.fireContainerEvent("addAlias", string);
    }

    public void addChild(Container container) {
        if (!(container instanceof Context)) {
            throw new IllegalArgumentException(sm.getString("standardHost.notContext"));
        }
        super.addChild(container);
    }

    public String[] findAliases() {
        return this.aliases;
    }

    public String getInfo() {
        return info;
    }

    public Context map(String string) {
        int n;
        if (this.debug > 0) {
            this.log("Mapping request URI '" + string + "'");
        }
        if (string == null) {
            return null;
        }
        if (this.debug > 1) {
            this.log("  Trying the longest context path prefix");
        }
        Context context = null;
        while ((context = (Context)this.findChild(string)) == null && (n = string.lastIndexOf(47)) >= 0) {
            string = string.substring(0, n);
        }
        if (context == null) {
            if (this.debug > 1) {
                this.log("  Trying the default context");
            }
            context = (Context)this.findChild("");
        }
        if (context == null) {
            this.log(sm.getString("standardHost.mappingError", string));
            return null;
        }
        if (this.debug > 0) {
            this.log(" Mapped to context '" + context.getPath() + "'");
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAlias(String string) {
        string = string.toLowerCase();
        String[] stringArray = this.aliases;
        synchronized (this.aliases) {
            int n;
            int n2 = -1;
            for (n = 0; n < this.aliases.length; ++n) {
                if (!this.aliases[n].equals(string)) continue;
                n2 = n;
                break;
            }
            if (n2 < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            n = 0;
            String[] stringArray2 = new String[this.aliases.length - 1];
            for (int i = 0; i < this.aliases.length; ++i) {
                if (i == n2) continue;
                stringArray2[n++] = this.aliases[i];
            }
            this.aliases = stringArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("removeAlias", string);
            return;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getParent() != null) {
            stringBuffer.append(this.getParent().toString());
            stringBuffer.append(".");
        }
        stringBuffer.append("StandardHost[");
        stringBuffer.append(this.getName());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public synchronized void start() throws LifecycleException {
        if (this.errorReportValveClass != null && !this.errorReportValveClass.equals("")) {
            try {
                Valve valve = (Valve)Class.forName(this.errorReportValveClass).newInstance();
                this.addValve(valve);
            }
            catch (Throwable throwable) {
                this.log(sm.getString("standardHost.invalidErrorReportValveClass", this.errorReportValveClass));
            }
        }
        this.addValve(new ErrorDispatcherValve());
        super.start();
    }

    public void install(String string, URL uRL) throws IOException {
        Serializable serializable;
        if (string == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathRequired"));
        }
        if (!string.equals("") && !string.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathFormat", string));
        }
        if (this.findDeployedApp(string) != null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathUsed", string));
        }
        if (uRL == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.warRequired"));
        }
        String string2 = uRL.toString();
        String string3 = null;
        this.log(sm.getString("standardHost.installing", string, string2));
        if (this.isUnpackWARs()) {
            if (string2.startsWith("jar:")) {
                string3 = this.expand(uRL);
            } else if (string2.startsWith("file://")) {
                string3 = string2.substring(7);
            } else if (string2.startsWith("file:")) {
                string3 = string2.substring(5);
            } else {
                throw new IllegalArgumentException(sm.getString("standardHost.warURL", string2));
            }
            serializable = new File(string3);
            if (!(((File)serializable).exists() && ((File)serializable).isDirectory() && ((File)serializable).canRead())) {
                throw new IllegalArgumentException(sm.getString("standardHost.accessBase", string3));
            }
        } else {
            if (string2.startsWith("jar:")) {
                string2 = string2.substring(4, string2.length() - 2);
            }
            if (string2.startsWith("file://")) {
                string3 = string2.substring(7);
            } else if (string2.startsWith("file:")) {
                string3 = string2.substring(5);
            } else {
                throw new IllegalArgumentException(sm.getString("standardHost.warURL", string2));
            }
        }
        try {
            serializable = Class.forName(this.contextClass);
            Context context = (Context)((Class)serializable).newInstance();
            context.setPath(string);
            context.setDocBase(string3);
            if (context instanceof Lifecycle) {
                serializable = Class.forName(this.configClass);
                LifecycleListener lifecycleListener = (LifecycleListener)((Class)serializable).newInstance();
                ((Lifecycle)((Object)context)).addLifecycleListener(lifecycleListener);
            }
            this.addChild(context);
            this.fireContainerEvent("install", context);
        }
        catch (Exception exception) {
            this.log(sm.getString("standardHost.installError", string), exception);
            throw new IOException(exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context findDeployedApp(String string) {
        if (string == null) {
            return null;
        }
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return (Context)this.children.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findDeployedApps() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            String[] stringArray = new String[this.children.size()];
            return this.children.keySet().toArray(stringArray);
        }
    }

    public void remove(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathRequired"));
        }
        if (!string.equals("") && !string.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathFormat", string));
        }
        Context context = this.findDeployedApp(string);
        if (context == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathMissing", string));
        }
        this.log(sm.getString("standardHost.removing", string));
        try {
            this.removeChild(context);
        }
        catch (Exception exception) {
            this.log(sm.getString("standardHost.removeError", string), exception);
            throw new IOException(exception.toString());
        }
    }

    public void start(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathRequired"));
        }
        if (!string.equals("") && !string.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathFormat", string));
        }
        Context context = this.findDeployedApp(string);
        if (context == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathMissing", string));
        }
        this.log("standardHost.start " + string);
        try {
            ((Lifecycle)((Object)context)).start();
        }
        catch (LifecycleException lifecycleException) {
            this.log("standardHost.start " + string + ": ", lifecycleException);
            throw new IllegalStateException("standardHost.start " + string + ": " + lifecycleException);
        }
    }

    public void stop(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathRequired"));
        }
        if (!string.equals("") && !string.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathFormat", string));
        }
        Context context = this.findDeployedApp(string);
        if (context == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathMissing", string));
        }
        this.log("standardHost.stop " + string);
        try {
            ((Lifecycle)((Object)context)).stop();
        }
        catch (LifecycleException lifecycleException) {
            this.log("standardHost.stop " + string + ": ", lifecycleException);
            throw new IllegalStateException("standardHost.stop " + string + ": " + lifecycleException);
        }
    }

    protected void addDefaultMapper(String string) {
        super.addDefaultMapper(this.mapperClass);
    }

    protected String expand(URL uRL) throws IOException {
        File file;
        int n;
        int n2;
        String string;
        if (this.debug >= 1) {
            this.log("expand(" + uRL.toString() + ")");
        }
        if ((string = uRL.toString().replace('\\', '/')).endsWith("!/")) {
            string = string.substring(0, string.length() - 2);
        }
        if ((n2 = string.lastIndexOf(46)) >= string.length() - 4) {
            string = string.substring(0, n2);
        }
        if ((n = string.lastIndexOf(47)) >= 0) {
            string = string.substring(n + 1);
        }
        if (this.debug >= 1) {
            this.log("  Proposed directory name: " + string);
        }
        if (!(file = new File(this.getAppBase())).isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.getAppBase());
        }
        if (!file.exists() || !file.isDirectory()) {
            throw new IOException(sm.getString("standardHost.appBase", file.getAbsolutePath()));
        }
        File file2 = new File(file, string);
        if (file2.exists()) {
            return file2.getAbsolutePath();
        }
        file2.mkdir();
        if (this.debug >= 2) {
            this.log("  Have created expansion directory " + file2.getAbsolutePath());
        }
        JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
        jarURLConnection.setUseCaches(false);
        JarFile jarFile = jarURLConnection.getJarFile();
        if (this.debug >= 2) {
            this.log("  Have opened JAR file successfully");
        }
        Enumeration<JarEntry> enumeration = jarFile.entries();
        if (this.debug >= 2) {
            this.log("  Have retrieved entries enumeration");
        }
        while (enumeration.hasMoreElements()) {
            Object object;
            int n3;
            JarEntry jarEntry = enumeration.nextElement();
            String string2 = jarEntry.getName();
            if (this.debug >= 2) {
                this.log("  Am processing entry " + string2);
            }
            if ((n3 = string2.lastIndexOf(47)) >= 0) {
                object = new File(file2, string2.substring(0, n3));
                if (this.debug >= 2) {
                    this.log("  Creating parent directory " + object);
                }
                ((File)object).mkdirs();
            }
            if (string2.endsWith("/")) continue;
            if (this.debug >= 2) {
                this.log("  Creating expanded file " + string2);
            }
            object = jarFile.getInputStream(jarEntry);
            this.expand((InputStream)object, file2, string2);
            ((InputStream)object).close();
        }
        jarFile.close();
        return file2.getAbsolutePath();
    }

    protected void expand(InputStream inputStream, File file, String string) throws IOException {
        int n;
        File file2 = new File(file, string);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) > 0) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedOutputStream.close();
    }

    protected void remove(File file) throws IOException {
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                this.remove(file2);
                continue;
            }
            if (file2.delete()) continue;
            throw new IOException("Cannot delete file " + file2.getAbsolutePath());
        }
        if (!file.delete()) {
            throw new IOException("Cannot delete directory " + file.getAbsolutePath());
        }
    }
}

