/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.Mapper;
import org.apache.catalina.Request;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.util.StringManager;

public class StandardEngineMapper
implements Mapper {
    private StandardEngine engine = null;
    private String protocol = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");

    public Container getContainer() {
        return this.engine;
    }

    public void setContainer(Container container) {
        if (!(container instanceof StandardEngine)) {
            throw new IllegalArgumentException(sm.getString("httpEngineMapper.container"));
        }
        this.engine = (StandardEngine)container;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public Container map(Request request, boolean bl) {
        Host host;
        int n = this.engine.getDebug();
        String string = request.getRequest().getServerName();
        if (string == null) {
            string = this.engine.getDefaultHost();
            if (bl) {
                request.setServerName(string);
            }
        }
        if (string == null) {
            return null;
        }
        string = string.toLowerCase();
        if (n >= 1) {
            this.engine.log("Mapping server name '" + string + "'");
        }
        if (n >= 2) {
            this.engine.log(" Trying a direct match");
        }
        if ((host = (Host)this.engine.findChild(string)) == null) {
            if (n >= 2) {
                this.engine.log(" Trying an alias match");
            }
            Container[] containerArray = this.engine.findChildren();
            for (int i = 0; i < containerArray.length; ++i) {
                String[] stringArray = ((Host)containerArray[i]).findAliases();
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!string.equals(stringArray[j])) continue;
                    host = (Host)containerArray[i];
                    break;
                }
                if (host != null) break;
            }
        }
        if (host == null) {
            if (n >= 2) {
                this.engine.log(" Trying the default host");
            }
            host = (Host)this.engine.findChild(this.engine.getDefaultHost());
        }
        return host;
    }
}

