/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

final class StandardContextValve
extends ValveBase {
    private static final String info = "org.apache.catalina.core.StandardContextValve/1.0";
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");

    StandardContextValve() {
    }

    public String getInfo() {
        return info;
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        if (!(request.getRequest() instanceof HttpServletRequest) || !(response.getResponse() instanceof HttpServletResponse)) {
            return 2;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request.getRequest();
        String string = httpServletRequest.getContextPath();
        String string2 = httpServletRequest.getRequestURI();
        String string3 = string2.substring(string.length()).toUpperCase();
        if (string3.equals("/META-INF") || string3.equals("/WEB-INF") || string3.startsWith("/META-INF/") || string3.startsWith("/WEB-INF/")) {
            this.notFound(string2, (HttpServletResponse)response.getResponse());
            return 2;
        }
        Context context = (Context)this.getContainer();
        Wrapper wrapper = null;
        try {
            wrapper = (Wrapper)context.map(request, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.badRequest(string2, (HttpServletResponse)response.getResponse());
            return 2;
        }
        if (wrapper == null) {
            this.notFound(string2, (HttpServletResponse)response.getResponse());
            return 2;
        }
        response.setContext(context);
        ((ContainerBase)((Object)wrapper)).getPipeline().invoke(request, response);
        return 2;
    }

    private void badRequest(String string, HttpServletResponse httpServletResponse) {
        try {
            httpServletResponse.sendError(400, string);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void notFound(String string, HttpServletResponse httpServletResponse) {
        try {
            httpServletResponse.sendError(404, string);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

