/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Mapper;
import org.apache.catalina.Request;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public final class FastEngineMapper
implements ContainerListener,
Lifecycle,
Mapper,
PropertyChangeListener {
    private HashMap cache = new HashMap();
    private Host defaultHost = null;
    private int debug = 0;
    private StandardEngine engine = null;
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private String protocol = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private boolean started = false;

    public Container getContainer() {
        return this.engine;
    }

    public void setContainer(Container container) {
        if (!(container instanceof StandardEngine)) {
            throw new IllegalArgumentException(sm.getString("httpEngineMapper.container"));
        }
        this.engine = (StandardEngine)container;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public Container map(Request request, boolean bl) {
        Host host;
        this.debug = this.engine.getDebug();
        String string = request.getRequest().getServerName();
        if (string == null) {
            string = this.engine.getDefaultHost();
            if (bl) {
                request.setServerName(string);
            }
        }
        if (string == null) {
            return null;
        }
        if (this.debug >= 1) {
            this.engine.log("Mapping server name '" + string + "'");
        }
        if (this.debug >= 2) {
            this.engine.log(" Trying a cache match");
        }
        if ((host = (Host)this.cache.get(string)) == null && this.defaultHost != null) {
            if (this.debug >= 2) {
                this.engine.log(" Mapping to default host");
            }
            host = this.defaultHost;
            this.addAlias(string, host);
        }
        return host;
    }

    public void containerEvent(ContainerEvent containerEvent) {
        Container container = (Container)containerEvent.getSource();
        String string = containerEvent.getType();
        if (container == this.engine) {
            if ("addChild".equals(string)) {
                this.addHost((Host)containerEvent.getData());
            } else if ("removeChild".equals(string)) {
                this.removeHost((Host)containerEvent.getData());
            }
        } else if (container instanceof Host) {
            if ("addAlias".equals(string)) {
                this.addAlias((String)containerEvent.getData(), (Host)container);
            } else if ("removeAlias".equals(string)) {
                this.removeAlias((String)containerEvent.getData());
            }
        }
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.removeLifecycleListener(lifecycleListener);
    }

    public synchronized void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("fastEngineMapper.alreadyStarted", this.engine.getName()));
        }
        this.started = true;
        this.engine.addContainerListener(this);
        this.engine.addPropertyChangeListener(this);
        this.setDefaultHost(this.engine.getDefaultHost());
        Container[] containerArray = this.engine.findChildren();
        for (int i = 0; i < containerArray.length; ++i) {
            this.addHost((Host)containerArray[i]);
        }
        this.lifecycle.fireLifecycleEvent("start", null);
    }

    public synchronized void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("fastEngineMapper.notStarted", this.engine.getName()));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.engine.removePropertyChangeListener(this);
        this.setDefaultHost(null);
        this.engine.removeContainerListener(this);
        this.cache.clear();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (object instanceof Engine && "defaultHost".equals(propertyChangeEvent.getPropertyName())) {
            this.setDefaultHost((String)propertyChangeEvent.getNewValue());
        }
    }

    private void addAlias(String string, Host host) {
        if (this.debug >= 3) {
            this.engine.log("Adding alias '" + string + "' for host '" + host.getName() + "'");
        }
        this.cache.put(string.toLowerCase(), host);
    }

    private void addHost(Host host) {
        if (this.debug >= 3) {
            this.engine.log("Adding host '" + host.getName() + "'");
        }
        host.addContainerListener(this);
        this.addAlias(host.getName(), host);
        String[] stringArray = host.findAliases();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addAlias(stringArray[i], host);
        }
    }

    private Host findHost(String string) {
        return (Host)this.cache.get(string.toLowerCase());
    }

    private void removeAlias(String string) {
        if (this.debug >= 3) {
            this.engine.log("Removing alias '" + string + "'");
        }
        this.cache.remove(string.toLowerCase());
    }

    private void removeHost(Host host) {
        if (this.debug >= 3) {
            this.engine.log("Removing host '" + host.getName() + "'");
        }
        host.removeContainerListener(this);
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Object> iterator = this.cache.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!host.equals((Host)this.cache.get(string))) continue;
            arrayList.add(string);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.removeAlias((String)iterator.next());
        }
    }

    private void setDefaultHost(String string) {
        if (this.debug >= 3) {
            this.engine.log("Setting default host '" + string + "'");
        }
        this.defaultHost = string == null ? null : (Host)this.engine.findChild(string);
    }
}

