/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.directory.DirContext;
import javax.servlet.ServletException;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Mapper;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardPipeline;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.naming.resources.ProxyDirContext;

public abstract class ContainerBase
implements Container,
Lifecycle,
Pipeline {
    protected HashMap children = new HashMap();
    protected int debug = 0;
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected ArrayList listeners = new ArrayList();
    protected Loader loader = null;
    protected Logger logger = null;
    protected Manager manager = null;
    protected Cluster cluster = null;
    protected Mapper mapper = null;
    protected HashMap mappers = new HashMap();
    protected String mapperClass = null;
    protected String name = null;
    protected Container parent = null;
    protected ClassLoader parentClassLoader = null;
    protected Pipeline pipeline = new StandardPipeline(this);
    protected Realm realm = null;
    protected DirContext resources = null;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.core");
    protected boolean started = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int n) {
        int n2 = this.debug;
        this.debug = n;
        this.support.firePropertyChange("debug", new Integer(n2), new Integer(this.debug));
    }

    public abstract String getInfo();

    public Loader getLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        if (this.parent != null) {
            return this.parent.getLoader();
        }
        return null;
    }

    public synchronized void setLoader(Loader loader) {
        Loader loader2 = this.loader;
        if (loader2 == loader) {
            return;
        }
        this.loader = loader;
        if (this.started && loader2 != null && loader2 instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)loader2)).stop();
            }
            catch (LifecycleException lifecycleException) {
                this.log("ContainerBase.setLoader: stop: ", lifecycleException);
            }
        }
        if (loader != null) {
            loader.setContainer(this);
        }
        if (this.started && loader != null && loader instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)loader)).start();
            }
            catch (LifecycleException lifecycleException) {
                this.log("ContainerBase.setLoader: start: ", lifecycleException);
            }
        }
        this.support.firePropertyChange("loader", loader2, this.loader);
    }

    public Logger getLogger() {
        if (this.logger != null) {
            return this.logger;
        }
        if (this.parent != null) {
            return this.parent.getLogger();
        }
        return null;
    }

    public synchronized void setLogger(Logger logger) {
        Logger logger2 = this.logger;
        if (logger2 == logger) {
            return;
        }
        this.logger = logger;
        if (this.started && logger2 != null && logger2 instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)logger2)).stop();
            }
            catch (LifecycleException lifecycleException) {
                this.log("ContainerBase.setLogger: stop: ", lifecycleException);
            }
        }
        if (logger != null) {
            logger.setContainer(this);
        }
        if (this.started && logger != null && logger instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)logger)).start();
            }
            catch (LifecycleException lifecycleException) {
                this.log("ContainerBase.setLogger: start: ", lifecycleException);
            }
        }
        this.support.firePropertyChange("logger", logger2, this.logger);
    }

    public Manager getManager() {
        if (this.manager != null) {
            return this.manager;
        }
        if (this.parent != null) {
            return this.parent.getManager();
        }
        return null;
    }

    public synchronized void setManager(Manager manager) {
        Manager manager2 = this.manager;
        if (manager2 == manager) {
            return;
        }
        this.manager = manager;
        if (this.started && manager2 != null && manager2 instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)manager2)).stop();
            }
            catch (LifecycleException lifecycleException) {
                this.log("ContainerBase.setManager: stop: ", lifecycleException);
            }
        }
        if (manager != null) {
            manager.setContainer(this);
        }
        if (this.started && manager != null && manager instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)manager)).start();
            }
            catch (LifecycleException lifecycleException) {
                this.log("ContainerBase.setManager: start: ", lifecycleException);
            }
        }
        this.support.firePropertyChange("manager", manager2, this.manager);
    }

    public Cluster getCluster() {
        if (this.cluster != null) {
            return this.cluster;
        }
        if (this.parent != null) {
            return this.parent.getCluster();
        }
        return null;
    }

    public synchronized void setCluster(Cluster cluster) {
        Cluster cluster2 = this.cluster;
        if (cluster2 == cluster) {
            return;
        }
        this.cluster = cluster;
        if (this.started && cluster2 != null && cluster2 instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)cluster2)).stop();
            }
            catch (LifecycleException lifecycleException) {
                this.log("ContainerBase.setCluster: stop: ", lifecycleException);
            }
        }
        if (cluster != null) {
            cluster.setContainer(this);
        }
        if (this.started && cluster != null && cluster instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)cluster)).start();
            }
            catch (LifecycleException lifecycleException) {
                this.log("ContainerBase.setCluster: start: ", lifecycleException);
            }
        }
        this.support.firePropertyChange("cluster", cluster2, this.cluster);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        this.support.firePropertyChange("name", string2, this.name);
    }

    public Container getParent() {
        return this.parent;
    }

    public void setParent(Container container) {
        Container container2 = this.parent;
        this.parent = container;
        this.support.firePropertyChange("parent", container2, this.parent);
    }

    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.parent != null) {
            return this.parent.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    public void setParentClassLoader(ClassLoader classLoader) {
        ClassLoader classLoader2 = this.parentClassLoader;
        this.parentClassLoader = classLoader;
        this.support.firePropertyChange("parentClassLoader", classLoader2, this.parentClassLoader);
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public Realm getRealm() {
        if (this.realm != null) {
            return this.realm;
        }
        if (this.parent != null) {
            return this.parent.getRealm();
        }
        return null;
    }

    public synchronized void setRealm(Realm realm) {
        Realm realm2 = this.realm;
        if (realm2 == realm) {
            return;
        }
        this.realm = realm;
        if (this.started && realm2 != null && realm2 instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)realm2)).stop();
            }
            catch (LifecycleException lifecycleException) {
                this.log("ContainerBase.setRealm: stop: ", lifecycleException);
            }
        }
        if (realm != null) {
            realm.setContainer(this);
        }
        if (this.started && realm != null && realm instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)realm)).start();
            }
            catch (LifecycleException lifecycleException) {
                this.log("ContainerBase.setRealm: start: ", lifecycleException);
            }
        }
        this.support.firePropertyChange("realm", realm2, this.realm);
    }

    public DirContext getResources() {
        if (this.resources != null) {
            return this.resources;
        }
        if (this.parent != null) {
            return this.parent.getResources();
        }
        return null;
    }

    public synchronized void setResources(DirContext dirContext) {
        DirContext dirContext2 = this.resources;
        if (dirContext2 == dirContext) {
            return;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this.getParent() != null) {
            hashtable.put("host", this.getParent().getName());
        }
        hashtable.put("context", this.getName());
        this.resources = new ProxyDirContext(hashtable, dirContext);
        this.support.firePropertyChange("resources", dirContext2, this.resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(Container container) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            if (this.children.get(container.getName()) != null) {
                throw new IllegalArgumentException("addChild:  Child name '" + container.getName() + "' is not unique");
            }
            container.setParent(this);
            if (this.started && container instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)container)).start();
                }
                catch (LifecycleException lifecycleException) {
                    this.log("ContainerBase.addChild: start: ", lifecycleException);
                    throw new IllegalStateException("ContainerBase.addChild: start: " + lifecycleException);
                }
            }
            this.children.put(container.getName(), container);
            this.fireContainerEvent("addChild", container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContainerListener(ContainerListener containerListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(containerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMapper(Mapper mapper) {
        HashMap hashMap = this.mappers;
        synchronized (hashMap) {
            if (this.mappers.get(mapper.getProtocol()) != null) {
                throw new IllegalArgumentException("addMapper:  Protocol '" + mapper.getProtocol() + "' is not unique");
            }
            mapper.setContainer(this);
            if (this.started && mapper instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)mapper)).start();
                }
                catch (LifecycleException lifecycleException) {
                    this.log("ContainerBase.addMapper: start: ", lifecycleException);
                    throw new IllegalStateException("ContainerBase.addMapper: start: " + lifecycleException);
                }
            }
            this.mappers.put(mapper.getProtocol(), mapper);
            this.mapper = this.mappers.size() == 1 ? mapper : null;
            this.fireContainerEvent("addMapper", mapper);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Container findChild(String string) {
        if (string == null) {
            return null;
        }
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return (Container)this.children.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Container[] findChildren() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            Container[] containerArray = new Container[this.children.size()];
            return this.children.values().toArray(containerArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mapper findMapper(String string) {
        if (this.mapper != null) {
            return this.mapper;
        }
        HashMap hashMap = this.mappers;
        synchronized (hashMap) {
            return (Mapper)this.mappers.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mapper[] findMappers() {
        HashMap hashMap = this.mappers;
        synchronized (hashMap) {
            Mapper[] mapperArray = new Mapper[this.mappers.size()];
            return this.mappers.values().toArray(mapperArray);
        }
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.pipeline.invoke(request, response);
    }

    public Container map(Request request, boolean bl) {
        Mapper mapper = this.findMapper(request.getRequest().getProtocol());
        if (mapper == null) {
            return null;
        }
        return mapper.map(request, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(Container container) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            if (this.children.get(container.getName()) == null) {
                return;
            }
            this.children.remove(container.getName());
        }
        if (this.started && container instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)container)).stop();
            }
            catch (LifecycleException lifecycleException) {
                this.log("ContainerBase.removeChild: stop: ", lifecycleException);
            }
        }
        container.setParent(null);
        this.fireContainerEvent("removeChild", container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContainerListener(ContainerListener containerListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(containerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMapper(Mapper mapper) {
        HashMap hashMap = this.mappers;
        synchronized (hashMap) {
            if (this.mappers.get(mapper.getProtocol()) == null) {
                return;
            }
            this.mappers.remove(mapper.getProtocol());
            if (this.started && mapper instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)mapper)).stop();
                }
                catch (LifecycleException lifecycleException) {
                    this.log("ContainerBase.removeMapper: stop: ", lifecycleException);
                    throw new IllegalStateException("ContainerBase.removeMapper: stop: " + lifecycleException);
                }
            }
            if (this.mappers.size() != 1) {
                this.mapper = null;
            } else {
                Iterator iterator = this.mappers.values().iterator();
                this.mapper = (Mapper)iterator.next();
            }
            this.fireContainerEvent("removeMapper", mapper);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.removeLifecycleListener(lifecycleListener);
    }

    public synchronized void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("containerBase.alreadyStarted", this.logName()));
        }
        this.addDefaultMapper(this.mapperClass);
        this.started = true;
        if (this.loader != null && this.loader instanceof Lifecycle) {
            ((Lifecycle)((Object)this.loader)).start();
        }
        if (this.logger != null && this.logger instanceof Lifecycle) {
            ((Lifecycle)((Object)this.logger)).start();
        }
        if (this.manager != null && this.manager instanceof Lifecycle) {
            ((Lifecycle)((Object)this.manager)).start();
        }
        if (this.cluster != null && this.cluster instanceof Lifecycle) {
            ((Lifecycle)((Object)this.cluster)).start();
        }
        if (this.realm != null && this.realm instanceof Lifecycle) {
            ((Lifecycle)((Object)this.realm)).start();
        }
        if (this.resources != null && this.resources instanceof Lifecycle) {
            ((Lifecycle)((Object)this.resources)).start();
        }
        Mapper[] mapperArray = this.findMappers();
        for (int i = 0; i < mapperArray.length; ++i) {
            if (!(mapperArray[i] instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)mapperArray[i])).start();
        }
        Container[] containerArray = this.findChildren();
        for (int i = 0; i < containerArray.length; ++i) {
            if (!(containerArray[i] instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)containerArray[i])).start();
        }
        if (this.pipeline instanceof Lifecycle) {
            ((Lifecycle)((Object)this.pipeline)).start();
        }
        this.lifecycle.fireLifecycleEvent("start", null);
    }

    public synchronized void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("containerBase.notStarted", this.logName()));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (this.pipeline instanceof Lifecycle) {
            ((Lifecycle)((Object)this.pipeline)).stop();
        }
        Container[] containerArray = this.findChildren();
        for (int i = 0; i < containerArray.length; ++i) {
            if (!(containerArray[i] instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)containerArray[i])).stop();
        }
        Mapper[] mapperArray = this.findMappers();
        for (int i = 0; i < mapperArray.length; ++i) {
            if (!(mapperArray[mapperArray.length - 1 - i] instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)mapperArray[mapperArray.length - 1 - i])).stop();
        }
        if (this.resources != null && this.resources instanceof Lifecycle) {
            ((Lifecycle)((Object)this.resources)).stop();
        }
        if (this.realm != null && this.realm instanceof Lifecycle) {
            ((Lifecycle)((Object)this.realm)).stop();
        }
        if (this.cluster != null && this.cluster instanceof Lifecycle) {
            ((Lifecycle)((Object)this.cluster)).stop();
        }
        if (this.manager != null && this.manager instanceof Lifecycle) {
            ((Lifecycle)((Object)this.manager)).stop();
        }
        if (this.logger != null && this.logger instanceof Lifecycle) {
            ((Lifecycle)((Object)this.logger)).stop();
        }
        if (this.loader != null && this.loader instanceof Lifecycle) {
            ((Lifecycle)((Object)this.loader)).stop();
        }
    }

    public synchronized void addValve(Valve valve) {
        this.pipeline.addValve(valve);
        this.fireContainerEvent("addValve", valve);
    }

    public Valve getBasic() {
        return this.pipeline.getBasic();
    }

    public Valve[] getValves() {
        return this.pipeline.getValves();
    }

    public synchronized void removeValve(Valve valve) {
        this.pipeline.removeValve(valve);
        this.fireContainerEvent("removeValve", valve);
    }

    public void setBasic(Valve valve) {
        this.pipeline.setBasic(valve);
    }

    protected void addDefaultMapper(String string) {
        if (string == null) {
            return;
        }
        if (this.mappers.size() >= 1) {
            return;
        }
        try {
            Class<?> clazz = Class.forName(string);
            Mapper mapper = (Mapper)clazz.newInstance();
            mapper.setProtocol("http");
            this.addMapper(mapper);
        }
        catch (Exception exception) {
            this.log(sm.getString("containerBase.addDefaultMapper", string), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireContainerEvent(String string, Object object) {
        if (this.listeners.size() < 1) {
            return;
        }
        ContainerEvent containerEvent = new ContainerEvent(this, string, object);
        ContainerListener[] containerListenerArray = new ContainerListener[]{};
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            containerListenerArray = this.listeners.toArray(containerListenerArray);
        }
        for (int i = 0; i < containerListenerArray.length; ++i) {
            containerListenerArray[i].containerEvent(containerEvent);
        }
    }

    protected void log(String string) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(this.logName() + ": " + string);
        } else {
            System.out.println(this.logName() + ": " + string);
        }
    }

    protected void log(String string, Throwable throwable) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(this.logName() + ": " + string, throwable);
        } else {
            System.out.println(this.logName() + ": " + string + ": " + throwable);
            throwable.printStackTrace(System.out);
        }
    }

    protected String logName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string + "[" + this.getName() + "]";
    }
}

