/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.HttpRequestBase;
import org.apache.catalina.connector.HttpRequestFacade;
import org.apache.catalina.connector.RequestBase;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.core.ApplicationHttpRequest;
import org.apache.catalina.core.ApplicationHttpResponse;
import org.apache.catalina.core.ApplicationRequest;
import org.apache.catalina.core.ApplicationResponse;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.util.InstanceSupport;
import org.apache.catalina.util.StringManager;

final class ApplicationDispatcher
implements RequestDispatcher {
    private ServletRequest appRequest = null;
    private ServletResponse appResponse = null;
    private Context context = null;
    private int debug = 0;
    private boolean including = false;
    private static final String info = "org.apache.catalina.core.ApplicationDispatcher/1.0";
    private String name = null;
    private ServletRequest outerRequest = null;
    private ServletResponse outerResponse = null;
    private String pathInfo = null;
    private String queryString = null;
    private String servletPath = null;
    private String requestURI = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private InstanceSupport support = null;
    private Wrapper wrapper = null;
    private ServletRequest wrapRequest = null;
    private ServletResponse wrapResponse = null;

    public ApplicationDispatcher(Wrapper wrapper, String string, String string2, String string3, String string4, String string5) {
        String string6;
        this.wrapper = wrapper;
        this.context = (Context)wrapper.getParent();
        this.requestURI = string;
        this.servletPath = string2;
        this.pathInfo = string3;
        this.queryString = string4;
        this.name = string5;
        this.support = wrapper instanceof StandardWrapper ? ((StandardWrapper)wrapper).getInstanceSupport() : new InstanceSupport(wrapper);
        if (this.debug >= 1) {
            this.log("servletPath=" + this.servletPath + ", pathInfo=" + this.pathInfo + ", queryString=" + string4 + ", requestURI=" + this.requestURI + ", name=" + this.name);
        }
        if ((string6 = wrapper.getJspFile()) != null) {
            if (this.debug >= 1) {
                this.log("-->servletPath=" + string6);
            }
            this.servletPath = string6;
        }
    }

    public String getInfo() {
        return info;
    }

    public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        if (System.getSecurityManager() != null) {
            try {
                PrivilegedForward privilegedForward = new PrivilegedForward(servletRequest, servletResponse);
                AccessController.doPrivileged(privilegedForward);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof ServletException) {
                    throw (ServletException)((Object)exception);
                }
                throw (IOException)exception;
            }
        } else {
            this.doForward(servletRequest, servletResponse);
        }
    }

    private void doForward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        String string;
        Object object;
        if (servletResponse.isCommitted()) {
            if (this.debug >= 1) {
                this.log("  Forward on committed response --> ISE");
            }
            throw new IllegalStateException(sm.getString("applicationDispatcher.forward.ise"));
        }
        try {
            servletResponse.resetBuffer();
        }
        catch (IllegalStateException illegalStateException) {
            if (this.debug >= 1) {
                this.log("  Forward resetBuffer() returned ISE: " + illegalStateException);
            }
            throw illegalStateException;
        }
        this.setup(servletRequest, servletResponse, false);
        HttpServletRequest httpServletRequest = null;
        if (servletRequest instanceof HttpServletRequest) {
            httpServletRequest = (HttpServletRequest)servletRequest;
        }
        HttpServletResponse httpServletResponse = null;
        if (servletResponse instanceof HttpServletResponse) {
            httpServletResponse = (HttpServletResponse)servletResponse;
        }
        if (httpServletRequest == null || httpServletResponse == null) {
            if (this.debug >= 1) {
                this.log(" Non-HTTP Forward");
            }
            this.invoke(servletRequest, servletResponse);
        } else if (this.servletPath == null && this.pathInfo == null) {
            if (this.debug >= 1) {
                this.log(" Named Dispatcher Forward");
            }
            this.invoke(servletRequest, servletResponse);
        } else {
            if (this.debug >= 1) {
                this.log(" Path Based Forward");
            }
            object = (ApplicationHttpRequest)this.wrapRequest();
            string = this.context.getPath();
            ((ApplicationHttpRequest)((Object)object)).setContextPath(string);
            ((ApplicationHttpRequest)((Object)object)).setRequestURI(this.requestURI);
            ((ApplicationHttpRequest)((Object)object)).setServletPath(this.servletPath);
            ((ApplicationHttpRequest)((Object)object)).setPathInfo(this.pathInfo);
            if (this.queryString != null) {
                ((ApplicationHttpRequest)((Object)object)).setQueryString(this.queryString);
                ((ApplicationHttpRequest)((Object)object)).setQueryParams(this.queryString);
            }
            this.invoke(this.outerRequest, servletResponse);
            this.unwrapRequest();
        }
        if (this.debug >= 1) {
            this.log(" Committing and closing response");
        }
        if (servletResponse instanceof ResponseFacade) {
            ((ResponseFacade)servletResponse).finish();
        } else {
            try {
                servletResponse.flushBuffer();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                object = servletResponse.getWriter();
                ((PrintWriter)object).flush();
                ((PrintWriter)object).close();
            }
            catch (IllegalStateException illegalStateException) {
                try {
                    string = servletResponse.getOutputStream();
                    string.flush();
                    string.close();
                }
                catch (IllegalStateException illegalStateException2) {
                }
                catch (IOException iOException) {}
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        if (System.getSecurityManager() != null) {
            try {
                PrivilegedInclude privilegedInclude = new PrivilegedInclude(servletRequest, servletResponse);
                AccessController.doPrivileged(privilegedInclude);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                privilegedActionException.printStackTrace();
                if (exception instanceof ServletException) {
                    throw (ServletException)((Object)exception);
                }
                throw (IOException)exception;
            }
        } else {
            this.doInclude(servletRequest, servletResponse);
        }
    }

    private void doInclude(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        this.setup(servletRequest, servletResponse, true);
        ServletResponse servletResponse2 = this.wrapResponse();
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            if (this.debug >= 1) {
                this.log(" Non-HTTP Include");
            }
            this.invoke(servletRequest, this.outerResponse);
            this.unwrapResponse();
        } else if (this.name != null) {
            if (this.debug >= 1) {
                this.log(" Named Dispatcher Include");
            }
            ApplicationHttpRequest applicationHttpRequest = (ApplicationHttpRequest)this.wrapRequest();
            applicationHttpRequest.setAttribute("org.apache.catalina.NAMED", this.name);
            if (this.servletPath != null) {
                applicationHttpRequest.setServletPath(this.servletPath);
            }
            this.invoke(this.outerRequest, this.outerResponse);
            this.unwrapRequest();
            this.unwrapResponse();
        } else {
            if (this.debug >= 1) {
                this.log(" Path Based Include");
            }
            ApplicationHttpRequest applicationHttpRequest = (ApplicationHttpRequest)this.wrapRequest();
            String string = this.context.getPath();
            if (this.requestURI != null) {
                applicationHttpRequest.setAttribute("javax.servlet.include.request_uri", this.requestURI);
            }
            if (string != null) {
                applicationHttpRequest.setAttribute("javax.servlet.include.context_path", string);
            }
            if (this.servletPath != null) {
                applicationHttpRequest.setAttribute("javax.servlet.include.servlet_path", this.servletPath);
            }
            if (this.pathInfo != null) {
                applicationHttpRequest.setAttribute("javax.servlet.include.path_info", this.pathInfo);
            }
            if (this.queryString != null) {
                applicationHttpRequest.setAttribute("javax.servlet.include.query_string", this.queryString);
                applicationHttpRequest.setQueryParams(this.queryString);
            }
            this.invoke(this.outerRequest, this.outerResponse);
            this.unwrapRequest();
            this.unwrapResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void invoke(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        RuntimeException runtimeException;
        Throwable throwable;
        IOException iOException;
        Servlet servlet;
        ClassLoader classLoader;
        block46: {
            ClassLoader classLoader2;
            classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != (classLoader2 = this.context.getLoader().getClassLoader())) {
                Thread.currentThread().setContextClassLoader(classLoader2);
            } else {
                classLoader = null;
            }
            HttpServletRequest httpServletRequest = null;
            if (servletRequest instanceof HttpServletRequest) {
                httpServletRequest = (HttpServletRequest)servletRequest;
            }
            HttpServletResponse httpServletResponse = null;
            if (servletResponse instanceof HttpServletResponse) {
                httpServletResponse = (HttpServletResponse)servletResponse;
            }
            servlet = null;
            iOException = null;
            throwable = null;
            runtimeException = null;
            boolean bl = false;
            if (this.wrapper.isUnavailable()) {
                this.log(sm.getString("applicationDispatcher.isUnavailable", this.wrapper.getName()));
                if (httpServletResponse != null) {
                    long l = this.wrapper.getAvailable();
                    if (l > 0L && l < Long.MAX_VALUE) {
                        httpServletResponse.setDateHeader("Retry-After", l);
                    }
                    httpServletResponse.sendError(503, sm.getString("applicationDispatcher.isUnavailable", this.wrapper.getName()));
                }
                bl = true;
            }
            try {
                if (!bl) {
                    servlet = this.wrapper.allocate();
                }
            }
            catch (ServletException servletException) {
                this.log(sm.getString("applicationDispatcher.allocateException", this.wrapper.getName()), servletException);
                throwable = servletException;
                servlet = null;
            }
            catch (Throwable throwable2) {
                this.log(sm.getString("applicationDispatcher.allocateException", this.wrapper.getName()), throwable2);
                throwable = new ServletException(sm.getString("applicationDispatcher.allocateException", this.wrapper.getName()), throwable2);
                servlet = null;
            }
            RequestBase requestBase = null;
            HttpRequestBase httpRequestBase = null;
            Context context = null;
            try {
                try {
                    String string = this.wrapper.getJspFile();
                    if (string != null) {
                        servletRequest.setAttribute("org.apache.catalina.jsp_file", (Object)string);
                    } else {
                        servletRequest.removeAttribute("org.apache.catalina.jsp_file");
                    }
                    this.support.fireInstanceEvent("beforeDispatch", servlet, servletRequest, servletResponse);
                    if (servlet != null) {
                        requestBase = this.getRequestBase(servletRequest);
                        if (requestBase != null) {
                            requestBase.incrementDispatchDepth();
                            if (requestBase.isMaxDispatchDepthReached()) {
                                throw new ServletException(sm.getString("applicationDispatcher.maxDispatchDepthReached"));
                            }
                            if (requestBase instanceof HttpRequestBase) {
                                httpRequestBase = (HttpRequestBase)requestBase;
                                context = httpRequestBase.changeContext(this.context);
                            }
                        }
                        if (httpServletRequest != null && httpServletResponse != null) {
                            servlet.service((ServletRequest)((HttpServletRequest)servletRequest), (ServletResponse)((HttpServletResponse)servletResponse));
                        } else {
                            servlet.service(servletRequest, servletResponse);
                        }
                    }
                    servletRequest.removeAttribute("org.apache.catalina.jsp_file");
                    this.support.fireInstanceEvent("afterDispatch", servlet, servletRequest, servletResponse);
                }
                catch (IOException iOException2) {
                    servletRequest.removeAttribute("org.apache.catalina.jsp_file");
                    this.support.fireInstanceEvent("afterDispatch", servlet, servletRequest, servletResponse);
                    this.log(sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), iOException2);
                    iOException = iOException2;
                    Object var17_26 = null;
                    if (requestBase != null) {
                        requestBase.decrementDispatchDepth();
                    }
                    if (httpRequestBase != null) {
                        httpRequestBase.changeContext(context);
                    }
                    break block46;
                }
                catch (UnavailableException unavailableException) {
                    servletRequest.removeAttribute("org.apache.catalina.jsp_file");
                    this.support.fireInstanceEvent("afterDispatch", servlet, servletRequest, servletResponse);
                    this.log(sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), unavailableException);
                    throwable = unavailableException;
                    this.wrapper.unavailable(unavailableException);
                    Object var17_27 = null;
                    if (requestBase != null) {
                        requestBase.decrementDispatchDepth();
                    }
                    if (httpRequestBase != null) {
                        httpRequestBase.changeContext(context);
                    }
                    break block46;
                }
                catch (ServletException servletException) {
                    servletRequest.removeAttribute("org.apache.catalina.jsp_file");
                    this.support.fireInstanceEvent("afterDispatch", servlet, servletRequest, servletResponse);
                    this.log(sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), servletException);
                    throwable = servletException;
                    Object var17_28 = null;
                    if (requestBase != null) {
                        requestBase.decrementDispatchDepth();
                    }
                    if (httpRequestBase != null) {
                        httpRequestBase.changeContext(context);
                    }
                    break block46;
                }
                catch (RuntimeException runtimeException2) {
                    servletRequest.removeAttribute("org.apache.catalina.jsp_file");
                    this.support.fireInstanceEvent("afterDispatch", servlet, servletRequest, servletResponse);
                    this.log(sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), runtimeException2);
                    runtimeException = runtimeException2;
                    Object var17_29 = null;
                    if (requestBase != null) {
                        requestBase.decrementDispatchDepth();
                    }
                    if (httpRequestBase != null) {
                        httpRequestBase.changeContext(context);
                    }
                    break block46;
                }
                Object var17_25 = null;
                if (requestBase != null) {
                    requestBase.decrementDispatchDepth();
                }
            }
            catch (Throwable throwable3) {
                Object var17_30 = null;
                if (requestBase != null) {
                    requestBase.decrementDispatchDepth();
                }
                if (httpRequestBase != null) {
                    httpRequestBase.changeContext(context);
                }
                throw throwable3;
            }
            if (httpRequestBase != null) {
                httpRequestBase.changeContext(context);
            }
        }
        try {
            if (servlet != null) {
                this.wrapper.deallocate(servlet);
            }
        }
        catch (ServletException servletException) {
            this.log(sm.getString("applicationDispatcher.deallocateException", this.wrapper.getName()), servletException);
            throwable = servletException;
        }
        catch (Throwable throwable4) {
            this.log(sm.getString("applicationDispatcher.deallocateException", this.wrapper.getName()), throwable4);
            throwable = new ServletException(sm.getString("applicationDispatcher.deallocateException", this.wrapper.getName()), throwable4);
        }
        if (classLoader != null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        if (iOException != null) {
            throw iOException;
        }
        if (throwable != null) {
            throw throwable;
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    private void log(String string) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log("ApplicationDispatcher[" + this.context.getPath() + "]: " + string);
        } else {
            System.out.println("ApplicationDispatcher[" + this.context.getPath() + "]: " + string);
        }
    }

    private void log(String string, Throwable throwable) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log("ApplicationDispatcher[" + this.context.getPath() + "] " + string, throwable);
        } else {
            System.out.println("ApplicationDispatcher[" + this.context.getPath() + "]: " + string);
            throwable.printStackTrace(System.out);
        }
    }

    private void setup(ServletRequest servletRequest, ServletResponse servletResponse, boolean bl) {
        this.appRequest = servletRequest;
        this.appResponse = servletResponse;
        this.outerRequest = servletRequest;
        this.outerResponse = servletResponse;
        this.including = bl;
    }

    private void unwrapRequest() {
        if (this.wrapRequest == null) {
            return;
        }
        ServletRequest servletRequest = null;
        ServletRequest servletRequest2 = this.outerRequest;
        while (servletRequest2 != null && !(servletRequest2 instanceof Request)) {
            if (servletRequest2 == this.wrapRequest) {
                ServletRequest servletRequest3 = ((ServletRequestWrapper)servletRequest2).getRequest();
                if (servletRequest == null) {
                    this.outerRequest = servletRequest3;
                    break;
                }
                ((ServletRequestWrapper)servletRequest).setRequest(servletRequest3);
                break;
            }
            servletRequest = servletRequest2;
            servletRequest2 = ((ServletRequestWrapper)servletRequest2).getRequest();
        }
    }

    private void unwrapResponse() {
        if (this.wrapResponse == null) {
            return;
        }
        ServletResponse servletResponse = null;
        ServletResponse servletResponse2 = this.outerResponse;
        while (servletResponse2 != null && !(servletResponse2 instanceof Response)) {
            if (servletResponse2 == this.wrapResponse) {
                ServletResponse servletResponse3 = ((ServletResponseWrapper)servletResponse2).getResponse();
                if (servletResponse == null) {
                    this.outerResponse = servletResponse3;
                    break;
                }
                ((ServletResponseWrapper)servletResponse).setResponse(servletResponse3);
                break;
            }
            servletResponse = servletResponse2;
            servletResponse2 = ((ServletResponseWrapper)servletResponse2).getResponse();
        }
    }

    private ServletRequest wrapRequest() {
        ServletRequest servletRequest = null;
        ServletRequest servletRequest2 = this.outerRequest;
        while (!(servletRequest2 == null || "org.apache.catalina.servlets.InvokerHttpRequest".equals(servletRequest2.getClass().getName()) || !(servletRequest2 instanceof ServletRequestWrapper) || servletRequest2 instanceof ApplicationHttpRequest || servletRequest2 instanceof ApplicationRequest || servletRequest2 instanceof Request)) {
            servletRequest = servletRequest2;
            servletRequest2 = ((ServletRequestWrapper)servletRequest2).getRequest();
        }
        Object object = null;
        object = servletRequest2 instanceof ApplicationHttpRequest || servletRequest2 instanceof HttpRequest || servletRequest2 instanceof HttpServletRequest ? new ApplicationHttpRequest((HttpServletRequest)servletRequest2) : new ApplicationRequest(servletRequest2);
        if (servletRequest == null) {
            this.outerRequest = object;
        } else {
            ((ServletRequestWrapper)servletRequest).setRequest((ServletRequest)object);
        }
        this.wrapRequest = object;
        return object;
    }

    private ServletResponse wrapResponse() {
        ServletResponse servletResponse = null;
        ServletResponse servletResponse2 = this.outerResponse;
        while (servletResponse2 != null && servletResponse2 instanceof ServletResponseWrapper && !(servletResponse2 instanceof ApplicationHttpResponse) && !(servletResponse2 instanceof ApplicationResponse) && !(servletResponse2 instanceof Response)) {
            servletResponse = servletResponse2;
            servletResponse2 = ((ServletResponseWrapper)servletResponse2).getResponse();
        }
        Object object = null;
        object = servletResponse2 instanceof ApplicationHttpResponse || servletResponse2 instanceof HttpResponse || servletResponse2 instanceof HttpServletResponse ? new ApplicationHttpResponse((HttpServletResponse)servletResponse2, this.including) : new ApplicationResponse(servletResponse2, this.including);
        if (servletResponse == null) {
            this.outerResponse = object;
        } else {
            ((ServletResponseWrapper)servletResponse).setResponse((ServletResponse)object);
        }
        this.wrapResponse = object;
        return object;
    }

    private RequestBase getRequestBase(ServletRequest servletRequest) {
        RequestBase requestBase = null;
        ServletRequest servletRequest2 = servletRequest;
        while (servletRequest2 != null) {
            if (servletRequest2 instanceof HttpRequestFacade) {
                requestBase = ((HttpRequestFacade)servletRequest2).getHttpRequestBase();
                break;
            }
            if (servletRequest2 instanceof RequestFacade) {
                requestBase = ((RequestFacade)servletRequest2).getRequestBase();
                break;
            }
            if (!(servletRequest2 instanceof ServletRequestWrapper)) break;
            servletRequest2 = ((ServletRequestWrapper)servletRequest2).getRequest();
        }
        return requestBase;
    }

    protected class PrivilegedInclude
    implements PrivilegedExceptionAction {
        private ServletRequest request;
        private ServletResponse response;

        PrivilegedInclude(ServletRequest servletRequest, ServletResponse servletResponse) {
            this.request = servletRequest;
            this.response = servletResponse;
        }

        public Object run() throws ServletException, IOException {
            ApplicationDispatcher.this.doInclude(this.request, this.response);
            return null;
        }
    }

    protected class PrivilegedForward
    implements PrivilegedExceptionAction {
        private ServletRequest request;
        private ServletResponse response;

        PrivilegedForward(ServletRequest servletRequest, ServletResponse servletResponse) {
            this.request = servletRequest;
            this.response = servletResponse;
        }

        public Object run() throws ServletException, IOException {
            ApplicationDispatcher.this.doForward(this.request, this.response);
            return null;
        }
    }
}

