/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.http10;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.connector.http10.HttpConnector;
import org.apache.catalina.connector.http10.HttpRequestImpl;
import org.apache.catalina.connector.http10.HttpResponseImpl;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;

final class HttpProcessor
implements Lifecycle,
Runnable {
    private boolean available = false;
    private HttpConnector connector = null;
    private int debug = 0;
    private int id = 0;
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private static final String match = ";jsessionid=";
    private String proxyName = null;
    private int proxyPort = 0;
    private HttpRequestImpl request = null;
    private HttpResponseImpl response = null;
    private int serverPort = 0;
    protected StringManager sm = StringManager.getManager("org.apache.catalina.connector.http10");
    private Socket socket = null;
    private boolean started = false;
    private boolean stopped = false;
    private Thread thread = null;
    private String threadName = null;
    private Object threadSync = new Object();

    public HttpProcessor(HttpConnector httpConnector, int n) {
        this.connector = httpConnector;
        this.debug = httpConnector.getDebug();
        this.id = n;
        this.proxyName = httpConnector.getProxyName();
        this.proxyPort = httpConnector.getProxyPort();
        this.request = (HttpRequestImpl)httpConnector.createRequest();
        this.response = (HttpResponseImpl)httpConnector.createResponse();
        this.serverPort = httpConnector.getPort();
        this.threadName = "HttpProcessor[" + httpConnector.getPort() + "][" + n + "]";
    }

    synchronized void assign(Socket socket) {
        while (this.available) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.socket = socket;
        this.available = true;
        this.notifyAll();
        if (this.debug >= 1 && socket != null) {
            this.log(" An incoming request is being assigned");
        }
    }

    private synchronized Socket await() {
        while (!this.available) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        Socket socket = this.socket;
        this.available = false;
        this.notifyAll();
        if (this.debug >= 1 && socket != null) {
            this.log("  The incoming request has been awaited");
        }
        return socket;
    }

    private void log(String string) {
        Logger logger = this.connector.getContainer().getLogger();
        if (logger != null) {
            logger.log(this.threadName + " " + string);
        }
    }

    private void log(String string, Throwable throwable) {
        Logger logger = this.connector.getContainer().getLogger();
        if (logger != null) {
            logger.log(this.threadName + " " + string, throwable);
        }
    }

    private void parseConnection(Socket socket) throws IOException, ServletException {
        if (this.debug >= 2) {
            this.log("  parseConnection: address=" + socket.getInetAddress() + ", port=" + this.connector.getPort());
        }
        this.request.setInet(socket.getInetAddress());
        if (this.proxyPort != 0) {
            this.request.setServerPort(this.proxyPort);
        } else {
            this.request.setServerPort(this.serverPort);
        }
        this.request.setSocket(socket);
    }

    private void parseHeaders(InputStream inputStream) throws IOException, ServletException {
        String string;
        while ((string = this.read(inputStream)) != null && string.length() >= 1) {
            int n = string.indexOf(58);
            if (n < 0) {
                throw new ServletException(this.sm.getString("httpProcessor.parseHeaders.colon"));
            }
            String string2 = string.substring(0, n).trim();
            String string3 = string2.toLowerCase();
            String string4 = string.substring(n + 1).trim();
            if (this.debug >= 1) {
                this.log(" Header " + string2 + " = " + string4);
            }
            if (string3.equals("authorization")) {
                this.request.setAuthorization(string4);
                this.request.addHeader(string2, string4);
                continue;
            }
            if (string3.equals("accept-language")) {
                Object object;
                String string5;
                Object object2;
                Object object3;
                this.request.addHeader(string2, string4);
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    object3 = stringTokenizer.nextToken().trim();
                    int n2 = ((String)object3).indexOf(59);
                    int n3 = ((String)object3).indexOf(113);
                    int n4 = ((String)object3).indexOf(61);
                    object2 = new Double(1.0);
                    if (n2 > -1 && n2 < n3 && n3 < n4) {
                        string5 = ((String)object3).substring(n2 + 1);
                        object3 = ((String)object3).substring(0, n2);
                        string5 = string5.trim().toLowerCase();
                        n2 = string5.indexOf(61);
                        object2 = new Double(0.0);
                        if (string5.startsWith("q") && n2 > -1) {
                            string5 = string5.substring(n2 + 1);
                            try {
                                object2 = new Double(string5.trim());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    if (((String)object3).equals("*")) continue;
                    string5 = ((Double)object2).toString();
                    object = hashtable.containsKey(string5) ? hashtable.get(string5) : new Vector();
                    ((Vector)object).addElement(object3);
                    hashtable.put(string5, object);
                }
                object3 = new Vector();
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string6 = (String)enumeration.nextElement();
                    Vector vector = (Vector)hashtable.get(string6);
                    object2 = vector.elements();
                    while (object2.hasMoreElements()) {
                        string5 = (String)object2.nextElement();
                        object = "";
                        String string7 = "";
                        int n5 = string5.indexOf(45);
                        if (n5 > -1) {
                            object = string5.substring(n5 + 1).trim();
                            string5 = string5.substring(0, n5).trim();
                            int n6 = ((String)object).indexOf("-");
                            if (n6 > 0) {
                                String string8 = ((String)object).substring(0, n6);
                                string7 = ((String)object).substring(n6 + 1);
                                object = string8;
                            }
                        }
                        this.request.addLocale(new Locale(string5, (String)object, string7));
                    }
                }
                continue;
            }
            if (string3.equals("cookie")) {
                Cookie[] cookieArray = RequestUtil.parseCookieHeader(string4);
                for (int i = 0; i < cookieArray.length; ++i) {
                    if (cookieArray[i].getName().equals("JSESSIONID") && !this.request.isRequestedSessionIdFromCookie()) {
                        this.request.setRequestedSessionId(cookieArray[i].getValue());
                        this.request.setRequestedSessionCookie(true);
                        this.request.setRequestedSessionURL(false);
                        if (this.debug >= 1) {
                            this.log(" Requested cookie session id is " + ((HttpServletRequest)this.request.getRequest()).getRequestedSessionId());
                        }
                    }
                    this.request.addCookie(cookieArray[i]);
                }
                this.request.addHeader(string2, string4);
                continue;
            }
            if (string3.equals("content-length")) {
                int n7 = -1;
                try {
                    n7 = Integer.parseInt(string4);
                }
                catch (Exception exception) {
                    throw new ServletException(this.sm.getString("httpProcessor.parseHeaders.contentLength"));
                }
                this.request.setContentLength(n7);
                this.request.addHeader(string2, string4);
                continue;
            }
            if (string3.equals("content-type")) {
                this.request.setContentType(string4);
                this.request.addHeader(string2, string4);
                continue;
            }
            if (string3.equals("host")) {
                int n8 = string4.indexOf(58);
                if (n8 < 0) {
                    this.request.setServerName(string4);
                } else {
                    this.request.setServerName(string4.substring(0, n8).trim());
                    int n9 = 80;
                    try {
                        n9 = Integer.parseInt(string4.substring(n8 + 1).trim());
                    }
                    catch (Exception exception) {
                        throw new ServletException(this.sm.getString("httpProcessor.parseHeaders.portNumber"));
                    }
                    this.request.setServerPort(n9);
                }
                this.request.addHeader(string2, string4);
                continue;
            }
            this.request.addHeader(string2, string4);
        }
    }

    private void parseRequest(InputStream inputStream) throws IOException, ServletException {
        String string = this.read(inputStream);
        if (string == null) {
            throw new ServletException(this.sm.getString("httpProcessor.parseRequest.read"));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = null;
        try {
            string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = null;
        }
        String string3 = null;
        try {
            string3 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            string3 = null;
        }
        String string4 = null;
        try {
            string4 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            string4 = "HTTP/0.9";
        }
        if (string2 == null) {
            throw new ServletException(this.sm.getString("httpProcessor.parseRequest.method"));
        }
        if (string3 == null) {
            throw new ServletException(this.sm.getString("httpProcessor.parseRequest.uri"));
        }
        int n = string3.indexOf(63);
        if (n >= 0) {
            this.request.setQueryString(string3.substring(n + 1));
            if (this.debug >= 1) {
                this.log(" Query string is " + ((HttpServletRequest)this.request.getRequest()).getQueryString());
            }
            string3 = string3.substring(0, n);
        } else {
            this.request.setQueryString(null);
        }
        int n2 = string3.indexOf(match);
        if (n2 >= 0) {
            String string5 = string3.substring(n2 + match.length());
            int n3 = string5.indexOf(59);
            if (n3 >= 0) {
                this.request.setRequestedSessionId(string5.substring(0, n3));
                string5 = string5.substring(n3);
            } else {
                this.request.setRequestedSessionId(string5);
                string5 = "";
            }
            this.request.setRequestedSessionURL(true);
            string3 = string3.substring(0, n2) + string5;
            if (this.debug >= 1) {
                this.log(" Requested URL session id is " + ((HttpServletRequest)this.request.getRequest()).getRequestedSessionId());
            }
        } else {
            this.request.setRequestedSessionId(null);
            this.request.setRequestedSessionURL(false);
        }
        this.request.setMethod(string2);
        this.request.setProtocol(string4);
        this.request.setRequestURI(string3);
        this.request.setSecure(false);
        this.request.setScheme("http");
        if (this.debug >= 1) {
            this.log(" Request is " + string2 + " for " + string3);
        }
    }

    private void process(Socket socket) {
        boolean bl = true;
        BufferedInputStream bufferedInputStream = null;
        OutputStream outputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(socket.getInputStream(), this.connector.getBufferSize());
            this.request.setStream(bufferedInputStream);
            this.request.setResponse(this.response);
            outputStream = socket.getOutputStream();
            this.response.setStream(outputStream);
            this.response.setRequest(this.request);
            ((HttpServletResponse)this.response.getResponse()).setHeader("Server", "Sun Java System Application Server (HTTP/1.0 Connector)");
        }
        catch (Exception exception) {
            this.log("process.create", exception);
            bl = false;
        }
        try {
            if (bl) {
                this.parseConnection(socket);
                this.parseRequest(bufferedInputStream);
                if (!this.request.getRequest().getProtocol().startsWith("HTTP/0")) {
                    this.parseHeaders(bufferedInputStream);
                }
            }
        }
        catch (Exception exception) {
            try {
                this.log("process.parse", exception);
                ((HttpServletResponse)this.response.getResponse()).sendError(400);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        try {
            if (bl) {
                this.connector.getContainer().invoke(this.request, this.response);
            }
        }
        catch (ServletException servletException) {
            this.log("process.invoke", servletException);
            try {
                ((HttpServletResponse)this.response.getResponse()).sendError(500);
            }
            catch (Exception exception) {
                // empty catch block
            }
            bl = false;
        }
        catch (Throwable throwable) {
            this.log("process.invoke", throwable);
            try {
                ((HttpServletResponse)this.response.getResponse()).sendError(500);
            }
            catch (Exception exception) {
                // empty catch block
            }
            bl = false;
        }
        try {
            if (bl) {
                this.response.finishResponse();
            }
        }
        catch (IOException iOException) {
            this.log("FIXME-Exception from finishResponse", iOException);
        }
        try {
            if (outputStream != null) {
                outputStream.flush();
            }
        }
        catch (IOException iOException) {
            this.log("FIXME-Exception flushing output", iOException);
        }
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            this.log("FIXME-Exception closing output", iOException);
        }
        try {
            if (bl) {
                this.request.finishRequest();
            }
        }
        catch (IOException iOException) {
            this.log("FIXME-Exception from finishRequest", iOException);
        }
        try {
            if (bufferedInputStream != null) {
                ((InputStream)bufferedInputStream).close();
            }
        }
        catch (IOException iOException) {
            this.log("FIXME-Exception closing input", iOException);
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            this.log("FIXME-Exception closing socket", iOException);
        }
        socket = null;
    }

    private String read(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = inputStream.read()) < 0) {
                if (stringBuffer.length() != 0) break;
                return null;
            }
            if (n == 13) continue;
            if (n == 10) break;
            stringBuffer.append((char)n);
        }
        if (this.debug >= 2) {
            this.log("  Read: " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        while (!this.stopped) {
            object = this.await();
            if (object == null) continue;
            this.process((Socket)object);
            this.request.recycle();
            this.response.recycle();
            this.connector.recycle(this);
        }
        object = this.threadSync;
        synchronized (object) {
            this.threadSync.notifyAll();
        }
    }

    private void threadStart() {
        this.log(this.sm.getString("httpProcessor.starting"));
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
        if (this.debug >= 1) {
            this.log(" Background thread has been started");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadStop() {
        this.log(this.sm.getString("httpProcessor.stopping"));
        this.stopped = true;
        this.assign(null);
        Object object = this.threadSync;
        synchronized (object) {
            try {
                this.threadSync.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.thread = null;
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.removeLifecycleListener(lifecycleListener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("httpProcessor.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.threadStart();
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("httpProcessor.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.threadStop();
    }
}

