/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.http;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.catalina.connector.http.HttpHeader;
import org.apache.catalina.connector.http.HttpRequestLine;
import org.apache.catalina.util.StringManager;

public class SocketInputStream
extends InputStream {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte SP = 32;
    private static final byte HT = 9;
    private static final byte COLON = 58;
    private static final int LC_OFFSET = -32;
    protected byte[] buf;
    protected int count;
    protected int pos;
    protected InputStream is;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.connector.http");

    public SocketInputStream(InputStream inputStream, int n) {
        this.is = inputStream;
        this.buf = new byte[n];
    }

    public void readRequestLine(HttpRequestLine httpRequestLine) throws IOException {
        if (httpRequestLine.methodEnd != 0) {
            httpRequestLine.recycle();
        }
        int n = 0;
        do {
            try {
                n = this.read();
            }
            catch (IOException iOException) {
                n = -1;
            }
        } while (n == 13 || n == 10);
        if (n == -1) {
            throw new EOFException(sm.getString("requestStream.readline.error"));
        }
        --this.pos;
        int n2 = httpRequestLine.method.length;
        int n3 = this.pos;
        int n4 = 0;
        boolean bl = false;
        while (!bl) {
            if (n4 >= n2) {
                if (2 * n2 <= 1024) {
                    char[] cArray = new char[2 * n2];
                    System.arraycopy(httpRequestLine.method, 0, cArray, 0, n2);
                    httpRequestLine.method = cArray;
                    n2 = httpRequestLine.method.length;
                } else {
                    throw new IOException(sm.getString("requestStream.readline.toolong"));
                }
            }
            if (this.pos >= this.count) {
                int n5 = this.read();
                if (n5 == -1) {
                    throw new IOException(sm.getString("requestStream.readline.error"));
                }
                this.pos = 0;
                n3 = 0;
            }
            if (this.buf[this.pos] == 32) {
                bl = true;
            }
            httpRequestLine.method[n4] = (char)this.buf[this.pos];
            ++n4;
            ++this.pos;
        }
        httpRequestLine.methodEnd = n4 - 1;
        n2 = httpRequestLine.uri.length;
        n3 = this.pos;
        n4 = 0;
        bl = false;
        boolean bl2 = false;
        while (!bl) {
            if (n4 >= n2) {
                if (2 * n2 <= 32768) {
                    char[] cArray = new char[2 * n2];
                    System.arraycopy(httpRequestLine.uri, 0, cArray, 0, n2);
                    httpRequestLine.uri = cArray;
                    n2 = httpRequestLine.uri.length;
                } else {
                    throw new IOException(sm.getString("requestStream.readline.toolong"));
                }
            }
            if (this.pos >= this.count) {
                int n6 = this.read();
                if (n6 == -1) {
                    throw new IOException(sm.getString("requestStream.readline.error"));
                }
                this.pos = 0;
                n3 = 0;
            }
            if (this.buf[this.pos] == 32) {
                bl = true;
            } else if (this.buf[this.pos] == 13 || this.buf[this.pos] == 10) {
                bl2 = true;
                bl = true;
            }
            httpRequestLine.uri[n4] = (char)this.buf[this.pos];
            ++n4;
            ++this.pos;
        }
        httpRequestLine.uriEnd = n4 - 1;
        n2 = httpRequestLine.protocol.length;
        n3 = this.pos;
        n4 = 0;
        while (!bl2) {
            if (n4 >= n2) {
                if (2 * n2 <= 1024) {
                    char[] cArray = new char[2 * n2];
                    System.arraycopy(httpRequestLine.protocol, 0, cArray, 0, n2);
                    httpRequestLine.protocol = cArray;
                    n2 = httpRequestLine.protocol.length;
                } else {
                    throw new IOException(sm.getString("requestStream.readline.toolong"));
                }
            }
            if (this.pos >= this.count) {
                int n7 = this.read();
                if (n7 == -1) {
                    throw new IOException(sm.getString("requestStream.readline.error"));
                }
                this.pos = 0;
                n3 = 0;
            }
            if (this.buf[this.pos] != 13) {
                if (this.buf[this.pos] == 10) {
                    bl2 = true;
                } else {
                    httpRequestLine.protocol[n4] = (char)this.buf[this.pos];
                    ++n4;
                }
            }
            ++this.pos;
        }
        httpRequestLine.protocolEnd = n4;
    }

    public void readHeader(HttpHeader httpHeader) throws IOException {
        int n;
        int n2;
        if (httpHeader.nameEnd != 0) {
            httpHeader.recycle();
        }
        if ((n2 = this.read()) == 13 || n2 == 10) {
            if (n2 == 13) {
                this.read();
            }
            httpHeader.nameEnd = 0;
            httpHeader.valueEnd = 0;
            return;
        }
        --this.pos;
        int n3 = httpHeader.name.length;
        int n4 = this.pos;
        int n5 = 0;
        boolean bl = false;
        while (!bl) {
            if (n5 >= n3) {
                if (2 * n3 <= 128) {
                    char[] cArray = new char[2 * n3];
                    System.arraycopy(httpHeader.name, 0, cArray, 0, n3);
                    httpHeader.name = cArray;
                    n3 = httpHeader.name.length;
                } else {
                    throw new IOException(sm.getString("requestStream.readline.toolong"));
                }
            }
            if (this.pos >= this.count) {
                int n6 = this.read();
                if (n6 == -1) {
                    throw new IOException(sm.getString("requestStream.readline.error"));
                }
                this.pos = 0;
                n4 = 0;
            }
            if (this.buf[this.pos] == 58) {
                bl = true;
            }
            if ((n = (int)((char)this.buf[this.pos])) >= 65 && n <= 90) {
                n = (char)(n - -32);
            }
            httpHeader.name[n5] = n;
            ++n5;
            ++this.pos;
        }
        httpHeader.nameEnd = n5 - 1;
        n3 = httpHeader.value.length;
        n4 = this.pos;
        n5 = 0;
        n = -2;
        boolean bl2 = false;
        boolean bl3 = true;
        while (bl3) {
            int n7;
            boolean bl4 = true;
            while (bl4) {
                if (this.pos >= this.count) {
                    n7 = this.read();
                    if (n7 == -1) {
                        throw new IOException(sm.getString("requestStream.readline.error"));
                    }
                    this.pos = 0;
                    n4 = 0;
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    ++this.pos;
                    continue;
                }
                bl4 = false;
            }
            while (!bl2) {
                if (n5 >= n3) {
                    if (2 * n3 <= 4096) {
                        char[] cArray = new char[2 * n3];
                        System.arraycopy(httpHeader.value, 0, cArray, 0, n3);
                        httpHeader.value = cArray;
                        n3 = httpHeader.value.length;
                    } else {
                        throw new IOException(sm.getString("requestStream.readline.toolong"));
                    }
                }
                if (this.pos >= this.count) {
                    int n8 = this.read();
                    if (n8 == -1) {
                        throw new IOException(sm.getString("requestStream.readline.error"));
                    }
                    this.pos = 0;
                    n4 = 0;
                }
                if (this.buf[this.pos] != 13) {
                    if (this.buf[this.pos] == 10) {
                        bl2 = true;
                    } else {
                        int n9 = this.buf[this.pos] & 0xFF;
                        httpHeader.value[n5] = (char)n9;
                        ++n5;
                    }
                }
                ++this.pos;
            }
            n7 = this.read();
            if (n7 != 32 && n7 != 9) {
                --this.pos;
                bl3 = false;
                continue;
            }
            bl2 = false;
            if (n5 >= n3) {
                if (2 * n3 <= 4096) {
                    char[] cArray = new char[2 * n3];
                    System.arraycopy(httpHeader.value, 0, cArray, 0, n3);
                    httpHeader.value = cArray;
                    n3 = httpHeader.value.length;
                } else {
                    throw new IOException(sm.getString("requestStream.readline.toolong"));
                }
            }
            httpHeader.value[n5] = 32;
            ++n5;
        }
        httpHeader.valueEnd = n5;
    }

    public int read() throws IOException {
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public int available() throws IOException {
        return this.count - this.pos + this.is.available();
    }

    public void close() throws IOException {
        if (this.is == null) {
            return;
        }
        this.is.close();
        this.is = null;
        this.buf = null;
    }

    protected void fill() throws IOException {
        this.pos = 0;
        this.count = 0;
        int n = this.is.read(this.buf, 0, this.buf.length);
        if (n > 0) {
            this.count = n;
        }
    }
}

