/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.http;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.ResponseStream;
import org.apache.catalina.connector.http.HttpResponseImpl;

public final class HttpResponseStream
extends ResponseStream {
    private static final int MAX_CHUNK_SIZE = 4096;
    private static final String CRLF = "\r\n";
    private boolean useChunking;
    private boolean writingChunk;
    private boolean writeContent;

    public HttpResponseStream(HttpResponseImpl httpResponseImpl) {
        super(httpResponseImpl);
        this.checkChunking(httpResponseImpl);
        this.checkHead(httpResponseImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n) throws IOException {
        if (this.suspended) {
            return;
        }
        if (!this.writeContent) {
            return;
        }
        if (this.useChunking && !this.writingChunk) {
            this.writingChunk = true;
            try {
                this.print("1\r\n");
                super.write(n);
                this.println();
            }
            finally {
                this.writingChunk = false;
            }
        } else {
            super.write(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.suspended) {
            return;
        }
        if (!this.writeContent) {
            return;
        }
        if (this.useChunking && !this.writingChunk) {
            if (n2 > 0) {
                this.writingChunk = true;
                try {
                    this.println(Integer.toHexString(n2));
                    super.write(byArray, n, n2);
                    this.println();
                }
                finally {
                    this.writingChunk = false;
                }
            }
        } else {
            super.write(byArray, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.suspended) {
            throw new IOException(sm.getString("responseStream.suspended"));
        }
        if (!this.writeContent) {
            return;
        }
        if (this.useChunking) {
            this.writingChunk = true;
            try {
                this.print("0\r\n\r\n");
            }
            finally {
                this.writingChunk = false;
            }
        }
        super.close();
    }

    void checkChunking(HttpResponseImpl httpResponseImpl) {
        if (this.count != 0) {
            return;
        }
        boolean bl = this.useChunking = !httpResponseImpl.isCommitted() && httpResponseImpl.getContentLength() == -1 && httpResponseImpl.getStatus() != 304;
        if (!httpResponseImpl.isChunkingAllowed() && this.useChunking) {
            httpResponseImpl.setHeader("Connection", "close");
        }
        boolean bl2 = this.useChunking = this.useChunking && !httpResponseImpl.isCloseConnection();
        if (this.useChunking) {
            httpResponseImpl.setHeader("Transfer-Encoding", "chunked");
        } else if (httpResponseImpl.isChunkingAllowed()) {
            httpResponseImpl.removeHeader("Transfer-Encoding", "chunked");
        }
    }

    protected void checkHead(HttpResponseImpl httpResponseImpl) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)httpResponseImpl.getRequest();
        this.writeContent = !"HEAD".equals(httpServletRequest.getMethod());
    }
}

